/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup.runtime;

import com.github.jhoenicke.javacup.runtime.Symbol;
import java.util.ArrayList;
import java.util.List;

class VirtualParseStack {
    private List<Symbol> real_stack;
    private int real_top;
    private ArrayList<Integer> vstack;

    public VirtualParseStack(List<Symbol> list) throws Exception {
        if (list == null) {
            throw new Exception("Internal parser error: attempt to create null virtual stack");
        }
        this.real_stack = list;
        this.vstack = new ArrayList();
        this.real_top = list.size();
        this.getFromReal();
    }

    private void getFromReal() {
        if (this.real_top == 0) {
            return;
        }
        Symbol symbol = this.real_stack.get(--this.real_top);
        this.vstack.add(symbol.parse_state);
    }

    public boolean empty() {
        return this.vstack.isEmpty();
    }

    public int top() throws Exception {
        if (this.vstack.isEmpty()) {
            throw new Exception("Internal parser error: top() called on empty virtual stack");
        }
        return this.vstack.get(this.vstack.size() - 1);
    }

    public void pop() {
        assert (!this.vstack.isEmpty()) : "Internal parser error: pop from empty virtual stack";
        this.vstack.remove(this.vstack.size() - 1);
        if (this.vstack.isEmpty()) {
            this.getFromReal();
        }
    }

    public void pop(int n) {
        int n2 = this.vstack.size();
        if (n2 > n) {
            while (n-- > 0) {
                this.vstack.remove(--n2);
            }
        } else {
            this.vstack.clear();
            this.real_top -= n - n2;
            this.getFromReal();
        }
    }

    public void push(int n) {
        this.vstack.add(n);
    }
}

