/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;

public class CheckClosedTerm
extends NonRecursive {
    private final ScopedHashSet<Term> mCheckedTerms = new ScopedHashSet();
    private boolean mIsClosed;

    public boolean isClosed(Term t) {
        this.mIsClosed = true;
        this.run(new TermWalker(t));
        return this.mIsClosed;
    }

    void check(Term t) {
        if (this.mCheckedTerms.contains(t) || !this.mIsClosed) {
            return;
        }
        this.mCheckedTerms.add(t);
        if (t instanceof ApplicationTerm) {
            for (Term arg : ((ApplicationTerm)t).getParameters()) {
                this.enqueueWalker(new TermWalker(arg));
            }
        } else if (t instanceof AnnotatedTerm) {
            this.enqueueWalker(new TermWalker(((AnnotatedTerm)t).getSubterm()));
        } else if (t instanceof LetTerm) {
            LetTerm let = (LetTerm)t;
            for (Term term : let.getValues()) {
                this.enqueueWalker(new TermWalker(term));
            }
            this.mCheckedTerms.beginScope();
            this.enqueueWalker(new EndScopeWalker());
            for (Term term : let.getVariables()) {
                this.mCheckedTerms.add(term);
            }
            this.enqueueWalker(new TermWalker(let.getSubTerm()));
        } else if (t instanceof TermVariable) {
            this.mIsClosed = false;
        } else if (t instanceof QuantifiedFormula) {
            QuantifiedFormula quant = (QuantifiedFormula)t;
            this.mCheckedTerms.beginScope();
            this.enqueueWalker(new EndScopeWalker());
            for (TermVariable termVariable : quant.getVariables()) {
                this.mCheckedTerms.add(termVariable);
            }
            this.enqueueWalker(new TermWalker(quant.getSubformula()));
        } else if (t instanceof MatchTerm) {
            MatchTerm match = (MatchTerm)t;
            for (int i = 0; i < match.getCases().length; ++i) {
                this.enqueueWalker(new MatchCaseWalker(match, i));
            }
            this.enqueueWalker(new TermWalker(match.getDataTerm()));
        } else if (!(t instanceof ConstantTerm)) {
            throw new AssertionError((Object)("Unknown term: " + t.getClass()));
        }
    }

    void checkMatchCase(MatchTerm match, int caseNr) {
        this.mCheckedTerms.beginScope();
        for (TermVariable var : match.getVariables()[caseNr]) {
            this.mCheckedTerms.add(var);
        }
        this.enqueueWalker(new EndScopeWalker());
        this.enqueueWalker(new TermWalker(match.getCases()[caseNr]));
    }

    static class EndScopeWalker
    implements NonRecursive.Walker {
        EndScopeWalker() {
        }

        @Override
        public void walk(NonRecursive engine) {
            ((CheckClosedTerm)engine).mCheckedTerms.endScope();
        }
    }

    static class MatchCaseWalker
    implements NonRecursive.Walker {
        final MatchTerm mMatch;
        final int mCaseNr;

        public MatchCaseWalker(MatchTerm match, int caseNr) {
            this.mMatch = match;
            this.mCaseNr = caseNr;
        }

        @Override
        public void walk(NonRecursive engine) {
            ((CheckClosedTerm)engine).checkMatchCase(this.mMatch, this.mCaseNr);
        }
    }

    static class TermWalker
    implements NonRecursive.Walker {
        final Term mTerm;

        public TermWalker(Term term) {
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            ((CheckClosedTerm)engine).check(this.mTerm);
        }
    }
}

