/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.NoSuchElementException;

public class DataType
extends SortSymbol {
    Constructor[] mConstructors;
    Sort[] mSortVariables;

    public DataType(Theory theory, String name, int numParams) {
        super(theory, name, numParams, null, 32);
    }

    public void setConstructors(Sort[] sortVars, Constructor[] constrs) {
        assert (this.mConstructors == null);
        this.mSortVariables = sortVars;
        this.mConstructors = constrs;
        if (sortVars != null) {
            for (Constructor cons : constrs) {
                cons.mNeedsReturnOverload = this.checkReturnOverload(sortVars, cons.mArgumentSorts);
            }
        }
    }

    public Sort[] getSortVariables() {
        return this.mSortVariables;
    }

    public Constructor findConstructor(String name) {
        for (int i = 0; i < this.mConstructors.length; ++i) {
            if (!this.mConstructors[i].getName().equals(name)) continue;
            return this.mConstructors[i];
        }
        return null;
    }

    public Constructor getConstructor(String name) {
        Constructor constr = this.findConstructor(name);
        if (constr == null) {
            throw new NoSuchElementException();
        }
        return constr;
    }

    public Constructor[] getConstructors() {
        return this.mConstructors;
    }

    private boolean checkReturnOverload(Sort[] sortParams, Sort[] argumentSorts) {
        BitSet unused = new BitSet();
        unused.set(0, sortParams.length);
        ArrayDeque<Sort> todo = new ArrayDeque<Sort>();
        HashSet<Sort> seen = new HashSet<Sort>();
        todo.addAll(Arrays.asList(argumentSorts));
        block0: while (!todo.isEmpty()) {
            Sort sort = (Sort)todo.removeFirst();
            if (!seen.add(sort)) continue;
            if (sort.isSortVariable()) {
                for (int i = 0; i < sortParams.length; ++i) {
                    if (sort != sortParams[i]) continue;
                    unused.clear(i);
                    continue block0;
                }
                continue;
            }
            todo.addAll(Arrays.asList(sort.getArguments()));
        }
        return !unused.isEmpty();
    }

    public static class Constructor {
        private final String mName;
        private final Sort[] mArgumentSorts;
        private final String[] mSelectors;
        private boolean mNeedsReturnOverload;

        public Constructor(String name, String[] selectors, Sort[] argumentSorts) {
            this.mName = name;
            this.mSelectors = selectors;
            this.mArgumentSorts = argumentSorts;
        }

        public String getName() {
            return this.mName;
        }

        public Sort[] getArgumentSorts() {
            return this.mArgumentSorts;
        }

        public int getSelectorIndex(String selector) {
            for (int i = 0; i < this.mSelectors.length; ++i) {
                if (!this.mSelectors[i].equals(selector)) continue;
                return i;
            }
            throw new NoSuchElementException();
        }

        public String[] getSelectors() {
            return this.mSelectors;
        }

        public boolean needsReturnOverload() {
            return this.mNeedsReturnOverload;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.mName);
            if (this.mSelectors.length != 0) {
                for (int i = 0; i < this.mSelectors.length; ++i) {
                    sb.append(" ");
                    sb.append("(");
                    sb.append(this.mSelectors[i]);
                    sb.append(" ");
                    sb.append(this.mArgumentSorts[i]);
                    sb.append(")");
                }
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

