/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermEquivalence;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormulaLet
extends NonRecursive {
    private final ArrayList<Map<Term, TermInfo>> mVisited = new ArrayList();
    private final ArrayList<Set<TermVariable>> mScopes = new ArrayList();
    private final ArrayDeque<Term> mResultStack = new ArrayDeque();
    private int mCseNum;
    private final LetFilter mFilter;

    public FormulaLet() {
        this(null);
    }

    public FormulaLet(LetFilter filter) {
        this.mFilter = filter;
    }

    private int findScope(Term term) {
        TermVariable[] tvs = term.getFreeVars();
        for (int scopeNr = this.mScopes.size() - 1; scopeNr >= 0; --scopeNr) {
            if (this.mScopes.get(scopeNr) == null) {
                return scopeNr;
            }
            for (TermVariable tv : tvs) {
                if (!this.mScopes.get(scopeNr).contains(tv)) continue;
                return scopeNr;
            }
        }
        throw new AssertionError((Object)"no scope");
    }

    public Term let(Term input) {
        input = new FormulaUnLet().unlet(input);
        this.mCseNum = 0;
        this.enqueueLetter(input);
        this.run();
        Term result = this.mResultStack.removeLast();
        assert (this.mResultStack.size() == 0 && this.mVisited.size() == 0);
        assert (new TermEquivalence().equal(new FormulaUnLet().unlet(result), input));
        return result;
    }

    public void enqueueLetter(Term term) {
        if (term instanceof TermVariable || term instanceof ConstantTerm) {
            this.mResultStack.addLast(term);
            return;
        }
        HashMap newScope = new HashMap();
        this.mScopes.add(null);
        this.mVisited.add(newScope);
        TermInfo info = new TermInfo(term);
        this.enqueueWalker(new ScopeRemover());
        this.enqueueWalker(new Transformer(info));
        this.enqueueWalker(new MarkLet(info));
        this.enqueueWalker(new CollectInfo(term, info));
    }

    private static boolean isNamed(AnnotatedTerm at) {
        return at.getAnnotations().length == 1 && at.getAnnotations()[0].getKey().equals(":named");
    }

    private static boolean isPattern(Term subterm) {
        if (subterm instanceof AnnotatedTerm) {
            AnnotatedTerm at = (AnnotatedTerm)subterm;
            for (Annotation annot : at.getAnnotations()) {
                if (annot.getKey().equals(":pattern")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean bindsVariable(Term parent, Term child) {
        HashSet<TermVariable> parentVars = new HashSet<TermVariable>(Arrays.asList(parent.getFreeVars()));
        for (TermVariable tv : child.getFreeVars()) {
            if (parentVars.contains(tv)) continue;
            return true;
        }
        return false;
    }

    public void addTransformScope(TermVariable[] vars, Map<Term, TermInfo> scope) {
        this.enqueueWalker(new ScopeRemover());
        this.mScopes.add(new HashSet<TermVariable>(Arrays.asList(vars)));
        this.mVisited.add(scope);
    }

    public void visitChild(Term term) {
        if (term instanceof TermVariable || term instanceof ConstantTerm) {
            return;
        }
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getParameters().length == 0) {
            return;
        }
        Map<Term, TermInfo> scopedInfos = this.mVisited.get(this.findScope(term));
        TermInfo child = scopedInfos.get(term);
        if (child == null) {
            child = new TermInfo(term);
            scopedInfos.put(term, child);
            this.enqueueWalker(new CollectInfo(term, child));
        } else {
            ++child.mCount;
        }
    }

    public Map<Term, TermInfo> newScope(TermVariable[] vars) {
        HashSet<TermVariable> varSet = new HashSet<TermVariable>(Arrays.asList(vars));
        HashMap<Term, TermInfo> newScope = new HashMap<Term, TermInfo>();
        this.mScopes.add(varSet);
        this.mVisited.add(newScope);
        this.enqueueWalker(new ScopeRemover());
        return newScope;
    }

    static class MarkLet
    implements NonRecursive.Walker {
        TermInfo mTermInfo;

        public MarkLet(TermInfo parent) {
            this.mTermInfo = parent;
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term term = this.mTermInfo.mTerm;
            this.mTermInfo.mLettedTerms = new ArrayDeque();
            this.mTermInfo.mLettedTerms.addFirst(new ArrayList());
            let.enqueueWalker(new CollectLets(this.mTermInfo));
            if (term instanceof LambdaTerm) {
                LambdaTerm lambda = (LambdaTerm)term;
                let.addTransformScope(lambda.getVariables(), this.mTermInfo.mScopes[0]);
                let.enqueueWalker(new AddParent(this.mTermInfo, lambda.getSubterm()));
            } else if (term instanceof QuantifiedFormula) {
                QuantifiedFormula quant = (QuantifiedFormula)term;
                if (FormulaLet.isPattern(quant.getSubformula())) {
                    AnnotatedTerm at = (AnnotatedTerm)quant.getSubformula();
                    let.addTransformScope(quant.getVariables(), this.mTermInfo.mScopes[0]);
                    let.enqueueWalker(new AddParent(this.mTermInfo, at.getSubterm()));
                } else {
                    let.addTransformScope(quant.getVariables(), this.mTermInfo.mScopes[0]);
                    let.enqueueWalker(new AddParent(this.mTermInfo, quant.getSubformula()));
                }
            } else if (term instanceof AnnotatedTerm) {
                AnnotatedTerm at = (AnnotatedTerm)term;
                if (!FormulaLet.isNamed(at)) {
                    let.enqueueWalker(new AddParent(this.mTermInfo, at.getSubterm()));
                    ArrayDeque<Object> todo = new ArrayDeque<Object>();
                    for (Annotation annot : at.getAnnotations()) {
                        if (annot.getValue() == null) continue;
                        todo.add(annot.getValue());
                    }
                    while (!todo.isEmpty()) {
                        Object value = todo.removeLast();
                        if (value instanceof Term) {
                            let.enqueueWalker(new AddParent(this.mTermInfo, (Term)value));
                            continue;
                        }
                        if (!(value instanceof Object[])) continue;
                        for (Object elem : (Object[])value) {
                            todo.add(elem);
                        }
                    }
                }
            } else if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                Term[] params = appTerm.getParameters();
                for (int i = params.length - 1; i >= 0; --i) {
                    let.enqueueWalker(new AddParent(this.mTermInfo, params[i]));
                }
            } else if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                Term[] cases = matchTerm.getCases();
                for (int i = cases.length - 1; i >= 0; --i) {
                    let.enqueueWalker(new AddParentMatchCase(matchTerm, this.mTermInfo, i));
                }
                let.enqueueWalker(new AddParent(this.mTermInfo, matchTerm.getDataTerm()));
            } else {
                let.mResultStack.addLast(term);
            }
        }
    }

    public static class AddParentMatchCase
    implements NonRecursive.Walker {
        MatchTerm mTerm;
        TermInfo mInfo;
        int mCaseNr;

        public AddParentMatchCase(MatchTerm term, TermInfo info, int caseNr) {
            this.mTerm = term;
            this.mInfo = info;
            this.mCaseNr = caseNr;
        }

        @Override
        public void walk(NonRecursive walker) {
            FormulaLet let = (FormulaLet)walker;
            let.addTransformScope(this.mTerm.getVariables()[this.mCaseNr], this.mInfo.mScopes[this.mCaseNr]);
            let.enqueueWalker(new AddParent(this.mInfo, this.mTerm.getCases()[this.mCaseNr]));
        }
    }

    static class AddParent
    implements NonRecursive.Walker {
        TermInfo mParent;
        Term mTerm;

        public AddParent(TermInfo parent, Term term) {
            this.mParent = parent;
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term child = this.mTerm;
            Map scopeInfos = (Map)let.mVisited.get(let.findScope(child));
            TermInfo info = (TermInfo)scopeInfos.get(child);
            if (info == null) {
                return;
            }
            if (info.mParent == null) {
                info.mParent = this.mParent;
                info.mPDepth = this.mParent.mPDepth + 1;
                if (info.mSubst == null && !(child instanceof LambdaTerm) && (let.mFilter == null || let.mFilter.isLettable(child)) && info.shouldBuildLet()) {
                    Term t = info.mTerm;
                    info.mSubst = t.getTheory().createTermVariable(".cse" + let.mCseNum++, t.getSort());
                }
            }
            ++info.mSeen;
            if (info.mSeen == info.mCount) {
                info.mergeParent(this.mParent);
                if (info.mSubst == null) {
                    let.enqueueWalker(new MarkLet(info));
                } else {
                    TermInfo ancestor;
                    TermInfo letPos = ancestor = info.mParent;
                    while (!(ancestor == null || ancestor.mSubst != null || ancestor.mParent != null && FormulaLet.bindsVariable(ancestor.mParent.mTerm, child))) {
                        if (ancestor.mCount > 1) {
                            letPos = ancestor.mParent;
                        }
                        ancestor = ancestor.mParent;
                    }
                    letPos.mLettedTerms.getFirst().add(info);
                }
            }
        }
    }

    static class BuildAnnotatedTerm
    implements NonRecursive.Walker {
        final AnnotatedTerm mOldTerm;

        public BuildAnnotatedTerm(AnnotatedTerm term) {
            this.mOldTerm = term;
        }

        private Object retrieveValue(FormulaLet let, Object old) {
            if (old instanceof Term) {
                return let.mResultStack.removeLast();
            }
            if (old instanceof Object[]) {
                Object[] newArray = (Object[])old;
                for (int i = newArray.length - 1; i >= 0; --i) {
                    Object oldValue = newArray[i];
                    Object newValue = this.retrieveValue(let, oldValue);
                    if (oldValue == newValue) continue;
                    if (newArray == old) {
                        newArray = (Object[])newArray.clone();
                    }
                    newArray[i] = newValue;
                }
                return newArray;
            }
            return old;
        }

        @Override
        public void walk(NonRecursive engine) {
            Annotation[] oldAnnot;
            FormulaLet let = (FormulaLet)engine;
            Term result = this.mOldTerm;
            Term newBody = (Term)let.mResultStack.removeLast();
            Annotation[] newAnnot = oldAnnot = this.mOldTerm.getAnnotations();
            for (int i = oldAnnot.length - 1; i >= 0; --i) {
                Object oldValue = oldAnnot[i].getValue();
                Object newValue = this.retrieveValue(let, oldValue);
                if (newValue == oldValue) continue;
                if (newAnnot == oldAnnot) {
                    newAnnot = (Annotation[])oldAnnot.clone();
                }
                newAnnot[i] = new Annotation(oldAnnot[i].getKey(), newValue);
            }
            if (newBody != this.mOldTerm.getSubterm() || newAnnot != oldAnnot) {
                Theory theory = this.mOldTerm.getTheory();
                result = theory.annotatedTerm(newAnnot, newBody);
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildMatchTerm
    implements NonRecursive.Walker {
        final MatchTerm mOldTerm;

        public BuildMatchTerm(MatchTerm term) {
            this.mOldTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            Term[] oldCases;
            FormulaLet let = (FormulaLet)engine;
            Term[] newCases = oldCases = this.mOldTerm.getCases();
            for (int i = oldCases.length - 1; i >= 0; --i) {
                Term caseTerm = (Term)let.mResultStack.removeLast();
                if (caseTerm == oldCases[i]) continue;
                if (newCases == oldCases) {
                    newCases = (Term[])oldCases.clone();
                }
                newCases[i] = caseTerm;
            }
            Term newDataTerm = (Term)let.mResultStack.removeLast();
            Term result = this.mOldTerm;
            if (newDataTerm != this.mOldTerm.getDataTerm() || newCases != oldCases) {
                Theory theory = this.mOldTerm.getTheory();
                result = theory.match(newDataTerm, this.mOldTerm.getVariables(), newCases, this.mOldTerm.getConstructors());
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildQuantifier
    implements NonRecursive.Walker {
        final QuantifiedFormula mOldTerm;

        public BuildQuantifier(QuantifiedFormula term) {
            this.mOldTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term newBody = (Term)let.mResultStack.removeLast();
            Term result = this.mOldTerm;
            if (newBody != this.mOldTerm.getSubformula()) {
                Theory theory = this.mOldTerm.getTheory();
                result = this.mOldTerm.getQuantifier() == 0 ? theory.exists(this.mOldTerm.getVariables(), newBody) : theory.forall(this.mOldTerm.getVariables(), newBody);
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildLambda
    implements NonRecursive.Walker {
        final LambdaTerm mOldTerm;

        public BuildLambda(LambdaTerm term) {
            this.mOldTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term newBody = (Term)let.mResultStack.removeLast();
            Term result = this.mOldTerm;
            if (newBody != this.mOldTerm.getSubterm()) {
                Theory theory = this.mOldTerm.getTheory();
                result = theory.lambda(this.mOldTerm.getVariables(), newBody);
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildApplicationTerm
    implements NonRecursive.Walker {
        final ApplicationTerm mOldTerm;

        public BuildApplicationTerm(ApplicationTerm term) {
            this.mOldTerm = term;
        }

        public Term[] getTerms(FormulaLet let, Term[] oldArgs) {
            Term[] newArgs = oldArgs;
            for (int i = oldArgs.length - 1; i >= 0; --i) {
                Term newTerm = (Term)let.mResultStack.removeLast();
                if (newTerm == oldArgs[i]) continue;
                if (newArgs == oldArgs) {
                    newArgs = (Term[])oldArgs.clone();
                }
                newArgs[i] = newTerm;
            }
            return newArgs;
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term[] newParams = this.getTerms(let, this.mOldTerm.getParameters());
            Term result = this.mOldTerm;
            if (newParams != this.mOldTerm.getParameters()) {
                Theory theory = this.mOldTerm.getTheory();
                result = theory.term(this.mOldTerm.getFunction(), newParams);
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildLetTerm
    implements NonRecursive.Walker {
        final TermVariable[] mVars;

        public BuildLetTerm(TermVariable[] vars) {
            this.mVars = vars;
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term[] values = new Term[this.mVars.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (Term)let.mResultStack.removeLast();
            }
            Term newBody = (Term)let.mResultStack.removeLast();
            Theory theory = newBody.getTheory();
            Term result = theory.let(this.mVars, values, newBody);
            let.mResultStack.addLast(result);
        }
    }

    static class CollectLets
    implements NonRecursive.Walker {
        final TermInfo mTermInfo;

        public CollectLets(TermInfo parent) {
            this.mTermInfo = parent;
        }

        @Override
        public void walk(NonRecursive engine) {
            List lettedTerms = this.mTermInfo.mLettedTerms.getFirst();
            if (lettedTerms.isEmpty()) {
                this.mTermInfo.mLettedTerms.removeFirst();
                return;
            }
            FormulaLet let = (FormulaLet)engine;
            let.enqueueWalker(this);
            this.mTermInfo.mLettedTerms.addFirst(new ArrayList());
            for (TermInfo ti : lettedTerms) {
                let.enqueueWalker(new MarkLet(ti));
            }
        }
    }

    static class Transformer
    implements NonRecursive.Walker {
        TermInfo mTermInfo;

        public Transformer(TermInfo parent) {
            this.mTermInfo = parent;
        }

        public void enqueueBuildLetTerms(FormulaLet let) {
            for (ArrayList<TermInfo> letList : this.mTermInfo.mLettedTerms) {
                assert (!letList.isEmpty());
                TermVariable[] tvs = new TermVariable[letList.size()];
                let.enqueueWalker(new BuildLetTerm(tvs));
                int i = 0;
                for (TermInfo info : letList) {
                    assert (info.mSubst != null);
                    tvs[i++] = info.mSubst;
                    let.enqueueWalker(new Transformer(info));
                }
            }
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term term = this.mTermInfo.mTerm;
            this.enqueueBuildLetTerms(let);
            if (term instanceof LambdaTerm) {
                LambdaTerm lambda = (LambdaTerm)term;
                let.enqueueWalker(new BuildLambda(lambda));
                let.addTransformScope(lambda.getVariables(), this.mTermInfo.mScopes[0]);
                let.enqueueWalker(new Converter(lambda.getSubterm()));
            } else if (term instanceof QuantifiedFormula) {
                QuantifiedFormula quant = (QuantifiedFormula)term;
                let.enqueueWalker(new BuildQuantifier(quant));
                if (FormulaLet.isPattern(quant.getSubformula())) {
                    AnnotatedTerm at = (AnnotatedTerm)quant.getSubformula();
                    let.enqueueWalker(new BuildAnnotatedTerm(at));
                    let.addTransformScope(quant.getVariables(), this.mTermInfo.mScopes[0]);
                    let.enqueueWalker(new Converter(at.getSubterm()));
                    ArrayDeque<Object> todo = new ArrayDeque<Object>();
                    for (Annotation annot : at.getAnnotations()) {
                        if (annot.getValue() == null) continue;
                        todo.add(annot.getValue());
                    }
                    while (!todo.isEmpty()) {
                        Object value = todo.removeFirst();
                        if (value instanceof Term) {
                            let.mResultStack.addLast((Term)value);
                            continue;
                        }
                        if (!(value instanceof Object[])) continue;
                        for (Object elem : (Object[])value) {
                            todo.add(elem);
                        }
                    }
                } else {
                    let.addTransformScope(quant.getVariables(), this.mTermInfo.mScopes[0]);
                    let.enqueueWalker(new Converter(quant.getSubformula()));
                }
            } else if (term instanceof AnnotatedTerm) {
                AnnotatedTerm at = (AnnotatedTerm)term;
                let.enqueueWalker(new BuildAnnotatedTerm(at));
                if (FormulaLet.isNamed(at)) {
                    let.enqueueLetter(at.getSubterm());
                } else {
                    let.enqueueWalker(new Converter(at.getSubterm()));
                    ArrayDeque<Object> todo = new ArrayDeque<Object>();
                    for (Annotation annot : at.getAnnotations()) {
                        if (annot.getValue() == null) continue;
                        todo.add(annot.getValue());
                    }
                    while (!todo.isEmpty()) {
                        Object value = todo.removeLast();
                        if (value instanceof Term) {
                            let.enqueueWalker(new Converter((Term)value));
                            continue;
                        }
                        if (!(value instanceof Object[])) continue;
                        for (Object elem : (Object[])value) {
                            todo.add(elem);
                        }
                    }
                }
            } else if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                let.enqueueWalker(new BuildApplicationTerm(appTerm));
                Term[] params = appTerm.getParameters();
                for (int i = params.length - 1; i >= 0; --i) {
                    let.enqueueWalker(new Converter(params[i]));
                }
            } else if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                let.enqueueWalker(new BuildMatchTerm(matchTerm));
                Term[] cases = matchTerm.getCases();
                for (int i = cases.length - 1; i >= 0; --i) {
                    let.enqueueWalker(new TransformMatchCase(matchTerm, this.mTermInfo, i));
                }
                let.enqueueWalker(new Converter(matchTerm.getDataTerm()));
            } else {
                let.mResultStack.addLast(term);
            }
        }
    }

    public static class TransformMatchCase
    implements NonRecursive.Walker {
        MatchTerm mTerm;
        TermInfo mInfo;
        int mCaseNr;

        public TransformMatchCase(MatchTerm term, TermInfo info, int caseNr) {
            this.mTerm = term;
            this.mInfo = info;
            this.mCaseNr = caseNr;
        }

        @Override
        public void walk(NonRecursive walker) {
            FormulaLet let = (FormulaLet)walker;
            let.addTransformScope(this.mTerm.getVariables()[this.mCaseNr], this.mInfo.mScopes[this.mCaseNr]);
            let.enqueueWalker(new Converter(this.mTerm.getCases()[this.mCaseNr]));
        }
    }

    static class Converter
    implements NonRecursive.Walker {
        Term mTerm;

        public Converter(Term term) {
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term term = this.mTerm;
            Map scopeInfos = (Map)let.mVisited.get(let.findScope(term));
            TermInfo info = (TermInfo)scopeInfos.get(term);
            if (info == null) {
                let.mResultStack.addLast(term);
            } else if (info.mSubst != null) {
                let.mResultStack.addLast(info.mSubst);
            } else {
                let.enqueueWalker(new Transformer(info));
            }
        }
    }

    public static class CollectMatchCase
    implements NonRecursive.Walker {
        MatchTerm mTerm;
        TermInfo mInfo;
        int mCaseNr;

        public CollectMatchCase(MatchTerm term, TermInfo info, int caseNr) {
            this.mTerm = term;
            this.mInfo = info;
            this.mCaseNr = caseNr;
        }

        @Override
        public void walk(NonRecursive walker) {
            FormulaLet let = (FormulaLet)walker;
            this.mInfo.mScopes[this.mCaseNr] = let.newScope(this.mTerm.getVariables()[this.mCaseNr]);
            let.visitChild(this.mTerm.getCases()[this.mCaseNr]);
        }
    }

    public static class CollectInfo
    implements NonRecursive.Walker {
        Term mTerm;
        TermInfo mInfo;

        public CollectInfo(Term term, TermInfo info) {
            this.mTerm = term;
            this.mInfo = info;
        }

        @Override
        public void walk(NonRecursive walker) {
            FormulaLet let = (FormulaLet)walker;
            if (this.mTerm instanceof AnnotatedTerm) {
                AnnotatedTerm annotTerm = (AnnotatedTerm)this.mTerm;
                if (!FormulaLet.isNamed(annotTerm)) {
                    let.visitChild(annotTerm.getSubterm());
                    ArrayDeque<Object> todo = new ArrayDeque<Object>();
                    for (Annotation annot : annotTerm.getAnnotations()) {
                        if (annot.getValue() == null) continue;
                        todo.add(annot.getValue());
                    }
                    while (!todo.isEmpty()) {
                        Object value = todo.removeLast();
                        if (value instanceof Term) {
                            let.visitChild((Term)value);
                            continue;
                        }
                        if (!(value instanceof Object[])) continue;
                        for (Object elem : (Object[])value) {
                            todo.add(elem);
                        }
                    }
                }
            } else if (this.mTerm instanceof ApplicationTerm) {
                Term[] args;
                ApplicationTerm term = (ApplicationTerm)this.mTerm;
                for (Term t : args = term.getParameters()) {
                    let.visitChild(t);
                }
            } else if (this.mTerm instanceof LambdaTerm) {
                LambdaTerm lambda = (LambdaTerm)this.mTerm;
                this.mInfo.mScopes = new Map[]{let.newScope(lambda.getVariables())};
                let.visitChild(lambda.getSubterm());
            } else if (this.mTerm instanceof QuantifiedFormula) {
                QuantifiedFormula quant = (QuantifiedFormula)this.mTerm;
                this.mInfo.mScopes = new Map[]{let.newScope(quant.getVariables())};
                if (FormulaLet.isPattern(quant.getSubformula())) {
                    let.visitChild(((AnnotatedTerm)quant.getSubformula()).getSubterm());
                } else {
                    let.visitChild(quant.getSubformula());
                }
            } else if (this.mTerm instanceof MatchTerm) {
                MatchTerm match = (MatchTerm)this.mTerm;
                int numCases = match.getCases().length;
                this.mInfo.mScopes = new Map[numCases];
                for (int i = numCases - 1; i >= 0; --i) {
                    let.enqueueWalker(new CollectMatchCase(match, this.mInfo, i));
                }
                let.visitChild(match.getDataTerm());
            } else {
                throw new AssertionError();
            }
        }
    }

    private static final class TermInfo {
        final Term mTerm;
        int mCount;
        int mSeen;
        ArrayDeque<ArrayList<TermInfo>> mLettedTerms;
        TermVariable mSubst;
        TermInfo mParent;
        int mPDepth;
        Map<Term, TermInfo>[] mScopes;

        public TermInfo(Term term) {
            this.mTerm = term;
            this.mCount = 1;
        }

        public boolean shouldBuildLet() {
            TermInfo info = this;
            while (info.mCount == 1) {
                info = info.mParent;
                if (info == null) {
                    return false;
                }
                if (FormulaLet.bindsVariable(info.mTerm, this.mTerm)) {
                    return false;
                }
                if (info.mSubst == null) continue;
                return false;
            }
            return true;
        }

        public void mergeParent(TermInfo parent) {
            if (this.mParent == null) {
                this.mParent = parent;
                this.mPDepth = parent.mPDepth + 1;
                return;
            }
            while (this.mParent != parent) {
                if (parent.mPDepth == this.mParent.mPDepth) {
                    parent = parent.mParent;
                    this.mParent = this.mParent.mParent;
                    continue;
                }
                if (parent.mPDepth > this.mParent.mPDepth) {
                    parent = parent.mParent;
                    continue;
                }
                this.mParent = this.mParent.mParent;
            }
            this.mPDepth = this.mParent.mPDepth + 1;
        }
    }

    public static final class ScopeRemover
    implements NonRecursive.Walker {
        @Override
        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            int scopeNr = let.mScopes.size() - 1;
            let.mScopes.remove(scopeNr);
            let.mVisited.remove(scopeNr);
        }
    }

    public static interface LetFilter {
        public boolean isLettable(Term var1);
    }
}

