/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FormulaUnLet
extends TermTransformer {
    private final ScopedHashMap<TermVariable, Term> mLetMap = new ScopedHashMap(false);
    private final UnletType mType;
    private final ArrayList<TermVariable[]> mMatchVars = new ArrayList();

    public FormulaUnLet() {
        this(UnletType.SMTLIB);
    }

    public FormulaUnLet(UnletType type) {
        this.mType = type;
    }

    public void addSubstitutions(Map<TermVariable, Term> termSubst) {
        this.mLetMap.putAll(termSubst);
    }

    public Term unlet(Term term) {
        return this.transform(term);
    }

    private boolean isRenamedVar(String name) {
        return name.charAt(0) == '.' && name.charAt(1) >= '1' && name.charAt(1) <= '9';
    }

    private void noteUsage(Map<String, Integer> usageMap, TermVariable usedTv) {
        Integer oldGen;
        String name = usedTv.getName();
        int generation = 0;
        if (this.isRenamedVar(name)) {
            int dotPos = name.indexOf(46, 2);
            generation = Integer.valueOf(name.substring(1, dotPos));
            name = name.substring(dotPos + 1);
        }
        if ((oldGen = usageMap.put(name, generation)) != null && oldGen > generation) {
            usageMap.put(name, oldGen);
        }
    }

    private String boundedRename(Map<String, Integer> usageMap, String name) {
        Integer usedOutside;
        if (this.isRenamedVar(name)) {
            name = name.substring(name.indexOf(46, 2) + 1);
        }
        if ((usedOutside = usageMap.get(name)) == null) {
            return name;
        }
        return "." + (usedOutside + 1) + "." + name;
    }

    public void startVarScope(Term body, TermVariable[] vars) {
        HashMap<String, Integer> usedOutside = new HashMap<String, Integer>();
        HashSet<TermVariable> bodyVars = new HashSet<TermVariable>();
        bodyVars.addAll(Arrays.asList(body.getFreeVars()));
        for (TermVariable tv : vars) {
            bodyVars.remove(tv);
        }
        for (TermVariable tv : bodyVars) {
            Term refTerm = this.mLetMap.get(tv);
            if (refTerm == null) {
                this.noteUsage(usedOutside, tv);
                continue;
            }
            for (TermVariable usedTv : refTerm.getFreeVars()) {
                this.noteUsage(usedOutside, usedTv);
            }
        }
        this.mLetMap.beginScope();
        for (int i = 0; i < vars.length; ++i) {
            String name = vars[i].getName();
            String newName = this.boundedRename(usedOutside, name);
            if (newName.equals(name)) {
                if (!this.mLetMap.containsKey(vars[i])) continue;
                this.mLetMap.remove(vars[i]);
                continue;
            }
            this.mLetMap.put(vars[i], vars[i].getTheory().createTermVariable(newName, vars[i].getSort()));
        }
    }

    public TermVariable[] endVarScope(TermVariable[] vars) {
        TermVariable[] newVars = vars;
        for (int i = 0; i < vars.length; ++i) {
            Term newVar = this.mLetMap.get(vars[i]);
            if (newVar == null) continue;
            if (vars == newVars) {
                newVars = (TermVariable[])vars.clone();
            }
            newVars[i] = (TermVariable)newVar;
        }
        this.mLetMap.endScope();
        return newVars;
    }

    @Override
    public void convert(Term term) {
        if (term instanceof TermVariable) {
            Term value = this.mLetMap.get(term);
            if (value == null) {
                this.setResult(term);
            } else if (this.mType.mIsLazy) {
                this.pushTerm(value);
            } else {
                this.setResult(value);
            }
        } else if (this.mType.mIsLazy && term instanceof LetTerm) {
            LetTerm letTerm = (LetTerm)term;
            this.preConvertLet(letTerm, letTerm.getValues());
        } else if (term instanceof LambdaTerm) {
            LambdaTerm lambda = (LambdaTerm)term;
            this.startVarScope(lambda.getSubterm(), lambda.getVariables());
            super.convert(term);
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)term;
            this.startVarScope(qf.getSubformula(), qf.getVariables());
            super.convert(term);
        } else if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if (this.mType.mExpandDefinitions && appTerm.getFunction().getDefinition() != null) {
                FunctionSymbol defed = appTerm.getFunction();
                Term fakeLet = appTerm.getTheory().let(defed.getDefinitionVars(), appTerm.getParameters(), defed.getDefinition());
                this.pushTerm(fakeLet);
                return;
            }
            super.convert(term);
        } else {
            super.convert(term);
        }
    }

    @Override
    public void preConvertLet(LetTerm oldLet, Term[] newValues) {
        this.mLetMap.beginScope();
        TermVariable[] vars = oldLet.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            this.mLetMap.put(vars[i], newValues[i]);
        }
        super.preConvertLet(oldLet, newValues);
    }

    @Override
    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        this.setResult(newBody);
        this.mLetMap.endScope();
    }

    @Override
    public void postConvertLambda(LambdaTerm old, Term newBody) {
        TermVariable[] newVars;
        TermVariable[] vars = old.getVariables();
        if (vars == (newVars = this.endVarScope(vars)) && old.getSubterm() == newBody) {
            this.setResult(old);
        } else {
            Theory theory = old.getTheory();
            this.setResult(theory.lambda(newVars, newBody));
        }
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        TermVariable[] newVars;
        TermVariable[] vars = old.getVariables();
        if (vars == (newVars = this.endVarScope(vars)) && old.getSubformula() == newBody) {
            this.setResult(old);
        } else {
            Theory theory = old.getTheory();
            this.setResult(old.getQuantifier() == 0 ? theory.exists(newVars, newBody) : theory.forall(newVars, newBody));
        }
    }

    @Override
    public void preConvertMatchCase(MatchTerm oldMatch, int caseNr) {
        if (caseNr > 0) {
            this.mMatchVars.add(this.endVarScope(oldMatch.getVariables()[caseNr - 1]));
        }
        this.startVarScope(oldMatch.getCases()[caseNr], oldMatch.getVariables()[caseNr]);
        super.preConvertMatchCase(oldMatch, caseNr);
    }

    @Override
    public void postConvertMatch(MatchTerm oldMatch, Term newDataTerm, Term[] newCases) {
        assert (oldMatch.getCases().length > 0);
        this.mMatchVars.add(this.endVarScope(oldMatch.getVariables()[oldMatch.getVariables().length - 1]));
        TermVariable[][] oldVars = oldMatch.getVariables();
        TermVariable[][] newVars = null;
        for (int i = oldVars.length - 1; i >= 0; --i) {
            TermVariable[] newVarsCase = this.mMatchVars.remove(this.mMatchVars.size() - 1);
            if (newVarsCase == oldVars[i]) continue;
            if (newVars == null) {
                newVars = (TermVariable[][])oldVars.clone();
            }
            newVars[i] = newVarsCase;
        }
        if (newVars != null) {
            this.setResult(oldMatch.getTheory().match(newDataTerm, newVars, newCases, oldMatch.getConstructors()));
        } else {
            super.postConvertMatch(oldMatch, newDataTerm, newCases);
        }
    }

    public static enum UnletType {
        SMTLIB(false, false),
        LAZY(true, false),
        EXPAND_DEFINITIONS(false, true);

        final boolean mIsLazy;
        final boolean mExpandDefinitions;

        private UnletType(boolean lazy, boolean expandDefinitions) {
            this.mIsLazy = lazy;
            this.mExpandDefinitions = expandDefinitions;
        }
    }
}

