/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.Arrays;

public class IRAWrapperFactory {
    final UnifyHash<FunctionSymbol> mInstances = new UnifyHash();

    public FunctionSymbol createWrapper(Theory theory, String name, String[] indices, Sort[] paramSorts, Sort resultType) {
        FunctionSymbol fsym;
        Sort realSort = theory.getRealSort();
        Sort intSort = theory.getNumericSort();
        if (name.equals("ite") && indices == null) {
            if (paramSorts[0] != theory.getBooleanSort()) {
                return null;
            }
            if (!(paramSorts[1] == intSort && paramSorts[2] == realSort || paramSorts[1] == realSort && paramSorts[2] == intSort)) {
                return null;
            }
            fsym = theory.getFunctionWithResult(name, indices, resultType, theory.getBooleanSort(), realSort, realSort);
            if (fsym == null) {
                return null;
            }
        } else {
            boolean hasInt = false;
            for (int i = 0; i < paramSorts.length; ++i) {
                if (paramSorts[i] == intSort) {
                    hasInt = true;
                    continue;
                }
                if (paramSorts[i] == realSort) continue;
                return null;
            }
            if (!hasInt) {
                return null;
            }
            fsym = theory.getFunctionWithResult(name, indices, resultType, realSort, realSort);
            if (fsym == null) {
                return null;
            }
            if (paramSorts.length != 2 && (paramSorts.length < 2 || (fsym.mFlags & 0xE) == 0)) {
                return null;
            }
        }
        int hash = fsym.hashCode() ^ Arrays.hashCode(paramSorts);
        for (FunctionSymbol func : this.mInstances.iterateHashCode(hash)) {
            if (((ApplicationTerm)func.getDefinition()).getFunction() != fsym || !Arrays.equals(func.mParamSort, paramSorts)) continue;
            return func;
        }
        TermVariable[] defVars = new TermVariable[paramSorts.length];
        Term[] wrappedArgs = new Term[paramSorts.length];
        for (int i = 0; i < paramSorts.length; ++i) {
            defVars[i] = theory.createTermVariable("x" + i, paramSorts[i]);
            wrappedArgs[i] = paramSorts[i] == intSort ? theory.term("to_real", defVars[i]) : defVars[i];
        }
        Term definition = theory.term(fsym, wrappedArgs);
        assert (definition != null);
        FunctionSymbol wrapper = new FunctionSymbol(fsym.getName(), fsym.getIndices(), paramSorts, fsym.getReturnSort(), defVars, definition, fsym.mFlags & 0xFFFFFFF1);
        this.mInstances.put(hash, wrapper);
        return wrapper;
    }
}

