/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class LambdaTerm
extends Term {
    private final TermVariable[] mVariables;
    private final Term mSubTerm;

    LambdaTerm(TermVariable[] vars, Term subterm, int hash) {
        super(hash);
        this.mVariables = vars;
        this.mSubTerm = subterm;
    }

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term getSubterm() {
        return this.mSubTerm;
    }

    @Override
    public Sort getSort() {
        return this.mSubTerm.getSort();
    }

    public static final int hashLambda(TermVariable[] vars, Term f) {
        return HashUtils.hashJenkins(f.hashCode(), vars);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> mTodo) {
        mTodo.addLast(")");
        mTodo.addLast(this.getSubterm());
        mTodo.addLast(")) ");
        TermVariable[] vars = this.getVariables();
        for (int i = vars.length - 1; i > 0; --i) {
            mTodo.addLast(vars[i].getSort());
            mTodo.addLast(") (" + vars[i] + " ");
        }
        mTodo.addLast(vars[0].getSort());
        mTodo.addLast("(lambda ((" + vars[0] + " ");
    }
}

