/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

public enum Logics {
    CORE(0),
    ALL(4047),
    HORN(4047),
    QF_ABV(12),
    QF_ABVFP(524),
    QF_ABVFPLRA(812),
    QF_ALIA(164),
    QF_ANIA(196),
    QF_AUFBV(14),
    QF_AUFBVFP(526),
    QF_AUFBVLIA(174),
    QF_AUFBVNIA(206),
    QF_AUFLIA(166),
    QF_AUFLIRA(422),
    QF_AUFNIA(198),
    QF_AUFNIRA(454),
    QF_AX(4),
    QF_BV(8),
    QF_BVFP(520),
    QF_BVFPLRA(808),
    QF_DT(1024),
    QF_FP(512),
    QF_FPLRA(800),
    QF_IDL(144),
    QF_LIA(160),
    QF_LIRA(416),
    QF_LRA(288),
    QF_NIA(192),
    QF_NIRA(448),
    QF_NRA(320),
    QF_RDL(272),
    QF_S(2048),
    QF_SLIA(2208),
    QF_SNIA(2240),
    QF_UF(2),
    QF_UFBV(10),
    QF_UFBVLIA(170),
    QF_UFDT(1026),
    QF_UFDTLIA(1186),
    QF_UFDTLIRA(1442),
    QF_UFFP(514),
    QF_UFFPDTLIRA(1954),
    QF_UFFPDTNIRA(1986),
    QF_UFIDL(146),
    QF_UFLIA(162),
    QF_UFLIRA(418),
    QF_UFLRA(290),
    QF_UFNIA(194),
    QF_UFNRA(322),
    ABV(13),
    ABVFP(525),
    ABVFPLRA(813),
    ALIA(165),
    ANIA(197),
    AUFBV(15),
    AUFBVDTLIA(1199),
    AUFBVDTNIA(1231),
    AUFBVFP(527),
    AUFDTLIA(1191),
    AUFDTNIA(1223),
    AUFDTLIRA(1447),
    AUFDTNIRA(1479),
    AUFFPDTLIRA(1959),
    AUFFPDTNIRA(1991),
    AUFLIA(167),
    AUFLIRA(423),
    AUFNIA(199),
    AUFNIRA(455),
    BV(9),
    BVFP(521),
    BVFPLRA(809),
    FP(513),
    FPLRA(801),
    LIA(161),
    LRA(289),
    NIA(193),
    NRA(321),
    UF(3),
    UFBV(11),
    UFBVFP(523),
    UFBVLIA(171),
    UFDT(1027),
    UFDTLIA(1187),
    UFDTLIRA(1443),
    UFDTNIA(1219),
    UFDTNIRA(1475),
    UFFPDTLIRA(1955),
    UFFPDTNIRA(1987),
    UFIDL(147),
    UFLIA(163),
    UFLRA(291),
    UFNIA(195),
    UFNRA(323);

    private final int mFeatures;

    private Logics(int features) {
        this.mFeatures = features;
    }

    public boolean isIRA() {
        return (this.mFeatures & 0x180) == 384;
    }

    public boolean isUF() {
        return (this.mFeatures & 2) != 0;
    }

    public boolean isArray() {
        return (this.mFeatures & 4) != 0;
    }

    public boolean isBitVector() {
        return (this.mFeatures & 8) != 0;
    }

    public boolean isQuantified() {
        return (this.mFeatures & 1) != 0;
    }

    public boolean isArithmetic() {
        return (this.mFeatures & 0x70) != 0;
    }

    public boolean isDifferenceLogic() {
        return (this.mFeatures & 0x10) != 0;
    }

    public boolean isLinearArithmetic() {
        return (this.mFeatures & 0x30) != 0;
    }

    public boolean isNonLinearArithmetic() {
        return (this.mFeatures & 0x40) != 0;
    }

    public boolean hasIntegers() {
        return (this.mFeatures & 0x80) != 0;
    }

    public boolean hasReals() {
        return (this.mFeatures & 0x100) != 0;
    }

    public boolean isFloatingPoint() {
        return (this.mFeatures & 0x200) != 0;
    }

    public boolean isDatatype() {
        return (this.mFeatures & 0x400) != 0;
    }

    public boolean isString() {
        return (this.mFeatures & 0x800) != 0;
    }

    static class Features {
        static final int QU = 1;
        static final int UF = 2;
        static final int AX = 4;
        static final int BV = 8;
        static final int DL = 16;
        static final int LA = 32;
        static final int NA = 64;
        static final int IA = 128;
        static final int RA = 256;
        static final int FP = 512;
        static final int DT = 1024;
        static final int S = 2048;

        Features() {
        }
    }
}

