/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class MatchTerm
extends Term {
    private final Term mDataTerm;
    private final TermVariable[][] mVariables;
    private final Term[] mCases;
    private final DataType.Constructor[] mConstructors;

    MatchTerm(int hash, Term dataArg, TermVariable[][] vars, Term[] cases, DataType.Constructor[] constructors) {
        super(hash);
        this.mDataTerm = dataArg;
        this.mVariables = vars;
        this.mCases = cases;
        this.mConstructors = constructors;
    }

    @Override
    public Sort getSort() {
        return this.mCases[0].getSort();
    }

    public Term getDataTerm() {
        return this.mDataTerm;
    }

    public DataType.Constructor[] getConstructors() {
        return this.mConstructors;
    }

    public TermVariable[][] getVariables() {
        return this.mVariables;
    }

    public Term[] getCases() {
        return this.mCases;
    }

    public static final int hashMatch(Term dataArg, TermVariable[][] vars, Term[] cases) {
        return HashUtils.hashJenkins(dataArg.hashCode(), cases);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> mTodo) {
        mTodo.addLast("))");
        for (int i = this.mCases.length - 1; i >= 0; --i) {
            mTodo.addLast(")");
            mTodo.addLast(this.mCases[i]);
            if (this.mConstructors[i] == null) {
                mTodo.addLast(" ");
                mTodo.addLast(this.mVariables[i][0]);
            } else if (this.mVariables[i].length > 0) {
                mTodo.addLast(") ");
                for (int j = this.mVariables[i].length - 1; j >= 0; --j) {
                    mTodo.addLast(this.mVariables[i][j]);
                    mTodo.addLast(" ");
                }
                mTodo.addLast(this.mConstructors[i].getName());
                mTodo.addLast("(");
            } else {
                mTodo.addLast(" ");
                mTodo.addLast(this.mConstructors[i].getName());
            }
            mTodo.addLast(i > 0 ? " (" : "(");
        }
        mTodo.addLast(" (");
        mTodo.addLast(this.mDataTerm);
        mTodo.addLast("(match ");
    }
}

