/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.math.BigInteger;

public class MutableRational
implements Comparable<MutableRational> {
    int mNum;
    int mDenom;
    BigInteger mBignum;
    BigInteger mBigdenom;

    public MutableRational(int num, int denom) {
        this.setValue(num, denom);
    }

    public MutableRational(BigInteger num, BigInteger denom) {
        this.mBignum = num;
        this.mBigdenom = denom;
        this.normalize();
    }

    public MutableRational(Rational r) {
        this.mNum = r.mNum;
        this.mDenom = r.mDenom;
        if (r instanceof Rational.BigRational) {
            this.mBignum = r.numerator();
            this.mBigdenom = r.denominator();
        }
    }

    public MutableRational(MutableRational r) {
        this.mNum = r.mNum;
        this.mDenom = r.mDenom;
        this.mBignum = r.mBignum;
        this.mBigdenom = r.mBigdenom;
    }

    public void setValue(Rational value) {
        this.mNum = value.mNum;
        this.mDenom = value.mDenom;
        if (value instanceof Rational.BigRational) {
            this.mBignum = value.numerator();
            this.mBigdenom = value.denominator();
        } else {
            this.mBigdenom = null;
            this.mBignum = null;
        }
    }

    public void setValue(long newnum, long newdenom) {
        long gcd2 = Rational.gcd(Math.abs(newnum), Math.abs(newdenom));
        if (newdenom < 0L) {
            gcd2 = -gcd2;
        }
        if (gcd2 != 0L) {
            newnum /= gcd2;
            newdenom /= gcd2;
        }
        if (Integer.MIN_VALUE <= newnum && newnum <= Integer.MAX_VALUE && newdenom <= Integer.MAX_VALUE) {
            this.mNum = (int)newnum;
            this.mDenom = (int)newdenom;
            this.mBigdenom = null;
            this.mBignum = null;
        } else {
            this.mBignum = BigInteger.valueOf(newnum);
            this.mBigdenom = BigInteger.valueOf(newdenom);
        }
    }

    private void normalize() {
        if (this.mBignum == null) {
            int norm = Rational.gcd(this.mNum, this.mDenom);
            if (norm != 0 && norm != 1) {
                this.mNum /= norm;
                this.mDenom /= norm;
            }
            if (this.mDenom < 0) {
                this.mNum = -this.mNum;
                this.mDenom = -this.mDenom;
            }
        } else {
            if (!this.mBigdenom.equals(BigInteger.ONE)) {
                BigInteger norm = Rational.gcd(this.mBignum, this.mBigdenom).abs();
                if (this.mBigdenom.signum() < 0) {
                    norm = norm.negate();
                }
                if (!norm.equals(BigInteger.ZERO) && !norm.equals(BigInteger.ONE)) {
                    this.mBignum = this.mBignum.divide(norm);
                    this.mBigdenom = this.mBigdenom.divide(norm);
                }
            }
            if (this.mBigdenom.bitLength() < 32 && this.mBignum.bitLength() < 32) {
                this.mNum = this.mBignum.intValue();
                this.mDenom = this.mBigdenom.intValue();
                this.mBigdenom = null;
                this.mBignum = null;
            }
        }
    }

    public MutableRational add(Rational other) {
        BigInteger odenom;
        if (other == Rational.ZERO) {
            return this;
        }
        if (this.mBignum == null && !(other instanceof Rational.BigRational)) {
            if (this.mDenom == other.mDenom) {
                if (this.mDenom == 0) {
                    if (this.mNum != other.mNum) {
                        this.mNum = 0;
                    }
                } else {
                    this.setValue((long)this.mNum + (long)other.mNum, this.mDenom);
                }
            } else {
                int gcd = Rational.gcd(this.mDenom, other.mDenom);
                long denomgcd = this.mDenom / gcd;
                long otherdenomgcd = other.mDenom / gcd;
                long newdenom = denomgcd * (long)other.mDenom;
                long newnum = otherdenomgcd * (long)this.mNum + denomgcd * (long)other.mNum;
                this.setValue(newnum, newdenom);
            }
            return this;
        }
        if (this.mBignum == null && this.mNum == 0 && this.mDenom == 1) {
            this.mBignum = other.numerator();
            this.mBigdenom = other.denominator();
            return this;
        }
        BigInteger tdenom = this.denominator();
        if (tdenom.equals(odenom = other.denominator())) {
            this.mBignum = this.numerator().add(other.numerator());
            this.mBigdenom = tdenom;
        } else {
            BigInteger gcd = Rational.gcd(tdenom, odenom);
            BigInteger tdenomgcd = tdenom.divide(gcd);
            BigInteger odenomgcd = odenom.divide(gcd);
            this.mBignum = this.numerator().multiply(odenomgcd).add(other.numerator().multiply(tdenomgcd));
            this.mBigdenom = tdenom.multiply(odenomgcd);
        }
        this.normalize();
        return this;
    }

    public MutableRational negate() {
        if (this.mBignum == null) {
            if (this.mNum == Integer.MIN_VALUE) {
                this.setValue(0x80000000L, this.mDenom);
            } else {
                this.mNum = -this.mNum;
            }
        } else {
            this.mBignum = this.mBignum.negate();
        }
        return this;
    }

    public MutableRational sub(Rational other) {
        return this.add(other.negate());
    }

    public MutableRational mul(Rational other) {
        if (other == Rational.ONE) {
            return this;
        }
        if (other == Rational.MONE) {
            return this.negate();
        }
        if (this.mBignum == null && !(other instanceof Rational.BigRational)) {
            long newnum = (long)this.mNum * (long)other.mNum;
            long newdenom = (long)this.mDenom * (long)other.mDenom;
            this.setValue(newnum, newdenom);
            return this;
        }
        this.mBignum = this.numerator().multiply(other.numerator());
        this.mBigdenom = this.denominator().multiply(other.denominator());
        this.normalize();
        return this;
    }

    public MutableRational div(Rational other) {
        if (other == Rational.ZERO) {
            throw new ArithmeticException("Division by ZERO");
        }
        if (this.mBignum == null && this.mNum == 0) {
            return this;
        }
        if (other == Rational.ONE) {
            return this;
        }
        if (other == Rational.MONE) {
            return this.negate();
        }
        if (this.mBignum == null && !(other instanceof Rational.BigRational)) {
            long newnum = (long)this.mNum * (long)other.mDenom;
            long newdenom = (long)this.mDenom * (long)other.mNum;
            if (newdenom == 0L && other.mNum < 0) {
                newnum = -newnum;
            }
            this.setValue(newnum, newdenom);
            return this;
        }
        this.mBignum = this.numerator().multiply(other.denominator());
        this.mBigdenom = this.denominator().multiply(other.numerator());
        if (this.mBigdenom.equals(BigInteger.ZERO) && other.numerator().signum() == -1) {
            this.mBignum = this.mBignum.negate();
        }
        this.normalize();
        return this;
    }

    public MutableRational inverse() {
        if (this.mBignum == null) {
            this.setValue(this.mDenom, this.mNum);
        } else {
            BigInteger tmp = this.mBigdenom;
            if (this.mBignum.signum() < 0) {
                this.mBigdenom = this.mBignum.negate();
                this.mBignum = tmp.negate();
            } else {
                this.mBigdenom = this.mBignum;
                this.mBignum = tmp;
            }
        }
        return this;
    }

    public boolean isNegative() {
        return this.numerator().signum() < 0;
    }

    public MutableRational addmul(Rational fac1, Rational fac2) {
        return this.add(fac1.mul(fac2));
    }

    public MutableRational addmul(Rational fac1, BigInteger fac2) {
        return this.add(fac1.mul(fac2));
    }

    public MutableRational subdiv(Rational s, Rational d) {
        return this.sub(s).div(d);
    }

    @Override
    public int compareTo(MutableRational o) {
        if (this.mBignum == null && o.mBignum == null) {
            if (o.mDenom == this.mDenom) {
                return this.mNum < o.mNum ? -1 : (this.mNum == o.mNum ? 0 : 1);
            }
            long valt = (long)this.mNum * (long)o.mDenom;
            long valo = (long)o.mNum * (long)this.mDenom;
            return valt < valo ? -1 : (valt == valo ? 0 : 1);
        }
        BigInteger valthis = this.numerator().multiply(o.denominator());
        BigInteger valo = o.numerator().multiply(this.denominator());
        return valthis.compareTo(valo);
    }

    @Override
    public int compareTo(Rational o) {
        if (this.mBignum == null && !(o instanceof Rational.BigRational)) {
            if (o.mDenom == this.mDenom) {
                return this.mNum < o.mNum ? -1 : (this.mNum == o.mNum ? 0 : 1);
            }
            long valt = (long)this.mNum * (long)o.mDenom;
            long valo = (long)o.mNum * (long)this.mDenom;
            return valt < valo ? -1 : (valt == valo ? 0 : 1);
        }
        BigInteger valthis = this.numerator().multiply(o.denominator());
        BigInteger valo = o.numerator().multiply(this.denominator());
        return valthis.compareTo(valo);
    }

    public boolean equals(Object o) {
        if (o instanceof Rational) {
            Rational r = (Rational)o;
            return this.mBignum == null ? !(r instanceof Rational.BigRational) && this.mNum == r.mNum && this.mDenom == r.mDenom : this.mBignum.equals(r.numerator()) && this.mBigdenom.equals(r.denominator());
        }
        if (o instanceof MutableRational) {
            MutableRational r = (MutableRational)o;
            return this.mBignum == null ? r.mBignum == null && this.mNum == r.mNum && this.mDenom == r.mDenom : this.mBignum.equals(r.mBignum) && this.mBigdenom.equals(r.mBigdenom);
        }
        return false;
    }

    public BigInteger numerator() {
        return this.mBignum == null ? BigInteger.valueOf(this.mNum) : this.mBignum;
    }

    public BigInteger denominator() {
        return this.mBigdenom == null ? BigInteger.valueOf(this.mDenom) : this.mBigdenom;
    }

    public int hashCode() {
        if (this.mBignum == null) {
            return this.mNum * 257 + this.mDenom;
        }
        return this.mBignum.hashCode() * 257 + this.mBigdenom.hashCode();
    }

    public String toString() {
        if (this.mBignum == null) {
            if (this.mDenom == 0) {
                return this.mNum > 0 ? "inf" : (this.mNum == 0 ? "nan" : "-inf");
            }
            if (this.mDenom == 1) {
                return String.valueOf(this.mNum);
            }
            return this.mNum + "/" + this.mDenom;
        }
        if (this.mBigdenom.equals(BigInteger.ONE)) {
            return this.mBignum.toString();
        }
        return this.mBignum + "/" + this.mBigdenom;
    }

    public boolean isIntegral() {
        return this.mBignum == null ? this.mDenom <= 1 : this.mBigdenom.equals(BigInteger.ONE);
    }

    public Rational toRational() {
        if (this.mBignum == null) {
            return Rational.valueOf(this.mNum, this.mDenom);
        }
        return Rational.valueOf(this.numerator(), this.denominator());
    }

    public int signum() {
        if (this.mBignum == null) {
            return this.mNum < 0 ? -1 : (this.mNum == 0 ? 0 : 1);
        }
        return this.mBignum.signum();
    }
}

