/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class NoopScript
implements Script {
    private Theory mTheory;
    protected int mStackLevel = 0;
    protected Theory.SolverSetup mSolverSetup;

    public NoopScript() {
        this(null, null);
    }

    protected NoopScript(Theory theory) {
        this(theory, null);
    }

    protected NoopScript(Theory theory, Theory.SolverSetup setup) {
        this.mTheory = theory;
        this.mSolverSetup = setup;
    }

    @Override
    public Theory getTheory() {
        return this.mTheory;
    }

    private void checkSymbol(String symbol) throws SMTLIBException {
        if (symbol.indexOf(124) >= 0 || symbol.indexOf(92) >= 0) {
            throw new SMTLIBException("Symbol must not contain | or \\");
        }
    }

    @Override
    public void setLogic(String logic) throws UnsupportedOperationException {
        try {
            this.setLogic(Logics.valueOf(logic));
        }
        catch (IllegalArgumentException eLogicUnsupported) {
            throw new UnsupportedOperationException("Logic " + logic + " not supported");
        }
    }

    @Override
    public void setLogic(Logics logic) throws UnsupportedOperationException {
        if (this.mTheory != null) {
            throw new SMTLIBException("Logic already set!");
        }
        this.mTheory = new Theory(logic, this.mSolverSetup);
    }

    @Override
    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
    }

    @Override
    public void setInfo(String info, Object value) {
    }

    @Override
    public FunctionSymbol getFunctionSymbol(String constructor) {
        return this.mTheory.getFunctionSymbol(constructor);
    }

    @Override
    public DataType.Constructor constructor(String name, String[] selectors, Sort[] argumentSorts) {
        if (name == null) {
            throw new SMTLIBException("Invalid input to declare a datatype");
        }
        this.checkSymbol(name);
        return this.mTheory.createConstructor(name, selectors, argumentSorts);
    }

    @Override
    public DataType datatype(String typename, int numParams) {
        if (typename == null) {
            throw new SMTLIBException("Invalid input to declare a datatype");
        }
        this.checkSymbol(typename);
        return this.mTheory.createDatatypes(typename, numParams);
    }

    private void declareConstructorFunctions(DataType datatype, DataType.Constructor[] constrs, Sort[] sortParams) {
        Sort datatypeSort;
        String[] indices = null;
        if (sortParams == null) {
            if (datatype.mNumParams != 0) {
                throw new SMTLIBException("Sort parameters missing");
            }
            datatypeSort = datatype.getSort(indices, Theory.EMPTY_SORT_ARRAY);
        } else {
            if (datatype.mNumParams == 0 || datatype.mNumParams != sortParams.length) {
                throw new SMTLIBException("Sort parameter mismatch");
            }
            datatypeSort = datatype.getSort(indices, sortParams);
        }
        Sort[] selectorParamSorts = new Sort[]{datatypeSort};
        for (DataType.Constructor cons : constrs) {
            String constrName = cons.getName();
            String[] selectors = cons.getSelectors();
            Sort[] argumentSorts = cons.getArgumentSorts();
            if (sortParams == null) {
                this.getTheory().declareInternalFunction(constrName, argumentSorts, datatypeSort, 128);
                for (int j = 0; j < selectors.length; ++j) {
                    this.getTheory().declareInternalFunction(selectors[j], selectorParamSorts, argumentSorts[j], 256);
                }
                continue;
            }
            int constrFlags = 128 + (cons.needsReturnOverload() ? 16 : 0);
            this.getTheory().declareInternalPolymorphicFunction(constrName, sortParams, argumentSorts, datatypeSort, constrFlags);
            for (int j = 0; j < selectors.length; ++j) {
                this.getTheory().declareInternalPolymorphicFunction(selectors[j], sortParams, selectorParamSorts, argumentSorts[j], 256);
            }
        }
    }

    @Override
    public void declareDatatype(DataType datatype, DataType.Constructor[] constrs) {
        assert (datatype.mNumParams == 0);
        datatype.setConstructors(new Sort[0], constrs);
        this.declareConstructorFunctions(datatype, constrs, null);
    }

    @Override
    public void declareDatatypes(DataType[] datatypes, DataType.Constructor[][] constrs, Sort[][] sortParams) {
        for (int i = 0; i < datatypes.length; ++i) {
            datatypes[i].setConstructors(sortParams[i], constrs[i]);
            this.declareConstructorFunctions(datatypes[i], constrs[i], sortParams[i]);
        }
    }

    @Override
    public void declareSort(String sort, int arity) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.checkSymbol(sort);
        try {
            this.mTheory.declareSort(sort, arity);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.checkSymbol(sort);
        try {
            this.mTheory.defineSort(sort, sortParams.length, definition);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.checkSymbol(fun);
        try {
            this.mTheory.declareFunction(fun, paramSorts, resultSort);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        this.checkSymbol(fun);
        this.defineFunInternal(fun, params, resultSort, definition);
    }

    private void defineFunInternal(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!resultSort.equalsSort(definition.getSort())) {
            throw new SMTLIBException("Sort mismatch");
        }
        try {
            this.mTheory.defineFunction(fun, params, definition);
        }
        catch (IllegalArgumentException eiae) {
            throw new SMTLIBException(eiae.getMessage());
        }
    }

    @Override
    public void push(int levels) {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mStackLevel += levels;
        for (int i = 0; i < levels; ++i) {
            this.mTheory.push();
        }
    }

    @Override
    public void pop(int levels) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (levels > this.mStackLevel) {
            throw new SMTLIBException("Not enough levels on assertion stack");
        }
        this.mStackLevel -= levels;
        for (int i = 0; i < levels; ++i) {
            this.mTheory.pop();
        }
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Script.LBool checkSat() {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Script.LBool checkSatAssuming(Term ... assumptions) {
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOption(String opt) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getInfo(String info) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.mTheory = null;
        this.mStackLevel = 0;
    }

    @Override
    public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        int[] startOfSubtrees = new int[partition.length];
        return this.getInterpolants(partition, startOfSubtrees);
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException, UnsupportedOperationException {
        return this.getInterpolants(partition, startOfSubtree, this.getProof());
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree, Term proofTree) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exit() {
    }

    @Override
    public Sort sort(String sortname, Sort ... params) throws SMTLIBException {
        return this.sort(sortname, (String[])null, params);
    }

    @Override
    public Sort sort(String sortname, String[] indices, Sort ... params) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Sort res = this.mTheory.getSort(sortname, indices, params);
        if (res == null) {
            throw new SMTLIBException("Sort " + sortname + " not declared");
        }
        return res;
    }

    @Override
    public Term term(String funcname, Term ... params) throws SMTLIBException {
        return this.term(funcname, (String[])null, (Sort)null, params);
    }

    @Override
    public Term term(String funcname, String[] indices, Sort returnSort, Term ... params) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        return this.mTheory.term(funcname, indices, returnSort, params);
    }

    @Override
    public TermVariable variable(String varname, Sort sort) throws SMTLIBException {
        if (sort == null || varname == null) {
            throw new SMTLIBException("Invalid input to create a term variable");
        }
        this.checkSymbol(varname);
        return this.mTheory.createTermVariable(varname, sort);
    }

    @Override
    public Term quantifier(int quantor, TermVariable[] vars, Term body, Term[] ... patterns) throws SMTLIBException {
        if (vars.length == 0) {
            throw new SMTLIBException("No quantified variables given");
        }
        if (body == null) {
            throw new SMTLIBException("Empty quantifier body");
        }
        if (patterns != null && patterns.length > 0) {
            Annotation[] annots = new Annotation[patterns.length];
            int i = 0;
            for (Term[] p : patterns) {
                annots[i++] = new Annotation(":pattern", p);
            }
            body = this.mTheory.annotatedTerm(annots, body);
        }
        if (quantor == 0) {
            return this.mTheory.exists(vars, body);
        }
        if (quantor == 1) {
            return this.mTheory.forall(vars, body);
        }
        throw new SMTLIBException("Unknown Quantifier");
    }

    @Override
    public Term let(TermVariable[] vars, Term[] values, Term body) throws SMTLIBException {
        if (vars.length != values.length) {
            throw new SMTLIBException("Need exactly one value for every variable");
        }
        return this.mTheory.let(vars, values, body);
    }

    @Override
    public Term match(Term dataArg, TermVariable[][] vars, Term[] cases, DataType.Constructor[] constructors) throws SMTLIBException {
        return this.mTheory.match(dataArg, vars, cases, constructors);
    }

    @Override
    public Term annotate(Term t, Annotation ... annotations) throws SMTLIBException {
        if (annotations.length > 0) {
            for (Annotation a : annotations) {
                if (!a.getKey().equals(":named")) continue;
                if (!(a.getValue() instanceof String)) {
                    throw new SMTLIBException("Need a string value for :named");
                }
                this.checkSymbol((String)a.getValue());
                if (t.getFreeVars().length != 0) {
                    throw new SMTLIBException("Cannot name open terms");
                }
                this.defineFunInternal((String)a.getValue(), Theory.EMPTY_TERM_VARIABLE_ARRAY, t.getSort(), t);
            }
            return this.mTheory.annotatedTerm(annotations, t);
        }
        return t;
    }

    @Override
    public Term numeral(String num) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getNumericSort() == null) {
            throw new SMTLIBException("Logic does not allow numerals");
        }
        try {
            return this.mTheory.numeral(num);
        }
        catch (NumberFormatException enfe) {
            throw new SMTLIBException("Not a numeral: " + num);
        }
    }

    @Override
    public Term numeral(BigInteger num) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getNumericSort() == null) {
            throw new SMTLIBException("Logic does not allow numerals");
        }
        return this.mTheory.numeral(num);
    }

    @Override
    public Term decimal(String decimal) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getRealSort() == null) {
            throw new SMTLIBException("Logic does not allow reals");
        }
        try {
            return this.mTheory.decimal(decimal);
        }
        catch (NumberFormatException enfe) {
            throw new SMTLIBException("Not a decimal: " + decimal);
        }
    }

    @Override
    public Term decimal(BigDecimal decimal) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getRealSort() == null) {
            throw new SMTLIBException("Logic does not allow reals");
        }
        return this.mTheory.decimal(decimal);
    }

    @Override
    public Term string(QuotedObject str) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mTheory.getStringSort() == null) {
            throw new SMTLIBException("Logic does not allow strings");
        }
        return this.mTheory.string(str);
    }

    @Override
    public Term hexadecimal(String hex) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Term res = this.mTheory.hexadecimal(hex);
        if (res == null) {
            throw new SMTLIBException("No bitvector logic");
        }
        return res;
    }

    @Override
    public Term binary(String bin) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        Term res = this.mTheory.binary(bin);
        if (res == null) {
            throw new SMTLIBException("No bitvector logic");
        }
        return res;
    }

    @Override
    public Sort[] sortVariables(String ... names) throws SMTLIBException {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        return this.mTheory.createSortVariables(names);
    }

    @Override
    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Term[]> checkAllsat(Term[] predicates) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term[] findImpliedEquality(Term[] x, Term[] y) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public QuotedObject echo(QuotedObject msg) {
        return msg;
    }

    @Override
    public void resetAssertions() {
        if (this.mTheory == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mTheory.resetAssertions();
        this.mStackLevel = 0;
    }

    @Override
    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

