/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.util.HashMap;

public class PolymorphicFunctionSymbol
extends FunctionSymbolFactory {
    private final Sort[] mTypeParams;
    private final Sort[] mParamSorts;
    private final Sort mResultSort;
    private final int mFlags;

    PolymorphicFunctionSymbol(String name, Sort[] typeParams, Sort[] params, Sort result, int flags) {
        super(name);
        this.mTypeParams = typeParams;
        this.mParamSorts = params;
        this.mResultSort = result;
        this.mFlags = flags;
    }

    @Override
    public int getFlags(String[] indices, Sort[] paramSorts, Sort result) {
        return this.mFlags;
    }

    @Override
    public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort result) {
        if (indices != null) {
            return null;
        }
        if (paramSorts.length != this.mParamSorts.length) {
            return null;
        }
        HashMap<Sort, Sort> unifier = new HashMap<Sort, Sort>();
        for (int i = 0; i < paramSorts.length; ++i) {
            if (this.mParamSorts[i].unifySort(unifier, paramSorts[i])) continue;
            return null;
        }
        if (result != null) {
            if (!this.mResultSort.unifySort(unifier, result.getRealSort())) {
                return null;
            }
            return result;
        }
        Sort[] mapping = new Sort[this.mTypeParams.length];
        for (int i = 0; i < this.mTypeParams.length; ++i) {
            mapping[i] = unifier.get(this.mTypeParams[i]);
            if (mapping[i] != null) continue;
            return null;
        }
        return this.mResultSort.mapSort(mapping);
    }
}

