/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

public class QuotedObject {
    private final String mValue;
    private boolean mIsSMTLIB25;

    public QuotedObject(String value) {
        this(value, true);
        assert (value.indexOf(92) < 0 && value.indexOf(34) < 0);
    }

    public QuotedObject(String value, boolean isSMTLIB25) {
        this.mValue = value;
        this.mIsSMTLIB25 = isSMTLIB25;
    }

    public String getValue() {
        return this.mValue;
    }

    private static String quoteString20(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block4: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.append('\"').toString();
    }

    private static String quoteString25(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                sb.append("\"\"");
                continue;
            }
            sb.append(c);
        }
        return sb.append('\"').toString();
    }

    public String toString() {
        return this.mIsSMTLIB25 ? QuotedObject.quoteString25(this.mValue) : QuotedObject.quoteString20(this.mValue);
    }
}

