/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.Arrays;

public class SortSymbol {
    static final int INTERNAL = 1;
    static final int TYPEPARAM = 2;
    static final int INDEXED = 4;
    static final int NUMERIC = 8;
    static final int ARRAY = 16;
    static final int DATATYPE = 32;
    final Theory mTheory;
    final String mName;
    final int mNumParams;
    final int mFlags;
    final Object mSorts;
    final Sort mSortDefinition;

    SortSymbol(Theory theory, String name, int numParams, Sort definition, int flags) {
        this.mTheory = theory;
        this.mName = name;
        this.mFlags = flags;
        this.mNumParams = numParams;
        this.mSortDefinition = definition;
        this.mSorts = (this.mFlags & 2) != 0 || (this.mFlags & 4) == 0 && this.mNumParams == 0 ? new Sort(this, null, new Sort[0]) : new UnifyHash();
    }

    public boolean isIntern() {
        return (this.mFlags & 1) != 0;
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "(" + PrintTerm.quoteIdentifier(this.mName) + " " + this.mNumParams + ")";
    }

    public void checkArity(String[] indices, int arity) {
        if (indices != null) {
            throw new IllegalArgumentException("Indexed Sort " + this.mName + " undefined");
        }
        if (arity != ((this.mFlags & 2) == 0 ? this.mNumParams : 0)) {
            throw new IllegalArgumentException("Wrong number of arguments for sort " + this.mName);
        }
    }

    public Sort getSort(String[] indices, Sort ... args) {
        this.checkArity(indices, args.length);
        if ((this.mFlags & 4) == 0 && args.length == 0) {
            return (Sort)this.mSorts;
        }
        UnifyHash sortCache = (UnifyHash)this.mSorts;
        int hash = Arrays.hashCode(indices) ^ Arrays.hashCode(args);
        for (Sort sort : sortCache.iterateHashCode(hash)) {
            if (!Arrays.equals(sort.getArguments(), args) || !Arrays.equals(sort.getIndices(), indices)) continue;
            return sort;
        }
        Sort sort = new Sort(this, indices, args);
        sortCache.put(hash, sort);
        return sort;
    }

    public boolean isSortVariable() {
        return (this.mFlags & 2) != 0;
    }

    public boolean isNumeric() {
        return (this.mFlags & 8) != 0;
    }

    public boolean isArray() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean isDatatype() {
        return (this.mFlags & 0x20) != 0;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }
}

