/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.IRAWrapperFactory;
import de.uni_freiburg.informatik.ultimate.logic.IsConstructorFactory;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.PolymorphicFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public class Theory {
    private SolverSetup mSolverSetup;
    private Logics mLogic;
    private Sort mNumericSort;
    private Sort mRealSort;
    private Sort mStringSort;
    private Sort mBooleanSort;
    private SortSymbol mBitVecSort;
    private SortSymbol mFloatingPointSort;
    private Sort mRoundingModeSort;
    private final ScopedHashMap<String, FunctionSymbolFactory> mFunFactory = new ScopedHashMap();
    private final UnifyHash<FunctionSymbol> mModelValueCache = new UnifyHash();
    private final ScopedHashMap<String, SortSymbol> mDeclaredSorts = new ScopedHashMap();
    private final ScopedHashMap<String, FunctionSymbol> mDeclaredFuns = new ScopedHashMap();
    private final UnifyHash<LetTerm> mLetCache = new UnifyHash();
    private final UnifyHash<Term> mTermCache = new UnifyHash();
    private final UnifyHash<TermVariable> mTvUnify = new UnifyHash();
    private IRAWrapperFactory mIRAWrappers;
    private UnifyHash<FunctionSymbol> mBitVecConstCache;
    public final ApplicationTerm mTrue;
    public final ApplicationTerm mFalse;
    public final FunctionSymbol mAnd;
    public final FunctionSymbol mOr;
    public final FunctionSymbol mNot;
    public final FunctionSymbol mImplies;
    public final FunctionSymbol mXor;
    public final PolymorphicFunctionSymbol mEquals;
    public final PolymorphicFunctionSymbol mDistinct;
    static final Sort[] EMPTY_SORT_ARRAY = Script.EMPTY_SORT_ARRAY;
    static final TermVariable[] EMPTY_TERM_VARIABLE_ARRAY = new TermVariable[0];
    static final Term[] EMPTY_TERM_ARRAY = Script.EMPTY_TERM_ARRAY;
    private static final String MODEL_VALUE_PATTERN = "@\\d+";
    private static final String BITVEC_CONST_PATTERN = "bv\\d+";
    private int mTvarCtr = 0;
    private int mAuxCounter = 0;
    private boolean mGlobalDecls;

    public Theory() {
        this.mFalse = null;
        this.mTrue = null;
        this.mXor = null;
        this.mImplies = null;
        this.mNot = null;
        this.mOr = null;
        this.mAnd = null;
        this.mDistinct = null;
        this.mEquals = null;
    }

    public Theory(Logics logic) {
        this(logic, null);
    }

    public Theory(Logics logic, SolverSetup solverSetup) {
        this.mSolverSetup = solverSetup;
        Sort[] noarg = new Sort[]{};
        this.mBooleanSort = this.declareInternalSort("Bool", 0, 0).getSort(null, noarg);
        Sort[] generic1 = this.createSortVariables("A");
        Sort[] bool1 = new Sort[]{this.mBooleanSort};
        Sort[] bool2 = new Sort[]{this.mBooleanSort, this.mBooleanSort};
        Sort[] generic2 = new Sort[]{generic1[0], generic1[0]};
        int leftassoc = 2;
        this.mNot = this.declareInternalFunction("not", bool1, this.mBooleanSort, 0);
        this.mAnd = this.declareInternalFunction("and", bool2, this.mBooleanSort, 2);
        this.mOr = this.declareInternalFunction("or", bool2, this.mBooleanSort, 2);
        this.mImplies = this.declareInternalFunction("=>", bool2, this.mBooleanSort, 4);
        this.mEquals = this.declareInternalPolymorphicFunction("=", generic1, generic2, this.mBooleanSort, 6);
        this.mDistinct = this.declareInternalPolymorphicFunction("distinct", generic1, generic2, this.mBooleanSort, 8);
        this.mXor = this.declareInternalFunction("xor", bool2, this.mBooleanSort, 2);
        this.declareInternalPolymorphicFunction("ite", generic1, new Sort[]{this.mBooleanSort, generic1[0], generic1[0]}, generic1[0], 0);
        this.mTrue = (ApplicationTerm)this.term(this.declareInternalFunction("true", noarg, this.mBooleanSort, 0), new Term[0]);
        this.mFalse = (ApplicationTerm)this.term(this.declareInternalFunction("false", noarg, this.mBooleanSort, 0), new Term[0]);
        this.setLogic(logic);
    }

    public BigInteger toNumeral(String index) {
        try {
            return new BigInteger(index);
        }
        catch (NumberFormatException e) {
            throw new SMTLIBException("not a numeral: " + index, e);
        }
    }

    public FunctionSymbol getFunctionSymbol(String constructor) {
        return this.mDeclaredFuns.get(constructor);
    }

    private Term simplifyAndOr(FunctionSymbol connector, Term ... subforms) {
        ApplicationTerm neutral = connector == this.mAnd ? this.mTrue : this.mFalse;
        LinkedHashSet<Term> formulas = new LinkedHashSet<Term>();
        for (Term f : subforms) {
            if (f == this.mTrue || f == this.mFalse) {
                if (f == neutral) continue;
                return f;
            }
            if (f instanceof ApplicationTerm && ((ApplicationTerm)f).getFunction() == connector) {
                for (Term subf : ((ApplicationTerm)f).getParameters()) {
                    formulas.add(subf);
                }
                continue;
            }
            formulas.add(f);
        }
        if (formulas.size() <= 1) {
            if (formulas.isEmpty()) {
                return neutral;
            }
            return (Term)formulas.iterator().next();
        }
        Term[] arrforms = formulas.toArray(new Term[formulas.size()]);
        return this.term(connector, arrforms);
    }

    public Term not(Term f) {
        if (f == this.mTrue) {
            return this.mFalse;
        }
        if (f == this.mFalse) {
            return this.mTrue;
        }
        if (f instanceof ApplicationTerm && ((ApplicationTerm)f).getFunction() == this.mNot) {
            return ((ApplicationTerm)f).getParameters()[0];
        }
        return this.term(this.mNot, f);
    }

    public Term and(Term ... subforms) {
        return this.simplifyAndOr(this.mAnd, subforms);
    }

    public Term or(Term ... subforms) {
        return this.simplifyAndOr(this.mOr, subforms);
    }

    public Term implies(Term f, Term g) {
        if (g == this.mTrue || f == this.mTrue) {
            return g;
        }
        if (f == this.mFalse) {
            return this.mTrue;
        }
        if (g == this.mFalse) {
            return this.not(f);
        }
        if (f == g) {
            return this.mTrue;
        }
        return this.term(this.mImplies, f, g);
    }

    public Term xor(Term f, Term g) {
        if (f == this.mTrue) {
            return this.not(g);
        }
        if (g == this.mTrue) {
            return this.not(f);
        }
        if (f == this.mFalse) {
            return g;
        }
        if (g == this.mFalse) {
            return f;
        }
        if (f == g) {
            return this.mFalse;
        }
        return this.term(this.mXor, f, g);
    }

    public Term ifthenelse(Term c, Term t, Term e) {
        if (c == this.mTrue) {
            return t;
        }
        if (c == this.mFalse) {
            return e;
        }
        if (t == e) {
            return t;
        }
        if (t == this.mTrue && e == this.mFalse) {
            return c;
        }
        if (t == this.mFalse && e == this.mTrue) {
            return this.not(c);
        }
        if (t == this.mTrue) {
            return this.term(this.mOr, c, e);
        }
        if (t == this.mFalse) {
            return this.term(this.mAnd, this.term(this.mNot, c), e);
        }
        if (e == this.mTrue) {
            return this.term(this.mImplies, c, t);
        }
        if (e == this.mFalse) {
            return this.term(this.mAnd, c, t);
        }
        return this.term("ite", c, t, e);
    }

    public Term lambda(TermVariable[] vars, Term subterm) {
        int hash = LambdaTerm.hashLambda(vars, subterm);
        for (Term term : this.mTermCache.iterateHashCode(hash)) {
            LambdaTerm lambda;
            if (!(term instanceof LambdaTerm) || (lambda = (LambdaTerm)term).getSubterm() != subterm || !Arrays.equals(lambda.getVariables(), vars)) continue;
            return lambda;
        }
        LambdaTerm lambda = new LambdaTerm(vars, subterm, hash);
        this.mTermCache.put(hash, lambda);
        return lambda;
    }

    private Term quantify(int quant, TermVariable[] vars, Term f) {
        int hash = QuantifiedFormula.hashQuantifier(quant, vars, f);
        for (Term term : this.mTermCache.iterateHashCode(hash)) {
            QuantifiedFormula qf;
            if (!(term instanceof QuantifiedFormula) || (qf = (QuantifiedFormula)term).getQuantifier() != quant || qf.getSubformula() != f || !Arrays.equals(vars, qf.getVariables())) continue;
            return qf;
        }
        QuantifiedFormula qf = new QuantifiedFormula(quant, vars, f, hash);
        this.mTermCache.put(hash, qf);
        return qf;
    }

    public Term exists(TermVariable[] vars, Term f) {
        return this.quantify(0, vars, f);
    }

    public Term forall(TermVariable[] vars, Term f) {
        return this.quantify(1, vars, f);
    }

    public Term match(Term dataArg, TermVariable[][] vars, Term[] cases, DataType.Constructor[] constructors) {
        int hash = MatchTerm.hashMatch(dataArg, vars, cases);
        for (Term t : this.mTermCache.iterateHashCode(hash)) {
            MatchTerm mt;
            if (!(t instanceof MatchTerm) || (mt = (MatchTerm)t).getDataTerm() != dataArg || !Arrays.equals(mt.getCases(), cases) || !Arrays.deepEquals((Object[])mt.getVariables(), (Object[])vars) || !Arrays.equals(mt.getConstructors(), constructors)) continue;
            return mt;
        }
        MatchTerm mt = new MatchTerm(hash, dataArg, vars, cases, constructors);
        this.mTermCache.put(hash, mt);
        return mt;
    }

    public Term let(TermVariable[] vars, Term[] values, Term subform) {
        assert (vars.length == values.length);
        if (vars.length == 0) {
            return subform;
        }
        int hash = LetTerm.hashLet(vars, values, subform);
        for (LetTerm lt : this.mLetCache.iterateHashCode(hash)) {
            if (lt.getSubTerm() != subform || !Arrays.equals(lt.getVariables(), vars) || !Arrays.equals(lt.getValues(), values)) continue;
            return lt;
        }
        LetTerm lf = new LetTerm(vars, values, subform, hash);
        this.mLetCache.put(hash, lf);
        return lf;
    }

    public Term let(TermVariable var, Term value, Term subform) {
        return this.let(new TermVariable[]{var}, new Term[]{value}, subform);
    }

    public Term distinct(Term ... terms) {
        if (terms.length < 2) {
            return null;
        }
        if (terms.length == 2) {
            if (terms[0] == terms[1]) {
                return this.mFalse;
            }
            if (terms[0].getSort() == this.mBooleanSort) {
                if (terms[0] == this.mFalse) {
                    return terms[1];
                }
                if (terms[1] == this.mFalse) {
                    return terms[0];
                }
                if (terms[0] == this.mTrue) {
                    return this.not(terms[1]);
                }
                if (terms[1] == this.mTrue) {
                    return this.not(terms[0]);
                }
            }
            return this.term(this.mDistinct, terms);
        }
        HashSet<Term> params = new HashSet<Term>(Arrays.asList(terms));
        if (params.size() != terms.length) {
            return this.mFalse;
        }
        return this.term(this.mDistinct, terms);
    }

    public Term equals(Term ... terms) {
        if (terms.length < 2) {
            return null;
        }
        if (terms.length == 2) {
            if (terms[0] == terms[1]) {
                return this.mTrue;
            }
            if (terms[0].getSort() == this.mBooleanSort) {
                if (terms[0] == this.mTrue) {
                    return terms[1];
                }
                if (terms[1] == this.mTrue) {
                    return terms[0];
                }
                if (terms[0] == this.mFalse) {
                    return this.not(terms[1]);
                }
                if (terms[1] == this.mFalse) {
                    return this.not(terms[0]);
                }
            }
            return this.term(this.mEquals, terms);
        }
        HashSet<Term> params = new HashSet<Term>(Arrays.asList(terms));
        if (params.size() == 1) {
            return this.mTrue;
        }
        return this.term(this.mEquals, terms);
    }

    public Term constant(Object value, Sort sort) {
        if (value instanceof Rational) {
            if (!sort.isNumericSort()) {
                throw new SMTLIBException("Not a numeric sort");
            }
            Rational v = (Rational)value;
            if (!v.isRational()) {
                throw new SMTLIBException("Infinite/NaN value");
            }
            if (sort.getName().equals("Int") && !v.isIntegral()) {
                throw new SMTLIBException("Non-integral value with integer sort");
            }
        }
        int hash = ConstantTerm.hashConstant(value, sort);
        for (Term t : this.mTermCache.iterateHashCode(hash)) {
            ConstantTerm nt;
            if (!(t instanceof ConstantTerm) || (nt = (ConstantTerm)t).getSort() != sort || !value.equals(nt.getValue())) continue;
            return nt;
        }
        ConstantTerm nt = new ConstantTerm(value, sort, hash);
        this.mTermCache.put(hash, nt);
        return nt;
    }

    public Term numeral(BigInteger num) {
        if (this.mNumericSort != this.mRealSort) {
            return this.constant(Rational.valueOf(num, BigInteger.ONE), this.mNumericSort);
        }
        return this.constant(num, this.mNumericSort);
    }

    public Term numeral(String num) {
        return this.numeral(this.toNumeral(num));
    }

    public Term decimal(BigDecimal value) {
        if (value.scale() <= 0 || value.scale() == 1 && value.remainder(BigDecimal.ONE).signum() == 0) {
            return this.constant(Rational.valueOf(value.toBigIntegerExact(), BigInteger.ONE), this.mRealSort);
        }
        Term result = this.constant(value.abs(), this.mRealSort);
        if (value.signum() < 0) {
            FunctionSymbol neg = this.getFunction("-", this.mRealSort);
            result = this.term(neg, result);
        }
        return result;
    }

    public Term decimal(String value) {
        return this.decimal(new BigDecimal(value));
    }

    public Term rational(Rational c, Sort sort) {
        return this.constant(c, sort);
    }

    public Term binary(String value) {
        assert (value.startsWith("#b"));
        if (this.mBitVecSort == null) {
            return null;
        }
        String bsize = String.valueOf(value.length() - 2);
        Sort sort = this.mBitVecSort.getSort(new String[]{bsize}, new Sort[0]);
        return new ConstantTerm(value, sort, ConstantTerm.hashConstant(value, sort));
    }

    public Term hexadecimal(String value) {
        assert (value.startsWith("#x"));
        if (this.mBitVecSort == null) {
            return null;
        }
        String bsize = String.valueOf(4 * (value.length() - 2));
        Sort sort = this.mBitVecSort.getSort(new String[]{bsize}, new Sort[0]);
        return new ConstantTerm(value, sort, ConstantTerm.hashConstant(value, sort));
    }

    public Term modelRational(Rational rat, Sort sort) {
        BigInteger num = rat.numerator();
        BigInteger denom = rat.denominator();
        if (sort == this.mRealSort) {
            if (this.mLogic.isIRA()) {
                FunctionSymbol div = this.getFunction("/", this.mRealSort, this.mRealSort);
                FunctionSymbol toreal = this.getFunction("to_real", this.mNumericSort);
                Term numeralTerm = this.term(toreal, this.numeral(num.abs()));
                if (num.signum() < 0) {
                    numeralTerm = this.term("-", numeralTerm);
                }
                return this.term(div, numeralTerm, this.term(toreal, this.numeral(denom)));
            }
            if (denom.equals(BigInteger.ONE)) {
                return this.decimal(new BigDecimal(num));
            }
            FunctionSymbol div = this.getFunction("/", this.mNumericSort, this.mNumericSort);
            return this.term(div, this.numeral(num), this.numeral(denom));
        }
        assert (denom.equals(BigInteger.ONE));
        return this.numeral(rat.numerator());
    }

    public Term string(QuotedObject value) {
        return this.constant(value, this.mStringSort);
    }

    public Logics getLogic() {
        return this.mLogic;
    }

    public FunctionSymbol declareInternalFunction(String name, Sort[] paramTypes, Sort resultType, int flags) {
        return this.defineFunction(name, paramTypes, resultType, null, null, flags | 1);
    }

    public FunctionSymbol declareInternalFunction(String name, Sort[] paramTypes, TermVariable[] defVars, Term definition, int flags) {
        return this.defineFunction(name, paramTypes, definition.getSort(), defVars, definition, flags | 1);
    }

    public PolymorphicFunctionSymbol declareInternalPolymorphicFunction(String name, Sort[] sortParams, Sort[] paramTypes, Sort resultType, int flags) {
        assert (!this.mFunFactory.containsKey(name));
        PolymorphicFunctionSymbol f = new PolymorphicFunctionSymbol(name, sortParams, paramTypes, resultType, flags | 1);
        this.declareInternalFunctionFactory(f);
        return f;
    }

    private Term absDefinition(TermVariable x) {
        Term zero = Rational.ZERO.toTerm(x.getSort());
        return this.term("ite", this.term("<", x, zero), this.term("-", x), x);
    }

    private void createNumericOperators(Sort sort, boolean isRealArith) {
        Sort[] sort1 = new Sort[]{sort};
        Sort[] sort2 = new Sort[]{sort, sort};
        this.declareInternalFunction("+", sort2, sort, 2);
        this.declareInternalFunctionFactory(new MinusFunctionFactory(sort, sort));
        this.declareInternalFunction("*", sort2, sort, 2);
        if (isRealArith) {
            this.declareInternalFunction("/", sort2, sort, 66);
        } else {
            this.declareInternalFunction("div", sort2, sort, 66);
            this.declareInternalFunction("mod", sort2, sort, 64);
            this.declareInternalFunctionFactory(new DivisibleFunctionFactory());
        }
        Sort sBool = this.mBooleanSort;
        this.declareInternalFunction(">", sort2, sBool, 6);
        this.declareInternalFunction(">=", sort2, sBool, 6);
        this.declareInternalFunction("<", sort2, sBool, 6);
        this.declareInternalFunction("<=", sort2, sBool, 6);
        TermVariable x = this.createTermVariable("x", sort);
        this.declareInternalFunction("abs", sort1, new TermVariable[]{x}, this.absDefinition(x), 0);
    }

    private void createIRAOperators() {
        this.mIRAWrappers = new IRAWrapperFactory();
        class BinArithFactory
        extends FunctionSymbolFactory {
            Sort mReturnSort;
            int mFlags;

            BinArithFactory(String name, Sort returnSort, int flags) {
                super(name);
                this.mReturnSort = returnSort;
                this.mFlags = flags | 1;
            }

            @Override
            public int getFlags(String[] indices, Sort[] paramSorts, Sort resultSort) {
                return this.mFlags;
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null && paramSorts.length == 2 && paramSorts[0] == paramSorts[1] && (paramSorts[0] == Theory.this.mNumericSort || paramSorts[0] == Theory.this.mRealSort) && resultSort == null) {
                    return this.mReturnSort == null ? paramSorts[0] : this.mReturnSort;
                }
                return null;
            }
        }
        this.declareInternalFunctionFactory(new BinArithFactory("+", null, 2));
        this.declareInternalFunctionFactory(new MinusFunctionFactory(this.mNumericSort, this.mRealSort));
        this.declareInternalFunctionFactory(new BinArithFactory("*", null, 2));
        this.declareInternalFunctionFactory(new BinArithFactory(">", this.mBooleanSort, 6));
        this.declareInternalFunctionFactory(new BinArithFactory(">=", this.mBooleanSort, 6));
        this.declareInternalFunctionFactory(new BinArithFactory("<", this.mBooleanSort, 6));
        this.declareInternalFunctionFactory(new BinArithFactory("<=", this.mBooleanSort, 6));
        Sort[] int1 = new Sort[]{this.mNumericSort};
        Sort[] int2 = new Sort[]{this.mNumericSort, this.mNumericSort};
        Sort[] real1 = new Sort[]{this.mRealSort};
        Sort[] real2 = new Sort[]{this.mRealSort, this.mRealSort};
        this.declareInternalFunction("/", real2, this.mRealSort, 2);
        this.declareInternalFunction("div", int2, this.mNumericSort, 2);
        this.declareInternalFunctionFactory(new DivisibleFunctionFactory());
        this.declareInternalFunction("to_real", int1, this.mRealSort, 0);
        this.declareInternalFunction("to_int", real1, this.mNumericSort, 0);
        this.declareInternalFunction("mod", int2, this.mNumericSort, 0);
        TermVariable xr = this.createTermVariable("x1", this.mRealSort);
        Term isintx = this.term("=", xr, this.term("to_real", this.term("to_int", xr)));
        this.declareInternalFunction("is_int", real1, new TermVariable[]{xr}, isintx, 0);
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("abs"){

            @Override
            public Term getDefinition(TermVariable[] tvs, Sort resultSort) {
                return Theory.this.absDefinition(tvs[0]);
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null && paramSorts.length == 1 && (paramSorts[0] == Theory.this.mNumericSort || paramSorts[0] == Theory.this.mRealSort) && resultSort == null) {
                    return paramSorts[0];
                }
                return null;
            }
        });
    }

    private void createArrayOperators() {
        Sort[] generic2 = this.createSortVariables("X", "Y");
        SortSymbol arraySort = this.declareInternalSort("Array", 2, 16);
        Sort array = arraySort.getSort(null, generic2);
        this.declareInternalPolymorphicFunction("select", generic2, new Sort[]{array, generic2[0]}, generic2[1], 0);
        this.declareInternalPolymorphicFunction("store", generic2, new Sort[]{array, generic2[0], generic2[1]}, array, 0);
        this.declareInternalPolymorphicFunction("const", generic2, new Sort[]{generic2[1]}, array, 17);
    }

    private void createBitVecSort() {
        this.mBitVecSort = new SortSymbol(this, "BitVec", 0, null, 5){

            @Override
            public void checkArity(String[] indices, int arity) {
                if (indices == null || indices.length != 1) {
                    throw new IllegalArgumentException("BitVec needs one index");
                }
                if (Theory.this.toNumeral(indices[0]).signum() <= 0) {
                    throw new IllegalArgumentException("BitVec index must be positive");
                }
                if (arity != 0) {
                    throw new IllegalArgumentException("BitVec has no parameters");
                }
            }
        };
        this.mDeclaredSorts.put("BitVec", this.mBitVecSort);
    }

    private void createBitVecOperators() {
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("concat"){

            @Override
            public int getFlags(String[] indices, Sort[] paramSorts, Sort resultSort) {
                return 1;
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length != 2 || resultSort != null || paramSorts[0].getName() != "BitVec" || paramSorts[1].getName() != "BitVec") {
                    return null;
                }
                BigInteger paramSortAsInt0 = Theory.this.toNumeral(paramSorts[0].getIndices()[0]);
                BigInteger paramSortAsInt1 = Theory.this.toNumeral(paramSorts[1].getIndices()[0]);
                BigInteger size = paramSortAsInt0.add(paramSortAsInt1);
                return Theory.this.mBitVecSort.getSort(new String[]{size.toString()}, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("extract"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length < 2 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger idxFirst = Theory.this.toNumeral(indices[0]);
                BigInteger idxScnd = Theory.this.toNumeral(indices[1]);
                BigInteger paramLength = Theory.this.toNumeral(paramSorts[0].getIndices()[0]);
                if (idxFirst.compareTo(idxScnd) < 0 || paramLength.compareTo(idxFirst) < 0) {
                    return null;
                }
                BigInteger size = idxFirst.subtract(idxScnd).add(BigInteger.ONE);
                return Theory.this.mBitVecSort.getSort(new String[]{size.toString()}, new Sort[0]);
            }
        });
        Sort bitvec1 = this.mBitVecSort.getSort(new String[]{BigInteger.ONE.toString()}, new Sort[0]);
        class RegularBitVecFunction
        extends FunctionSymbolFactory {
            int mNumArgs;
            int mFlags;
            Sort mResult;

            public RegularBitVecFunction(String name, int numArgs, Sort result, int flags) {
                super(name);
                this.mNumArgs = numArgs;
                this.mResult = result;
                this.mFlags = flags;
            }

            public RegularBitVecFunction(String name, int numArgs, Sort result) {
                this(name, numArgs, result, 1);
            }

            @Override
            public int getFlags(String[] indices, Sort[] paramSorts, Sort resultSort) {
                return this.mFlags;
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length != this.mNumArgs || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                for (int i = 1; i < this.mNumArgs; ++i) {
                    if (paramSorts[i] == paramSorts[0]) continue;
                    return null;
                }
                return this.mResult == null ? paramSorts[0] : this.mResult;
            }
        }
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvnot", 1, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvand", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvor", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvneg", 1, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvadd", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvmul", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvudiv", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvurem", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvshl", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvlshr", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvnand", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvnor", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvxor", 2, null, 3));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvxnor", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvcomp", 2, bitvec1));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsub", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsdiv", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsrem", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsmod", 2, null));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvashr", 2, null));
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("repeat"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger size = Theory.this.toNumeral(indices[0]).multiply(Theory.this.toNumeral(paramSorts[0].getIndices()[0]));
                return Theory.this.mBitVecSort.getSort(new String[]{size.toString()}, new Sort[0]);
            }
        });
        class ExtendBitVecFunction
        extends FunctionSymbolFactory {
            public ExtendBitVecFunction(String name) {
                super(name);
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger size = Theory.this.toNumeral(indices[0]).add(Theory.this.toNumeral(paramSorts[0].getIndices()[0]));
                return Theory.this.mBitVecSort.getSort(new String[]{size.toString()}, new Sort[0]);
            }
        }
        this.declareInternalFunctionFactory(new ExtendBitVecFunction("zero_extend"));
        this.declareInternalFunctionFactory(new ExtendBitVecFunction("sign_extend"));
        class RotateBitVecFunction
        extends FunctionSymbolFactory {
            public RotateBitVecFunction(String name) {
                super(name);
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                return paramSorts[0];
            }
        }
        this.declareInternalFunctionFactory(new RotateBitVecFunction("rotate_left"));
        this.declareInternalFunctionFactory(new RotateBitVecFunction("rotate_right"));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvult", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvule", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvugt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvuge", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvslt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsle", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsgt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularBitVecFunction("bvsge", 2, this.mBooleanSort, 7));
    }

    private void createFloatingPointOperators() {
        this.mFloatingPointSort = new SortSymbol(this, "FloatingPoint", 0, null, 5){

            @Override
            public void checkArity(String[] indices, int arity) {
                if (indices == null || indices.length != 2) {
                    throw new IllegalArgumentException("Floating Point needs two indices");
                }
                if (Theory.this.toNumeral(indices[0]).signum() <= 0 || Theory.this.toNumeral(indices[1]).signum() <= 0) {
                    throw new IllegalArgumentException("FloatingPoint indices must be greater 0");
                }
                if (arity != 0) {
                    throw new IllegalArgumentException("FloatingPoint has no parameters");
                }
            }
        };
        this.mDeclaredSorts.put("FloatingPoint", this.mFloatingPointSort);
        this.mRoundingModeSort = this.declareInternalSort("RoundingMode", 0, 0).getSort(null, new Sort[0]);
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("fp"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length != 3 || resultSort != null || paramSorts[0].getName() != "BitVec" || paramSorts[1].getName() != "BitVec" || paramSorts[2].getName() != "BitVec") {
                    return null;
                }
                BigInteger fpSignIndex = Theory.this.toNumeral(paramSorts[0].getIndices()[0]);
                if (!fpSignIndex.equals(BigInteger.ONE)) {
                    return null;
                }
                String[] fpIndices = new String[]{Theory.this.toNumeral(paramSorts[1].getIndices()[0]).toString(), Theory.this.toNumeral(paramSorts[2].getIndices()[0]).add(BigInteger.ONE).toString()};
                return Theory.this.mFloatingPointSort.getSort(fpIndices, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("to_fp"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 2 || paramSorts == null) {
                    return null;
                }
                if (paramSorts.length == 1 && paramSorts[0].getName() == "BitVec") {
                    if (!Theory.this.toNumeral(indices[0]).add(Theory.this.toNumeral(indices[1])).equals(Theory.this.toNumeral(paramSorts[0].getIndices()[0]))) {
                        return null;
                    }
                    return Theory.this.mFloatingPointSort.getSort(indices, new Sort[0]);
                }
                if (paramSorts.length == 2 && paramSorts[0].getName() == "RoundingMode" && paramSorts[1].getName() == "FloatingPoint") {
                    return Theory.this.mFloatingPointSort.getSort(indices, new Sort[0]);
                }
                if (paramSorts.length == 2 && paramSorts[0].getName() == "RoundingMode" && paramSorts[1].getName() == "Real") {
                    return Theory.this.mFloatingPointSort.getSort(indices, new Sort[0]);
                }
                if (paramSorts.length == 2 && paramSorts[0].getName() == "RoundingMode" && paramSorts[1].getName() == "BitVec") {
                    return Theory.this.mFloatingPointSort.getSort(indices, new Sort[0]);
                }
                return null;
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("to_fp_unsigned"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 2 || paramSorts.length != 2 || resultSort != null || paramSorts[0].getName() != "RoundingMode" || paramSorts[1].getName() != "BitVec") {
                    return null;
                }
                return Theory.this.mFloatingPointSort.getSort(indices, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("fp.to_ubv"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 2 || resultSort != null || paramSorts[0].getName() != "RoundingMode" || paramSorts[1].getName() != "FloatingPoint") {
                    return null;
                }
                return Theory.this.mBitVecSort.getSort(new String[]{indices[0]}, new Sort[0]);
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("fp.to_sbv"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 2 || resultSort != null || paramSorts[0].getName() != "RoundingMode" || paramSorts[1].getName() != "FloatingPoint") {
                    return null;
                }
                return Theory.this.mBitVecSort.getSort(new String[]{indices[0]}, new Sort[0]);
            }
        });
        class FloatingPointConstant
        extends FunctionSymbolFactory {
            public FloatingPointConstant(String name) {
                super(name);
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices.length != 2 || paramSorts.length != 0 || resultSort != null) {
                    return null;
                }
                return Theory.this.mFloatingPointSort.getSort(indices, new Sort[0]);
            }
        }
        this.declareInternalFunctionFactory(new FloatingPointConstant("+oo"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("-oo"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("+zero"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("-zero"));
        this.declareInternalFunctionFactory(new FloatingPointConstant("NaN"));
        this.defineSort("Float16", 0, this.mFloatingPointSort.getSort(new String[]{new String("5"), new String("11")}, new Sort[0]));
        this.defineSort("Float32", 0, this.mFloatingPointSort.getSort(new String[]{new String("8"), new String("24")}, new Sort[0]));
        this.defineSort("Float64", 0, this.mFloatingPointSort.getSort(new String[]{new String("11"), new String("53")}, new Sort[0]));
        this.defineSort("Float128", 0, this.mFloatingPointSort.getSort(new String[]{new String("15"), new String("113")}, new Sort[0]));
        this.declareInternalFunction("roundNearestTiesToEven", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundNearestTiesToAway", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundTowardPositive", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundTowardNegative", new Sort[0], this.mRoundingModeSort, 0);
        this.declareInternalFunction("roundTowardZero", new Sort[0], this.mRoundingModeSort, 0);
        this.defineFunction("RNE", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundNearestTiesToEven", new Term[0]), 1);
        this.defineFunction("RNA", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundNearestTiesToAway", new Term[0]), 1);
        this.defineFunction("RTP", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundTowardPositive", new Term[0]), 1);
        this.defineFunction("RTN", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundTowardNegative", new Term[0]), 1);
        this.defineFunction("RTZ", new Sort[0], this.mRoundingModeSort, new TermVariable[0], this.term("roundTowardZero", new Term[0]), 1);
        class RegularFloatingPointFunction
        extends FunctionSymbolFactory {
            int mNumArgs;
            Sort mResult;
            int mFlags;
            int mFirstFloat;

            public RegularFloatingPointFunction(String name, int numArgs, Sort result, int flags) {
                super(name);
                this.mNumArgs = numArgs;
                this.mResult = result;
                this.mFlags = flags;
            }

            @Override
            public int getFlags(String[] indices, Sort[] paramSorts, Sort resultSort) {
                return this.mFlags;
            }

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length != this.mNumArgs || resultSort != null) {
                    return null;
                }
                this.mFirstFloat = paramSorts[0].getName() == "RoundingMode" ? 1 : 0;
                for (int i = this.mFirstFloat; i < this.mNumArgs; ++i) {
                    if (paramSorts[i].getName() == "FloatingPoint") continue;
                    return null;
                }
                return this.mResult == null ? paramSorts[this.mFirstFloat] : this.mResult;
            }
        }
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.abs", 1, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.neg", 1, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.min", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.max", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.rem", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.add", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.sub", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.mul", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.div", 3, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.fma", 4, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.sqrt", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.roundToIntegral", 2, null, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.leq", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.lt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.geq", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.gt", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.eq", 2, this.mBooleanSort, 7));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isNormal", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isSubnormal", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isZero", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isInfinite", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isNaN", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isNegative", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.isPositive", 1, this.mBooleanSort, 1));
        this.declareInternalFunctionFactory(new RegularFloatingPointFunction("fp.to_real", 1, this.mRealSort, 1));
    }

    private void createStringOperators() {
        final Sort str = this.declareInternalSort("String", 0, 0).getSort(null, new Sort[0]);
        final Sort re = this.declareInternalSort("RegLan", 0, 0).getSort(null, new Sort[0]);
        this.mStringSort = str;
        Sort[] str1 = new Sort[]{str};
        Sort[] str2 = new Sort[]{str, str};
        Sort[] str3 = new Sort[]{str, str, str};
        Sort[] str_re = new Sort[]{str, re};
        Sort[] str_re_str = new Sort[]{str, re, str};
        Sort[] re1 = new Sort[]{re};
        Sort[] re2 = new Sort[]{re, re};
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("char"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 0 || resultSort != null) {
                    return null;
                }
                String index = indices[0];
                if (!index.startsWith("#x") || index.length() <= 2 || index.length() > 7 || index.length() == 7 && index.charAt(2) > '2') {
                    return null;
                }
                return str;
            }
        });
        this.declareInternalFunction("str.++", str2, str, 2);
        this.declareInternalFunction("str.<", str2, this.mBooleanSort, 6);
        this.declareInternalFunction("str.to_re", str1, re, 0);
        this.declareInternalFunction("str.in_re", str_re, this.mBooleanSort, 0);
        this.declareInternalFunction("re.none", EMPTY_SORT_ARRAY, re, 0);
        this.declareInternalFunction("re.all", EMPTY_SORT_ARRAY, re, 0);
        this.declareInternalFunction("re.allchar", EMPTY_SORT_ARRAY, re, 0);
        this.declareInternalFunction("re.++", re2, re, 2);
        this.declareInternalFunction("re.union", re2, re, 2);
        this.declareInternalFunction("re.inter", re2, re, 2);
        this.declareInternalFunction("re.*", re1, re, 0);
        this.declareInternalFunction("str.<=", str2, this.mBooleanSort, 6);
        this.declareInternalFunction("str.prefixof", str2, this.mBooleanSort, 0);
        this.declareInternalFunction("str.suffixof", str2, this.mBooleanSort, 0);
        this.declareInternalFunction("str.contains", str2, this.mBooleanSort, 0);
        this.declareInternalFunction("str.replace", str3, str, 0);
        this.declareInternalFunction("str.replace_all", str3, str, 0);
        this.declareInternalFunction("str.replace_re", str_re_str, str, 0);
        this.declareInternalFunction("str.replace_re_all", str_re_str, str, 0);
        this.declareInternalFunction("re.comp", re1, re, 0);
        this.declareInternalFunction("re.diff", re2, re, 2);
        this.declareInternalFunction("re.+", re1, re, 0);
        this.declareInternalFunction("re.opt", re1, re, 0);
        this.declareInternalFunction("re.range", str2, re, 0);
        this.declareInternalFunction("str.is_digit", str1, this.mBooleanSort, 0);
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("re.^"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 1 || resultSort != null || paramSorts[0] != re) {
                    return null;
                }
                Theory.this.toNumeral(indices[0]);
                return re;
            }
        });
        this.declareInternalFunctionFactory(new FunctionSymbolFactory("re.loop"){

            @Override
            public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 2 || paramSorts.length != 1 || resultSort != null || paramSorts[0] != re) {
                    return null;
                }
                Theory.this.toNumeral(indices[0]);
                Theory.this.toNumeral(indices[1]);
                return re;
            }
        });
        if (this.mLogic.hasIntegers()) {
            Sort[] int1 = new Sort[]{this.mNumericSort};
            Sort[] str_int = new Sort[]{str, this.mNumericSort};
            Sort[] str2_int = new Sort[]{str, str, this.mNumericSort};
            Sort[] str_int2 = new Sort[]{str, this.mNumericSort, this.mNumericSort};
            this.declareInternalFunction("str.len", str1, this.mNumericSort, 0);
            this.declareInternalFunction("str.at", str_int, str, 0);
            this.declareInternalFunction("str.substr", str_int2, str, 0);
            this.declareInternalFunction("str.indexof", str2_int, this.mNumericSort, 0);
            this.declareInternalFunction("str.to_code", str1, this.mNumericSort, 0);
            this.declareInternalFunction("str.from_code", int1, str, 0);
            this.declareInternalFunction("str.to_int", str1, this.mNumericSort, 0);
            this.declareInternalFunction("str.from_int", int1, str, 0);
        }
    }

    private void setLogic(Logics logic) {
        this.mLogic = logic;
        if (logic.isArray()) {
            this.createArrayOperators();
        }
        if (logic.hasReals() || logic.isFloatingPoint()) {
            this.mRealSort = this.declareInternalSort("Real", 0, 8).getSort(null, new Sort[0]);
        }
        if (logic.isArithmetic()) {
            this.mNumericSort = logic.hasIntegers() ? this.declareInternalSort("Int", 0, 8).getSort(null, new Sort[0]) : this.mRealSort;
            if (logic.isIRA()) {
                this.createIRAOperators();
            } else {
                this.createNumericOperators(this.mNumericSort, logic.hasReals());
            }
        }
        if (logic.isBitVector() || logic.isFloatingPoint()) {
            this.createBitVecSort();
        }
        if (logic.isBitVector()) {
            this.createBitVecOperators();
        }
        if (logic.isFloatingPoint()) {
            this.createFloatingPointOperators();
        }
        if (logic.isString()) {
            this.createStringOperators();
        }
        if (this.mSolverSetup != null) {
            this.mSolverSetup.setLogic(this, logic);
        }
        if (logic.isDatatype()) {
            this.declareInternalFunctionFactory(new IsConstructorFactory());
        }
    }

    private SortSymbol defineSort(String name, int paramCount, Sort definition, int flags) {
        if ((flags & 1) == 0 && definition == null && !this.mLogic.isUF() && !this.mLogic.isArray()) {
            throw new IllegalArgumentException("Free sorts are not allowed in this logic");
        }
        SortSymbol sortsym = this.mDeclaredSorts.get(name);
        if (sortsym != null) {
            throw new IllegalArgumentException("Sort " + name + " already exists.");
        }
        sortsym = new SortSymbol(this, name, paramCount, definition, flags);
        this.mDeclaredSorts.put(name, sortsym);
        return sortsym;
    }

    public SortSymbol declareSort(String name, int paramCount) {
        return this.defineSort(name, paramCount, null, 0);
    }

    public SortSymbol defineSort(String name, int paramCount, Sort definition) {
        return this.defineSort(name, paramCount, definition, 0);
    }

    public Sort[] createSortVariables(String ... names) {
        Sort[] sorts = new Sort[names.length];
        for (int i = 0; i < names.length; ++i) {
            sorts[i] = new SortSymbol(this, names[i], i, null, 2).getSort(null, new Sort[0]);
        }
        return sorts;
    }

    public SortSymbol declareInternalSort(String name, int paramCount, int flags) {
        return this.defineSort(name, paramCount, null, flags | 1);
    }

    public Sort getSort(String id, Sort ... args) {
        return this.getSort(id, (String[])null, args);
    }

    public Sort getSort(String id, String[] indices, Sort ... args) {
        SortSymbol symbol = this.mDeclaredSorts.get(id);
        if (symbol == null) {
            return null;
        }
        return symbol.getSort(indices, args);
    }

    public Sort getBooleanSort() {
        return this.mBooleanSort;
    }

    public Sort getNumericSort() {
        return this.mNumericSort;
    }

    public Sort getRealSort() {
        return this.mRealSort;
    }

    public Sort getStringSort() {
        return this.mStringSort;
    }

    public void declareInternalFunctionFactory(FunctionSymbolFactory factory) {
        if (this.mFunFactory.put(factory.mFuncName, factory) != null) {
            throw new AssertionError();
        }
    }

    private FunctionSymbol defineFunction(String name, Sort[] paramTypes, Sort resultType, TermVariable[] definitionVars, Term definition, int flags) {
        if ((flags & 1) == 0) {
            if (this.mLogic == null) {
                throw new IllegalArgumentException("Call set-logic first!");
            }
            if (!this.mLogic.isUF() && paramTypes.length > 0 && definition == null) {
                throw new IllegalArgumentException("Free functions are not allowed in this logic!");
            }
        }
        if (name.charAt(0) == '@' && name.matches(MODEL_VALUE_PATTERN)) {
            throw new IllegalArgumentException("Function " + name + " is reserved for internal purposes.");
        }
        if (this.mFunFactory.get(name) != null || this.mDeclaredFuns.get(name) != null) {
            throw new IllegalArgumentException("Function " + name + " is already defined.");
        }
        if (paramTypes.length == 0) {
            paramTypes = EMPTY_SORT_ARRAY;
        }
        if (definitionVars != null && definitionVars.length == 0) {
            definitionVars = EMPTY_TERM_VARIABLE_ARRAY;
        }
        FunctionSymbol f = new FunctionSymbol(name, null, paramTypes, resultType, definitionVars, definition, flags);
        this.mDeclaredFuns.put(name, f);
        return f;
    }

    public FunctionSymbol declareFunction(String name, Sort[] paramTypes, Sort resultType) {
        return this.defineFunction(name, paramTypes, resultType, null, null, 0);
    }

    public FunctionSymbol defineFunction(String name, TermVariable[] definitionVars, Term definition) {
        Sort[] paramTypes = definitionVars.length == 0 ? EMPTY_SORT_ARRAY : new Sort[definitionVars.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = definitionVars[i].getSort();
        }
        Sort resultType = definition.getSort();
        return this.defineFunction(name, paramTypes, resultType, definitionVars, definition, 0);
    }

    public FunctionSymbol getFunction(String name, Sort ... paramTypes) {
        return this.getFunctionWithResult(name, null, null, paramTypes);
    }

    public Map<String, FunctionSymbol> getDeclaredFunctions() {
        return this.mDeclaredFuns;
    }

    public Map<String, SortSymbol> getDeclaredSorts() {
        return this.mDeclaredSorts;
    }

    public Map<String, FunctionSymbolFactory> getFunctionFactories() {
        return this.mFunFactory;
    }

    private FunctionSymbol getModelValueSymbol(String name, Sort sort) {
        int hash = HashUtils.hashJenkins(name.hashCode(), (Object)sort);
        for (FunctionSymbol symb : this.mModelValueCache.iterateHashCode(hash)) {
            if (!symb.getName().equals(name) || symb.getReturnSort() != sort) continue;
            return symb;
        }
        FunctionSymbol symb = new FunctionSymbol(name, null, EMPTY_SORT_ARRAY, sort, null, null, 49);
        this.mModelValueCache.put(hash, symb);
        return symb;
    }

    public FunctionSymbol getFunctionWithResult(String name, String[] indices, Sort resultType, Sort ... paramTypes) {
        FunctionSymbol fsym;
        if (resultType != null && indices == null && paramTypes.length == 0 && name.matches(MODEL_VALUE_PATTERN)) {
            return this.getModelValueSymbol(name, resultType);
        }
        FunctionSymbolFactory factory = this.mFunFactory.get(name);
        if (factory != null ? (fsym = factory.getFunctionWithResult(this, indices, paramTypes, resultType)) != null : (fsym = this.mDeclaredFuns.get(name)) != null && indices == null && resultType == null && fsym.typecheck(paramTypes)) {
            return fsym;
        }
        if (this.mIRAWrappers != null && (fsym = this.mIRAWrappers.createWrapper(this, name, indices, paramTypes, resultType)) != null) {
            return fsym;
        }
        if (this.mBitVecSort != null && name.matches(BITVEC_CONST_PATTERN) && indices != null && indices.length == 1 && resultType == null) {
            return this.getBitVecConstant(name, indices);
        }
        return null;
    }

    private FunctionSymbol getBitVecConstant(String name, String[] indices) {
        FunctionSymbol symb2;
        if (this.mBitVecConstCache == null) {
            this.mBitVecConstCache = new UnifyHash();
        }
        int hash = HashUtils.hashJenkins(name.hashCode(), indices);
        for (FunctionSymbol symb2 : this.mBitVecConstCache.iterateHashCode(hash)) {
            if (!symb2.getName().equals(name) || !symb2.getIndices()[0].equals(indices[0])) continue;
            return symb2;
        }
        Sort sort = this.mBitVecSort.getSort(indices, new Sort[0]);
        symb2 = new FunctionSymbol(name, indices, EMPTY_SORT_ARRAY, sort, null, null, 1);
        this.mBitVecConstCache.put(hash, symb2);
        return symb2;
    }

    public Term term(FunctionSymbolFactory factory, Term ... parameters) {
        Sort[] sorts = parameters.length == 0 ? EMPTY_SORT_ARRAY : new Sort[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            sorts[i] = parameters[i].getSort();
        }
        FunctionSymbol fsym = factory.getFunctionWithResult(this, null, sorts, null);
        if (fsym == null) {
            throw new IllegalArgumentException("Did not find overload for function " + factory);
        }
        return this.term(fsym, parameters);
    }

    public Term term(String funcname, String[] indices, Sort returnSort, Term ... params) throws SMTLIBException {
        Sort[] sorts = params.length == 0 ? Script.EMPTY_SORT_ARRAY : new Sort[params.length];
        for (int i = 0; i < sorts.length; ++i) {
            sorts[i] = params[i].getSort();
        }
        FunctionSymbol fsym = this.getFunctionWithResult(funcname, indices, returnSort, sorts);
        if (fsym == null) {
            StringBuilder sb = new StringBuilder();
            PrintTerm pt = new PrintTerm();
            sb.append("Undeclared function symbol (").append(funcname);
            for (Sort s : sorts) {
                sb.append(' ');
                pt.append((Appendable)sb, s);
            }
            sb.append(')');
            throw new SMTLIBException(sb.toString());
        }
        return this.term(fsym, params);
    }

    public Term term(String func, Term ... parameters) {
        return this.term(func, (String[])null, (Sort)null, parameters);
    }

    public Term term(FunctionSymbol func, Term ... parameters) {
        Object num;
        ConstantTerm numTerm;
        if (func.isIntern() && func.getName().equals("/") && parameters.length == 2 && parameters[0] instanceof ConstantTerm && parameters[1] instanceof ConstantTerm && parameters[0].getSort() == this.getRealSort() && parameters[1].getSort() == this.getRealSort()) {
            numTerm = (ConstantTerm)parameters[0];
            ConstantTerm denomTerm = (ConstantTerm)parameters[1];
            BigInteger num2 = null;
            BigInteger denom = null;
            if (numTerm.getValue() instanceof Rational && denomTerm.getValue() instanceof Rational) {
                Rational numRat = (Rational)numTerm.getValue();
                Rational denomRat = (Rational)denomTerm.getValue();
                if (numRat.isIntegral() && denomRat.isIntegral()) {
                    num2 = numRat.numerator();
                    denom = denomRat.numerator();
                }
            }
            if (num2 != null && denom.compareTo(BigInteger.ONE) > 0 && num2.gcd(denom).equals(BigInteger.ONE)) {
                Rational value = Rational.valueOf(num2, denom);
                return this.constant(value, this.getRealSort());
            }
        }
        if (func.isIntern() && func.getName().equals("-") && parameters.length == 1 && parameters[0] instanceof ConstantTerm && (parameters[0].getSort() == this.getNumericSort() || parameters[0].getSort() == this.getRealSort()) && ((numTerm = (ConstantTerm)parameters[0]).getValue() instanceof Rational ? ((Rational)(num = (Rational)numTerm.getValue())).isIntegral() && ((Rational)num).signum() > 0 : numTerm.getValue() instanceof BigInteger && ((BigInteger)(num = (BigInteger)numTerm.getValue())).signum() > 0)) {
            return this.constant(((Rational)num).negate(), numTerm.getSort());
        }
        if (parameters.length == 0) {
            parameters = EMPTY_TERM_ARRAY;
        }
        int hash = ApplicationTerm.hashApplication(func, parameters);
        for (Term t : this.mTermCache.iterateHashCode(hash)) {
            ApplicationTerm app;
            if (!(t instanceof ApplicationTerm) || func != (app = (ApplicationTerm)t).getFunction() || !Arrays.equals(app.getParameters(), parameters)) continue;
            return app;
        }
        ApplicationTerm app = new ApplicationTerm(func, parameters, hash);
        this.mTermCache.put(hash, app);
        return app;
    }

    public TermVariable createFreshTermVariable(String prefix, Sort sort) {
        String name = "." + prefix + "." + this.mTvarCtr++;
        return new TermVariable(name, sort, TermVariable.hashVariable(name, sort));
    }

    public TermVariable createTermVariable(String name, Sort sort) {
        int hash = TermVariable.hashVariable(name, sort);
        for (TermVariable tv : this.mTvUnify.iterateHashCode(hash)) {
            if (!tv.getSort().equals(sort) || !tv.getName().equals(name)) continue;
            return tv;
        }
        TermVariable tv = new TermVariable(name, sort, hash);
        this.mTvUnify.put(hash, tv);
        return tv;
    }

    public DataType.Constructor createConstructor(String name, String[] selectors, Sort[] argumentSorts) {
        DataType.Constructor constructor = new DataType.Constructor(name, selectors, argumentSorts);
        return constructor;
    }

    public DataType createDatatypes(String name, int numParams) {
        if (this.mDeclaredSorts.containsKey(name)) {
            throw new IllegalArgumentException("Datatype " + name + " already exists.");
        }
        DataType datatype = new DataType(this, name, numParams);
        this.mDeclaredSorts.put(name, datatype);
        return datatype;
    }

    public Term term(TermVariable var) {
        return var;
    }

    public Term annotatedTerm(Annotation[] annots, Term sub) {
        int hash = AnnotatedTerm.hashAnnotations(annots, sub);
        for (Term t : this.mTermCache.iterateHashCode(hash)) {
            AnnotatedTerm annot;
            if (!(t instanceof AnnotatedTerm) || sub != (annot = (AnnotatedTerm)t).getSubterm() || !Arrays.equals(annot.getAnnotations(), annots)) continue;
            return annot;
        }
        AnnotatedTerm annot = new AnnotatedTerm(annots, sub, hash);
        this.mTermCache.put(hash, annot);
        return annot;
    }

    public void push() {
        if (!this.mGlobalDecls) {
            this.mFunFactory.beginScope();
            this.mDeclaredFuns.beginScope();
            this.mDeclaredSorts.beginScope();
        }
    }

    public void pop() {
        if (!this.mGlobalDecls) {
            this.mFunFactory.endScope();
            this.mDeclaredFuns.endScope();
            this.mDeclaredSorts.endScope();
        }
    }

    public FunctionSymbol createFreshAuxFunction(TermVariable[] vars, Term term) {
        Sort[] paramSorts = new Sort[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            paramSorts[i] = vars[i].getSort();
        }
        return this.declareInternalFunction("@AUX" + this.mAuxCounter++, paramSorts, vars, term, 64);
    }

    public void resetAssertions() {
        Map.Entry<String, Object> next;
        if (this.mGlobalDecls) {
            return;
        }
        while (this.mDeclaredFuns.getActiveScopeNum() > 1) {
            this.mDeclaredFuns.endScope();
        }
        Iterator<Map.Entry<String, Object>> it = this.mDeclaredFuns.entrySet().iterator();
        while (it.hasNext()) {
            next = it.next();
            if (next.getValue().isIntern()) continue;
            it.remove();
        }
        while (this.mDeclaredSorts.getActiveScopeNum() > 1) {
            this.mDeclaredSorts.endScope();
        }
        it = this.mDeclaredSorts.entrySet().iterator();
        while (it.hasNext()) {
            next = it.next();
            if (((SortSymbol)next.getValue()).isIntern()) continue;
            it.remove();
        }
    }

    public void setGlobalSymbols(boolean globalDecls) {
        this.mGlobalDecls = globalDecls;
    }

    class DivisibleFunctionFactory
    extends FunctionSymbolFactory {
        public DivisibleFunctionFactory() {
            super("divisible");
        }

        @Override
        public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
            return indices != null && indices.length == 1 && Theory.this.toNumeral(indices[0]).signum() > 0 && paramSorts.length == 1 && paramSorts[0] == Theory.this.mNumericSort && resultSort == null ? Theory.this.mBooleanSort : null;
        }
    }

    class MinusFunctionFactory
    extends FunctionSymbolFactory {
        Sort mSort1;
        Sort mSort2;

        public MinusFunctionFactory(Sort sort1, Sort sort2) {
            super("-");
            this.mSort1 = sort1;
            this.mSort2 = sort2;
        }

        @Override
        public int getFlags(String[] indices, Sort[] paramSorts, Sort resultSort) {
            return paramSorts.length == 1 ? 1 : 3;
        }

        @Override
        public Sort getResultSort(String[] indices, Sort[] paramSorts, Sort resultSort) {
            if (indices != null || paramSorts.length == 0 || paramSorts.length > 2 || resultSort != null || paramSorts[0] != this.mSort1 && paramSorts[0] != this.mSort2) {
                return null;
            }
            if (paramSorts.length == 2 && paramSorts[0] != paramSorts[1]) {
                return null;
            }
            return paramSorts[0];
        }
    }

    public static abstract class SolverSetup {
        public abstract void setLogic(Theory var1, Logics var2);

        protected static final void declareInternalSort(Theory theory, String name, int cardinality, int flags) {
            theory.declareInternalSort(name, cardinality, flags);
        }

        protected static final void declareInternalFunction(Theory theory, String name, Sort[] paramSorts, Sort resultSort, int flags) {
            theory.declareInternalFunction(name, paramSorts, resultSort, flags);
        }

        protected static final void declareInternalFunction(Theory theory, String name, Sort[] paramTypes, TermVariable[] defVars, Term definition, int flags) {
            theory.declareInternalFunction(name, paramTypes, defVars, definition, flags);
        }

        protected static final void declareInternalPolymorphicFunction(Theory theory, String name, Sort[] sortParams, Sort[] paramTypes, Sort resultType, int flags) {
            theory.declareInternalPolymorphicFunction(name, sortParams, paramTypes, resultType, flags);
        }

        protected static final void defineFunction(Theory theory, FunctionSymbolFactory factory) {
            theory.declareInternalFunctionFactory(factory);
        }
    }
}

