/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol;

import de.uni_freiburg.informatik.ultimate.smtinterpol.ChannelUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;

public class DefaultLogger
implements LogProxy {
    private static final Object LOCK = new Object();
    private static final String[] LEVELS = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
    private PrintWriter mWriter = new PrintWriter(System.err);
    private Formatter mFormat = new Formatter(this.mWriter, Locale.ROOT);
    private String mDest = "stderr";
    private int mLevel = 4;

    @Override
    public void setLoglevel(int level) {
        this.mLevel = level;
    }

    @Override
    public int getLoglevel() {
        return this.mLevel;
    }

    private final boolean isEnabled(int lvl) {
        return lvl <= this.mLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void log(int lvl, Object msg) {
        Object object = LOCK;
        synchronized (object) {
            this.mWriter.print(LEVELS[lvl - 1]);
            this.mWriter.print(" - ");
            this.mWriter.println(msg);
            this.mWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void log(int lvl, String msg, Object[] params) {
        Object object = LOCK;
        synchronized (object) {
            this.mWriter.print(LEVELS[lvl - 1]);
            this.mWriter.print(" - ");
            this.mFormat.format(msg, params);
            this.mWriter.println();
            this.mWriter.flush();
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(1);
    }

    @Override
    public void fatal(String msg, Object ... params) {
        if (this.isFatalEnabled()) {
            this.log(1, msg, params);
        }
    }

    @Override
    public void fatal(Object msg) {
        if (this.isFatalEnabled()) {
            this.log(1, msg);
        }
    }

    @Override
    public void outOfMemory(String msg) {
        if (this.isFatalEnabled()) {
            this.log(1, msg);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(2);
    }

    @Override
    public void error(String msg, Object ... params) {
        if (this.isErrorEnabled()) {
            this.log(2, msg, params);
        }
    }

    @Override
    public void error(Object msg) {
        if (this.isErrorEnabled()) {
            this.log(2, msg);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(3);
    }

    @Override
    public void warn(String msg, Object ... params) {
        if (this.isWarnEnabled()) {
            this.log(3, msg, params);
        }
    }

    @Override
    public void warn(Object msg) {
        if (this.isWarnEnabled()) {
            this.log(3, msg);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(4);
    }

    @Override
    public void info(String msg, Object ... params) {
        if (this.isInfoEnabled()) {
            this.log(4, msg, params);
        }
    }

    @Override
    public void info(Object msg) {
        if (this.isInfoEnabled()) {
            this.log(4, msg);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(5);
    }

    @Override
    public void debug(String msg, Object ... params) {
        if (this.isDebugEnabled()) {
            this.log(5, msg, params);
        }
    }

    @Override
    public void debug(Object msg) {
        if (this.isDebugEnabled()) {
            this.log(5, msg);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(6);
    }

    @Override
    public void trace(String msg, Object ... params) {
        if (this.isTraceEnabled()) {
            this.log(6, msg, params);
        }
    }

    @Override
    public void trace(Object msg) {
        if (this.isTraceEnabled()) {
            this.log(6, msg);
        }
    }

    @Override
    public boolean canChangeDestination() {
        return true;
    }

    @Override
    public void changeDestination(String newDest) throws IOException {
        this.mWriter = ChannelUtil.createChannel(newDest);
        this.mFormat = new Formatter(this.mWriter, Locale.ROOT);
        this.mDest = newDest;
    }

    @Override
    public String getDestination() {
        return this.mDest;
    }
}

