/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.OccurrenceCounter;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.LogicSimplifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.BooleanVarAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.NoopProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DTReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LASharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.DestructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantAuxEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Clausifier {
    public static final int AUX_AXIOM_ADDED = 16;
    public static final int NEG_AUX_AXIOMS_ADDED = 8;
    public static final int POS_AUX_AXIOMS_ADDED = 4;
    public static final int NEG_AXIOMS_ADDED = 2;
    public static final int POS_AXIOMS_ADDED = 1;
    private final FormulaUnLet mUnlet = new FormulaUnLet();
    private final TermCompiler mCompiler = new TermCompiler();
    private final OccurrenceCounter mOccCounter = new OccurrenceCounter();
    private final Deque<Operation> mTodoStack = new ArrayDeque<Operation>();
    private final Theory mTheory;
    private final DPLLEngine mEngine;
    private CClosure mCClosure;
    private LinArSolve mLASolver;
    private ArrayTheory mArrayTheory;
    private DataTypeTheory mDataTypeTheory;
    private EprTheory mEprTheory;
    private QuantifierTheory mQuantTheory;
    private boolean mIsRunning = false;
    private boolean mIsEprEnabled;
    private QuantifierTheory.InstantiationMethod mInstantiationMethod;
    private boolean mIsUnknownTermDawgsEnabled;
    private boolean mPropagateUnknownTerms;
    private boolean mPropagateUnknownAux;
    private final ScopedHashMap<Term, Term> mAnonAuxTerms = new ScopedHashMap();
    private final ScopedHashMap<Term, ILiteral> mLiterals = new ScopedHashMap();
    private final ScopedHashMap<Term, CCTerm> mCCTerms = new ScopedHashMap();
    private final ScopedHashMap<Term, LASharedTerm> mLATerms = new ScopedHashMap();
    private final ScopedHashMap<Term, Integer> mTermDataFlags = new ScopedHashMap();
    final ScopedArrayList<Term> mUnshareCC = new ScopedArrayList();
    final ScopedHashMap<SMTAffineTerm, EqualityProxy> mEqualities = new ScopedHashMap();
    private int mStackLevel = 0;
    private int mNumFailedPushes = 0;
    private boolean mWarnedInconsistent = false;
    private static int mSkolemCounter = 0;
    private final LogProxy mLogger;
    private final IProofTracker mTracker;
    private final LogicSimplifier mUtils;
    static final ILiteral mTRUE = new TrueLiteral();
    static final ILiteral mFALSE = new FalseLiteral();

    private Term rewriteBooleanSubterms(Term term, SourceAnnotation source) {
        return new BooleanSubtermReplacer(source).transform(term);
    }

    public CCTerm createCCTerm(Term term, SourceAnnotation source) {
        CCTerm ccterm = new CCTermBuilder(source).convert(term);
        if (!this.mIsRunning) {
            this.run();
        }
        return ccterm;
    }

    public int getTermFlags(Term term) {
        Integer flags = this.mTermDataFlags.get(term);
        return flags == null ? 0 : flags;
    }

    public void setTermFlags(Term term, int newFlags) {
        this.mTermDataFlags.put(term, newFlags);
    }

    public void share(CCTerm ccTerm, LASharedTerm laTerm) {
        this.getLASolver().addSharedTerm(laTerm);
        this.getCClosure().addSharedTerm(ccTerm);
    }

    public void shareLATerm(Term term, LASharedTerm laTerm) {
        assert (!this.mLATerms.containsKey(term));
        this.mLATerms.put(term, laTerm);
        CCTerm ccTerm = this.getCCTerm(term);
        if (ccTerm != null) {
            this.share(ccTerm, laTerm);
        }
    }

    public void shareCCTerm(Term term, CCTerm ccTerm) {
        assert (!this.mCCTerms.containsKey(term));
        this.mCCTerms.put(term, ccTerm);
        LASharedTerm laTerm = this.getLATerm(term);
        if (laTerm != null) {
            this.share(ccTerm, laTerm);
        }
    }

    public void addTermAxioms(Term term, SourceAnnotation source) {
        int termFlags = this.getTermFlags(term);
        if ((termFlags & 0x10) == 0) {
            this.setTermFlags(term, termFlags | 0x10);
            if (term instanceof ApplicationTerm) {
                ApplicationTerm at;
                FunctionSymbol fs;
                CCTerm ccTerm = this.getCCTerm(term);
                if (ccTerm == null && (Clausifier.needCCTerm(term) || term.getSort().isArraySort())) {
                    CCTermBuilder cc = new CCTermBuilder(source);
                    ccTerm = cc.convert(term);
                }
                if ((fs = (at = (ApplicationTerm)term).getFunction()).isIntern()) {
                    if (fs.getName().equals("div")) {
                        this.addDivideAxioms(at, source);
                    } else if (fs.getName().equals("to_int")) {
                        this.addToIntAxioms(at, source);
                    } else if (fs.getName().equals("ite") && fs.getReturnSort() != this.mTheory.getBooleanSort()) {
                        this.pushOperation(new AddTermITEAxiom(term, source));
                    } else if (fs.getName().equals("store")) {
                        this.addStoreAxiom(at, source);
                    } else if (fs.getName().equals("@diff")) {
                        this.addDiffAxiom(at, source);
                        this.mArrayTheory.notifyDiff((CCAppTerm)ccTerm);
                    }
                }
                if (term.getSort().isArraySort()) {
                    assert (ccTerm != null);
                    String funcName = at.getFunction().getName();
                    boolean isStore = funcName.equals("store");
                    boolean isConst = funcName.equals("const");
                    this.mArrayTheory.notifyArray(this.getCCTerm(term), isStore, isConst);
                }
                if (fs.isConstructor()) {
                    DataType returnSort = (DataType)fs.getReturnSort().getSortSymbol();
                    DataType.Constructor c = returnSort.getConstructor(fs.getName());
                    this.mCClosure.addSharedTerm(ccTerm);
                    for (String sel : c.getSelectors()) {
                        FunctionSymbol selFs = this.mTheory.getFunction(sel, fs.getReturnSort());
                        this.mCClosure.insertReverseTrigger(selFs, ccTerm, 0, new DTReverseTrigger(this.mDataTypeTheory, this, selFs, ccTerm));
                    }
                    for (DataType.Constructor constr : returnSort.getConstructors()) {
                        String[] index = new String[]{constr.getName()};
                        FunctionSymbol isFs = this.mTheory.getFunctionWithResult("is", index, null, fs.getReturnSort());
                        this.mCClosure.insertReverseTrigger(isFs, ccTerm, 0, new DTReverseTrigger(this.mDataTypeTheory, this, isFs, ccTerm));
                    }
                }
            }
            if (term.getSort().isNumericSort()) {
                String func;
                boolean needsLA = term instanceof ConstantTerm;
                if (term instanceof ApplicationTerm && ((func = ((ApplicationTerm)term).getFunction().getName()).equals("+") || func.equals("-") || func.equals("*") || func.equals("to_real"))) {
                    needsLA = true;
                }
                if (needsLA) {
                    MutableAffineTerm mat = this.createMutableAffinTerm(new SMTAffineTerm(term), source);
                    assert (mat.getConstant().mEps == 0);
                    this.shareLATerm(term, new LASharedTerm(term, mat.getSummands(), mat.getConstant().mReal));
                }
            }
            if (!(term.getSort() != term.getTheory().getBooleanSort() || term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().startsWith("@AUX") || term == term.getTheory().mTrue || term == term.getTheory().mFalse)) {
                this.addExcludedMiddleAxiom(term, source);
            }
            if (term instanceof MatchTerm) {
                this.addMatchAxiom((MatchTerm)term, source);
            }
        }
        if (!this.mIsRunning) {
            this.run();
        }
    }

    public LinVar getLinVar(Term term) {
        assert (term.getSort().isNumericSort());
        assert (term == SMTAffineTerm.create(term).getSummands().keySet().iterator().next());
        LASharedTerm laShared = this.getLATerm(term);
        assert (laShared != null);
        assert (laShared.getSummands().size() == 1 && laShared.getOffset() == Rational.ZERO && laShared.getSummands().values().iterator().next() == Rational.ONE);
        return laShared.getSummands().keySet().iterator().next();
    }

    public LinVar createLinVar(Term term, SourceAnnotation source) {
        assert (term.getSort().isNumericSort());
        assert (term == SMTAffineTerm.create(term).getSummands().keySet().iterator().next());
        this.addTermAxioms(term, source);
        LASharedTerm laShared = this.getLATerm(term);
        if (laShared == null) {
            boolean isint = term.getSort().getName().equals("Int");
            LinVar lv = this.getLASolver().addVar(term, isint, this.getStackLevel());
            laShared = new LASharedTerm(term, Collections.singletonMap(lv, Rational.ONE), Rational.ZERO);
            this.shareLATerm(term, laShared);
        }
        assert (laShared.getSummands().size() == 1 && laShared.getOffset() == Rational.ZERO && laShared.getSummands().values().iterator().next() == Rational.ONE);
        return laShared.getSummands().keySet().iterator().next();
    }

    public MutableAffineTerm createMutableAffinTerm(SMTAffineTerm at, SourceAnnotation source) {
        MutableAffineTerm res = new MutableAffineTerm();
        for (Map.Entry<Term, Rational> summand : at.getSummands().entrySet()) {
            LinVar lv = this.createLinVar(summand.getKey(), source);
            Rational coeff = summand.getValue();
            res.add(coeff, lv);
        }
        res.add(at.getConstant());
        return res;
    }

    public CCTerm getCCTerm(Term term) {
        return this.mCCTerms.get(term);
    }

    public LASharedTerm getLATerm(Term term) {
        return this.mLATerms.get(term);
    }

    public ILiteral getILiteral(Term term) {
        return this.mLiterals.get(term);
    }

    public void setLiteral(Term term, ILiteral lit) {
        this.mLiterals.put(term, lit);
    }

    public static boolean needCCTerm(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol fs = appTerm.getFunction();
            if (fs.isConstructor() || fs.isSelector()) {
                return true;
            }
            if (appTerm.getParameters().length == 0) {
                return false;
            }
            if (!fs.isIntern()) {
                return true;
            }
            if (fs.getName().startsWith("@AUX")) {
                return true;
            }
            if (fs.getName().startsWith("@skolem.")) {
                return true;
            }
            switch (fs.getName()) {
                case "select": 
                case "store": 
                case "@diff": 
                case "const": 
                case "@EQ": 
                case "is": {
                    return true;
                }
                case "div": 
                case "mod": 
                case "/": {
                    return SMTAffineTerm.convertConstant((ConstantTerm)appTerm.getParameters()[1]) == Rational.ZERO;
                }
            }
            return false;
        }
        return false;
    }

    private Pair<Term, Annotation> convertQuantifiedSubformula(boolean positive, QuantifiedFormula qf) {
        Annotation rule;
        TermVariable[] vars = qf.getVariables();
        Term[] substTerms = new Term[vars.length];
        if (positive == (qf.getQuantifier() == 0)) {
            TermVariable[] freeVars = qf.getFreeVars();
            Term[] args = new Term[freeVars.length];
            Sort[] freeVarSorts = new Sort[freeVars.length];
            for (int i = 0; i < freeVars.length; ++i) {
                args[i] = freeVars[i];
                freeVarSorts[i] = freeVars[i].getSort();
            }
            Term[] skolemTerms = new ProofRules(this.mTheory).getSkolemVars(vars, qf.getSubformula(), qf.getQuantifier() == 1);
            for (int i = 0; i < vars.length; ++i) {
                String skolemName = "@skolem." + vars[i].getName() + "." + mSkolemCounter++;
                FunctionSymbol fsym = this.mTheory.declareInternalFunction(skolemName, freeVarSorts, freeVars, skolemTerms[i], 64);
                substTerms[i] = this.mTheory.term(fsym, args);
            }
            if (this.mEprTheory != null) {
                this.mEprTheory.addSkolemConstants(substTerms);
            }
            rule = qf.getQuantifier() == 0 ? ProofConstants.getTautExistsNeg(substTerms) : ProofConstants.getTautForallPos(substTerms);
        } else {
            for (int i = 0; i < vars.length; ++i) {
                substTerms[i] = this.mTheory.createFreshTermVariable(vars[i].getName(), vars[i].getSort());
            }
            rule = qf.getQuantifier() == 0 ? ProofConstants.getTautExistsPos(substTerms) : ProofConstants.getTautForallNeg(substTerms);
        }
        FormulaUnLet unlet = new FormulaUnLet();
        unlet.addSubstitutions(new ArrayMap<TermVariable, Term>(vars, substTerms));
        Term substituted = unlet.unlet(qf.getSubformula());
        Term pivotLit = qf;
        if (!positive) {
            substituted = this.mTheory.term("not", substituted);
        } else {
            pivotLit = this.mTheory.term("not", pivotLit);
        }
        return new Pair<Term, Annotation>(substituted, rule);
    }

    public Clausifier(Theory theory, DPLLEngine engine, SMTInterpol.ProofMode proofLevel) {
        this.mTheory = theory;
        this.mEngine = engine;
        this.mLogger = engine.getLogger();
        this.mTracker = proofLevel == SMTInterpol.ProofMode.NONE || proofLevel == SMTInterpol.ProofMode.CLAUSES ? new NoopProofTracker() : new ProofTracker(theory);
        this.mUtils = new LogicSimplifier(this.mTracker);
        this.mCompiler.setProofTracker(this.mTracker);
    }

    public void setAssignmentProduction(boolean on) {
        this.mCompiler.setAssignmentProduction(on);
    }

    void pushOperation(Operation op) {
        this.mTodoStack.push(op);
    }

    private static boolean isNotTerm(Term t) {
        return t instanceof ApplicationTerm && ((ApplicationTerm)t).getFunction().getName() == "not";
    }

    private Term removeDoubleNot(Term t) {
        while (Clausifier.isNotTerm(t) && Clausifier.isNotTerm(((ApplicationTerm)t).getParameters()[0])) {
            t = ((ApplicationTerm)((ApplicationTerm)t).getParameters()[0]).getParameters()[0];
        }
        return t;
    }

    private static Term toPositive(Term t) {
        if (Clausifier.isNotTerm(t)) {
            return ((ApplicationTerm)t).getParameters()[0];
        }
        return t;
    }

    public void buildAuxClause(ILiteral auxlit, Term axiom, SourceAnnotation source) {
        ApplicationTerm orTerm = (ApplicationTerm)this.mTracker.getProvedTerm(axiom);
        assert (orTerm.getFunction().getName() == "or");
        assert (orTerm.getParameters()[0] == auxlit.getSMTFormula(orTerm.getTheory()));
        BuildClause bc = new BuildClause(axiom, source);
        Term[] params = orTerm.getParameters();
        this.pushOperation(bc);
        bc.addLiteral(auxlit);
        for (int i = params.length - 1; i >= 1; --i) {
            bc.collectLiteral(params[i]);
        }
    }

    public void buildTautology(Theory theory, Term[] clause, Annotation rule, SourceAnnotation source) {
        BuildClause bc = new BuildClause(this.mTracker.tautology(theory.term("or", clause), rule), source);
        this.pushOperation(bc);
        for (Term term : clause) {
            bc.collectLiteral(term);
        }
    }

    public void buildClause(Term term, SourceAnnotation source) {
        BuildClause bc = new BuildClause(term, source);
        this.pushOperation(bc);
        bc.collectLiteral(this.mTracker.getProvedTerm(term));
    }

    public void buildClauseWithTautology(Term term, SourceAnnotation source, Term[] tautLits, Annotation rule) {
        Theory t = term.getTheory();
        Term tautology = this.mTracker.tautology(t.term("or", tautLits), rule);
        BuildClause bc = new BuildClause(term, source);
        this.pushOperation(bc);
        bc.addResolution(tautology, this.mTracker.getProvedTerm(term));
        for (int i = 1; i < tautLits.length; ++i) {
            bc.collectLiteral(tautLits[i]);
        }
    }

    public void addAuxAxioms(Term term, boolean positive, SourceAnnotation source) {
        int auxflag;
        assert (term == Clausifier.toPositive(term));
        int oldFlags = this.getTermFlags(term);
        int n = auxflag = positive ? 4 : 8;
        if ((oldFlags & auxflag) != 0) {
            return;
        }
        this.setTermFlags(term, oldFlags | auxflag);
        ILiteral negLit = this.getILiteral(term);
        assert (negLit != null);
        negLit = positive ? negLit.negate() : negLit;
        this.createDefiningClausesForLiteral(negLit, term, positive, source);
    }

    public void addAuxAxiomsQuant(Term term, Term auxTerm, SourceAnnotation source) {
        int oldFlags = this.getTermFlags(term);
        int auxflag = 12;
        if ((oldFlags & 0xC) == 12) {
            return;
        }
        this.setTermFlags(term, oldFlags | 0xC);
        QuantAuxEquality auxTrueLit = this.mQuantTheory.createAuxLiteral(auxTerm, term, source);
        ILiteral auxFalseLit = this.mQuantTheory.createAuxFalseLiteral(auxTrueLit, source);
        this.createDefiningClausesForLiteral(auxFalseLit, term, true, source);
        this.createDefiningClausesForLiteral(auxTrueLit, term, false, source);
    }

    private void createDefiningClausesForLiteral(ILiteral lit, Term term, boolean negative, SourceAnnotation source) {
        Theory t = term.getTheory();
        Term litTerm = lit.getSMTFormula(t);
        if (term instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)term;
            Term[] params = at.getParameters();
            if (at.getFunction() == t.mOr) {
                if (negative) {
                    Term[] literals = new Term[params.length + 1];
                    literals[0] = litTerm;
                    System.arraycopy(params, 0, literals, 1, params.length);
                    Term axiom = this.mTracker.tautology(t.term("or", literals), ProofConstants.TAUT_OR_NEG);
                    this.buildAuxClause(lit, axiom, source);
                } else {
                    for (Term p : params = at.getParameters()) {
                        Term axiom = t.term("or", litTerm, t.term("not", p));
                        Term axiomProof = this.mTracker.tautology(axiom, ProofConstants.TAUT_OR_POS);
                        this.buildAuxClause(lit, axiomProof, source);
                    }
                }
            } else if (at.getFunction() == t.mImplies) {
                if (negative) {
                    Term[] literals = new Term[params.length + 1];
                    literals[0] = litTerm;
                    for (int i = 0; i < params.length - 1; ++i) {
                        literals[i + 1] = t.term("not", params[i]);
                    }
                    literals[params.length] = params[params.length - 1];
                    Term axiom = this.mTracker.tautology(t.term("or", literals), ProofConstants.TAUT_IMP_NEG);
                    this.buildAuxClause(lit, axiom, source);
                } else {
                    params = at.getParameters();
                    for (int i = 0; i < params.length; ++i) {
                        Term p = i < params.length - 1 ? params[i] : t.term("not", params[i]);
                        Term axiom = t.term("or", litTerm, p);
                        Term axiomProof = this.mTracker.tautology(axiom, ProofConstants.TAUT_IMP_POS);
                        this.buildAuxClause(lit, axiomProof, source);
                    }
                }
            } else if (at.getFunction() == t.mAnd) {
                if (negative) {
                    for (Term p : params) {
                        Term axiom = t.term("or", litTerm, p);
                        Term axiomProof = this.mTracker.tautology(axiom, ProofConstants.TAUT_AND_NEG);
                        this.buildAuxClause(lit, axiomProof, source);
                    }
                } else {
                    Term[] literals = new Term[params.length + 1];
                    literals[0] = litTerm;
                    for (int i = 0; i < params.length; ++i) {
                        literals[i + 1] = t.term("not", params[i]);
                    }
                    Term axiom = this.mTracker.tautology(t.term("or", literals), ProofConstants.TAUT_AND_POS);
                    this.buildAuxClause(lit, axiom, source);
                }
            } else if (at.getFunction().getName().equals("ite")) {
                Term cond = params[0];
                Term thenTerm = params[1];
                Term elseTerm = params[2];
                if (negative) {
                    Term axiom = t.term("or", litTerm, t.term("not", cond), thenTerm);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_ITE_NEG_1);
                    this.buildAuxClause(lit, axiom, source);
                    axiom = t.term("or", litTerm, cond, elseTerm);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_ITE_NEG_2);
                    this.buildAuxClause(lit, axiom, source);
                    axiom = t.term("or", litTerm, thenTerm, elseTerm);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_ITE_NEG_RED);
                    this.buildAuxClause(lit, axiom, source);
                } else {
                    thenTerm = t.term("not", thenTerm);
                    elseTerm = t.term("not", elseTerm);
                    Term axiom = t.term("or", litTerm, t.term("not", cond), thenTerm);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_ITE_POS_1);
                    this.buildAuxClause(lit, axiom, source);
                    axiom = t.term("or", litTerm, cond, elseTerm);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_ITE_POS_2);
                    this.buildAuxClause(lit, axiom, source);
                    axiom = t.term("or", litTerm, thenTerm, elseTerm);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_ITE_POS_RED);
                    this.buildAuxClause(lit, axiom, source);
                }
            } else if (at.getFunction().getName().equals("xor")) {
                assert (at.getParameters().length == 2);
                Term p1 = at.getParameters()[0];
                Term p2 = at.getParameters()[1];
                assert (p1.getSort() == t.getBooleanSort());
                assert (p2.getSort() == t.getBooleanSort());
                if (negative) {
                    Term axiom = t.term("or", litTerm, p1, p2);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_XOR_NEG_1);
                    this.buildAuxClause(lit, axiom, source);
                    axiom = t.term("or", litTerm, t.term("not", p1), t.term("not", p2));
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_XOR_NEG_2);
                    this.buildAuxClause(lit, axiom, source);
                } else {
                    Term axiom = t.term("or", litTerm, p1, t.term("not", p2));
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_XOR_POS_1);
                    this.buildAuxClause(lit, axiom, source);
                    axiom = t.term("or", litTerm, t.term("not", p1), p2);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_XOR_POS_2);
                    this.buildAuxClause(lit, axiom, source);
                }
            } else {
                assert (lit instanceof QuantEquality);
                if (negative) {
                    Term axiom = t.term("or", litTerm, term);
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_EXCLUDED_MIDDLE_2);
                    this.buildAuxClause(lit, axiom, source);
                } else {
                    Term axiom = t.term("or", litTerm, t.term("not", term));
                    axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_EXCLUDED_MIDDLE_1);
                    this.buildAuxClause(lit, axiom, source);
                }
            }
        } else if (term instanceof MatchTerm) {
            Theory theory = term.getTheory();
            MatchTerm mt = (MatchTerm)term;
            Term dataTerm = mt.getDataTerm();
            LinkedHashMap<DataType.Constructor, Term> cases = new LinkedHashMap<DataType.Constructor, Term>();
            DataType.Constructor[] constrs = mt.getConstructors();
            for (int caseNr = 0; caseNr < constrs.length; ++caseNr) {
                Annotation rule;
                DataType.Constructor c = constrs[caseNr];
                if (cases.containsKey(c)) continue;
                ArrayDeque<Term> clause = new ArrayDeque<Term>();
                clause.add(litTerm);
                LinkedHashMap<TermVariable, Term> argSubs = new LinkedHashMap<TermVariable, Term>();
                if (c == null) {
                    clause.addAll(cases.values());
                    argSubs.put(mt.getVariables()[caseNr][0], dataTerm);
                    rule = ProofConstants.TAUT_MATCH_DEFAULT;
                } else {
                    FunctionSymbol isFs = theory.getFunctionWithResult("is", new String[]{c.getName()}, null, dataTerm.getSort());
                    Term isTerm = theory.term(isFs, dataTerm);
                    cases.put(c, isTerm);
                    clause.add(theory.term("not", isTerm));
                    int s_i = 0;
                    for (String sel : c.getSelectors()) {
                        Term selTerm = theory.term(theory.getFunctionSymbol(sel), dataTerm);
                        argSubs.put(mt.getVariables()[caseNr][s_i++], selTerm);
                    }
                    rule = ProofConstants.TAUT_MATCH_CASE;
                }
                FormulaUnLet unlet = new FormulaUnLet();
                unlet.addSubstitutions(argSubs);
                Term equalTerm = unlet.unlet(mt.getCases()[caseNr]);
                if (negative) {
                    clause.add(equalTerm);
                } else {
                    clause.add(theory.term("not", equalTerm));
                }
                Term axiom = this.mTracker.tautology(theory.term("or", clause.toArray(new Term[clause.size()])), rule);
                this.buildAuxClause(lit, axiom, source);
                if (c != null) {
                    continue;
                }
                break;
            }
        } else {
            assert (lit instanceof QuantEquality);
            if (negative) {
                Term axiom = t.term("or", litTerm, term);
                axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_EXCLUDED_MIDDLE_2);
                this.buildAuxClause(lit, axiom, source);
            } else {
                Term axiom = t.term("or", litTerm, t.term("not", term));
                axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_EXCLUDED_MIDDLE_1);
                this.buildAuxClause(lit, axiom, source);
            }
        }
    }

    public void addStoreAxiom(ApplicationTerm store, SourceAnnotation source) {
        Theory theory = store.getTheory();
        Term i = store.getParameters()[1];
        Term v = store.getParameters()[2];
        Term axiom = theory.term("=", theory.term("select", store, i), v);
        Term provedAxiom = this.mTracker.modusPonens(this.mTracker.tautology(axiom, ProofConstants.TAUT_ARRAY_STORE), this.mUtils.convertBinaryEq(this.mTracker.reflexivity(axiom)));
        this.buildClause(provedAxiom, source);
        if (v.getSort() == this.mTheory.getBooleanSort()) {
            Term a = store.getParameters()[0];
            Term sel = this.mTheory.term("select", a, i);
            this.createCCTerm(sel, source);
        }
    }

    public void addDiffAxiom(ApplicationTerm diff, SourceAnnotation source) {
        Theory theory = diff.getTheory();
        Term a = diff.getParameters()[0];
        Term b = diff.getParameters()[1];
        Term[] literals = new Term[]{theory.term("=", a, b), theory.term("not", theory.term("=", theory.term("select", a, diff), theory.term("select", b, diff)))};
        this.buildTautology(theory, literals, ProofConstants.TAUT_ARRAY_DIFF, source);
    }

    public void addDivideAxioms(ApplicationTerm divTerm, SourceAnnotation source) {
        Theory theory = divTerm.getTheory();
        Term[] divParams = divTerm.getParameters();
        Rational divisor = (Rational)((ConstantTerm)divParams[1]).getValue();
        if (divisor == Rational.ZERO) {
            return;
        }
        Term zero = Rational.ZERO.toTerm(divTerm.getSort());
        SMTAffineTerm diff = new SMTAffineTerm(divParams[0]);
        diff.negate();
        diff.add(divisor, divTerm);
        Term axiom = theory.term("<=", diff.toTerm(this.mCompiler, divTerm.getSort()), zero);
        this.buildClause(this.mTracker.tautology(axiom, ProofConstants.TAUT_DIV_LOW), source);
        diff.add(divisor.abs());
        axiom = theory.term("not", theory.term("<=", diff.toTerm(this.mCompiler, divTerm.getSort()), zero));
        this.buildClause(this.mTracker.tautology(axiom, ProofConstants.TAUT_DIV_HIGH), source);
    }

    public void addToIntAxioms(ApplicationTerm toIntTerm, SourceAnnotation source) {
        Theory theory = toIntTerm.getTheory();
        Term realTerm = toIntTerm.getParameters()[0];
        Term zero = Rational.ZERO.toTerm(realTerm.getSort());
        SMTAffineTerm diff = new SMTAffineTerm(realTerm);
        diff.negate();
        diff.add(Rational.ONE, toIntTerm);
        Term axiom = theory.term("<=", diff.toTerm(this.mCompiler, realTerm.getSort()), zero);
        this.buildClause(this.mTracker.tautology(axiom, ProofConstants.TAUT_TO_INT_LOW), source);
        diff.add(Rational.ONE);
        axiom = theory.term("not", theory.term("<=", diff.toTerm(this.mCompiler, realTerm.getSort()), zero));
        this.buildClause(this.mTracker.tautology(axiom, ProofConstants.TAUT_TO_INT_HIGH), source);
    }

    public void addExcludedMiddleAxiom(Term term, SourceAnnotation source) {
        Theory theory = term.getTheory();
        EqualityProxy trueProxy = this.createEqualityProxy(term, theory.mTrue, source);
        EqualityProxy falseProxy = this.createEqualityProxy(term, theory.mFalse, source);
        assert (trueProxy != EqualityProxy.getTrueProxy());
        assert (trueProxy != EqualityProxy.getFalseProxy());
        assert (falseProxy != EqualityProxy.getTrueProxy());
        assert (falseProxy != EqualityProxy.getFalseProxy());
        DPLLAtom trueLit = trueProxy.getLiteral(source);
        DPLLAtom falseLit = falseProxy.getLiteral(source);
        Term axiom = theory.term("or", trueLit.getSMTFormula(theory), theory.term("not", term));
        axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_EXCLUDED_MIDDLE_1);
        this.buildAuxClause(trueLit, axiom, source);
        axiom = theory.term("or", falseLit.getSMTFormula(theory), term);
        axiom = this.mTracker.tautology(axiom, ProofConstants.TAUT_EXCLUDED_MIDDLE_2);
        this.buildAuxClause(falseLit, axiom, source);
    }

    public void addMatchAxiom(MatchTerm term, SourceAnnotation source) {
        Theory theory = term.getTheory();
        Term dataTerm = term.getDataTerm();
        LinkedHashMap<DataType.Constructor, Term> cases = new LinkedHashMap<DataType.Constructor, Term>();
        DataType.Constructor[] constrs = term.getConstructors();
        for (int caseNr = 0; caseNr < constrs.length; ++caseNr) {
            Annotation rule;
            DataType.Constructor c = constrs[caseNr];
            if (cases.containsKey(c)) continue;
            LinkedHashMap<TermVariable, Term> argSubs = new LinkedHashMap<TermVariable, Term>();
            ArrayDeque<Object> clause = new ArrayDeque<Object>();
            if (c == null) {
                clause.addAll(cases.values());
                argSubs.put(term.getVariables()[caseNr][0], dataTerm);
                rule = ProofConstants.TAUT_MATCH_DEFAULT;
            } else {
                FunctionSymbol isFs = theory.getFunctionWithResult("is", new String[]{c.getName()}, null, dataTerm.getSort());
                Term isTerm = theory.term(isFs, dataTerm);
                cases.put(constrs[caseNr], isTerm);
                clause.add(theory.term("not", isTerm));
                int s_i = 0;
                for (String sel : c.getSelectors()) {
                    Term selTerm = theory.term(sel, dataTerm);
                    argSubs.put(term.getVariables()[caseNr][s_i++], selTerm);
                }
                rule = ProofConstants.TAUT_MATCH_CASE;
            }
            FormulaUnLet unlet = new FormulaUnLet();
            unlet.addSubstitutions(argSubs);
            Term caseTerm = this.mTheory.term("=", term, unlet.unlet(term.getCases()[caseNr]));
            clause.add(caseTerm);
            this.buildTautology(theory, clause.toArray(new Term[clause.size()]), rule, source);
            if (c == null) break;
        }
    }

    public EqualityProxy createEqualityProxy(Term lhs, Term rhs, SourceAnnotation source) {
        SMTAffineTerm diff = new SMTAffineTerm(lhs);
        diff.negate();
        diff.add(new SMTAffineTerm(rhs));
        if (diff.isConstant()) {
            if (diff.getConstant().equals(Rational.ZERO)) {
                return EqualityProxy.getTrueProxy();
            }
            return EqualityProxy.getFalseProxy();
        }
        diff.div(diff.getGcd());
        Sort sort = lhs.getSort();
        if (this.mTheory.getLogic().isIRA() && sort.getName().equals("Real") && diff.isAllIntSummands()) {
            sort = this.getTheory().getSort("Int", new Sort[0]);
        }
        if (sort.getName().equals("Int") && !diff.getConstant().isIntegral()) {
            return EqualityProxy.getFalseProxy();
        }
        this.addTermAxioms(lhs, source);
        this.addTermAxioms(rhs, source);
        EqualityProxy eqForm = this.mEqualities.get(diff);
        if (eqForm != null) {
            return eqForm;
        }
        diff.negate();
        eqForm = this.mEqualities.get(diff);
        if (eqForm != null) {
            return eqForm;
        }
        eqForm = new EqualityProxy(this, lhs, rhs);
        this.mEqualities.put(diff, eqForm);
        return eqForm;
    }

    public static Term checkAndGetTrivialEquality(Term lhs, Term rhs, Theory theory) {
        SMTAffineTerm diff = new SMTAffineTerm(lhs);
        diff.add(Rational.MONE, rhs);
        if (diff.isConstant()) {
            if (diff.getConstant().equals(Rational.ZERO)) {
                return theory.mTrue;
            }
            return theory.mFalse;
        }
        diff.div(diff.getGcd());
        Sort sort = lhs.getSort();
        if (theory.getLogic().isIRA() && sort.getName().equals("Real") && diff.isAllIntSummands()) {
            sort = theory.getSort("Int", new Sort[0]);
        }
        if (sort.getName().equals("Int") && !diff.getConstant().isIntegral()) {
            return theory.mFalse;
        }
        return null;
    }

    public Term createQuantAuxTerm(Term term, SourceAnnotation source) {
        Term auxTerm = this.mAnonAuxTerms.get(term);
        if (auxTerm == null) {
            assert (this.mTheory.getLogic().isQuantified()) : "quantified variables in quantifier-free theory";
            TermVariable[] freeVars = new TermVariable[term.getFreeVars().length];
            Term[] freeVarsAsTerm = new Term[freeVars.length];
            for (int i = 0; i < freeVars.length; ++i) {
                freeVars[i] = term.getFreeVars()[i];
                freeVarsAsTerm[i] = freeVars[i];
            }
            FunctionSymbol fs = this.mTheory.createFreshAuxFunction(freeVars, term);
            auxTerm = this.mTheory.term(fs, freeVarsAsTerm);
            this.addAuxAxiomsQuant(term, auxTerm, source);
            this.mAnonAuxTerms.put(term, auxTerm);
        }
        return auxTerm;
    }

    public ILiteral createAnonLiteral(Term term, SourceAnnotation source) {
        ILiteral lit = this.getILiteral(term);
        if (lit == null) {
            if (term.getFreeVars().length > 0) {
                Term auxTerm = this.createQuantAuxTerm(term, source);
                lit = this.mQuantTheory.createAuxLiteral(auxTerm, term, source);
            } else {
                lit = new NamedAtom(term, this.mStackLevel);
                this.mEngine.addAtom((NamedAtom)lit);
            }
            this.setLiteral(term, lit);
        }
        assert (lit != null);
        return lit;
    }

    ILiteral getLiteralTseitin(Term t, SourceAnnotation source) {
        Term idx = Clausifier.toPositive(t);
        boolean pos = t == idx;
        ILiteral lit = this.createAnonLiteral(idx, source);
        if (idx.getFreeVars().length == 0) {
            this.addAuxAxioms(idx, true, source);
            this.addAuxAxioms(idx, false, source);
        }
        return pos ? lit : lit.negate();
    }

    void addClause(Literal[] lits, ClauseDeletionHook hook, ProofNode proof) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Added Ground Clause: %s", Arrays.toString(lits));
        }
        if (this.mEprTheory != null) {
            this.mEprTheory.addConstants(EprHelpers.collectAppearingConstants(lits, this.mTheory));
        }
        this.mEngine.addFormulaClause(lits, proof, hook);
    }

    void addUnshareCC(Term shared) {
        this.mUnshareCC.add(shared);
    }

    private void setupCClosure() {
        if (this.mCClosure == null) {
            this.mCClosure = new CClosure(this);
            this.mEngine.addTheory(this.mCClosure);
            SourceAnnotation source = SourceAnnotation.EMPTY_SOURCE_ANNOT;
            DPLLAtom atom = this.createEqualityProxy(this.mTheory.mTrue, this.mTheory.mFalse, source).getLiteral(source);
            Term trueEqFalse = this.mTheory.term("=", this.mTheory.mTrue, this.mTheory.mFalse);
            Term axiom = this.mTracker.tautology(this.mTheory.not(trueEqFalse), ProofConstants.TAUT_TRUE_NOT_FALSE);
            BuildClause bc = new BuildClause(axiom, source);
            bc.mCurrentLits.add(this.mTheory.not(trueEqFalse));
            Term rewrite = this.mTracker.intern(trueEqFalse, atom.getSMTFormula(this.mTheory));
            bc.addLiteral(atom.negate(), trueEqFalse, rewrite, false);
            bc.perform();
        }
    }

    private void setupLinArithmetic() {
        if (this.mLASolver == null) {
            this.mLASolver = new LinArSolve(this);
            this.mEngine.addTheory(this.mLASolver);
        }
    }

    private void setupArrayTheory() {
        if (this.mArrayTheory == null) {
            this.mArrayTheory = new ArrayTheory(this, this.mCClosure);
            this.mEngine.addTheory(this.mArrayTheory);
        }
    }

    private void setupDataTypeTheory() {
        if (this.mDataTypeTheory == null) {
            this.mDataTypeTheory = new DataTypeTheory(this, this.mTheory, this.mCClosure);
            this.mEngine.addTheory(this.mDataTypeTheory);
        }
    }

    private void setupEprTheory() {
        if (this.mEprTheory == null) {
            this.mEprTheory = new EprTheory(this.mTheory, this.mEngine, this.mCClosure, this);
            this.mEngine.addTheory(this.mEprTheory);
        }
    }

    private void setupQuantifiers() {
        if (this.mQuantTheory == null) {
            this.mQuantTheory = new QuantifierTheory(this.mTheory, this.mEngine, this, this.mInstantiationMethod, this.mIsUnknownTermDawgsEnabled, this.mPropagateUnknownTerms, this.mPropagateUnknownAux);
            this.mEngine.addTheory(this.mQuantTheory);
        }
    }

    public void setQuantifierOptions(boolean isEprEnabled, QuantifierTheory.InstantiationMethod instMethod, boolean enableUnknownTermDawgs, boolean propagateUnknownTerm, boolean propagateUnknownAux) {
        this.mIsEprEnabled = isEprEnabled;
        this.mInstantiationMethod = instMethod;
        this.mIsUnknownTermDawgsEnabled = enableUnknownTermDawgs;
        this.mPropagateUnknownTerms = propagateUnknownTerm;
        this.mPropagateUnknownAux = propagateUnknownAux;
    }

    public void setLogic(Logics logic) {
        if (logic.isUF() || logic.isArray() || logic.isArithmetic() || logic.isQuantified() || logic.isDatatype()) {
            this.setupCClosure();
        }
        if (logic.isArray()) {
            this.setupArrayTheory();
        }
        if (logic.isDatatype()) {
            this.setupDataTypeTheory();
        }
        if (logic.isArithmetic()) {
            this.setupLinArithmetic();
        }
        if (logic.isQuantified()) {
            if (this.mIsEprEnabled) {
                this.setupEprTheory();
            } else {
                this.setupQuantifiers();
            }
        }
    }

    public Iterable<BooleanVarAtom> getBooleanVars() {
        final Iterator it = this.mLiterals.values().iterator();
        return () -> new Iterator<BooleanVarAtom>(){
            private BooleanVarAtom mNext = this.computeNext();

            private final BooleanVarAtom computeNext() {
                while (it.hasNext()) {
                    ILiteral lit = (ILiteral)it.next();
                    if (!(lit instanceof BooleanVarAtom)) continue;
                    return (BooleanVarAtom)lit;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mNext != null;
            }

            @Override
            public BooleanVarAtom next() {
                BooleanVarAtom res = this.mNext;
                if (res == null) {
                    throw new NoSuchElementException();
                }
                this.mNext = this.computeNext();
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final void run() {
        try {
            this.mIsRunning = true;
            while (!this.mTodoStack.isEmpty()) {
                if (this.mEngine.isTerminationRequested()) {
                    return;
                }
                Operation op = this.mTodoStack.pop();
                op.perform();
            }
        }
        finally {
            this.mTodoStack.clear();
            this.mIsRunning = false;
        }
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public ArrayTheory getArrayTheory() {
        return this.mArrayTheory;
    }

    public CClosure getCClosure() {
        return this.mCClosure;
    }

    public LinArSolve getLASolver() {
        return this.mLASolver;
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public int getStackLevel() {
        return this.mStackLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormula(Term f) {
        Term simpFormula;
        assert (this.mTodoStack.isEmpty());
        if (this.mEngine.inconsistent() && !this.mWarnedInconsistent) {
            this.mLogger.info("Already inconsistent.");
            this.mWarnedInconsistent = true;
            return;
        }
        SourceAnnotation source = SourceAnnotation.EMPTY_SOURCE_ANNOT;
        if (this.mEngine.isProofGenerationEnabled() && f instanceof AnnotatedTerm) {
            Annotation[] annots;
            AnnotatedTerm at = (AnnotatedTerm)f;
            for (Annotation a : annots = at.getAnnotations()) {
                if (!a.getKey().equals(":named")) continue;
                String name = ((String)a.getValue()).intern();
                source = new SourceAnnotation(name, null);
                break;
            }
        }
        Term origFormula = this.mUnlet.unlet(f);
        try {
            simpFormula = this.mCompiler.transform(this.removeDoubleNot(origFormula));
        }
        finally {
            this.mCompiler.reset();
        }
        simpFormula = this.mTracker.modusPonens(this.mTracker.asserted(origFormula), simpFormula);
        origFormula = null;
        this.mOccCounter.count(this.mTracker.getProvedTerm(simpFormula));
        Map<Term, Set<String>> names = this.mCompiler.getNames();
        if (names != null) {
            for (Map.Entry<Term, Set<String>> me : names.entrySet()) {
                this.trackAssignment(me.getKey(), me.getValue(), source);
            }
        }
        this.pushOperation(new AddAsAxiom(simpFormula, source));
        this.run();
        this.mOccCounter.reset(simpFormula);
        simpFormula = null;
    }

    public void push() {
        if (this.mEngine.inconsistent()) {
            if (!this.mWarnedInconsistent) {
                this.mLogger.info("Already inconsistent.");
                this.mWarnedInconsistent = true;
            }
            ++this.mNumFailedPushes;
        } else {
            this.mEngine.push();
            ++this.mStackLevel;
            this.mEqualities.beginScope();
            this.mTermDataFlags.beginScope();
            this.mLiterals.beginScope();
            this.mAnonAuxTerms.beginScope();
            this.mLATerms.beginScope();
            this.mCCTerms.beginScope();
        }
    }

    public void pop(int numpops) {
        if (numpops <= this.mNumFailedPushes) {
            this.mNumFailedPushes -= numpops;
            return;
        }
        this.mWarnedInconsistent = false;
        this.mNumFailedPushes = 0;
        this.mEngine.pop(numpops -= this.mNumFailedPushes);
        for (int i = 0; i < numpops; ++i) {
            this.mCCTerms.endScope();
            for (Term term : this.mLATerms.undoMap().keySet()) {
                CCTerm ccTerm = this.getCCTerm(term);
                if (ccTerm == null) continue;
                ccTerm.unshare();
            }
            this.mLATerms.endScope();
            this.mLiterals.endScope();
            this.mAnonAuxTerms.endScope();
            this.mTermDataFlags.endScope();
            this.mEqualities.endScope();
        }
        this.mStackLevel -= numpops;
    }

    private ProofNode getProofNewSource(Term proof, SourceAnnotation source) {
        SourceAnnotation annot = proof == null ? source : new SourceAnnotation(source, proof);
        return new LeafNode(-1, annot);
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    private void trackAssignment(Term term, Set<String> names, SourceAnnotation source) {
        EqualityProxy ep;
        ApplicationTerm at;
        FunctionSymbol fs;
        boolean pos;
        Term idx = Clausifier.toPositive(term);
        boolean bl = pos = idx == term;
        ILiteral lit = idx instanceof ApplicationTerm ? ((fs = (at = (ApplicationTerm)idx).getFunction()).getName().equals("<=") ? this.createLeq0(at, source) : (fs.getName().equals("=") && at.getParameters()[0].getSort() != this.mTheory.getBooleanSort() ? ((ep = this.createEqualityProxy(at.getParameters()[0], at.getParameters()[1], source)) == EqualityProxy.getTrueProxy() ? new DPLLAtom.TrueAtom() : (ep == EqualityProxy.getFalseProxy() ? new DPLLAtom.TrueAtom().negate() : ep.getLiteral(source))) : ((!fs.isIntern() || fs.getName().equals("select")) && fs.getReturnSort() == this.mTheory.getBooleanSort() ? this.createBooleanLit(at, source) : (at == this.mTheory.mTrue ? new DPLLAtom.TrueAtom() : (at == this.mTheory.mFalse ? new DPLLAtom.TrueAtom().negate() : this.getLiteralTseitin(idx, source)))))) : this.getLiteralTseitin(idx, source);
        assert (lit instanceof Literal);
        if (!pos) {
            lit = lit.negate();
        }
        for (String name : names) {
            this.mEngine.trackAssignment(name, (Literal)lit);
        }
    }

    private Literal createLeq0(ApplicationTerm leq0term, SourceAnnotation source) {
        Literal lit = (Literal)this.getILiteral(leq0term);
        if (lit == null) {
            SMTAffineTerm sum = new SMTAffineTerm(leq0term.getParameters()[0]);
            MutableAffineTerm msum = this.createMutableAffinTerm(sum, source);
            lit = this.mLASolver.generateConstraint(msum, false);
            this.setLiteral(leq0term, lit);
            this.setTermFlags(leq0term, this.getTermFlags(leq0term) | 4 | 8);
        }
        return lit;
    }

    private ILiteral createBooleanLit(ApplicationTerm term, SourceAnnotation source) {
        ILiteral lit = this.getILiteral(term);
        if (lit == null) {
            if (term.getParameters().length == 0) {
                BooleanVarAtom atom = new BooleanVarAtom(term, this.mStackLevel);
                this.mEngine.addAtom(atom);
                lit = atom;
            } else if (term.getFreeVars().length > 0 && !this.mIsEprEnabled) {
                lit = this.mQuantTheory.getQuantEquality(term, this.mTheory.mTrue, source);
            } else if (this.mEprTheory != null || EprTheory.isQuantifiedEprAtom(term)) {
                assert (!term.getFunction().getName().equals("not")) : "do something for the negated case!";
                EprAtom atom = this.mEprTheory.getEprAtom(term, 0, this.mStackLevel, source);
                lit = atom;
                if (atom instanceof EprGroundPredicateAtom) {
                    this.mEprTheory.addAtomToDPLLEngine(atom);
                }
            } else {
                EqualityProxy eq = this.createEqualityProxy(term, this.mTheory.mTrue, source);
                assert (eq != EqualityProxy.getTrueProxy());
                assert (eq != EqualityProxy.getFalseProxy());
                lit = eq.getLiteral(source);
            }
            this.setLiteral(term, lit);
            this.setTermFlags(term, this.getTermFlags(term) | 4 | 8);
        }
        return lit;
    }

    public IProofTracker getTracker() {
        return this.mTracker;
    }

    public LogicSimplifier getSimplifier() {
        return this.mUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Literal getCreateLiteral(Term f, SourceAnnotation source) {
        Literal res;
        Term tmp2;
        Term tmp = this.mUnlet.unlet(f);
        try {
            tmp2 = this.mCompiler.transform(tmp);
        }
        finally {
            this.mCompiler.reset();
        }
        tmp = null;
        this.mOccCounter.count(tmp2);
        ApplicationTerm at = (ApplicationTerm)this.mTracker.getProvedTerm(tmp2);
        boolean negated = false;
        FunctionSymbol fs = at.getFunction();
        if (fs == this.mTheory.mNot) {
            at = (ApplicationTerm)at.getParameters()[0];
            fs = at.getFunction();
            negated = true;
        }
        if (!fs.isIntern() || fs.getName().equals("select")) {
            ILiteral iLit = this.createBooleanLit(at, source);
            assert (iLit instanceof Literal);
            res = (Literal)iLit;
        } else if (at == this.mTheory.mTrue) {
            res = new DPLLAtom.TrueAtom();
        } else if (at == this.mTheory.mFalse) {
            res = new DPLLAtom.TrueAtom().negate();
        } else if (fs.getName().equals("xor")) {
            ILiteral iLit = this.getLiteralTseitin(at, source);
            assert (iLit instanceof Literal);
            res = (Literal)iLit;
        } else if (fs.getName().equals("=")) {
            EqualityProxy ep = this.createEqualityProxy(at.getParameters()[0], at.getParameters()[1], source);
            res = ep == EqualityProxy.getFalseProxy() ? new DPLLAtom.TrueAtom().negate() : (ep == EqualityProxy.getTrueProxy() ? new DPLLAtom.TrueAtom() : ep.getLiteral(source));
        } else if (fs.getName().equals("<=")) {
            res = this.createLeq0(at, source);
        } else {
            ILiteral iLit = this.getLiteralTseitin(at, source);
            assert (iLit instanceof Literal);
            res = (Literal)iLit;
        }
        this.run();
        this.mOccCounter.reset(tmp2);
        tmp2 = null;
        return negated ? res.negate() : res;
    }

    public EprTheory getEprTheory() {
        return this.mEprTheory;
    }

    public QuantifierTheory getQuantifierTheory() {
        return this.mQuantTheory;
    }

    public TermCompiler getTermCompiler() {
        return this.mCompiler;
    }

    private static class FalseLiteral
    implements ILiteral {
        private FalseLiteral() {
        }

        @Override
        public ILiteral getAtom() {
            return this;
        }

        @Override
        public ILiteral negate() {
            return mTRUE;
        }

        @Override
        public boolean isGround() {
            return true;
        }

        @Override
        public Term getSMTFormula(Theory theory) {
            return theory.mFalse;
        }
    }

    private static class TrueLiteral
    implements ILiteral {
        private TrueLiteral() {
        }

        @Override
        public ILiteral getAtom() {
            return this;
        }

        @Override
        public ILiteral negate() {
            return mFALSE;
        }

        @Override
        public boolean isGround() {
            return true;
        }

        @Override
        public Term getSMTFormula(Theory theory) {
            return theory.mTrue;
        }
    }

    class BooleanSubtermReplacer
    extends TermTransformer {
        private final SourceAnnotation mSource;

        public BooleanSubtermReplacer(SourceAnnotation source) {
            this.mSource = source;
        }

        @Override
        public void convert(Term term) {
            if (term.getSort().getName() == "Bool" && this.shouldReplaceTerm(term)) {
                Term auxTerm = Clausifier.this.createQuantAuxTerm(term, this.mSource);
                this.setResult(Clausifier.this.mTracker.buildRewrite(term, auxTerm, ProofConstants.RW_AUX_INTRO));
                return;
            }
            if (!(term instanceof ApplicationTerm)) {
                this.setResult(Clausifier.this.mTracker.reflexivity(term));
                return;
            }
            super.convert(term);
        }

        @Override
        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            this.setResult(Clausifier.this.mTracker.congruence(Clausifier.this.mTracker.reflexivity(appTerm), newArgs));
        }

        boolean shouldReplaceTerm(Term term) {
            return term.getFreeVars().length != 0 && !(term instanceof TermVariable) && (!Clausifier.needCCTerm(term) || term instanceof QuantifiedFormula || term instanceof MatchTerm);
        }
    }

    private class AddTermITEAxiom
    implements Operation {
        private final SourceAnnotation mSource;
        private Term mMinValue = null;
        private Rational mMaxSubMin = null;
        private final Set<Term> visited = new HashSet<Term>();
        boolean mIsNotConstant = false;
        private final Term mTermITE;

        public AddTermITEAxiom(Term termITE, SourceAnnotation source) {
            this.mTermITE = termITE;
            this.mSource = source;
        }

        @Override
        public void perform() {
            Clausifier.this.pushOperation(new CollectConditions(new LinkedHashSet<Term>(), this.mTermITE));
            Clausifier.this.pushOperation(new AddBoundAxioms());
            Clausifier.this.pushOperation(new CheckBounds(this.mTermITE));
        }

        private class AddBoundAxioms
        implements Operation {
            @Override
            public void perform() {
                if (!AddTermITEAxiom.this.mIsNotConstant && AddTermITEAxiom.this.mMinValue != null) {
                    Sort sort = AddTermITEAxiom.this.mTermITE.getSort();
                    Theory theory = sort.getTheory();
                    Term zero = Rational.ZERO.toTerm(sort);
                    SMTAffineTerm diff = new SMTAffineTerm(AddTermITEAxiom.this.mTermITE);
                    diff.negate();
                    diff.add(new SMTAffineTerm(AddTermITEAxiom.this.mMinValue));
                    Term lboundAx = theory.term("<=", diff.toTerm(Clausifier.this.mCompiler, sort), zero);
                    Clausifier.this.buildClause(Clausifier.this.mTracker.tautology(lboundAx, ProofConstants.TAUT_TERM_ITE_BOUND), AddTermITEAxiom.this.mSource);
                    diff.add(AddTermITEAxiom.this.mMaxSubMin);
                    diff.negate();
                    Term uboundAx = theory.term("<=", diff.toTerm(Clausifier.this.mCompiler, sort), zero);
                    Clausifier.this.buildClause(Clausifier.this.mTracker.tautology(uboundAx, ProofConstants.TAUT_TERM_ITE_BOUND), AddTermITEAxiom.this.mSource);
                }
            }
        }

        private class CheckBounds
        implements Operation {
            private final Term mTerm;

            public CheckBounds(Term term) {
                this.mTerm = term;
            }

            @Override
            public void perform() {
                ApplicationTerm at;
                if (AddTermITEAxiom.this.mIsNotConstant || !AddTermITEAxiom.this.visited.add(this.mTerm)) {
                    return;
                }
                if (this.mTerm instanceof ApplicationTerm && (at = (ApplicationTerm)this.mTerm).getFunction().getName().equals("ite")) {
                    Term t = at.getParameters()[1];
                    Term e = at.getParameters()[2];
                    Clausifier.this.pushOperation(new CheckBounds(t));
                    Clausifier.this.pushOperation(new CheckBounds(e));
                    return;
                }
                if (AddTermITEAxiom.this.mMinValue == null) {
                    AddTermITEAxiom.this.mMinValue = this.mTerm;
                    AddTermITEAxiom.this.mMaxSubMin = Rational.ZERO;
                    return;
                }
                SMTAffineTerm diff = new SMTAffineTerm(AddTermITEAxiom.this.mMinValue);
                diff.negate();
                diff.add(new SMTAffineTerm(this.mTerm));
                if (!diff.isConstant()) {
                    AddTermITEAxiom.this.mIsNotConstant = true;
                    return;
                }
                if (diff.getConstant().signum() < 0) {
                    AddTermITEAxiom.this.mMinValue = this.mTerm;
                    AddTermITEAxiom.this.mMaxSubMin = AddTermITEAxiom.this.mMaxSubMin.sub(diff.getConstant());
                } else if (diff.getConstant().compareTo(AddTermITEAxiom.this.mMaxSubMin) > 0) {
                    AddTermITEAxiom.this.mMaxSubMin = diff.getConstant();
                }
            }
        }

        private class CollectConditions
        implements Operation {
            private final LinkedHashSet<Term> mConds;
            private final Term mTerm;

            public CollectConditions(LinkedHashSet<Term> conds, Term term) {
                this.mConds = conds;
                this.mTerm = term;
            }

            @Override
            public void perform() {
                ApplicationTerm at;
                if (this.mTerm instanceof ApplicationTerm && (at = (ApplicationTerm)this.mTerm).getFunction().getName().equals("ite") && (at.mTmpCtr <= 1 || this.mConds.size() == 0)) {
                    Term t = at.getParameters()[1];
                    Term e = at.getParameters()[2];
                    Term c = at.getParameters()[0];
                    boolean isNegated = false;
                    while (Clausifier.isNotTerm(c)) {
                        c = ((ApplicationTerm)c).getParameters()[0];
                        isNegated = !isNegated;
                    }
                    Term notC = c.getTheory().term("not", c);
                    if (this.mConds.contains(c)) {
                        Clausifier.this.pushOperation(new CollectConditions(this.mConds, isNegated ? t : e));
                    } else if (this.mConds.contains(notC)) {
                        Clausifier.this.pushOperation(new CollectConditions(this.mConds, isNegated ? e : t));
                    } else {
                        LinkedHashSet<Term> other = new LinkedHashSet<Term>(this.mConds);
                        this.mConds.add(isNegated ? c : notC);
                        other.add(isNegated ? notC : c);
                        Clausifier.this.pushOperation(new CollectConditions(this.mConds, t));
                        Clausifier.this.pushOperation(new CollectConditions(other, e));
                    }
                    return;
                }
                Theory theory = this.mTerm.getTheory();
                Term[] literals = new Term[this.mConds.size() + 1];
                int offset = this.mConds.size();
                for (Term cond : this.mConds) {
                    literals[--offset] = cond;
                }
                literals[this.mConds.size()] = theory.term("=", AddTermITEAxiom.this.mTermITE, this.mTerm);
                Clausifier.this.buildTautology(theory, literals, ProofConstants.TAUT_TERM_ITE, AddTermITEAxiom.this.mSource);
            }
        }
    }

    private class BuildClause
    implements Operation {
        private final Term mClause;
        private Term mProof;
        private boolean mIsTrue = false;
        private final LinkedHashSet<Term> mCurrentLits = new LinkedHashSet();
        private final LinkedHashSet<Literal> mLits = new LinkedHashSet();
        private final LinkedHashSet<QuantLiteral> mQuantLits = new LinkedHashSet();
        private final SourceAnnotation mSource;

        public BuildClause(Term clauseWithProof, SourceAnnotation proofNode) {
            this.mClause = clauseWithProof;
            this.mSource = proofNode;
            this.mProof = Clausifier.this.mTracker.getClauseProof(clauseWithProof);
        }

        public SourceAnnotation getSource() {
            return this.mSource;
        }

        public void collectLiteral(Term term) {
            while (Clausifier.isNotTerm(term) && Clausifier.isNotTerm(((ApplicationTerm)term).getParameters()[0])) {
                Term negated = ((ApplicationTerm)term).getParameters()[0];
                term = ((ApplicationTerm)negated).getParameters()[0];
            }
            if (this.mCurrentLits.add(term)) {
                Clausifier.this.pushOperation(new CollectLiteral(term, this));
            }
        }

        public void addLiteral(ILiteral lit) {
            if (lit instanceof Literal) assert (((Literal)lit).getAtom().getAssertionStackLevel() <= Clausifier.this.mEngine.getAssertionStackLevel());
            if (lit == mTRUE) {
                this.mIsTrue = true;
            } else {
                if (lit == mFALSE) {
                    return;
                }
                if (lit instanceof Literal && this.mLits.add((Literal)lit)) {
                    this.mIsTrue |= this.mLits.contains(((Literal)lit).negate());
                } else if (lit instanceof QuantLiteral && this.mQuantLits.add((QuantLiteral)lit)) {
                    this.mIsTrue |= this.mQuantLits.contains(((QuantLiteral)lit).negate());
                } else {
                    return;
                }
            }
        }

        public void addResolution(Term otherClause, Term pivotLit) {
            if (Clausifier.this.mTracker instanceof ProofTracker && otherClause != null) {
                this.mProof = ((ProofTracker)Clausifier.this.mTracker).resolve(pivotLit, this.mProof, Clausifier.this.mTracker.getClauseProof(otherClause));
            }
        }

        public void addLiteral(ILiteral lit, Term origAtom, Term rewriteAtom, boolean positive) {
            Term rewriteLiteral;
            Theory theory = rewriteAtom.getTheory();
            Term origLiteral = positive ? origAtom : theory.term("not", origAtom);
            Term term = rewriteLiteral = positive ? rewriteAtom : Clausifier.this.mTracker.congruence(Clausifier.this.mTracker.reflexivity(origLiteral), new Term[]{rewriteAtom});
            assert (this.mCurrentLits.contains(origLiteral));
            this.mCurrentLits.remove(origLiteral);
            this.addResolution(Clausifier.this.mTracker.rewriteToClause(origLiteral, rewriteLiteral), origLiteral);
            if (lit == mFALSE && Clausifier.this.mTracker instanceof ProofTracker) {
                Term trueFalseTerm = Clausifier.this.mTracker.getProvedTerm(rewriteAtom);
                assert (!positive ? trueFalseTerm == theory.mTrue : trueFalseTerm == theory.mFalse);
                Term negTrueFalseTerm = positive ? theory.term("not", trueFalseTerm) : trueFalseTerm;
                Annotation rule = positive ? ProofConstants.TAUT_FALSE_NEG : ProofConstants.TAUT_TRUE_POS;
                this.addResolution(Clausifier.this.mTracker.tautology(negTrueFalseTerm, rule), Clausifier.this.mTracker.getProvedTerm(rewriteLiteral));
            }
            this.addLiteral(lit);
        }

        private Term buildQuantifierProof(Literal[] lits, QuantLiteral[] quantLits) {
            Term clause;
            Theory theory = Clausifier.this.mTheory;
            if (lits.length + quantLits.length > 1) {
                Term[] literals = new Term[lits.length + quantLits.length];
                int i = 0;
                for (Literal literal : lits) {
                    literals[i++] = literal.getSMTFormula(theory);
                }
                for (ILiteral iLiteral : quantLits) {
                    literals[i++] = ((QuantLiteral)iLiteral).getSMTFormula(theory);
                }
                clause = theory.term("or", literals);
                if (Clausifier.this.mTracker instanceof ProofTracker) {
                    for (i = 0; i < literals.length; ++i) {
                        Term orPos = Clausifier.this.mTracker.tautology(theory.term("or", clause, theory.term("not", literals[i])), ProofConstants.TAUT_OR_POS);
                        this.addResolution(orPos, literals[i]);
                    }
                }
            } else {
                assert (lits.length == 0 && quantLits.length == 1) : "quantLits must not be empty";
                clause = quantLits[0].getSMTFormula(theory);
            }
            Term rewriteProof = theory.annotatedTerm(new Annotation[]{new Annotation(":proof", this.mProof)}, clause);
            rewriteProof = Clausifier.this.mTracker.allIntro(rewriteProof, clause.getFreeVars());
            return rewriteProof;
        }

        @Override
        public void perform() {
            if (this.mIsTrue) {
                return;
            }
            Theory theory = this.mClause.getTheory();
            boolean isDpllClause = true;
            Literal[] lits = this.mLits.toArray(new Literal[this.mLits.size()]);
            QuantLiteral[] quantLits = this.mQuantLits.toArray(new QuantLiteral[this.mQuantLits.size()]);
            if (Clausifier.this.mIsEprEnabled) {
                for (Literal l : lits) {
                    if (!(l.getAtom() instanceof EprQuantifiedPredicateAtom) && !(l.getAtom() instanceof EprQuantifiedEqualityAtom)) continue;
                    isDpllClause = false;
                    break;
                }
            } else if (!this.mQuantLits.isEmpty()) {
                isDpllClause = false;
            }
            if (isDpllClause) {
                Clausifier.this.addClause(lits, null, Clausifier.this.getProofNewSource(this.mProof, this.mSource));
            } else if (Clausifier.this.mIsEprEnabled) {
                Literal[] groundLiteralsAfterDER = Clausifier.this.mEprTheory.addEprClause(lits, null, null);
                if (groundLiteralsAfterDER != null) {
                    Clausifier.this.addClause(groundLiteralsAfterDER, null, Clausifier.this.getProofNewSource(this.mProof, this.mSource));
                }
            } else {
                Term quantifierWithProof = this.buildQuantifierProof(lits, quantLits);
                TermVariable[] quantVars = ((QuantifiedFormula)Clausifier.this.mTracker.getProvedTerm(quantifierWithProof)).getVariables();
                DestructiveEqualityReasoning.DERResult resultFromDER = Clausifier.this.mQuantTheory.performDestructiveEqualityReasoning(quantVars, lits, quantLits, this.mSource);
                if (resultFromDER == null) {
                    Clausifier.this.mQuantTheory.addQuantClause(quantVars, lits, quantLits, this.mSource, quantifierWithProof);
                } else if (!resultFromDER.isTriviallyTrue()) {
                    Annotation splitAnnot = ProofConstants.getTautForallNeg(resultFromDER.getSubs());
                    Term substituted = resultFromDER.getSubstituted();
                    Term splitProof = Clausifier.this.mTracker.resolveBinaryTautology(quantifierWithProof, substituted, splitAnnot);
                    Term derProof = resultFromDER.getSimplified();
                    Term rewriteProofAfterDER = Clausifier.this.mTracker.modusPonens(splitProof, derProof);
                    Term provedAfterDER = Clausifier.this.mTracker.getProvedTerm(rewriteProofAfterDER);
                    this.mProof = Clausifier.this.mTracker.getClauseProof(rewriteProofAfterDER);
                    if (provedAfterDER instanceof ApplicationTerm) {
                        ApplicationTerm appTerm = (ApplicationTerm)provedAfterDER;
                        if (appTerm.getFunction().getName().equals("or")) {
                            Term[] litsAfterDER = ((ApplicationTerm)provedAfterDER).getParameters();
                            Term[] orElimParam = new Term[litsAfterDER.length + 1];
                            orElimParam[0] = theory.term("not", provedAfterDER);
                            for (int i = 0; i < litsAfterDER.length; ++i) {
                                orElimParam[i + 1] = litsAfterDER[i];
                            }
                            Term orElim = Clausifier.this.mTracker.tautology(theory.term("or", orElimParam), ProofConstants.TAUT_OR_NEG);
                            this.addResolution(orElim, provedAfterDER);
                        } else if (appTerm.getFunction().getName().equals("false")) {
                            Term pivot = theory.term("not", appTerm);
                            Term falseElim = Clausifier.this.mTracker.tautology(pivot, ProofConstants.TAUT_FALSE_NEG);
                            this.addResolution(falseElim, provedAfterDER);
                        }
                    }
                    Literal[] derGroundLits = resultFromDER.getGroundLits();
                    QuantLiteral[] derQuantLits = resultFromDER.getQuantLits();
                    if (derQuantLits.length == 0) {
                        Clausifier.this.addClause(derGroundLits, null, Clausifier.this.getProofNewSource(this.mProof, this.mSource));
                    } else {
                        rewriteProofAfterDER = this.buildQuantifierProof(derGroundLits, derQuantLits);
                        quantVars = ((QuantifiedFormula)Clausifier.this.mTracker.getProvedTerm(rewriteProofAfterDER)).getVariables();
                        Clausifier.this.mQuantTheory.addQuantClause(quantVars, derGroundLits, derQuantLits, this.mSource, rewriteProofAfterDER);
                    }
                }
            }
        }

        public String toString() {
            return "BC" + Clausifier.this.mTracker.getProvedTerm(this.mClause);
        }
    }

    private class CollectLiteral
    implements Operation {
        private final Term mLiteral;
        private final BuildClause mClauseBuilder;

        public CollectLiteral(Term term, BuildClause collector) {
            assert (term.getSort() == Clausifier.this.mTheory.getBooleanSort());
            this.mLiteral = term;
            this.mClauseBuilder = collector;
        }

        @Override
        public void perform() {
            Theory theory = this.mLiteral.getTheory();
            Term idx = this.mLiteral;
            boolean quantified = false;
            boolean positive = true;
            while (Clausifier.isNotTerm(idx)) {
                positive = !positive;
                idx = ((ApplicationTerm)idx).getParameters()[0];
            }
            if (idx instanceof ApplicationTerm) {
                ILiteral lit;
                if (Clausifier.this.mIsEprEnabled && EprTheory.isQuantifiedEprAtom(idx)) {
                    EprAtom eprAtom = Clausifier.this.mEprTheory.getEprAtom((ApplicationTerm)idx, 0, Clausifier.this.mStackLevel, this.mClauseBuilder.getSource());
                    this.mClauseBuilder.addLiteral(positive ? eprAtom : eprAtom.negate(), idx, Clausifier.this.mTracker.reflexivity(idx), positive);
                    return;
                }
                ApplicationTerm at = (ApplicationTerm)idx;
                if (this.mLiteral.mTmpCtr <= 1 && (positive ? at.getFunction() == theory.mOr || at.getFunction() == theory.mImplies : at.getFunction() == theory.mAnd)) {
                    Annotation rule = at.getFunction() == theory.mOr ? ProofConstants.TAUT_OR_NEG : (at.getFunction() == theory.mImplies ? ProofConstants.TAUT_IMP_NEG : ProofConstants.TAUT_AND_POS);
                    Term[] params = at.getParameters();
                    Term[] tautClause = new Term[params.length + 1];
                    tautClause[0] = positive ? theory.term("not", idx) : idx;
                    for (int i = 0; i < params.length; ++i) {
                        Term p = params[i];
                        if (at.getFunction() == theory.mAnd || at.getFunction() == theory.mImplies && i < params.length - 1) {
                            p = theory.term("not", p);
                        }
                        tautClause[i + 1] = p;
                    }
                    Term taut = Clausifier.this.mTracker.tautology(theory.term("or", tautClause), rule);
                    this.mClauseBuilder.mCurrentLits.remove(this.mLiteral);
                    this.mClauseBuilder.addResolution(taut, this.mLiteral);
                    for (int i = params.length - 1; i >= 0; --i) {
                        this.mClauseBuilder.collectLiteral(tautClause[i + 1]);
                    }
                    return;
                }
                if (idx.getFreeVars().length > 0) {
                    quantified = true;
                }
                Term rewrite = Clausifier.this.mTracker.reflexivity(at);
                if (at.getFunction().getName().equals("true")) {
                    lit = mTRUE;
                } else if (at.getFunction().getName().equals("false")) {
                    lit = mFALSE;
                } else if (at.getFunction().getName().equals("=")) {
                    assert (at.getParameters()[0].getSort() != Clausifier.this.mTheory.getBooleanSort());
                    Term lhs = at.getParameters()[0];
                    Term rhs = at.getParameters()[1];
                    if (quantified) {
                        Term trivialEq = Clausifier.checkAndGetTrivialEquality(lhs, rhs, Clausifier.this.mTheory);
                        if (trivialEq == ((Clausifier)Clausifier.this).mTheory.mTrue) {
                            lit = mTRUE;
                        } else if (trivialEq == ((Clausifier)Clausifier.this).mTheory.mFalse) {
                            lit = mFALSE;
                        } else {
                            Term newLhs = Clausifier.this.rewriteBooleanSubterms(lhs, this.mClauseBuilder.getSource());
                            Term newRhs = Clausifier.this.rewriteBooleanSubterms(rhs, this.mClauseBuilder.getSource());
                            rewrite = Clausifier.this.mTracker.congruence(rewrite, new Term[]{newLhs, newRhs});
                            lit = Clausifier.this.mQuantTheory.getQuantEquality(Clausifier.this.mTracker.getProvedTerm(newLhs), Clausifier.this.mTracker.getProvedTerm(newRhs), this.mClauseBuilder.getSource());
                        }
                    } else {
                        EqualityProxy eq = Clausifier.this.createEqualityProxy(lhs, rhs, this.mClauseBuilder.getSource());
                        lit = eq == EqualityProxy.getTrueProxy() ? mTRUE : (eq == EqualityProxy.getFalseProxy() ? mFALSE : eq.getLiteral(this.mClauseBuilder.getSource()));
                    }
                } else if (at.getFunction().getName().equals("<=")) {
                    if (quantified) {
                        Term linTerm = at.getParameters()[0];
                        Term zero = at.getParameters()[1];
                        Term newLinTerm = Clausifier.this.rewriteBooleanSubterms(linTerm, this.mClauseBuilder.getSource());
                        rewrite = Clausifier.this.mTracker.congruence(rewrite, new Term[]{newLinTerm, Clausifier.this.mTracker.reflexivity(zero)});
                        lit = Clausifier.this.mQuantTheory.getQuantInequality(positive, Clausifier.this.mTracker.getProvedTerm(newLinTerm), this.mClauseBuilder.getSource());
                    } else {
                        lit = Clausifier.this.createLeq0(at, this.mClauseBuilder.getSource());
                    }
                } else if (!at.getFunction().isInterpreted() || Clausifier.needCCTerm(at)) {
                    if (quantified) {
                        rewrite = Clausifier.this.rewriteBooleanSubterms(at, this.mClauseBuilder.getSource());
                    }
                    lit = Clausifier.this.createBooleanLit((ApplicationTerm)Clausifier.this.mTracker.getProvedTerm(rewrite), this.mClauseBuilder.getSource());
                } else {
                    lit = Clausifier.this.createAnonLiteral(idx, this.mClauseBuilder.getSource());
                    if (idx.getFreeVars().length == 0) {
                        if (positive) {
                            Clausifier.this.addAuxAxioms(idx, true, this.mClauseBuilder.getSource());
                        } else {
                            Clausifier.this.addAuxAxioms(idx, false, this.mClauseBuilder.getSource());
                        }
                    }
                }
                rewrite = Clausifier.this.mTracker.transitivity(rewrite, Clausifier.this.mTracker.intern(Clausifier.this.mTracker.getProvedTerm(rewrite), lit.getSMTFormula(theory)));
                this.mClauseBuilder.addLiteral(positive ? lit : lit.negate(), at, rewrite, positive);
            } else {
                if (idx instanceof QuantifiedFormula) {
                    QuantifiedFormula qf = (QuantifiedFormula)idx;
                    Pair converted = Clausifier.this.convertQuantifiedSubformula(positive, qf);
                    Term substituted = (Term)converted.getFirst();
                    Term lit = positive ? idx : theory.term("not", idx);
                    Term negLit = positive ? theory.term("not", idx) : idx;
                    Term tautology = Clausifier.this.mTracker.tautology(theory.term("or", negLit, substituted), (Annotation)converted.getSecond());
                    this.mClauseBuilder.mCurrentLits.remove(this.mLiteral);
                    this.mClauseBuilder.addResolution(tautology, lit);
                    Term substitutedCanonic = Clausifier.this.mCompiler.transform(substituted);
                    this.mClauseBuilder.addResolution(Clausifier.this.mTracker.rewriteToClause(substituted, substitutedCanonic), substituted);
                    Term newLiteral = Clausifier.this.mTracker.getProvedTerm(substitutedCanonic);
                    this.mClauseBuilder.collectLiteral(newLiteral);
                    return;
                }
                if (idx instanceof TermVariable) {
                    assert (idx.getSort().equals(theory.getBooleanSort()));
                    ApplicationTerm value = positive ? ((Clausifier)Clausifier.this).mTheory.mFalse : ((Clausifier)Clausifier.this).mTheory.mTrue;
                    QuantLiteral lit = Clausifier.this.mQuantTheory.getQuantEquality(idx, value, this.mClauseBuilder.getSource());
                    Term rewrite = Clausifier.this.mTracker.intern(idx, (positive ? lit.negate() : lit).getSMTFormula(theory));
                    this.mClauseBuilder.addLiteral(lit.negate(), idx, rewrite, positive);
                } else if (idx instanceof MatchTerm) {
                    ILiteral lit = Clausifier.this.createAnonLiteral(idx, this.mClauseBuilder.getSource());
                    if (idx.getFreeVars().length == 0) {
                        if (positive) {
                            Clausifier.this.addAuxAxioms(idx, true, this.mClauseBuilder.getSource());
                        } else {
                            Clausifier.this.addAuxAxioms(idx, false, this.mClauseBuilder.getSource());
                        }
                    }
                    Term rewrite = Clausifier.this.mTracker.intern(idx, lit.getSMTFormula(theory));
                    this.mClauseBuilder.addLiteral(positive ? lit : lit.negate(), idx, rewrite, positive);
                } else {
                    throw new SMTLIBException("Cannot handle literal " + this.mLiteral);
                }
            }
        }

        public String toString() {
            return "Collect" + this.mLiteral.toString();
        }
    }

    private class AddAsAxiom
    implements Operation {
        private final Term mAxiom;
        private final SourceAnnotation mSource;

        public AddAsAxiom(Term axiom, SourceAnnotation source) {
            assert (axiom.getSort().getName() == "Bool");
            this.mAxiom = axiom;
            this.mSource = source;
        }

        @Override
        public void perform() {
            int auxFlag;
            int assertedFlag;
            Term term = Clausifier.this.mTracker.getProvedTerm(this.mAxiom);
            boolean positive = true;
            while (Clausifier.isNotTerm(term)) {
                term = Clausifier.toPositive(term);
                positive = !positive;
            }
            int oldFlags = Clausifier.this.getTermFlags(term);
            if (positive) {
                assertedFlag = 1;
                auxFlag = 4;
            } else {
                assertedFlag = 2;
                auxFlag = 8;
            }
            if ((oldFlags & assertedFlag) != 0) {
                return;
            }
            Clausifier.this.setTermFlags(term, oldFlags | assertedFlag);
            ILiteral auxlit = Clausifier.this.getILiteral(term);
            if (auxlit != null) {
                if ((oldFlags & auxFlag) == 0) {
                    Clausifier.this.addAuxAxioms(term, positive, this.mSource);
                }
                Clausifier.this.buildClause(this.mAxiom, this.mSource);
                return;
            }
            Theory t = this.mAxiom.getTheory();
            if (term instanceof ApplicationTerm) {
                ApplicationTerm at = (ApplicationTerm)term;
                if (!positive && at.getFunction() == t.mOr) {
                    Clausifier.this.setTermFlags(term, oldFlags | assertedFlag | auxFlag);
                    for (Term p : at.getParameters()) {
                        Term split = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, t.term("not", p), ProofConstants.TAUT_OR_POS);
                        Clausifier.this.pushOperation(new AddAsAxiom(split, this.mSource));
                    }
                    return;
                }
                if (positive && at.getFunction() == t.mAnd) {
                    Clausifier.this.setTermFlags(term, oldFlags | assertedFlag | auxFlag);
                    for (Term p : at.getParameters()) {
                        Term split = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, p, ProofConstants.TAUT_AND_NEG);
                        Clausifier.this.pushOperation(new AddAsAxiom(split, this.mSource));
                    }
                    return;
                }
                if (!positive && at.getFunction() == t.mImplies) {
                    Clausifier.this.setTermFlags(term, oldFlags | assertedFlag | auxFlag);
                    Term[] params = at.getParameters();
                    for (int i = 0; i < params.length; ++i) {
                        Term p = i < params.length - 1 ? params[i] : t.term("not", params[i]);
                        Term split = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, p, ProofConstants.TAUT_IMP_POS);
                        Clausifier.this.pushOperation(new AddAsAxiom(split, this.mSource));
                    }
                    return;
                }
                if (at.getFunction().getName().equals("xor") && at.getParameters()[0].getSort() == t.getBooleanSort()) {
                    Clausifier.this.setTermFlags(term, oldFlags | assertedFlag | auxFlag);
                    Term p1 = at.getParameters()[0];
                    Term p2 = at.getParameters()[1];
                    if (positive) {
                        Term pivot = t.term("not", term);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, p1, p2}, ProofConstants.TAUT_XOR_NEG_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, t.term("not", p1), t.term("not", p2)}, ProofConstants.TAUT_XOR_NEG_2);
                    } else {
                        Term pivot = term;
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, p1, t.term("not", p2)}, ProofConstants.TAUT_XOR_POS_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, t.term("not", p1), p2}, ProofConstants.TAUT_XOR_POS_2);
                    }
                    return;
                }
                if (at.getFunction().getName().equals("ite")) {
                    Clausifier.this.setTermFlags(term, oldFlags | assertedFlag | auxFlag);
                    assert (at.getFunction().getReturnSort() == t.getBooleanSort());
                    Term cond = at.getParameters()[0];
                    Term thenForm = at.getParameters()[1];
                    Term elseForm = at.getParameters()[2];
                    if (positive) {
                        Term pivot = t.term("not", term);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, t.term("not", cond), thenForm}, ProofConstants.TAUT_ITE_NEG_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, cond, elseForm}, ProofConstants.TAUT_ITE_NEG_2);
                    } else {
                        Term pivot = term;
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, t.term("not", cond), t.term("not", thenForm)}, ProofConstants.TAUT_ITE_POS_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{pivot, cond, t.term("not", elseForm)}, ProofConstants.TAUT_ITE_POS_2);
                    }
                    return;
                }
            } else if (term instanceof QuantifiedFormula) {
                QuantifiedFormula qf = (QuantifiedFormula)term;
                Pair convertQuantInfo = Clausifier.this.convertQuantifiedSubformula(positive, qf);
                Annotation rule = (Annotation)convertQuantInfo.getSecond();
                Term skolemized = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, (Term)convertQuantInfo.getFirst(), rule);
                Term rewrite = Clausifier.this.mCompiler.transform(Clausifier.this.mTracker.getProvedTerm(skolemized));
                Term newAxiom = Clausifier.this.mTracker.modusPonens(skolemized, rewrite);
                Clausifier.this.pushOperation(new AddAsAxiom(newAxiom, this.mSource));
                return;
            }
            Clausifier.this.buildClause(this.mAxiom, this.mSource);
        }
    }

    private static interface Operation {
        public void perform();
    }

    public class CCTermBuilder {
        private final SourceAnnotation mSource;
        private final ArrayDeque<Operation> mOps = new ArrayDeque();
        private final ArrayDeque<CCTerm> mConverted = new ArrayDeque();

        public CCTermBuilder(SourceAnnotation source) {
            this.mSource = source;
        }

        public CCTerm convert(Term t) {
            this.mOps.push(new BuildCCTerm(t));
            while (!this.mOps.isEmpty()) {
                this.mOps.pop().perform();
            }
            CCTerm res = this.mConverted.pop();
            assert (this.mConverted.isEmpty());
            return res;
        }

        private class BuildCCAppTerm
        implements Operation {
            private final boolean mIsFunc;

            public BuildCCAppTerm(boolean isFunc) {
                this.mIsFunc = isFunc;
            }

            @Override
            public void perform() {
                CCTerm arg = (CCTerm)CCTermBuilder.this.mConverted.pop();
                CCTerm func = (CCTerm)CCTermBuilder.this.mConverted.pop();
                CCTermBuilder.this.mConverted.push(Clausifier.this.mCClosure.createAppTerm(this.mIsFunc, func, arg, CCTermBuilder.this.mSource));
            }
        }

        private class SaveCCTerm
        implements Operation {
            private final Term mTerm;

            public SaveCCTerm(Term term) {
                this.mTerm = term;
            }

            @Override
            public void perform() {
                CCTerm ccTerm = (CCTerm)CCTermBuilder.this.mConverted.peek();
                Clausifier.this.mCClosure.addTerm(ccTerm, this.mTerm);
                Clausifier.this.shareCCTerm(this.mTerm, ccTerm);
                Clausifier.this.addTermAxioms(this.mTerm, CCTermBuilder.this.mSource);
            }
        }

        private class BuildCCTerm
        implements Operation {
            private final Term mTerm;

            public BuildCCTerm(Term term) {
                this.mTerm = term;
            }

            @Override
            public void perform() {
                CCTerm ccTerm = Clausifier.this.getCCTerm(this.mTerm);
                if (ccTerm != null) {
                    CCTermBuilder.this.mConverted.push(ccTerm);
                } else if (Clausifier.needCCTerm(this.mTerm)) {
                    FunctionSymbol fs = ((ApplicationTerm)this.mTerm).getFunction();
                    if (fs.isIntern() && fs.getName() == "select") {
                        Clausifier.this.mArrayTheory.cleanCaches();
                    }
                    CCTermBuilder.this.mOps.push(new SaveCCTerm(this.mTerm));
                    ApplicationTerm at = (ApplicationTerm)this.mTerm;
                    Term[] args = at.getParameters();
                    for (int i = args.length - 1; i >= 0; --i) {
                        CCTermBuilder.this.mOps.push(new BuildCCAppTerm(i != args.length - 1));
                        CCTermBuilder.this.mOps.push(new BuildCCTerm(args[i]));
                    }
                    CCTermBuilder.this.mConverted.push(Clausifier.this.mCClosure.getFuncTerm(fs));
                } else {
                    ccTerm = Clausifier.this.mCClosure.createAnonTerm(this.mTerm);
                    Clausifier.this.mCClosure.addTerm(ccTerm, this.mTerm);
                    Clausifier.this.shareCCTerm(this.mTerm, ccTerm);
                    Clausifier.this.addTermAxioms(this.mTerm, CCTermBuilder.this.mSource);
                    CCTermBuilder.this.mConverted.push(ccTerm);
                }
            }
        }
    }
}

