/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;

public class EqualityProxy {
    private static final TrueEqualityProxy TRUE = new TrueEqualityProxy();
    private static final FalseEqualityProxy FALSE = new FalseEqualityProxy();
    final Clausifier mClausifier;
    final Term mLhs;
    final Term mRhs;

    public static TrueEqualityProxy getTrueProxy() {
        return TRUE;
    }

    public static FalseEqualityProxy getFalseProxy() {
        return FALSE;
    }

    public EqualityProxy(Clausifier clausifier, Term lhs, Term rhs) {
        this.mClausifier = clausifier;
        this.mLhs = lhs;
        this.mRhs = rhs;
    }

    public LAEquality createLAEquality() {
        SMTAffineTerm affine = SMTAffineTerm.create(this.mLhs);
        affine.add(Rational.MONE, SMTAffineTerm.create(this.mRhs));
        return this.mClausifier.getLASolver().createEquality(this.mClausifier.createMutableAffinTerm(affine, null));
    }

    public Rational computeNormFactor(Term lhs, Term rhs) {
        SMTAffineTerm affine = SMTAffineTerm.create(lhs);
        affine.add(Rational.MONE, rhs);
        return affine.getGcd().inverse();
    }

    public CCEquality createCCEquality(Term lhs, Term rhs) {
        Rational normFactor;
        LAEquality laeq;
        Object eq;
        assert (lhs.getSort().isNumericSort());
        CCTerm ccLhs = this.mClausifier.getCCTerm(lhs);
        CCTerm ccRhs = this.mClausifier.getCCTerm(rhs);
        assert (ccLhs != null && ccRhs != null);
        DPLLAtom eqAtom = this.getLiteral(null);
        if (eqAtom instanceof CCEquality) {
            eq = (CCEquality)eqAtom;
            laeq = ((CCEquality)eq).getLASharedData();
            if (laeq == null) {
                normFactor = this.computeNormFactor(this.mLhs, this.mRhs);
                laeq = this.createLAEquality();
                laeq.addDependentAtom((CCEquality)eq);
                ((CCEquality)eq).setLASharedData(laeq, normFactor);
            }
        } else {
            laeq = (LAEquality)eqAtom;
        }
        for (CCEquality eq2 : laeq.getDependentEqualities()) {
            assert (eq2.getLASharedData() == laeq);
            if (eq2.getLhs() == ccLhs && eq2.getRhs() == ccRhs) {
                return eq2;
            }
            if (eq2.getRhs() != ccLhs || eq2.getLhs() != ccRhs) continue;
            return eq2;
        }
        eq = this.mClausifier.getCClosure().createCCEquality(this.mClausifier.getStackLevel(), ccLhs, ccRhs);
        normFactor = this.computeNormFactor(lhs, rhs);
        laeq.addDependentAtom((CCEquality)eq);
        ((CCEquality)eq).setLASharedData(laeq, normFactor);
        return eq;
    }

    private DPLLAtom createAtom(Term eqTerm, SourceAnnotation source) {
        boolean hasRhsLA;
        this.mClausifier.addTermAxioms(this.mLhs, source);
        this.mClausifier.addTermAxioms(this.mRhs, source);
        CCTerm lhsCCTerm = this.mClausifier.getCCTerm(this.mLhs);
        CCTerm rhsCCTerm = this.mClausifier.getCCTerm(this.mRhs);
        boolean hasLhsLA = this.mClausifier.getLATerm(this.mLhs) != null;
        boolean bl = hasRhsLA = this.mClausifier.getLATerm(this.mRhs) != null;
        if (lhsCCTerm == null && rhsCCTerm == null) {
            if ((this.mClausifier.getCClosure() == null || hasLhsLA) && !hasRhsLA) {
                this.mClausifier.createLinVar(this.mRhs, source);
                hasRhsLA = true;
            }
            if ((this.mClausifier.getCClosure() == null || hasRhsLA) && !hasLhsLA) {
                this.mClausifier.createLinVar(this.mLhs, source);
                hasLhsLA = true;
            }
        }
        if (hasLhsLA && hasRhsLA) {
            return this.createLAEquality();
        }
        CCTerm ccLhs = this.mClausifier.createCCTerm(this.mLhs, source);
        CCTerm ccRhs = this.mClausifier.createCCTerm(this.mRhs, source);
        DPLLAtom atom = (DPLLAtom)this.mClausifier.getILiteral(eqTerm);
        if (atom != null) {
            return atom;
        }
        return this.mClausifier.getCClosure().createCCEquality(this.mClausifier.getStackLevel(), ccLhs, ccRhs);
    }

    public DPLLAtom getLiteral(SourceAnnotation source) {
        Term eqTerm = this.mLhs.getTheory().term("=", this.mLhs, this.mRhs);
        DPLLAtom lit = (DPLLAtom)this.mClausifier.getILiteral(eqTerm);
        if (lit == null) {
            lit = this.createAtom(eqTerm, source);
            this.mClausifier.getLogger().debug("Created Equality: %s", lit);
            this.mClausifier.setTermFlags(eqTerm, this.mClausifier.getTermFlags(eqTerm) | 4 | 8);
            this.mClausifier.setLiteral(eqTerm, lit);
        }
        return lit;
    }

    public String toString() {
        PrintTerm pt = new PrintTerm();
        StringBuilder sb = new StringBuilder();
        pt.append((Appendable)sb, this.mLhs);
        sb.append(" == ");
        pt.append((Appendable)sb, this.mRhs);
        return sb.toString();
    }

    public static final class FalseEqualityProxy
    extends EqualityProxy {
        private FalseEqualityProxy() {
            super(null, null, null);
        }

        @Override
        public DPLLAtom getLiteral(SourceAnnotation source) {
            throw new InternalError("Should never be called");
        }
    }

    public static final class TrueEqualityProxy
    extends EqualityProxy {
        private TrueEqualityProxy() {
            super(null, null, null);
        }

        @Override
        public DPLLAtom getLiteral(SourceAnnotation source) {
            throw new InternalError("Should never be called");
        }
    }
}

