/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import java.util.LinkedHashSet;

public class LogicSimplifier {
    private final IProofTracker mTracker;

    public LogicSimplifier(IProofTracker tracker) {
        this.mTracker = tracker;
    }

    public Term convertNot(Term input) {
        ApplicationTerm notTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (notTerm.getFunction().getName() == "not");
        Theory theory = notTerm.getTheory();
        Term arg = notTerm.getParameters()[0];
        if (arg == theory.mFalse) {
            Term rewrite = this.mTracker.buildRewrite(notTerm, theory.mTrue, ProofConstants.RW_NOT_SIMP);
            return this.mTracker.transitivity(input, rewrite);
        }
        if (arg == theory.mTrue) {
            Term rewrite = this.mTracker.buildRewrite(notTerm, theory.mFalse, ProofConstants.RW_NOT_SIMP);
            return this.mTracker.transitivity(input, rewrite);
        }
        return input;
    }

    public Term convertOr(Term input) {
        Term res;
        ApplicationTerm orTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (orTerm.getFunction().getName() == "or");
        Term[] args = orTerm.getParameters();
        LinkedHashSet<Term> ctx = new LinkedHashSet<Term>();
        Theory theory = args[0].getTheory();
        ApplicationTerm trueTerm = theory.mTrue;
        ApplicationTerm falseTerm = theory.mFalse;
        for (Term t : args) {
            if (t == trueTerm) {
                return this.mTracker.transitivity(input, this.mTracker.buildRewrite(orTerm, trueTerm, ProofConstants.RW_OR_TAUT));
            }
            if (t == falseTerm) continue;
            if (ctx.contains(theory.not(t))) {
                return this.mTracker.transitivity(input, this.mTracker.buildRewrite(orTerm, trueTerm, ProofConstants.RW_OR_TAUT));
            }
            ctx.add(t);
        }
        if (ctx.isEmpty()) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(orTerm, falseTerm, ProofConstants.RW_OR_SIMP));
        }
        if (ctx.size() == 1) {
            res = (Term)ctx.iterator().next();
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(orTerm, res, ProofConstants.RW_OR_SIMP));
        }
        if (ctx.size() == args.length) {
            return input;
        }
        res = theory.term(theory.mOr, ctx.toArray(new Term[ctx.size()]));
        return this.mTracker.transitivity(input, this.mTracker.buildRewrite(orTerm, res, ProofConstants.RW_OR_SIMP));
    }

    public Term convertLeq0(Term input) {
        ApplicationTerm leq0Term = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (leq0Term.getFunction().getName() == "<=");
        assert (leq0Term.getParameters()[1] == Rational.ZERO.toTerm(leq0Term.getParameters()[0].getSort()));
        Term arg = leq0Term.getParameters()[0];
        if (arg instanceof ConstantTerm) {
            Rational value = (Rational)((ConstantTerm)arg).getValue();
            Theory t = arg.getTheory();
            if (value.compareTo(Rational.ZERO) > 0) {
                return this.mTracker.transitivity(input, this.mTracker.buildRewrite(leq0Term, t.mFalse, ProofConstants.RW_LEQ_FALSE));
            }
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(leq0Term, t.mTrue, ProofConstants.RW_LEQ_TRUE));
        }
        return input;
    }

    public Term convertIte(Term input) {
        ApplicationTerm iteTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (iteTerm.getFunction().getName() == "ite");
        Term cond = iteTerm.getParameters()[0];
        Term trueBranch = iteTerm.getParameters()[1];
        Term falseBranch = iteTerm.getParameters()[2];
        Theory theory = cond.getTheory();
        if (cond == theory.mTrue) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, trueBranch, ProofConstants.RW_ITE_TRUE));
        }
        if (cond == theory.mFalse) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, falseBranch, ProofConstants.RW_ITE_FALSE));
        }
        if (trueBranch == falseBranch) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, trueBranch, ProofConstants.RW_ITE_SAME));
        }
        if (trueBranch == theory.mTrue && falseBranch == theory.mFalse) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, cond, ProofConstants.RW_ITE_BOOL_1));
        }
        if (trueBranch == theory.mFalse && falseBranch == theory.mTrue) {
            Term result = this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, theory.term("not", cond), ProofConstants.RW_ITE_BOOL_2));
            return this.convertNot(result);
        }
        if (trueBranch == theory.mTrue) {
            Term result = this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, theory.term("or", cond, falseBranch), ProofConstants.RW_ITE_BOOL_3));
            return this.convertOr(result);
        }
        if (trueBranch == theory.mFalse) {
            Term rhs = theory.term("not", theory.term("or", cond, theory.term("not", falseBranch)));
            Term result = this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, rhs, ProofConstants.RW_ITE_BOOL_4));
            return this.convertNotOrNot(result);
        }
        if (falseBranch == theory.mTrue) {
            Term rhs = theory.term("or", theory.term("not", cond), trueBranch);
            Term result = this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, rhs, ProofConstants.RW_ITE_BOOL_5));
            return this.convertOrNot(result);
        }
        if (falseBranch == theory.mFalse) {
            Term rhs = theory.term("not", theory.term("or", theory.term("not", cond), theory.term("not", trueBranch)));
            Term result = this.mTracker.transitivity(input, this.mTracker.buildRewrite(iteTerm, rhs, ProofConstants.RW_ITE_BOOL_6));
            return this.convertNotOrNot(result);
        }
        return input;
    }

    public Term convertBinaryEq(Term input) {
        Term[] newArgs;
        ApplicationTerm eqTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (eqTerm.getFunction().getName() == "=");
        Term[] args = eqTerm.getParameters();
        assert (args.length == 2) : "Non-binary equality in makeBinaryEq";
        Theory theory = input.getTheory();
        while (args[0].getSort().isArraySort() && (newArgs = this.checkStoreRewrite(args)) != null) {
            ApplicationTerm newEqTerm = (ApplicationTerm)theory.term("=", newArgs);
            Term result = this.mTracker.buildRewrite(eqTerm, newEqTerm, ProofConstants.RW_STORE_REWRITE);
            input = this.mTracker.transitivity(input, result);
            eqTerm = newEqTerm;
            args = newArgs;
        }
        if (args[0].getSort().equals(theory.getBooleanSort())) {
            Term xorTerm = theory.term("xor", args);
            Term rewrite = this.mTracker.buildRewrite(eqTerm, theory.term("not", xorTerm), ProofConstants.RW_EQ_TO_XOR);
            rewrite = this.mTracker.congruence(rewrite, new Term[]{this.convertXor(this.mTracker.reflexivity(xorTerm))});
            return this.convertNot(this.mTracker.transitivity(input, rewrite));
        }
        return input;
    }

    private Term[] checkStoreRewrite(Term[] eqArgs) {
        assert (eqArgs.length == 2);
        for (int i = 0; i < 2; ++i) {
            ApplicationTerm store;
            Term[] storeArgs;
            if (!this.isStore(eqArgs[i]) || eqArgs[1 - i] != (storeArgs = (store = (ApplicationTerm)eqArgs[i]).getParameters())[0]) continue;
            Theory theory = storeArgs[0].getTheory();
            return new Term[]{theory.term("select", storeArgs[0], storeArgs[1]), storeArgs[2]};
        }
        return null;
    }

    public Term convertEq(Term input) {
        ApplicationTerm eqTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (eqTerm.getFunction().getName() == "=");
        Theory theory = input.getTheory();
        Term[] args = eqTerm.getParameters();
        LinkedHashSet<Term> eqArgList = new LinkedHashSet<Term>();
        if (args[0].getSort().isNumericSort()) {
            Rational lastConst = null;
            for (Term t : args) {
                if (t instanceof ConstantTerm) {
                    Rational value = (Rational)((ConstantTerm)t).getValue();
                    if (lastConst == null) {
                        lastConst = value;
                    } else if (!lastConst.equals(value)) {
                        return this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, theory.mFalse, ProofConstants.RW_CONST_DIFF));
                    }
                }
                eqArgList.add(t);
            }
        } else if (args[0].getSort() == theory.getBooleanSort()) {
            boolean foundTrue = false;
            boolean foundFalse = false;
            for (Term t : args) {
                if (t == theory.mTrue) {
                    foundTrue = true;
                    continue;
                }
                if (t == theory.mFalse) {
                    foundFalse = true;
                    continue;
                }
                eqArgList.add(t);
            }
            if (foundTrue && foundFalse) {
                return this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, theory.mFalse, ProofConstants.RW_TRUE_NOT_FALSE));
            }
            if (foundTrue || foundFalse) {
                if (eqArgList.isEmpty()) {
                    return this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, theory.mTrue, ProofConstants.RW_EQ_SAME));
                }
                Annotation rule = foundTrue ? ProofConstants.RW_EQ_TRUE : ProofConstants.RW_EQ_FALSE;
                Term[] orArgs = eqArgList.toArray(new Term[eqArgList.size()]);
                if (orArgs.length == 1) {
                    Term rhs = orArgs[0];
                    if (foundFalse) {
                        rhs = theory.term("not", rhs);
                    }
                    Term rewrite = this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, rhs, rule));
                    if (foundFalse) {
                        rewrite = this.convertNot(rewrite);
                    }
                    return rewrite;
                }
                if (foundTrue) {
                    for (int i = 0; i < orArgs.length; ++i) {
                        orArgs[i] = theory.term("not", orArgs[i]);
                    }
                }
                Term rhs = theory.term("not", theory.term("or", orArgs));
                return this.convertNotOrNot(this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, rhs, rule)));
            }
        } else {
            for (Term t : args) {
                eqArgList.add(t);
            }
        }
        if (eqArgList.size() == 1) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, theory.mTrue, ProofConstants.RW_EQ_SAME));
        }
        if (eqArgList.size() != args.length) {
            Term[] newArgs = eqArgList.toArray(new Term[eqArgList.size()]);
            ApplicationTerm rhs = (ApplicationTerm)theory.term("=", newArgs);
            input = this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, rhs, ProofConstants.RW_EQ_SIMP));
            eqTerm = rhs;
            args = newArgs;
        }
        if (args.length == 2) {
            return this.convertBinaryEq(input);
        }
        Term[] binEqs = new Term[args.length - 1];
        Term[] binEqRewrites = new Term[args.length - 1];
        for (int i = 0; i < binEqs.length; ++i) {
            Term binEq = theory.term("=", args[i], args[i + 1]);
            binEqs[i] = theory.term("not", binEq);
            binEqRewrites[i] = this.convertNot(this.mTracker.congruence(this.mTracker.reflexivity(binEqs[i]), new Term[]{this.convertBinaryEq(this.mTracker.reflexivity(binEq))}));
        }
        Term orTerm = theory.term("or", binEqs);
        Term res = theory.term("not", orTerm);
        return this.mTracker.congruence(this.mTracker.transitivity(input, this.mTracker.buildRewrite(eqTerm, res, ProofConstants.RW_EQ_BINARY)), new Term[]{this.mTracker.congruence(this.mTracker.reflexivity(orTerm), binEqRewrites)});
    }

    private boolean isStore(Term t) {
        if (t instanceof ApplicationTerm) {
            FunctionSymbol fs = ((ApplicationTerm)t).getFunction();
            return fs.isIntern() && fs.getName().equals("store");
        }
        return false;
    }

    public Term convertDistinct(Term input) {
        ApplicationTerm distinctTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (distinctTerm.getFunction().getName() == "distinct");
        Term[] args = distinctTerm.getParameters();
        Theory theory = input.getTheory();
        if (args[0].getSort() == theory.getBooleanSort()) {
            if (args.length > 2) {
                return this.mTracker.transitivity(input, this.mTracker.buildRewrite(distinctTerm, theory.mFalse, ProofConstants.RW_DISTINCT_BOOL));
            }
            Term xorTerm = this.mTracker.transitivity(input, this.mTracker.buildRewrite(distinctTerm, theory.term("xor", args), ProofConstants.RW_DISTINCT_TO_XOR));
            return this.convertXor(xorTerm);
        }
        LinkedHashSet<Term> tmp = new LinkedHashSet<Term>();
        for (Term t : args) {
            if (tmp.add(t)) continue;
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(distinctTerm, theory.mFalse, ProofConstants.RW_DISTINCT_SAME));
        }
        tmp = null;
        if (args.length == 2) {
            Term res = theory.term("not", theory.term("=", args));
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(distinctTerm, res, ProofConstants.RW_DISTINCT_BINARY));
        }
        Term[] nconjs = new Term[args.length * (args.length - 1) / 2];
        int pos = 0;
        for (int i = 0; i < args.length - 1; ++i) {
            for (int j = i + 1; j < args.length; ++j) {
                nconjs[pos++] = theory.term("=", args[i], args[j]);
            }
        }
        Term res = theory.term("not", theory.term("or", nconjs));
        return this.mTracker.transitivity(input, this.mTracker.buildRewrite(distinctTerm, res, ProofConstants.RW_DISTINCT_BINARY));
    }

    public static boolean isNegation(Term t) {
        if (t instanceof ApplicationTerm) {
            return ((ApplicationTerm)t).getFunction() == t.getTheory().mNot;
        }
        return false;
    }

    public Term convertFuncNot(Term input) {
        ApplicationTerm appTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        Term[] args = appTerm.getParameters();
        Term[] argRewrites = new Term[args.length];
        for (int i = 0; i < args.length; ++i) {
            argRewrites[i] = this.mTracker.reflexivity(args[i]);
            if (!(args[i] instanceof ApplicationTerm) || ((ApplicationTerm)args[i]).getFunction().getName() != "not") continue;
            argRewrites[i] = this.convertNot(argRewrites[i]);
        }
        return this.mTracker.congruence(input, argRewrites);
    }

    public Term convertOrNot(Term input) {
        return this.convertOr(this.convertFuncNot(input));
    }

    public Term convertNotOrNot(Term input) {
        ApplicationTerm notTerm = (ApplicationTerm)this.mTracker.getProvedTerm(input);
        assert (notTerm.getFunction().getName() == "not");
        ApplicationTerm orTerm = (ApplicationTerm)notTerm.getParameters()[0];
        Term orRewrite = this.convertOrNot(this.mTracker.reflexivity(orTerm));
        return this.convertNot(this.mTracker.congruence(input, new Term[]{orRewrite}));
    }

    public Term convertAnd(Term input) {
        return input;
    }

    public Term convertXor(Term input) {
        Term xorTerm = this.mTracker.getProvedTerm(input);
        assert (((ApplicationTerm)xorTerm).getFunction().getName() == "xor");
        Term[] args = ((ApplicationTerm)xorTerm).getParameters();
        Theory theory = input.getTheory();
        assert (args.length == 2);
        if (args[0] == theory.mFalse) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(xorTerm, args[1], ProofConstants.RW_XOR_FALSE));
        }
        if (args[1] == theory.mFalse) {
            return this.mTracker.transitivity(input, this.mTracker.buildRewrite(xorTerm, args[0], ProofConstants.RW_XOR_FALSE));
        }
        if (args[0] == theory.mTrue) {
            Term rewrite = this.mTracker.transitivity(input, this.mTracker.buildRewrite(xorTerm, theory.term("not", args[1]), ProofConstants.RW_XOR_TRUE));
            return this.convertNot(rewrite);
        }
        if (args[1] == theory.mTrue) {
            Term rewrite = this.mTracker.transitivity(input, this.mTracker.buildRewrite(xorTerm, theory.term("not", args[0]), ProofConstants.RW_XOR_TRUE));
            return this.convertNot(rewrite);
        }
        Term[] newArgs = (Term[])args.clone();
        int countNot = 0;
        for (int i = 0; i < args.length; ++i) {
            Term arg = args[i];
            while (LogicSimplifier.isNegation(arg)) {
                arg = ((ApplicationTerm)arg).getParameters()[0];
                ++countNot;
            }
            newArgs[i] = arg;
        }
        Term rewrite = input;
        if (countNot > 0) {
            Term newXorTerm = theory.term("xor", newArgs);
            Term newTerm = countNot % 2 == 1 ? theory.term("not", newXorTerm) : newXorTerm;
            rewrite = this.mTracker.transitivity(input, this.mTracker.buildRewrite(xorTerm, newTerm, ProofConstants.RW_XOR_NOT));
            xorTerm = newXorTerm;
        }
        if (newArgs[0] == newArgs[1]) {
            Term rewriteFalse = this.mTracker.buildRewrite(xorTerm, theory.term("false", new Term[0]), ProofConstants.RW_XOR_SAME);
            rewrite = countNot % 2 == 1 ? this.convertNot(this.mTracker.congruence(rewrite, new Term[]{rewriteFalse})) : this.mTracker.transitivity(rewrite, rewriteFalse);
        }
        return rewrite;
    }

    public Term convertImplies(Term input) {
        return input;
    }
}

