/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SMTAffineTerm {
    private final Map<Term, Rational> mSummands = new LinkedHashMap<Term, Rational>();
    private Rational mConstant = Rational.ZERO;

    public SMTAffineTerm() {
    }

    public SMTAffineTerm(Term term) {
        this();
        Term[] subterms = term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("+") ? ((ApplicationTerm)term).getParameters() : new Term[]{term};
        for (Term subterm : subterms) {
            Rational factor = Rational.ONE;
            if (subterm instanceof ApplicationTerm && ((ApplicationTerm)subterm).getFunction().getName() == "*") {
                Term[] params = ((ApplicationTerm)subterm).getParameters();
                assert (params.length == 2);
                factor = SMTAffineTerm.convertConstant((ConstantTerm)SMTAffineTerm.parseConstant(params[0]));
                subterm = params[1];
            }
            if (subterm instanceof ApplicationTerm && ((ApplicationTerm)subterm).getFunction().getName() == "-" && ((ApplicationTerm)subterm).getParameters().length == 1) {
                factor = factor.negate();
                subterm = ((ApplicationTerm)subterm).getParameters()[0];
            }
            if (subterm instanceof ApplicationTerm && ((ApplicationTerm)subterm).getFunction().getName() == "to_real") {
                subterm = ((ApplicationTerm)subterm).getParameters()[0];
            }
            if ((subterm = SMTAffineTerm.parseConstant(subterm)) instanceof ConstantTerm) {
                assert (factor == Rational.ONE && this.mConstant == Rational.ZERO);
                this.mConstant = SMTAffineTerm.convertConstant((ConstantTerm)subterm);
                continue;
            }
            assert (!this.mSummands.containsKey(subterm));
            this.mSummands.put(subterm, factor);
        }
    }

    public static SMTAffineTerm create(Term term) {
        return new SMTAffineTerm(term);
    }

    public static boolean isToReal(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("to_real");
    }

    public static Term parseConstant(Term term) {
        Rational denominator;
        Term numerator;
        boolean isNegated = false;
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("/")) {
            Term[] params = ((ApplicationTerm)term).getParameters();
            numerator = params[0];
            if (SMTAffineTerm.isToReal(params[1])) {
                params[1] = ((ApplicationTerm)params[1]).getParameters()[0];
            }
            if (!(params[1] instanceof ConstantTerm)) {
                return term;
            }
            denominator = SMTAffineTerm.convertConstant((ConstantTerm)params[1]);
            if (denominator == Rational.ZERO) {
                return term;
            }
        } else {
            numerator = term;
            denominator = Rational.ONE;
        }
        if (numerator instanceof ApplicationTerm && ((ApplicationTerm)numerator).getFunction().getName().equals("-") && ((ApplicationTerm)numerator).getParameters().length == 1) {
            numerator = ((ApplicationTerm)numerator).getParameters()[0];
            isNegated = true;
        }
        if (SMTAffineTerm.isToReal(numerator)) {
            numerator = ((ApplicationTerm)numerator).getParameters()[0];
        }
        if (!(numerator instanceof ConstantTerm)) {
            return term;
        }
        Rational value = SMTAffineTerm.convertConstant((ConstantTerm)numerator).mul(denominator.inverse());
        if (isNegated) {
            value = value.negate();
        }
        return value.toTerm(term.getSort());
    }

    public void mul(Rational factor) {
        if (factor == Rational.ZERO) {
            this.mSummands.clear();
            this.mConstant = Rational.ZERO;
            return;
        }
        for (Map.Entry<Term, Rational> entry : this.mSummands.entrySet()) {
            entry.setValue(entry.getValue().mul(factor));
        }
        this.mConstant = this.mConstant.mul(factor);
    }

    public void add(Rational constant) {
        this.mConstant = this.mConstant.add(constant);
    }

    public void add(Rational factor, Term other) {
        SMTAffineTerm otherAffine = new SMTAffineTerm(other);
        this.add(factor, otherAffine);
    }

    public void add(Rational factor, SMTAffineTerm other) {
        for (Map.Entry<Term, Rational> entry : other.mSummands.entrySet()) {
            Term var = entry.getKey();
            Rational coeff = factor.mul(entry.getValue());
            if (this.mSummands.containsKey(var)) {
                Rational r = this.mSummands.get(var).add(coeff);
                if (r.equals(Rational.ZERO)) {
                    this.mSummands.remove(var);
                    continue;
                }
                this.mSummands.put(var, r);
                continue;
            }
            this.mSummands.put(var, coeff);
        }
        this.mConstant = this.mConstant.add(factor.mul(other.mConstant));
    }

    public void add(SMTAffineTerm other) {
        this.add(Rational.ONE, other);
    }

    public static Rational convertConstant(ConstantTerm term) {
        Rational constant;
        Object value = term.getValue();
        if (value instanceof BigInteger) {
            constant = Rational.valueOf((BigInteger)value, BigInteger.ONE);
        } else if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            if (decimal.scale() <= 0) {
                BigInteger num = decimal.toBigInteger();
                constant = Rational.valueOf(num, BigInteger.ONE);
            } else {
                BigInteger num = decimal.unscaledValue();
                BigInteger denom = BigInteger.TEN.pow(decimal.scale());
                constant = Rational.valueOf(num, denom);
            }
        } else if (value instanceof Rational) {
            constant = (Rational)value;
        } else {
            throw new InternalError("Something went wrong with constants!");
        }
        return constant;
    }

    public void div(Rational c) {
        this.mul(c.inverse());
    }

    public void negate() {
        this.mul(Rational.MONE);
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty();
    }

    public Rational getConstant() {
        return this.mConstant;
    }

    Rational getCoefficient(Term subterm) {
        Rational coeff = this.mSummands.get(subterm);
        return coeff == null ? Rational.ZERO : coeff;
    }

    public Rational getGcd() {
        assert (!this.mSummands.isEmpty());
        Iterator<Rational> it = this.mSummands.values().iterator();
        Rational gcd = it.next().abs();
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next().abs());
        }
        return gcd;
    }

    public Map<Term, Rational> getSummands() {
        return this.mSummands;
    }

    public Term toTerm(TermCompiler unifier, Sort sort) {
        Term term = this.toTerm(sort);
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("+")) {
            return unifier.unifySummation((ApplicationTerm)term);
        }
        return term;
    }

    public Term toTerm(Sort sort) {
        assert (sort.isNumericSort());
        Theory t = sort.getTheory();
        int size = this.mSummands.size();
        if (size == 0 || !this.mConstant.equals(Rational.ZERO)) {
            ++size;
        }
        Term[] sum = new Term[size];
        int i = 0;
        for (Map.Entry<Term, Rational> factor : this.mSummands.entrySet()) {
            Term convTerm = factor.getKey();
            if (!convTerm.getSort().equals(sort)) {
                convTerm = t.term("to_real", convTerm);
            }
            if (!factor.getValue().equals(Rational.ONE)) {
                Term convfac = factor.getValue().toTerm(sort);
                convTerm = t.term("*", convfac, convTerm);
            }
            sum[i++] = convTerm;
        }
        if (i < size) {
            sum[i++] = this.mConstant.toTerm(sort);
        }
        return size == 1 ? sum[0] : t.term("+", sum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (Map.Entry<Term, Rational> entry : this.mSummands.entrySet()) {
            sb.append(comma);
            String key = entry.getKey().toString();
            if (entry.getValue() == Rational.ONE) {
                sb.append(key);
            } else if (entry.getValue() == Rational.MONE) {
                sb.append("-").append(key);
            } else {
                sb.append(entry.getValue()).append(" * ").append(key);
            }
            comma = " + ";
        }
        if (this.mSummands.isEmpty() || this.mConstant != Rational.ZERO) {
            sb.append(comma).append(this.mConstant);
        }
        return sb.toString();
    }

    public boolean isAllIntSummands() {
        for (Map.Entry<Term, Rational> me : this.mSummands.entrySet()) {
            if (me.getKey().getSort().getName().equals("Int")) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SMTAffineTerm)) {
            return false;
        }
        SMTAffineTerm o = (SMTAffineTerm)other;
        return this.mSummands.equals(o.mSummands) && this.mConstant.equals(o.mConstant);
    }

    public int hashCode() {
        return HashUtils.hashJenkins(this.mConstant.hashCode(), this.mSummands);
    }
}

