/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.LogicSimplifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TermCompiler
extends TermTransformer {
    private Map<Term, Set<String>> mNames;
    UnifyHash<ApplicationTerm> mCanonicalSums = new UnifyHash();
    private IProofTracker mTracker;
    private LogicSimplifier mUtils;

    public void setProofTracker(IProofTracker tracker) {
        this.mTracker = tracker;
        this.mUtils = new LogicSimplifier(tracker);
    }

    public void setAssignmentProduction(boolean on) {
        this.mNames = on ? new HashMap<Term, Set<String>>() : null;
    }

    public Map<Term, Set<String>> getNames() {
        return this.mNames;
    }

    @Override
    public void convert(Term term) {
        if (term.getSort().isInternal()) {
            switch (term.getSort().getName()) {
                case "Bool": 
                case "Int": 
                case "Real": 
                case "Array": {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported internal sort: " + term.getSort());
                }
            }
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol fsym = appTerm.getFunction();
            Term[] params = appTerm.getParameters();
            if (fsym.isLeftAssoc() && params.length > 2) {
                Theory theory = appTerm.getTheory();
                String fsymName = fsym.getName();
                if (fsymName == "and" || fsymName == "or" || fsymName == "+" || fsymName == "-" || fsymName == "*") {
                    this.enqueueWalker(new TermTransformer.BuildApplicationTerm(appTerm));
                    this.pushTerms(params);
                    return;
                }
                Term rhs = params[0];
                for (int i = 1; i < params.length; ++i) {
                    rhs = theory.term(fsym, rhs, params[i]);
                }
                Term rewrite = this.mTracker.buildRewrite(appTerm, rhs, ProofConstants.RW_EXPAND);
                this.enqueueWalker(new TransitivityStep(rewrite));
                for (int i = params.length - 1; i > 0; --i) {
                    ApplicationTerm binAppTerm = (ApplicationTerm)rhs;
                    this.enqueueWalker(new TermTransformer.BuildApplicationTerm(binAppTerm));
                    this.pushTerm(binAppTerm.getParameters()[1]);
                    rhs = binAppTerm.getParameters()[0];
                }
                this.pushTerm(params[0]);
                return;
            }
            if (fsym.isRightAssoc() && params.length > 2) {
                Theory theory = appTerm.getTheory();
                if (fsym == theory.mImplies) {
                    this.enqueueWalker(new TermTransformer.BuildApplicationTerm(appTerm));
                    this.pushTerms(params);
                    return;
                }
                Term rhs = params[params.length - 1];
                for (int i = params.length - 2; i >= 0; --i) {
                    rhs = theory.term(fsym, params[i], rhs);
                }
                Term rewrite = this.mTracker.buildRewrite(appTerm, rhs, ProofConstants.RW_EXPAND);
                this.enqueueWalker(new TransitivityStep(rewrite));
                for (int i = params.length - 1; i > 0; --i) {
                    ApplicationTerm binAppTerm = (ApplicationTerm)rhs;
                    this.enqueueWalker(new TermTransformer.BuildApplicationTerm(binAppTerm));
                    rhs = binAppTerm.getParameters()[1];
                }
                this.pushTerms(params);
                return;
            }
            if (fsym.isChainable() && params.length > 2 && !fsym.getName().equals("=")) {
                Theory theory = appTerm.getTheory();
                Term[] conjs = new Term[params.length - 1];
                for (int i = 0; i < params.length - 1; ++i) {
                    conjs[i] = theory.term(fsym, params[i], params[i + 1]);
                }
                Term rhs = theory.term("and", conjs);
                Term rewrite = this.mTracker.buildRewrite(appTerm, rhs, ProofConstants.RW_EXPAND);
                this.enqueueWalker(new TransitivityStep(rewrite));
                this.enqueueWalker(new TermTransformer.BuildApplicationTerm((ApplicationTerm)rhs));
                this.pushTerms(conjs);
                return;
            }
        } else {
            if (term instanceof ConstantTerm && term.getSort().isNumericSort()) {
                Term res = SMTAffineTerm.convertConstant((ConstantTerm)term).toTerm(term.getSort());
                this.setResult(this.mTracker.buildRewrite(term, res, ProofConstants.RW_CANONICAL_SUM));
                return;
            }
            if (term instanceof TermVariable) {
                this.setResult(this.mTracker.reflexivity(term));
                return;
            }
        }
        super.convert(term);
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] args) {
        FunctionSymbol fsym = appTerm.getFunction();
        Theory theory = appTerm.getTheory();
        Term convertedApp = this.mTracker.congruence(this.mTracker.reflexivity(appTerm), args);
        if (this.mTracker.getProvedTerm(convertedApp) instanceof ConstantTerm) {
            this.setResult(convertedApp);
            return;
        }
        Term[] params = ((ApplicationTerm)this.mTracker.getProvedTerm(convertedApp)).getParameters();
        if (fsym.getDefinition() != null && !fsym.getName().startsWith("@skolem.") && !fsym.getName().startsWith("@AUX")) {
            HashMap<TermVariable, Term> substs = new HashMap<TermVariable, Term>();
            for (int i = 0; i < params.length; ++i) {
                substs.put(fsym.getDefinitionVars()[i], params[i]);
            }
            FormulaUnLet unletter = new FormulaUnLet();
            unletter.addSubstitutions(substs);
            Term expanded = unletter.unlet(fsym.getDefinition());
            Term expandedProof = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(convertedApp), expanded, ProofConstants.RW_EXPAND_DEF);
            this.enqueueWalker(new TransitivityStep(this.mTracker.transitivity(convertedApp, expandedProof)));
            this.pushTerm(expanded);
            return;
        }
        if (fsym.isIntern()) {
            switch (fsym.getName()) {
                case "not": {
                    this.setResult(this.mUtils.convertNot(convertedApp));
                    return;
                }
                case "and": {
                    this.setResult(this.mUtils.convertAnd(convertedApp));
                    return;
                }
                case "or": {
                    this.setResult(this.mUtils.convertOr(convertedApp));
                    return;
                }
                case "xor": {
                    this.setResult(this.mUtils.convertXor(convertedApp));
                    return;
                }
                case "=>": {
                    this.setResult(this.mUtils.convertImplies(convertedApp));
                    return;
                }
                case "ite": {
                    this.setResult(this.mUtils.convertIte(convertedApp));
                    return;
                }
                case "=": {
                    this.setResult(this.mUtils.convertEq(convertedApp));
                    return;
                }
                case "distinct": {
                    this.setResult(this.mUtils.convertDistinct(convertedApp));
                    return;
                }
                case "<=": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Sort sort = params[0].getSort();
                    SMTAffineTerm affine1 = new SMTAffineTerm(params[0]);
                    SMTAffineTerm affine2 = new SMTAffineTerm(params[1]);
                    affine2.negate();
                    affine1.add(affine2);
                    Term rhs = theory.term("<=", affine1.toTerm(this, sort), Rational.ZERO.toTerm(sort));
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_LEQ_TO_LEQ0);
                    this.setResult(this.mUtils.convertLeq0(this.mTracker.transitivity(convertedApp, rewrite)));
                    return;
                }
                case ">=": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Sort sort = params[0].getSort();
                    SMTAffineTerm affine1 = new SMTAffineTerm(params[1]);
                    SMTAffineTerm affine2 = new SMTAffineTerm(params[0]);
                    affine2.negate();
                    affine1.add(affine2);
                    Term rhs = theory.term("<=", affine1.toTerm(this, sort), Rational.ZERO.toTerm(sort));
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_GEQ_TO_LEQ0);
                    this.setResult(this.mUtils.convertLeq0(this.mTracker.transitivity(convertedApp, rewrite)));
                    return;
                }
                case ">": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Sort sort = params[0].getSort();
                    SMTAffineTerm affine1 = new SMTAffineTerm(params[0]);
                    SMTAffineTerm affine2 = new SMTAffineTerm(params[1]);
                    affine2.negate();
                    affine1.add(affine2);
                    Term leq = theory.term("<=", affine1.toTerm(this, sort), Rational.ZERO.toTerm(sort));
                    Term rhs = theory.term("not", leq);
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_GT_TO_LEQ0);
                    Term leqRewrite = this.mUtils.convertLeq0(this.mTracker.reflexivity(leq));
                    rewrite = this.mTracker.congruence(this.mTracker.transitivity(convertedApp, rewrite), new Term[]{leqRewrite});
                    this.setResult(this.mUtils.convertNot(rewrite));
                    return;
                }
                case "<": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Sort sort = params[0].getSort();
                    SMTAffineTerm affine1 = new SMTAffineTerm(params[1]);
                    SMTAffineTerm affine2 = new SMTAffineTerm(params[0]);
                    affine2.negate();
                    affine1.add(affine2);
                    Term leq = theory.term("<=", affine1.toTerm(this, sort), Rational.ZERO.toTerm(sort));
                    Term rhs = theory.term("not", leq);
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_LT_TO_LEQ0);
                    Term leqRewrite = this.mUtils.convertLeq0(this.mTracker.reflexivity(leq));
                    rewrite = this.mTracker.congruence(this.mTracker.transitivity(convertedApp, rewrite), new Term[]{leqRewrite});
                    this.setResult(this.mUtils.convertNot(rewrite));
                    return;
                }
                case "+": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    SMTAffineTerm sum = new SMTAffineTerm(params[0]);
                    for (int i = 1; i < params.length; ++i) {
                        sum.add(new SMTAffineTerm(params[i]));
                    }
                    Term rhs = sum.toTerm(this, convertedApp.getSort());
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                    return;
                }
                case "-": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    SMTAffineTerm result = new SMTAffineTerm(params[0]);
                    if (params.length == 1) {
                        result.negate();
                    } else {
                        for (int i = 1; i < params.length; ++i) {
                            SMTAffineTerm subtrahend = new SMTAffineTerm(params[i]);
                            subtrahend.negate();
                            result.add(subtrahend);
                        }
                    }
                    Term rhs = result.toTerm(this, convertedApp.getSort());
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                    return;
                }
                case "*": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    SMTAffineTerm prod = new SMTAffineTerm(params[0]);
                    for (int i = 1; i < params.length; ++i) {
                        SMTAffineTerm factor = new SMTAffineTerm(params[i]);
                        if (prod.isConstant()) {
                            factor.mul(prod.getConstant());
                            prod = factor;
                            continue;
                        }
                        if (factor.isConstant()) {
                            prod.mul(factor.getConstant());
                            continue;
                        }
                        throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
                    }
                    Term rhs = prod.toTerm(this, convertedApp.getSort());
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                    return;
                }
                case "/": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    SMTAffineTerm arg0 = new SMTAffineTerm(params[0]);
                    if (params[1] instanceof ConstantTerm) {
                        Rational arg1 = SMTAffineTerm.convertConstant((ConstantTerm)params[1]);
                        if (arg1.equals(Rational.ZERO)) {
                            this.setResult(convertedApp);
                        } else {
                            arg0.mul(arg1.inverse());
                            Term rhs = arg0.toTerm(this, convertedApp.getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_CANONICAL_SUM);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        }
                        return;
                    }
                    throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
                }
                case "div": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    SMTAffineTerm arg0 = new SMTAffineTerm(params[0]);
                    if (params[1] instanceof ConstantTerm) {
                        Rational divisor = (Rational)((ConstantTerm)params[1]).getValue();
                        assert (divisor.isIntegral());
                        if (divisor.equals(Rational.ONE)) {
                            Term rhs = arg0.toTerm(this, convertedApp.getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_DIV_ONE);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        } else if (divisor.equals(Rational.MONE)) {
                            arg0.negate();
                            Term rhs = arg0.toTerm(this, convertedApp.getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_DIV_MONE);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        } else if (arg0.isConstant() && !divisor.equals(Rational.ZERO)) {
                            Rational div = TermCompiler.constDiv(arg0.getConstant(), divisor);
                            Term rhs = div.toTerm(convertedApp.getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_DIV_CONST);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        } else {
                            this.setResult(convertedApp);
                        }
                        return;
                    }
                    throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
                }
                case "mod": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    SMTAffineTerm arg0 = new SMTAffineTerm(params[0]);
                    if (params[1] instanceof ConstantTerm) {
                        Rational divisor = (Rational)((ConstantTerm)params[1]).getValue();
                        assert (divisor.isIntegral());
                        if (divisor.equals(Rational.ZERO)) {
                            this.setResult(convertedApp);
                        } else if (divisor.equals(Rational.ONE)) {
                            Term rhs = Rational.ZERO.toTerm(convertedApp.getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_MODULO_ONE);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        } else if (divisor.equals(Rational.MONE)) {
                            Term rhs = Rational.ZERO.toTerm(convertedApp.getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_MODULO_MONE);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        } else if (arg0.isConstant()) {
                            Rational c0 = arg0.getConstant();
                            Rational mod = c0.sub(TermCompiler.constDiv(c0, divisor).mul(divisor));
                            Term rhs = mod.toTerm(convertedApp.getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_MODULO_CONST);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        } else {
                            Term div = theory.term("div", params[0], params[1]);
                            arg0.add(divisor.negate(), div);
                            Term rhs = arg0.toTerm(this, params[1].getSort());
                            Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_MODULO);
                            this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                        }
                        return;
                    }
                    throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
                }
                case "to_real": {
                    SMTAffineTerm arg = new SMTAffineTerm(params[0]);
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Term rhs = arg.toTerm(this, convertedApp.getSort());
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                    return;
                }
                case "to_int": {
                    if (!(params[0] instanceof ConstantTerm)) break;
                    Rational value = (Rational)((ConstantTerm)params[0]).getValue();
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Term rhs = value.floor().toTerm(fsym.getReturnSort());
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_TO_INT);
                    this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                    return;
                }
                case "divisible": {
                    Term rhs;
                    BigInteger divisor1;
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    try {
                        divisor1 = new BigInteger(fsym.getIndices()[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new SMTLIBException("index must be numeral", e);
                    }
                    Rational divisor = Rational.valueOf(divisor1, BigInteger.ONE);
                    if (divisor.equals(Rational.ONE)) {
                        rhs = theory.mTrue;
                    } else if (params[0] instanceof ConstantTerm) {
                        Rational value = (Rational)((ConstantTerm)params[0]).getValue();
                        rhs = value.equals(divisor.mul(TermCompiler.constDiv(value, divisor))) ? theory.mTrue : theory.mFalse;
                    } else {
                        Term divisorTerm = divisor.toTerm(params[0].getSort());
                        rhs = theory.term("=", params[0], theory.term("*", divisorTerm, theory.term("div", params[0], divisorTerm)));
                    }
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_DIVISIBLE);
                    this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                    return;
                }
                case "store": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Term array = params[0];
                    Term idx = params[1];
                    Term nestedIdx = TermCompiler.getArrayStoreIdx(array);
                    if (nestedIdx == null) break;
                    SMTAffineTerm diff = new SMTAffineTerm(idx);
                    diff.negate();
                    diff.add(new SMTAffineTerm(nestedIdx));
                    if (!diff.isConstant() || !diff.getConstant().equals(Rational.ZERO)) break;
                    ApplicationTerm appArray = (ApplicationTerm)array;
                    Term rhs = theory.term("store", appArray.getParameters()[0], params[1], params[2]);
                    Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_STORE_OVER_STORE);
                    this.setResult(this.mTracker.transitivity(convertedApp, rewrite));
                    return;
                }
                case "select": {
                    Term lhs = this.mTracker.getProvedTerm(convertedApp);
                    Term array = params[0];
                    Term idx = params[1];
                    boolean isSelect = true;
                    while (isSelect) {
                        Term rhs;
                        isSelect = false;
                        Term nestedIdx = TermCompiler.getArrayStoreIdx(array);
                        if (nestedIdx == null) continue;
                        SMTAffineTerm diff = new SMTAffineTerm(idx);
                        diff.negate();
                        diff.add(new SMTAffineTerm(nestedIdx));
                        if (!diff.isConstant()) continue;
                        ApplicationTerm store = (ApplicationTerm)array;
                        if (diff.getConstant().equals(Rational.ZERO)) {
                            rhs = store.getParameters()[2];
                        } else {
                            isSelect = true;
                            array = store.getParameters()[0];
                            rhs = theory.term("select", array, idx);
                        }
                        Term rewrite = this.mTracker.buildRewrite(lhs, rhs, ProofConstants.RW_SELECT_OVER_STORE);
                        lhs = rhs;
                        convertedApp = this.mTracker.transitivity(convertedApp, rewrite);
                    }
                    break;
                }
                case "const": {
                    Sort sort = this.mTracker.getProvedTerm(convertedApp).getSort();
                    assert (sort.isArraySort());
                    if (this.isInfinite(sort.getArguments()[0])) break;
                    throw new SMTLIBException("Const is only supported for infinite index sort");
                }
                case "true": 
                case "false": 
                case "@diff": 
                case "@0": 
                case "is": 
                case "@EQ": {
                    break;
                }
                default: {
                    if (fsym.isConstructor() || fsym.isSelector() || fsym.getName().startsWith("@AUX") || fsym.getName().matches("@.*skolem.*")) break;
                    throw new UnsupportedOperationException("Unsupported internal function " + fsym.getName());
                }
            }
        }
        this.setResult(convertedApp);
    }

    private boolean isInfinite(Sort sort) {
        if (sort.isInternal()) {
            switch (sort.getName()) {
                case "Int": 
                case "Real": {
                    return true;
                }
                case "Array": {
                    Sort[] args = sort.getArguments();
                    Sort indexSort = args[0];
                    Sort elemSort = args[1];
                    return elemSort.isInternal() && this.isInfinite(indexSort);
                }
            }
            return false;
        }
        return false;
    }

    public static final Rational constDiv(Rational c0, Rational c1) {
        Rational div = c0.div(c1);
        return c1.isNegative() ? div.ceil() : div.floor();
    }

    private static final Term getArrayStoreIdx(Term array) {
        ApplicationTerm appArray;
        FunctionSymbol arrayFunc;
        if (array instanceof ApplicationTerm && (arrayFunc = (appArray = (ApplicationTerm)array).getFunction()).isIntern() && arrayFunc.getName().equals("store")) {
            return appArray.getParameters()[1];
        }
        return null;
    }

    @Override
    public void postConvertMatch(MatchTerm oldMatch, Term newDataTerm, Term[] newCases) {
        this.setResult(this.mTracker.match(oldMatch, newDataTerm, newCases));
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        Theory theory = old.getTheory();
        if (!theory.getLogic().isQuantified()) {
            throw new SMTLIBException("Quantifier in quantifier-free logic");
        }
        this.setResult(this.mTracker.quantCong(old, newBody));
    }

    @Override
    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        if (this.mNames != null && newBody.getSort() == newBody.getTheory().getBooleanSort()) {
            Annotation[] oldAnnots;
            for (Annotation annot : oldAnnots = old.getAnnotations()) {
                if (!annot.getKey().equals(":named")) continue;
                Set<String> oldNames = this.mNames.get(newBody);
                if (oldNames == null) {
                    oldNames = new HashSet<String>();
                    this.mNames.put(newBody, oldNames);
                }
                oldNames.add(annot.getValue().toString());
            }
        }
        this.setResult(this.mTracker.transitivity(this.mTracker.buildRewrite(old, old.getSubterm(), ProofConstants.RW_STRIP), newBody));
    }

    public ApplicationTerm unifySummation(ApplicationTerm sumTerm) {
        assert (sumTerm.getFunction().getName() == "+");
        HashSet<Term> summands = new HashSet<Term>(Arrays.asList(sumTerm.getParameters()));
        assert (summands.size() == sumTerm.getParameters().length);
        int hash = summands.hashCode();
        for (ApplicationTerm canonic : this.mCanonicalSums.iterateHashCode(hash)) {
            if (canonic.getParameters().length != summands.size() || !summands.containsAll(Arrays.asList(canonic.getParameters()))) continue;
            return canonic;
        }
        this.mCanonicalSums.put(hash, sumTerm);
        return sumTerm;
    }

    static class TransitivityStep
    implements NonRecursive.Walker {
        final Term mFirst;

        public TransitivityStep(Term first) {
            this.mFirst = first;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermCompiler compiler = (TermCompiler)engine;
            Term second = compiler.getConverted();
            compiler.setResult(compiler.mTracker.transitivity(this.mFirst, second));
        }
    }
}

