/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.Arrays;

public class Clause
extends SimpleListable<Clause> {
    Literal[] mLiterals;
    Clause mNextFirstWatch;
    Clause mNextSecondWatch;
    int mNextIsSecond;
    double mActivity;
    final int mStacklevel;
    ProofNode mProof;
    ClauseDeletionHook mCleanupHook;

    public int getSize() {
        return this.mLiterals.length;
    }

    public Literal getLiteral(int i) {
        return this.mLiterals[i];
    }

    public Clause(Literal[] literals) {
        this.mLiterals = literals;
        this.mStacklevel = this.computeStackLevel();
    }

    public Clause(Literal[] literals, ProofNode proof) {
        this.mLiterals = literals;
        this.mProof = proof;
        this.mStacklevel = this.computeStackLevel();
    }

    public Clause(Literal[] literals, int stacklevel) {
        this.mLiterals = literals;
        this.mStacklevel = Math.max(stacklevel, this.computeStackLevel());
    }

    public Clause(Literal[] literals, ResolutionNode proof, int stacklevel) {
        this.mLiterals = literals;
        this.mProof = proof;
        this.mStacklevel = Math.max(stacklevel, this.computeStackLevel());
    }

    private final int computeStackLevel() {
        int sl = 0;
        for (Literal lit : this.mLiterals) {
            if (lit.getAtom().mAssertionstacklevel <= sl) continue;
            sl = lit.getAtom().mAssertionstacklevel;
        }
        return sl;
    }

    public String toString() {
        return Arrays.toString(this.mLiterals);
    }

    public void setActivityInfinite() {
        this.mActivity = Double.POSITIVE_INFINITY;
    }

    public void setProof(ProofNode proof) {
        this.mProof = proof;
    }

    public ProofNode getProof() {
        return this.mProof;
    }

    public void setDeletionHook(ClauseDeletionHook hook) {
        this.mCleanupHook = hook;
    }

    public boolean doCleanup(DPLLEngine engine) {
        return this.mCleanupHook == null ? true : this.mCleanupHook.clauseDeleted(this, engine);
    }

    public boolean contains(Literal lit) {
        for (Literal l : this.mLiterals) {
            if (l != lit) continue;
            return true;
        }
        return false;
    }

    public Term toTerm(Theory theory) {
        if (this.mLiterals.length == 0) {
            return theory.mFalse;
        }
        if (this.mLiterals.length == 1) {
            return this.mLiterals[0].getSMTFormula(theory);
        }
        Term[] args = new Term[this.mLiterals.length];
        for (int i = 0; i < this.mLiterals.length; ++i) {
            args[i] = this.mLiterals[i].getSMTFormula(theory);
        }
        return theory.term("or", args);
    }

    public Term[] toTermArray(Theory theory) {
        Term[] literals = new Term[this.mLiterals.length];
        for (int i = 0; i < this.mLiterals.length; ++i) {
            literals[i] = this.mLiterals[i].getSMTFormula(theory);
        }
        return literals;
    }

    public ProofLiteral[] toProofLiterals(ProofRules proofRules) {
        ProofLiteral[] proofLits = new ProofLiteral[this.mLiterals.length];
        for (int i = 0; i < proofLits.length; ++i) {
            Literal lit = this.mLiterals[i];
            proofLits[i] = new ProofLiteral(lit.getAtom().getSMTFormula(proofRules.getTheory()), lit == lit.getAtom());
        }
        return proofLits;
    }

    static final class WatchList {
        Clause mHead = null;
        int mHeadIndex;
        Clause mTail = null;
        int mTailIndex;
        int mSize;

        public boolean isEmpty() {
            return this.mHead == null;
        }

        public int size() {
            return this.mSize;
        }

        public void prepend(Clause c, int index) {
            if (this.mHead == null) {
                this.mTail = c;
                this.mTailIndex = index;
            } else if (index == 0) {
                assert (c.mNextFirstWatch == null);
                c.mNextFirstWatch = this.mHead;
                c.mNextIsSecond |= this.mHeadIndex;
            } else {
                assert (c.mNextSecondWatch == null);
                c.mNextSecondWatch = this.mHead;
                c.mNextIsSecond |= this.mHeadIndex << 1;
            }
            this.mHead = c;
            this.mHeadIndex = index;
            ++this.mSize;
        }

        public void append(Clause c, int index) {
            if (this.mHead == null) {
                this.mHead = c;
                this.mHeadIndex = index;
            } else {
                Clause t = this.mTail;
                if (this.mTailIndex == 0) {
                    assert (t.mNextFirstWatch == null);
                    t.mNextFirstWatch = c;
                    t.mNextIsSecond |= index;
                } else {
                    assert (t.mNextSecondWatch == null);
                    t.mNextSecondWatch = c;
                    t.mNextIsSecond |= index << 1;
                }
            }
            this.mTail = c;
            this.mTailIndex = index;
            ++this.mSize;
        }

        public int getIndex() {
            return this.mHeadIndex;
        }

        public Clause removeFirst() {
            Clause c = this.mHead;
            if (this.mHeadIndex == 0) {
                this.mHead = c.mNextFirstWatch;
                this.mHeadIndex = c.mNextIsSecond & 1;
                c.mNextFirstWatch = null;
                c.mNextIsSecond &= 2;
            } else {
                this.mHead = c.mNextSecondWatch;
                this.mHeadIndex = (c.mNextIsSecond & 2) >> 1;
                c.mNextSecondWatch = null;
                c.mNextIsSecond &= 1;
            }
            if (this.mHead == null) {
                this.mTail = null;
                this.mTailIndex = 0;
            }
            --this.mSize;
            return c;
        }

        public void moveAll(WatchList src) {
            if (src.mHead == null) {
                return;
            }
            this.append(src.mHead, src.mHeadIndex);
            this.mSize += src.mSize - 1;
            this.mTail = src.mTail;
            this.mTailIndex = src.mTailIndex;
            src.mHead = null;
            src.mHeadIndex = 0;
            src.mTail = null;
            src.mTailIndex = 0;
            src.mSize = 0;
        }
    }
}

