/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;

public abstract class DPLLAtom
extends Literal {
    int mDecideLevel = -1;
    int mStackPosition = -1;
    Literal mDecideStatus;
    Literal mLastStatus;
    double mActivity;
    public Object mExplanation;
    Clause.WatchList mBacktrackWatchers = new Clause.WatchList();
    int mAtomQueueIndex = -1;
    final int mAssertionstacklevel;
    boolean mPreferredStatusIsLocked;

    public DPLLAtom(int hash, int assertionstacklevel) {
        super(hash);
        this.mAtom = this;
        this.mNegated = new NegLiteral(this);
        this.mAssertionstacklevel = assertionstacklevel;
        this.mLastStatus = this.mNegated;
        this.mPreferredStatusIsLocked = false;
    }

    public final int compareActivityTo(DPLLAtom other) {
        return this.mActivity < other.mActivity ? 1 : (this.mActivity == other.mActivity ? 0 : -1);
    }

    @Override
    public int getSign() {
        return 1;
    }

    public final int getDecideLevel() {
        return this.mDecideLevel;
    }

    public final int getStackPosition() {
        return this.mStackPosition;
    }

    public String toStringNegated() {
        return "!(" + this.toString() + ")";
    }

    public final Term getNegatedSMTFormula(Theory smtTheory) {
        return smtTheory.not(this.getSMTFormula(smtTheory));
    }

    public Literal getDecideStatus() {
        return this.mDecideStatus;
    }

    public int getAssertionStackLevel() {
        return this.mAssertionstacklevel;
    }

    public boolean preferredStatusIsLocked() {
        return this.mPreferredStatusIsLocked;
    }

    public void lockPreferredStatus() {
        this.mPreferredStatusIsLocked = true;
    }

    public void unlockPreferredStatus() {
        this.mPreferredStatusIsLocked = false;
    }

    public void setPreferredStatus(Literal status) {
        if (this.mPreferredStatusIsLocked) {
            throw new SMTLIBException("PreferredStatus must not be changed, since it is locked!");
        }
        this.mLastStatus = status;
    }

    public Literal getPreferredStatus() {
        return this.mLastStatus;
    }

    public static class NegLiteral
    extends Literal {
        public NegLiteral(DPLLAtom atom) {
            super(~atom.hashCode());
            this.mAtom = atom;
            this.mNegated = atom;
        }

        @Override
        public int getSign() {
            return -1;
        }

        @Override
        public String toString() {
            return this.mAtom.toStringNegated();
        }

        @Override
        public Term getSMTFormula(Theory smtTheory) {
            return this.mAtom.getNegatedSMTFormula(smtTheory);
        }
    }

    public static class TrueAtom
    extends DPLLAtom {
        public TrueAtom() {
            super(0, 0);
            this.mDecideStatus = this;
            this.mDecideLevel = 0;
        }

        @Override
        public Term getSMTFormula(Theory smtTheory) {
            return smtTheory.mTrue;
        }
    }
}

