/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.AtomQueue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.CuckooHashSet;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class DPLLEngine {
    private final LogProxy mLogger;
    public static final int COMPLETE = 0;
    public static final int INCOMPLETE_QUANTIFIER = 1;
    public static final int INCOMPLETE_THEORY = 2;
    public static final int INCOMPLETE_MEMOUT = 3;
    public static final int INCOMPLETE_UNKNOWN = 4;
    public static final int INCOMPLETE_TIMEOUT = 5;
    public static final int INCOMPLETE_CHECK = 6;
    public static final int INCOMPLETE_CANCELLED = 7;
    private static final String[] COMPLETENESS_STRINGS = new String[]{"Complete", "Quantifier in Assertion Stack", "Theories with incomplete decision procedure used", "Not enough memory", "Unknown internal error", "Sat check timed out", "Incomplete check used", "User requested cancellation"};
    private int mCompleteness = 0;
    private int mPushPopLevel = 0;
    private final ScopedArrayList<DPLLAtom> mAtomList;
    private final SimpleList<Clause> mClauses = new SimpleList();
    private Clause mUnsatClause = null;
    private final Set<Literal> mAssumptionLiterals = new LinkedHashSet<Literal>();
    private int mConflicts;
    private int mDecides;
    private int mTProps;
    private int mProps;
    private int mNumSolvedAtoms;
    private int mNumClauses;
    private int mNumAxiomClauses;
    SimpleList<Clause> mLearnedClauses = new SimpleList();
    private long mPropTime;
    private long mPropClauseTime;
    private long mExplainTime;
    private long mSetTime;
    private long mCheckTime;
    private long mBacktrackTime;
    private int mNumRandomSplits;
    private boolean mHasModel;
    double mAtomScale = 0.09090909090909094;
    double mClsScale = 0.00990099009900991;
    Clause.WatchList mPendingWatcherList = new Clause.WatchList();
    ArrayList<Literal> mDPLLStack = new ArrayList();
    private ITheory[] mTheories = new ITheory[0];
    private final AtomQueue mAtoms = new AtomQueue();
    private int mCurrentDecideLevel = 0;
    private int mBaseLevel = 0;
    private boolean mPGenabled = false;
    private ScopedHashMap<String, Literal> mAssignments;
    private final Random mRandom;
    private final TerminationRequest mCancel;

    public DPLLEngine(LogProxy logger, TerminationRequest cancel) {
        assert (logger != null);
        this.mLogger = logger;
        this.mAtomList = new ScopedArrayList();
        this.mRandom = new Random();
        this.mCancel = cancel;
    }

    public int getDecideLevel() {
        return this.mCurrentDecideLevel;
    }

    public void insertPropagatedLiteral(ITheory t, Literal lit, int decideLevel) {
        DPLLAtom atom;
        assert (lit.getAtom().mDecideStatus == null);
        assert (!this.mDPLLStack.contains(lit));
        assert (!this.mDPLLStack.contains(lit.negate()));
        assert (t != null) : "Decision in propagation!!!";
        assert (this.checkDecideLevel());
        int stackptr = this.mDPLLStack.size();
        int level = this.mCurrentDecideLevel;
        while (level > decideLevel) {
            atom = this.mDPLLStack.get(--stackptr).getAtom();
            if (atom.mExplanation == null) {
                --level;
            }
            ++atom.mStackPosition;
        }
        this.mDPLLStack.add(stackptr, lit);
        atom = lit.getAtom();
        this.mAtomList.add(atom);
        assert (!this.mAtoms.contains(atom));
        atom.mDecideLevel = decideLevel;
        atom.mStackPosition = stackptr;
        atom.mLastStatus = atom.mDecideStatus = lit;
        atom.mExplanation = t;
        if (decideLevel <= this.mBaseLevel) {
            ++this.mNumSolvedAtoms;
            this.generateLevel0Proof(lit);
        }
        assert (this.checkDecideLevel());
    }

    public void insertPropagatedLiteralBefore(ITheory t, Literal lit, Literal beforeLit) {
        DPLLAtom beforeAtom = beforeLit.getAtom();
        assert (this.mDPLLStack.get(beforeAtom.getStackPosition()).getAtom() == beforeAtom);
        assert (beforeAtom.mDecideStatus != null);
        assert (beforeAtom.getStackPosition() >= 0);
        assert (lit.getAtom().mDecideStatus == null);
        assert (!this.mDPLLStack.contains(lit));
        assert (!this.mDPLLStack.contains(lit.negate()));
        assert (t != null) : "Decision in propagation!!!";
        assert (this.checkDecideLevel());
        int stackptr = beforeAtom.getStackPosition();
        int level = beforeAtom.getDecideLevel();
        if (beforeAtom.mExplanation == null) {
            --level;
        }
        this.mDPLLStack.add(stackptr, lit);
        for (int i = stackptr + 1; i < this.mDPLLStack.size(); ++i) {
            assert (this.mDPLLStack.get(i).getAtom().getStackPosition() == i - 1);
            this.mDPLLStack.get((int)i).getAtom().mStackPosition = i;
        }
        DPLLAtom atom = lit.getAtom();
        this.mAtomList.add(atom);
        assert (!this.mAtoms.contains(atom));
        atom.mDecideLevel = level;
        atom.mStackPosition = stackptr;
        atom.mLastStatus = atom.mDecideStatus = lit;
        atom.mExplanation = t;
        if (level <= this.mBaseLevel) {
            ++this.mNumSolvedAtoms;
            this.generateLevel0Proof(lit);
        }
        assert (this.checkDecideLevel());
    }

    private Clause propagateInternal() {
        while (true) {
            Clause conflict;
            if ((conflict = this.propagateTheories()) != null) {
                return conflict;
            }
            int level = this.mDPLLStack.size();
            int numAtoms = this.mAtoms.size();
            conflict = this.propagateClauses();
            if (conflict != null) {
                return conflict;
            }
            if (this.mDPLLStack.size() > level) continue;
            long time = 0L;
            time = System.nanoTime();
            this.mLogger.debug("DPLL: checkpoint");
            for (ITheory t : this.mTheories) {
                conflict = t.checkpoint();
                if (conflict == null) continue;
                return conflict;
            }
            this.mCheckTime += System.nanoTime() - time;
            conflict = this.propagateTheories();
            if (conflict != null) {
                return conflict;
            }
            if (this.mDPLLStack.size() == level && this.mAtoms.size() == numAtoms) break;
        }
        return null;
    }

    private Clause propagateTheories() {
        boolean changed;
        do {
            changed = false;
            this.mLogger.debug("DPLL: propagate theories");
            for (ITheory t : this.mTheories) {
                Literal propLit = t.getPropagatedLiteral();
                if (propLit == null) continue;
                do {
                    Clause conflict;
                    if (propLit.mAtom.mDecideStatus == null) {
                        ++this.mTProps;
                        if (propLit.mAtom.mExplanation == null) {
                            propLit.mAtom.mExplanation = t;
                        }
                        if ((conflict = this.setLiteral(propLit)) == null) continue;
                        for (Literal lit : conflict.mLiterals) {
                            DPLLAtom atom = lit.getAtom();
                            assert (atom.mDecideStatus == lit.negate());
                        }
                        return conflict;
                    }
                    if (propLit.mAtom.mDecideStatus == propLit) continue;
                    conflict = t.getUnitClause(propLit);
                    return conflict;
                } while ((propLit = t.getPropagatedLiteral()) != null);
                changed = true;
            }
        } while (changed);
        return null;
    }

    private Clause propagateClauses() {
        long time = 0L;
        time = System.nanoTime() - this.mSetTime;
        block0: while (!this.mPendingWatcherList.isEmpty()) {
            int index = this.mPendingWatcherList.getIndex();
            Clause clause = this.mPendingWatcherList.removeFirst();
            if (clause.mNext == null) continue;
            Literal[] lits = clause.mLiterals;
            if (index < lits.length) {
                Literal myLit = lits[index];
                if (myLit.getAtom().getDecideStatus() != myLit.negate()) {
                    myLit.mWatchers.append(clause, index);
                    continue;
                }
            } else assert (index == 1 && lits.length == 1);
            Literal otherLit = lits[1 - index];
            DPLLAtom otherAtom = otherLit.getAtom();
            if (otherAtom.mDecideStatus == otherLit) {
                otherAtom.mBacktrackWatchers.append(clause, index);
                continue;
            }
            for (int i = 2; i < lits.length; ++i) {
                Literal lit = lits[i];
                DPLLAtom atom = lit.getAtom();
                Literal status = atom.mDecideStatus;
                if (status == lit.negate()) continue;
                if (clause.mActivity < this.mClsScale * 1.0E-150 && status == null && clause.doCleanup(this)) {
                    clause.removeFromList();
                    continue block0;
                }
                for (int j = i; j > 2; --j) {
                    lits[j] = lits[j - 1];
                }
                lits[2] = lits[index];
                lits[index] = lit;
                lit.mWatchers.append(clause, index);
                continue block0;
            }
            if (otherAtom.mDecideStatus == null) {
                otherAtom.mBacktrackWatchers.append(clause, index);
                otherAtom.mExplanation = clause;
                ++this.mProps;
                clause = this.setLiteral(otherLit);
            } else {
                this.mPendingWatcherList.append(clause, index);
            }
            this.mPropClauseTime += System.nanoTime() - time - this.mSetTime;
            return clause;
        }
        this.mPropClauseTime += System.nanoTime() - time - this.mSetTime;
        return null;
    }

    private boolean checkConflict(Clause conflict) {
        for (Literal lit : conflict.mLiterals) {
            DPLLAtom a = lit.getAtom();
            assert (a.mDecideStatus == lit.negate());
        }
        return true;
    }

    public Clause setLiteral(Literal literal) {
        this.mLogger.debug("S %s", literal);
        DPLLAtom atom = literal.getAtom();
        assert (atom.mDecideStatus == null);
        assert (this.mAtoms.contains(atom));
        atom.mStackPosition = this.mDPLLStack.size();
        this.mDPLLStack.add(literal);
        atom.mDecideLevel = this.mCurrentDecideLevel;
        atom.mDecideStatus = literal;
        if (!atom.preferredStatusIsLocked()) {
            atom.mLastStatus = atom.mDecideStatus;
        }
        this.mAtoms.remove(atom);
        this.mPendingWatcherList.moveAll(literal.negate().mWatchers);
        long time = System.nanoTime();
        Clause conflict = null;
        if (this.mCurrentDecideLevel <= this.mBaseLevel) {
            ++this.mNumSolvedAtoms;
            this.generateLevel0Proof(literal);
        }
        for (ITheory t : this.mTheories) {
            conflict = t.setLiteral(literal);
            if (conflict == null) continue;
            assert (this.checkConflict(conflict));
            break;
        }
        this.mSetTime += System.nanoTime() - time;
        return conflict;
    }

    public void watchClause(Clause clause) {
        if (clause.getSize() <= 1) {
            if (clause.getSize() == 0) {
                if (this.mUnsatClause == null) {
                    this.mUnsatClause = clause;
                }
            } else {
                this.mPendingWatcherList.append(clause, 1);
            }
        } else {
            this.mPendingWatcherList.append(clause, 0);
            this.mPendingWatcherList.append(clause, 1);
        }
    }

    public void addClause(Clause clause) {
        this.mAtomScale += 0.09090909090909094;
        clause.mActivity = Double.POSITIVE_INFINITY;
        ++this.mNumAxiomClauses;
        assert (clause.mStacklevel == this.mPushPopLevel);
        this.mClauses.prepend(clause);
        this.watchClause(clause);
    }

    void removeClause(Clause c) {
        c.removeFromList();
    }

    public void addFormulaClause(Literal[] literals, ProofNode proof) {
        this.addFormulaClause(literals, proof, null);
    }

    public void addFormulaClause(Literal[] literals, ProofNode proof, ClauseDeletionHook hook) {
        Clause clause = new Clause(literals, this.mPushPopLevel);
        clause.setDeletionHook(hook);
        this.addClause(clause);
        if (this.isProofGenerationEnabled()) {
            assert (proof instanceof LeafNode);
            clause.setProof(proof);
        }
        this.mLogger.trace("Added clause %s", clause);
    }

    public void learnClause(Clause clause) {
        this.mAtomScale += 0.09090909090909094;
        ++this.mNumClauses;
        clause.mActivity = this.mClsScale;
        if (clause.getSize() <= 2) {
            clause.mActivity = Double.POSITIVE_INFINITY;
        }
        this.mLearnedClauses.append(clause);
        this.watchClause(clause);
    }

    private boolean checkDecideLevel() {
        int decision = 0;
        int i = 0;
        for (Literal lit : this.mDPLLStack) {
            if (lit.getAtom().mExplanation == null) {
                ++decision;
            }
            assert (lit.getAtom().mStackPosition == i);
            assert (lit.getAtom().mDecideLevel == decision);
            ++i;
        }
        return decision == this.mCurrentDecideLevel;
    }

    private int countLitsOnDecideLevel(Set<Literal> conflict) {
        Literal lit;
        int numLits = 0;
        int stackPtr = this.mDPLLStack.size();
        do {
            lit = this.mDPLLStack.get(--stackPtr);
            assert (!conflict.contains(lit.negate()));
            if (!conflict.contains(lit)) continue;
            ++numLits;
        } while (lit.getAtom().mExplanation != null);
        return numLits;
    }

    private Clause explainConflict(Clause clause) {
        Literal lit;
        this.mLogger.debug("explain conflict %s", clause);
        HashSet<Literal> level0Ants = new HashSet<Literal>();
        ArrayList<ResolutionNode.Antecedent> antecedents = null;
        if (this.isProofGenerationEnabled()) {
            antecedents = new ArrayList<ResolutionNode.Antecedent>();
        }
        int expstacklevel = clause.mStacklevel;
        ++this.mConflicts;
        assert (this.checkDecideLevel());
        this.mAtomScale *= 1.1;
        this.mClsScale *= 1.01;
        CuckooHashSet<Literal> conflict = new CuckooHashSet<Literal>();
        int maxDecideLevel = this.mBaseLevel + 1;
        int numLitsOnMaxDecideLevel = 0;
        int numAssumptions = 0;
        for (Literal literal : clause.mLiterals) {
            DPLLAtom atom = literal.getAtom();
            assert (atom.mDecideStatus == literal.negate());
            if (atom.mDecideLevel > this.mBaseLevel) {
                if (atom.mDecideLevel >= maxDecideLevel) {
                    if (atom.mDecideLevel > maxDecideLevel) {
                        maxDecideLevel = atom.mDecideLevel;
                        numLitsOnMaxDecideLevel = 1;
                    } else {
                        ++numLitsOnMaxDecideLevel;
                    }
                }
                conflict.add(literal.negate());
            } else if (this.mAssumptionLiterals.contains(literal.negate())) {
                conflict.add(literal.negate());
                ++numAssumptions;
            } else {
                expstacklevel = this.level0resolve(literal, level0Ants, expstacklevel);
            }
            atom.mActivity += this.mAtomScale;
        }
        this.mLogger.debug("removing level0: %s", conflict);
        if (conflict.size() == numAssumptions) {
            for (Literal lit0 : level0Ants) {
                Clause c = this.getLevel0(lit0);
                for (Literal assumptionLit : c.mLiterals) {
                    if (assumptionLit == lit0) continue;
                    conflict.add(assumptionLit.negate());
                }
            }
            Literal[] newlits = new Literal[conflict.size()];
            int i = 0;
            for (Literal literal : conflict) {
                newlits[i++] = literal.negate();
            }
            assert (i == newlits.length);
            Clause resolution = new Clause(newlits, expstacklevel);
            if (this.isProofGenerationEnabled()) {
                for (Literal l0 : level0Ants) {
                    antecedents.add(new ResolutionNode.Antecedent(l0, this.getLevel0(l0)));
                }
                if (antecedents.isEmpty()) {
                    resolution.setProof(clause.getProof());
                } else {
                    ResolutionNode.Antecedent[] antecedentArray = antecedents.toArray(new ResolutionNode.Antecedent[antecedents.size()]);
                    resolution.setProof(new ResolutionNode(clause, antecedentArray));
                }
            }
            this.mUnsatClause = resolution;
            return resolution;
        }
        assert (numLitsOnMaxDecideLevel >= 1);
        while (this.mCurrentDecideLevel > maxDecideLevel) {
            lit = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            assert (!conflict.contains(lit.negate()));
            assert (!conflict.contains(lit));
            this.backtrackLiteral(lit);
            assert (this.checkDecideLevel());
        }
        while (numLitsOnMaxDecideLevel > 1) {
            assert (this.checkDecideLevel());
            assert (this.mCurrentDecideLevel == maxDecideLevel);
            assert (this.countLitsOnDecideLevel(conflict) == numLitsOnMaxDecideLevel);
            assert (this.checkDecideLevel());
            lit = this.mDPLLStack.get(this.mDPLLStack.size() - 1);
            assert (!conflict.contains(lit.negate()));
            if (!conflict.contains(lit)) {
                assert (lit.getAtom().mExplanation != null);
                assert (this.checkDecideLevel());
                this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
                this.backtrackLiteral(lit);
                assert (this.checkDecideLevel());
                continue;
            }
            Clause expl = this.getExplanation(lit);
            expl.mActivity += this.mClsScale;
            expstacklevel = Math.max(expstacklevel, expl.mStacklevel);
            if (this.isProofGenerationEnabled()) {
                antecedents.add(new ResolutionNode.Antecedent(lit, expl));
            }
            this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral(lit);
            assert (this.checkDecideLevel());
            conflict.remove(lit);
            --numLitsOnMaxDecideLevel;
            DPLLAtom atom = lit.getAtom();
            this.mLogger.debug("Resolving with %s pivot = %s", expl, atom);
            for (Literal l : expl.mLiterals) {
                if (l == lit) continue;
                assert (l.getAtom().mDecideStatus == l.negate());
                int level = l.getAtom().mDecideLevel;
                if (this.mAssumptionLiterals.contains(l.negate())) {
                    if (conflict.add(l.negate())) {
                        ++numAssumptions;
                    }
                } else if (level > this.mBaseLevel) {
                    if (conflict.add(l.negate()) && level == maxDecideLevel) {
                        ++numLitsOnMaxDecideLevel;
                    }
                } else {
                    expstacklevel = this.level0resolve(l, level0Ants, expstacklevel);
                }
                l.getAtom().mActivity += this.mAtomScale;
            }
            assert (this.countLitsOnDecideLevel(conflict) == numLitsOnMaxDecideLevel);
            this.mLogger.debug("new conflict: %s", conflict);
        }
        assert (this.mCurrentDecideLevel == maxDecideLevel);
        assert (this.countLitsOnDecideLevel(conflict) == numLitsOnMaxDecideLevel);
        assert (numLitsOnMaxDecideLevel == 1);
        while (this.mCurrentDecideLevel >= maxDecideLevel) {
            lit = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            assert (!conflict.contains(lit.negate()));
            this.backtrackLiteral(lit);
            assert (this.checkDecideLevel());
        }
        this.findBacktrackingPoint(conflict);
        this.mLogger.debug("Backtrack to %d", this.mDPLLStack.size());
        HashMap<Literal, Integer> redundancy = this.computeRedundancy(conflict);
        Integer REDUNDANT = 1;
        int stackPtr = this.mDPLLStack.size();
        while (stackPtr > this.mNumSolvedAtoms) {
            Literal literal;
            if (redundancy.get(literal = this.mDPLLStack.get(--stackPtr)) != REDUNDANT || !conflict.contains(literal)) continue;
            Clause expl = this.getExplanation(literal);
            expl.mActivity += this.mClsScale;
            expstacklevel = Math.max(expstacklevel, expl.mStacklevel);
            if (this.isProofGenerationEnabled()) {
                antecedents.add(new ResolutionNode.Antecedent(literal, expl));
            }
            conflict.remove(literal);
            for (Literal l : expl.mLiterals) {
                if (l == literal) continue;
                assert (l.getAtom().mDecideStatus == l.negate());
                int level = l.getAtom().mDecideLevel;
                if (this.mAssumptionLiterals.contains(l.negate())) {
                    if (conflict.add(l.negate())) {
                        ++numAssumptions;
                    }
                } else if (level > this.mBaseLevel) {
                    conflict.add(l.negate());
                } else {
                    expstacklevel = this.level0resolve(l, level0Ants, expstacklevel);
                }
                l.getAtom().mActivity += this.mAtomScale;
            }
        }
        this.mLogger.debug("removing redundancy yields %s", conflict);
        for (Literal lit0 : level0Ants) {
            Clause c = this.getLevel0(lit0);
            for (Literal assumptionLit : c.mLiterals) {
                if (assumptionLit == lit0) continue;
                conflict.add(assumptionLit.negate());
            }
        }
        Literal[] literalArray = new Literal[conflict.size()];
        int i = 0;
        for (Literal l : conflict) {
            literalArray[i++] = l.negate();
        }
        assert (literalArray[literalArray.length - 1] != null);
        Clause resolution = new Clause(literalArray, expstacklevel);
        if (this.isProofGenerationEnabled()) {
            for (Literal l0 : level0Ants) {
                antecedents.add(new ResolutionNode.Antecedent(l0, this.getLevel0(l0)));
            }
            if (antecedents.isEmpty()) {
                resolution.setProof(clause.getProof());
            } else {
                ResolutionNode.Antecedent[] ants = antecedents.toArray(new ResolutionNode.Antecedent[antecedents.size()]);
                resolution.setProof(new ResolutionNode(clause, ants));
            }
        }
        this.mLogger.debug("Resolved to %s", resolution);
        if (literalArray.length == numAssumptions) {
            this.mUnsatClause = resolution;
        }
        return resolution;
    }

    private boolean explain(Clause conflict) {
        while (conflict != null) {
            this.startBacktrack();
            conflict = this.explainConflict(conflict);
            this.learnClause(conflict);
            if (this.mUnsatClause != null) {
                return true;
            }
            conflict = this.finalizeBacktrack();
        }
        return false;
    }

    private final int level0resolve(Literal l, Set<Literal> level0Ants, int sl) {
        Clause l0 = this.getLevel0(l.negate());
        level0Ants.add(l.negate());
        return l0.mStacklevel > sl ? l0.mStacklevel : sl;
    }

    private Clause getExplanation(Literal lit) {
        Object explanation = lit.getAtom().mExplanation;
        if (explanation instanceof ITheory) {
            Clause expl = ((ITheory)explanation).getUnitClause(lit);
            lit.getAtom().mExplanation = expl;
            assert (this.checkUnitClause(expl, lit));
            assert (this.checkDecideLevel());
            return expl;
        }
        assert (explanation == null || this.checkUnitClause((Clause)explanation, lit));
        return (Clause)explanation;
    }

    private HashMap<Literal, Integer> computeRedundancy(Set<Literal> conflict) {
        Integer REDUNDANT = 1;
        Integer FAILED = 2;
        Integer KEEP = 3;
        HashMap<Literal, Integer> status = new HashMap<Literal, Integer>();
        for (Literal l : conflict) {
            if (l.getAtom().getDecideStatus() == null) continue;
            assert (l.getAtom().getDecideStatus() == l);
            status.put(l, REDUNDANT);
        }
        ArrayDeque<Literal> todo = new ArrayDeque<Literal>();
        block1: for (Literal lit : conflict) {
            if (lit.getAtom().getDecideStatus() == null) continue;
            todo.addFirst(lit);
            block2: while (!todo.isEmpty()) {
                Literal next = (Literal)todo.getFirst();
                assert (next.getAtom().getDecideStatus() == next);
                Clause expl = this.getExplanation(next);
                if (expl == null) {
                    while (todo.size() > 1) {
                        status.put((Literal)todo.removeFirst(), FAILED);
                    }
                    status.put((Literal)todo.removeFirst(), KEEP);
                    continue block1;
                }
                for (Literal l : expl.mLiterals) {
                    assert (l.getAtom().getDecideStatus() != null);
                    if (l == next || l.getAtom().getDecideLevel() <= this.mBaseLevel) continue;
                    Literal lneg = l.negate();
                    assert (lneg.getAtom().getDecideStatus() == lneg);
                    Integer st = status.get(lneg);
                    if (st == FAILED) {
                        while (todo.size() > 1) {
                            status.put((Literal)todo.removeFirst(), FAILED);
                        }
                        status.put((Literal)todo.removeFirst(), KEEP);
                        continue block1;
                    }
                    if (st != null) continue;
                    todo.addFirst(lneg);
                    continue block2;
                }
                status.put((Literal)todo.removeFirst(), REDUNDANT);
            }
        }
        return status;
    }

    private boolean checkUnitClause(Clause unit, Literal lit) {
        boolean found = false;
        for (Literal l : unit.mLiterals) {
            assert (l != lit.negate()) : "Negation of unit literal in explanation";
            if (l == lit) {
                found = true;
                continue;
            }
            assert (l.mAtom.mDecideStatus == l.negate() && l.mAtom.getStackPosition() < lit.getAtom().getStackPosition()) : "Not a unit clause: " + l + " in " + unit;
        }
        assert (found) : "Unit literal not in explanation";
        return found;
    }

    private void startBacktrack() {
        for (ITheory t : this.mTheories) {
            t.backtrackStart();
        }
    }

    private Clause finalizeBacktrack() {
        for (ITheory t : this.mTheories) {
            Clause conflict = t.backtrackComplete();
            if (conflict == null) continue;
            return conflict;
        }
        return null;
    }

    private void findBacktrackingPoint(Set<Literal> conflict) {
        Literal lit;
        int i = this.mDPLLStack.size();
        while (i > 0 && !conflict.contains(lit = this.mDPLLStack.get(--i))) {
            if (lit.getAtom().mExplanation != null) continue;
            while (this.mDPLLStack.size() > i) {
                this.backtrackLiteral(this.mDPLLStack.remove(this.mDPLLStack.size() - 1));
            }
        }
    }

    public void backtrackLiteral(Literal literal) {
        this.mLogger.debug("B %s", literal);
        DPLLAtom atom = literal.getAtom();
        long time = System.nanoTime();
        for (ITheory t2 : this.mTheories) {
            t2.backtrackLiteral(literal);
        }
        this.mBacktrackTime += System.nanoTime() - time;
        this.mPendingWatcherList.moveAll(atom.mBacktrackWatchers);
        if (atom.mExplanation == null) {
            this.decreaseDecideLevel();
        }
        atom.mExplanation = null;
        atom.mDecideStatus = null;
        atom.mDecideLevel = -1;
        atom.mStackPosition = -1;
        this.mAtoms.add(atom);
    }

    private Clause checkConsistency() {
        long time = 0L;
        time = System.nanoTime();
        this.mLogger.debug("DPLL: final check");
        for (ITheory t : this.mTheories) {
            Clause conflict = t.computeConflictClause();
            if (conflict != null) {
                return conflict;
            }
            if (!this.mAtoms.isEmpty()) break;
        }
        this.mCheckTime += System.nanoTime() - time;
        return null;
    }

    private Literal chooseLiteral() {
        Literal lit = this.suggestions();
        if (lit != null) {
            return lit;
        }
        DPLLAtom atom = this.mAtoms.peek();
        if (atom == null) {
            return null;
        }
        assert (atom.mDecideStatus == null);
        return atom.getPreferredStatus();
    }

    private static final int luby_super(int i) {
        int power;
        assert (i > 0);
        for (power = 2; power < i + 1; power *= 2) {
        }
        if (power == i + 1) {
            return power / 2;
        }
        return DPLLEngine.luby_super(i - power / 2 + 1);
    }

    private void printStatistics() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("Confl: " + this.mConflicts + " Props: " + this.mProps + " Tprops: " + this.mTProps + " Decides: " + this.mDecides + " RSplits: " + this.mNumRandomSplits);
            this.mLogger.info("Times: Expl: " + (double)(this.mExplainTime / 1000L) / 1000.0 + " Prop: " + (double)(this.mPropTime / 1000L) / 1000.0 + " PropClause: " + (double)(this.mPropClauseTime / 1000L) / 1000.0 + " Set: " + (double)(this.mSetTime / 1000L) / 1000.0 + " Check: " + (double)(this.mCheckTime / 1000L) / 1000.0 + " Back: " + (double)(this.mBacktrackTime / 1000L) / 1000.0);
            this.mLogger.info("Atoms: " + this.mNumSolvedAtoms + "/" + (this.mAtoms.size() + this.mDPLLStack.size()) + " Clauses: " + this.mNumClauses + " Axioms: " + this.mNumAxiomClauses);
            for (ITheory t : this.mTheories) {
                t.printStatistics(this.mLogger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean solve() {
        this.mHasModel = false;
        if (this.mUnsatClause != null) {
            this.mLogger.debug("Using cached unsatisfiability");
            return false;
        }
        try {
            Clause conflict;
            HashMap<Literal, Double> scores = new HashMap<Literal, Double>();
            block8: for (Clause c : this.mClauses) {
                Literal ds;
                double inc = 1.0;
                for (Literal literal : c.mLiterals) {
                    ds = literal.getAtom().getDecideStatus();
                    if (ds == literal) continue block8;
                    if (ds == literal.negate()) continue;
                    inc /= 2.0;
                }
                for (Literal literal : c.mLiterals) {
                    ds = literal.getAtom().getDecideStatus();
                    if (ds == literal.negate()) continue;
                    Double score = (Double)scores.get(literal);
                    if (score == null) {
                        scores.put(literal, inc);
                        continue;
                    }
                    scores.put(literal, score + inc);
                }
            }
            for (ITheory[] atom : this.mAtoms) {
                double Nscore;
                Double pscore = (Double)scores.get(atom);
                Double nscore = (Double)scores.get(atom.negate());
                double Pscore = pscore == null ? 0.0 : pscore;
                double d = Nscore = nscore == null ? 0.0 : nscore;
                if (atom.preferredStatusIsLocked()) continue;
                atom.setPreferredStatus((Literal)(Pscore > Nscore ? atom : atom.negate()));
            }
            long lastTime = System.nanoTime() - this.mSetTime - this.mBacktrackTime;
            for (ITheory t : this.mTheories) {
                conflict = t.startCheck();
                if (!this.explain(conflict)) continue;
                boolean Nscore = false;
                return Nscore;
            }
            int iteration = 1;
            int nextRestart = 500;
            while (!this.isTerminationRequested()) {
                while ((conflict = this.propagateInternal()) == null && !this.isTerminationRequested()) {
                    long time = System.nanoTime();
                    this.mPropTime += time - lastTime - this.mSetTime - this.mBacktrackTime;
                    lastTime = time - this.mSetTime - this.mBacktrackTime;
                    Literal literal = this.chooseLiteral();
                    if (literal == null) {
                        conflict = this.checkConsistency();
                        if (conflict == null) {
                            Literal literal2;
                            boolean suggested = false;
                            while (conflict != null && (literal2 = this.suggestions()) != null) {
                                if (literal2.getAtom().mExplanation == null) {
                                    this.increaseDecideLevel();
                                    ++this.mDecides;
                                }
                                conflict = this.setLiteral(literal2);
                                suggested = true;
                            }
                            if (!suggested && this.mPendingWatcherList.isEmpty() && this.mAtoms.isEmpty()) {
                                if (this.mLogger.isInfoEnabled()) {
                                    this.printStatistics();
                                    this.mLogger.info("Hooray, we found a model:");
                                    for (ITheory t : this.mTheories) {
                                        t.dumpModel(this.mLogger);
                                    }
                                    if (this.mLogger.isTraceEnabled()) {
                                        for (Literal dlit : this.mDPLLStack) {
                                            this.mLogger.trace("%d: %s", dlit.hashCode(), dlit);
                                        }
                                    }
                                }
                                this.mHasModel = true;
                                boolean score = true;
                                return score;
                            }
                        }
                    } else {
                        this.increaseDecideLevel();
                        ++this.mDecides;
                        conflict = this.setLiteral(literal);
                    }
                    if (conflict == null && !this.isTerminationRequested()) continue;
                }
                long time = System.nanoTime();
                this.mPropTime += time - lastTime - this.mSetTime - this.mBacktrackTime;
                lastTime = time - this.mSetTime - this.mBacktrackTime;
                if (this.explain(conflict)) {
                    time = System.nanoTime();
                    this.mExplainTime += time - lastTime - this.mSetTime - this.mBacktrackTime;
                    lastTime = time - this.mSetTime - this.mBacktrackTime;
                    this.printStatistics();
                    this.mLogger.info("Formula is unsat");
                    boolean literal = false;
                    return literal;
                }
                time = System.nanoTime();
                this.mExplainTime += time - lastTime - this.mSetTime - this.mBacktrackTime;
                lastTime = time - this.mSetTime - this.mBacktrackTime;
                if (this.mAtomScale > 1.0E250) {
                    for (DPLLAtom dPLLAtom : this.mAtoms) {
                        dPLLAtom.mActivity *= Double.MIN_NORMAL;
                    }
                    for (Literal literal : this.mDPLLStack) {
                        literal.getAtom().mActivity *= Double.MIN_NORMAL;
                    }
                    this.mAtomScale *= Double.MIN_NORMAL;
                }
                if (this.mClsScale > 1.0E250) {
                    for (Clause clause : this.mLearnedClauses) {
                        clause.mActivity *= Double.MIN_NORMAL;
                    }
                    this.mClsScale *= Double.MIN_NORMAL;
                }
                if (--nextRestart == 0) {
                    int n;
                    this.startBacktrack();
                    DPLLAtom next = this.mAtoms.peek();
                    int n2 = -1;
                    for (int i = this.mNumSolvedAtoms + this.mBaseLevel; i < this.mDPLLStack.size(); ++i) {
                        DPLLAtom var = this.mDPLLStack.get(i).getAtom();
                        if (var.mExplanation != null || !(var.mActivity < next.mActivity)) continue;
                        n = i;
                        break;
                    }
                    if (n != -1) {
                        while (this.mDPLLStack.size() > n) {
                            Literal lit = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
                            assert (lit.getAtom().mDecideLevel != this.mBaseLevel);
                            Object litexpl = lit.getAtom().mExplanation;
                            if (litexpl instanceof Clause) {
                                ((Clause)litexpl).mActivity += this.mClsScale;
                            }
                            this.backtrackLiteral(lit);
                        }
                    }
                    this.unlearnClauses(this.mPushPopLevel);
                    conflict = this.finalizeBacktrack();
                    assert (conflict == null);
                    ++iteration;
                    for (ITheory t : this.mTheories) {
                        t.restart(iteration);
                    }
                    nextRestart = 500 * DPLLEngine.luby_super(iteration);
                    this.mLogger.info("Restart");
                    this.printStatistics();
                }
                lastTime = System.nanoTime() - this.mSetTime - this.mBacktrackTime;
            }
            boolean bl = true;
            return bl;
        }
        catch (OutOfMemoryError eOOM) {
            this.setCompleteness(3);
            boolean bl = true;
            return bl;
        }
        finally {
            for (ITheory t : this.mTheories) {
                t.endCheck();
            }
        }
    }

    private final void unlearnClauses(int targetstacklevel) {
        Iterator<Clause> it = this.mLearnedClauses.iterator();
        while (it.hasNext()) {
            Clause c = it.next();
            if (!(c.mActivity < this.mClsScale * 1.0E-150) && (c.mStacklevel <= targetstacklevel || !c.doCleanup(this))) continue;
            --this.mNumClauses;
            it.remove();
        }
    }

    private Literal suggestions() {
        Literal lit;
        for (ITheory t : this.mTheories) {
            lit = t.getPropagatedLiteral();
            if (lit == null) continue;
            lit.mAtom.mExplanation = t;
            assert (lit.getAtom().mDecideStatus == null);
            return lit;
        }
        for (ITheory t : this.mTheories) {
            lit = t.getSuggestion();
            if (lit == null) continue;
            assert (lit.getAtom().mDecideStatus == null);
            return lit;
        }
        return null;
    }

    public void addAtom(DPLLAtom atom) {
        this.mAtoms.add(atom);
        this.mAtomList.add(atom);
    }

    public void removeAtom(DPLLAtom atom) {
        assert (atom.mDecideStatus == null);
        this.mAtoms.remove(atom);
        for (ITheory t : this.mTheories) {
            t.removeAtom(atom);
        }
    }

    public void addTheory(ITheory t) {
        ITheory[] newTheories = new ITheory[this.mTheories.length + 1];
        System.arraycopy(this.mTheories, 0, newTheories, 0, this.mTheories.length);
        newTheories[this.mTheories.length] = t;
        this.mTheories = newTheories;
    }

    public void removeTheory() {
        ITheory[] newTheories = new ITheory[this.mTheories.length - 1];
        System.arraycopy(this.mTheories, 0, newTheories, 0, this.mTheories.length);
        this.mTheories = newTheories;
    }

    public String dumpClauses(Theory smtTheory) {
        StringBuilder sb = new StringBuilder();
        for (Clause c : this.mClauses) {
            sb.append("(assert ");
            Literal[] lits = c.mLiterals;
            if (lits.length == 1) {
                sb.append(lits[0].getSMTFormula(smtTheory)).append(")\n");
                continue;
            }
            sb.append("(or");
            for (Literal l : lits) {
                sb.append(' ').append(l.getSMTFormula(smtTheory));
            }
            sb.append("))\n");
        }
        return sb.toString();
    }

    public void setCompleteness(int ncompleteness) {
        this.mCompleteness = ncompleteness;
    }

    public int getCompleteness() {
        return this.mCompleteness;
    }

    public void provideCompleteness(int ncompleteness) {
        if (this.mCompleteness == 0) {
            this.mCompleteness = ncompleteness;
        }
    }

    public String getCompletenessReason() {
        return COMPLETENESS_STRINGS[this.mCompleteness];
    }

    public void push() {
        if (this.mAssignments != null) {
            this.mAssignments.beginScope();
        }
        this.mAtomList.beginScope();
        for (ITheory theory : this.getAttachedTheories()) {
            theory.push();
        }
        ++this.mPushPopLevel;
    }

    public void pop(int numpops) {
        if (numpops < 1 || numpops > this.mPushPopLevel) {
            throw new IllegalArgumentException("Must pop a positive number less than the current stack level");
        }
        int targetstacklevel = this.mPushPopLevel - numpops;
        if (this.mUnsatClause != null && this.mUnsatClause.mStacklevel > targetstacklevel) {
            this.mUnsatClause = null;
        }
        if (!this.mDPLLStack.isEmpty()) {
            ListIterator<Literal> literals = this.mDPLLStack.listIterator(this.mDPLLStack.size());
            while (literals.hasPrevious()) {
                ITheory[] lit = literals.previous();
                Object litexpl = lit.getAtom().mExplanation;
                if (litexpl instanceof Clause) {
                    ((Clause)litexpl).mActivity += this.mClsScale;
                }
                this.backtrackLiteral((Literal)lit);
            }
            this.mDPLLStack.clear();
            for (ITheory t : this.mTheories) {
                t.backtrackAll();
            }
        }
        this.unlearnClauses(targetstacklevel);
        assert (this.mCurrentDecideLevel == 0);
        this.mNumSolvedAtoms = 0;
        Iterator<Clause> inputit = this.mClauses.iterator();
        while (inputit.hasNext()) {
            Clause input = inputit.next();
            if (input.mStacklevel <= targetstacklevel) break;
            if (input.doCleanup(this)) {
                inputit.remove();
                continue;
            }
            throw new InternalError("Input clause still blocked, but invalid");
        }
        for (int i = 0; i < numpops; ++i) {
            for (ITheory theory : this.getAttachedTheories()) {
                theory.pop();
            }
            if (this.mAssignments != null) {
                this.mAssignments.endScope();
            }
            for (DPLLAtom atom : this.mAtomList.currentScope()) {
                this.removeAtom(atom);
            }
            this.mAtomList.endScope();
            --this.mPushPopLevel;
        }
        this.mCompleteness = 0;
        assert (this.mPushPopLevel == targetstacklevel);
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public void showClauses(PrintWriter pw) {
        SimpleListable c = this.mClauses.mNext;
        while (c != this.mClauses) {
            pw.println(c);
            c = c.mNext;
        }
    }

    public boolean hasModel() {
        for (ITheory t : this.mTheories) {
            this.provideCompleteness(t.checkCompleteness());
        }
        return this.mHasModel && this.mCompleteness == 0;
    }

    public void setProofGeneration(boolean enablePG) {
        this.mPGenabled = enablePG;
    }

    public boolean isProofGenerationEnabled() {
        return this.mPGenabled;
    }

    public Literal[] getUnsatAssumptions() {
        return this.mUnsatClause.mLiterals;
    }

    public Clause getProof() {
        assert (this.checkValidUnsatClause());
        Clause empty = this.mUnsatClause;
        if (this.mUnsatClause != null && this.mUnsatClause.getSize() > 0) {
            ResolutionNode.Antecedent[] antecedents = new ResolutionNode.Antecedent[this.mUnsatClause.getSize()];
            for (int i = 0; i < this.mUnsatClause.getSize(); ++i) {
                Literal lit = this.mUnsatClause.getLiteral(i).negate();
                antecedents[i] = new ResolutionNode.Antecedent(lit, new Clause(new Literal[]{lit}, new LeafNode(-7, null)));
            }
            ResolutionNode proof = new ResolutionNode(this.mUnsatClause, antecedents);
            empty = new Clause(new Literal[0], proof);
        }
        return empty;
    }

    private void generateLevel0Proof(Literal lit) {
        assert (lit.getAtom().mDecideLevel <= this.mBaseLevel) : "Level0 proof for non-level0 literal?";
        assert (!this.mAssumptionLiterals.contains(lit));
        HashSet<Literal> clauseLits = new HashSet<Literal>();
        Clause c = this.getExplanation(lit);
        if (c.getSize() > 1) {
            int stacklvl = c.mStacklevel;
            Literal[] lits = c.mLiterals;
            ResolutionNode.Antecedent[] ants = this.isProofGenerationEnabled() ? new ResolutionNode.Antecedent[c.getSize() - 1] : null;
            int i = 0;
            for (Literal l : lits) {
                if (this.mAssumptionLiterals.contains(l.negate())) {
                    clauseLits.add(l);
                    continue;
                }
                if (l == lit) continue;
                Clause lc = this.getLevel0(l.negate());
                if (this.isProofGenerationEnabled()) {
                    ants[i++] = new ResolutionNode.Antecedent(l.negate(), lc);
                }
                for (int j = 0; j < lc.getSize(); ++j) {
                    Literal depLit = lc.getLiteral(j);
                    if (depLit == l.negate()) continue;
                    assert (this.mAssumptionLiterals.contains(depLit.negate()));
                    clauseLits.add(depLit);
                }
                stacklvl = Math.max(stacklvl, lc.mStacklevel);
            }
            clauseLits.add(lit);
            Literal[] arrayLits = clauseLits.toArray(new Literal[clauseLits.size()]);
            Clause res = this.isProofGenerationEnabled() ? new Clause(arrayLits, new ResolutionNode(c, ants), stacklvl) : new Clause(arrayLits, stacklvl);
            lit.getAtom().mExplanation = res;
        }
    }

    private boolean checkLevel0Clause(Clause clause, Literal lit) {
        boolean found = false;
        for (Literal l : clause.mLiterals) {
            if (l == lit) {
                found = true;
                continue;
            }
            assert (this.mAssumptionLiterals.contains(l.negate()));
        }
        return found;
    }

    private Clause getLevel0(Literal lit) {
        assert (lit.getAtom().mDecideLevel <= this.mBaseLevel);
        Object expl = lit.getAtom().mExplanation;
        assert (expl instanceof Clause);
        assert (this.checkLevel0Clause((Clause)expl, lit));
        return (Clause)expl;
    }

    public final void increaseDecideLevel() {
        this.mLogger.debug("Decide@%d", this.mDPLLStack.size());
        ++this.mCurrentDecideLevel;
        assert (this.mCurrentDecideLevel >= 0) : "Decidelevel negative";
        for (ITheory t : this.mTheories) {
            t.increasedDecideLevel(this.mCurrentDecideLevel);
        }
    }

    public final void decreaseDecideLevel() {
        --this.mCurrentDecideLevel;
        assert (this.mCurrentDecideLevel >= 0) : "Decidelevel negative";
        for (ITheory t : this.mTheories) {
            t.decreasedDecideLevel(this.mCurrentDecideLevel);
        }
    }

    public ITheory[] getAttachedTheories() {
        return this.mTheories;
    }

    public int getAssertionStackLevel() {
        return this.mPushPopLevel;
    }

    public boolean inconsistent() {
        return this.mUnsatClause != null;
    }

    private boolean checkProofStackLevel(Clause c, int targetlvl) {
        if (c == null || c.mProof == null) {
            return true;
        }
        if (c.mStacklevel > targetlvl) {
            System.err.println("Clause " + c + " above target level!");
            return false;
        }
        for (Literal lit : c.mLiterals) {
            if (lit.getAtom().mAssertionstacklevel <= targetlvl) continue;
            System.err.println("Literal " + lit + " in clause " + c + " above target level");
            return false;
        }
        if (c.mProof instanceof ResolutionNode) {
            ResolutionNode rn = (ResolutionNode)c.mProof;
            if (!this.checkProofStackLevel(rn.getPrimary(), targetlvl)) {
                return false;
            }
            for (ResolutionNode.Antecedent ante : rn.getAntecedents()) {
                if (this.checkProofStackLevel(ante.mAntecedent, targetlvl)) continue;
                return false;
            }
        }
        return true;
    }

    public Object getStatistics() {
        Object[] res = new Object[this.mTheories.length + 1];
        Object[][] mystats = new Object[][]{{"Conflicts", this.mConflicts}, {"Propagations", this.mProps}, {"Theory_propagations", this.mTProps}, {"Decides", this.mDecides}, {"Random_splits", this.mNumRandomSplits}, {"Num_Atoms", this.mAtoms.size() + this.mDPLLStack.size()}, {"Solved_Atoms", this.mNumSolvedAtoms}, {"Clauses", this.mNumClauses}, {"Axioms", this.mNumAxiomClauses}, {"Times", new Object[][]{{"Explain", this.mExplainTime}, {"Propagation", this.mPropTime}, {"Set", this.mSetTime}, {"Check", this.mCheckTime}, {"Backtrack", this.mBacktrackTime}}}};
        res[0] = new Object[]{":Core", mystats};
        for (int i = 1; i < res.length; ++i) {
            res[i] = this.mTheories[i - 1].getStatistics();
        }
        return res;
    }

    public void setProduceAssignments(boolean value) {
        assert (this.mPushPopLevel == 0 && this.mAssignments == null || this.mAssignments.isEmpty());
        this.mAssignments = value ? new ScopedHashMap() : null;
    }

    public boolean isProduceAssignments() {
        return this.mAssignments != null;
    }

    public void trackAssignment(String label, Literal literal) {
        this.mAssignments.put(label, literal);
    }

    public Assignments getAssignments() {
        if (!this.isProduceAssignments()) {
            return null;
        }
        HashMap<String, Boolean> assignment = new HashMap<String, Boolean>(this.mAssignments.size(), 1.0f);
        for (Map.Entry<String, Literal> me : this.mAssignments.entrySet()) {
            assignment.put(me.getKey(), me.getValue().getAtom().mDecideStatus == me.getValue());
        }
        return new Assignments(assignment);
    }

    public boolean quickCheck() {
        if (this.mUnsatClause != null) {
            return false;
        }
        Clause conflict = this.propagateInternal();
        boolean res = !this.explain(conflict);
        return res;
    }

    public boolean propagate() {
        ITheory t;
        if (this.mUnsatClause != null) {
            return false;
        }
        Clause conflict = null;
        ITheory[] iTheoryArray = this.mTheories;
        int n = iTheoryArray.length;
        for (int i = 0; i < n && (conflict = (t = iTheoryArray[i]).startCheck()) == null; ++i) {
        }
        if (conflict == null) {
            conflict = this.propagateInternal();
        }
        boolean res = !this.explain(conflict);
        for (ITheory t2 : this.mTheories) {
            t2.endCheck();
        }
        return res;
    }

    public Random getRandom() {
        return this.mRandom;
    }

    public void setRandomSeed(long seed) {
        this.mRandom.setSeed(seed);
    }

    public void flipDecisions() {
        this.startBacktrack();
        while (this.mDPLLStack.size() > this.mBaseLevel + this.mNumSolvedAtoms) {
            Literal lit = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral(lit);
            lit.getAtom().mLastStatus = lit.negate();
        }
        Clause conflict = this.finalizeBacktrack();
        assert (conflict == null);
        assert (this.mCurrentDecideLevel == this.mBaseLevel);
    }

    public void flipNamedLiteral(String name) throws SMTLIBException {
        this.startBacktrack();
        while (this.mDPLLStack.size() > this.mBaseLevel + this.mNumSolvedAtoms) {
            Literal lit = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral(lit);
        }
        Clause conflict = this.finalizeBacktrack();
        assert (conflict == null);
        assert (this.mCurrentDecideLevel == this.mBaseLevel);
        Literal lit = this.mAssignments.get(name);
        if (lit == null) {
            throw new SMTLIBException("Name " + name + " not known");
        }
        DPLLAtom atom = lit.getAtom();
        atom.mLastStatus = atom.mLastStatus == null ? atom : atom.mLastStatus.negate();
    }

    public SimpleList<Clause> getClauses() {
        return this.mClauses;
    }

    public Term[] getSatisfiedLiterals(Theory smtTheory) {
        int size = 0;
        for (Literal lit : this.mDPLLStack) {
            if (lit.getAtom() instanceof NamedAtom) continue;
            ++size;
        }
        Term[] res = new Term[size];
        int i = -1;
        for (Literal lit : this.mDPLLStack) {
            if (lit.getAtom() instanceof NamedAtom) continue;
            res[++i] = lit.getSMTFormula(smtTheory);
        }
        return res;
    }

    public boolean isTerminationRequested() {
        if (this.mCompleteness == 7 || this.mCancel.isTerminationRequested()) {
            this.mCompleteness = 7;
            return true;
        }
        return false;
    }

    public void clearAssumptions() {
        Clause conflict;
        if (this.mCurrentDecideLevel == 0) {
            return;
        }
        this.startBacktrack();
        this.mAssumptionLiterals.clear();
        this.mLogger.debug("Clearing Assumptions (Baselevel is %d)", this.mBaseLevel);
        while (this.mCurrentDecideLevel > 0) {
            Literal lit = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral(lit);
        }
        assert (this.mCurrentDecideLevel == 0);
        this.mBaseLevel = 0;
        if (this.mUnsatClause != null && this.mUnsatClause.getSize() > 0) {
            this.mUnsatClause = null;
        }
        if ((conflict = this.finalizeBacktrack()) != null) {
            this.explain(conflict);
        }
    }

    public boolean assume(Literal[] lits) {
        assert (this.mCurrentDecideLevel == this.mBaseLevel);
        for (Literal lit : lits) {
            this.mLogger.debug("Assuming Literal %s", lit);
            this.mAssumptionLiterals.add(lit);
            if (lit.getAtom().getDecideStatus() != null) {
                if (lit.getAtom().getDecideStatus() == lit) {
                    this.mLogger.debug("Already set!");
                    continue;
                }
                this.mUnsatClause = this.mAssumptionLiterals.contains(lit.negate()) ? new Clause(new Literal[]{lit}, new LeafNode(-7, null)) : this.getLevel0(lit.negate());
                assert (this.checkValidUnsatClause());
                assert (this.mBaseLevel == this.mCurrentDecideLevel);
                return false;
            }
            this.increaseDecideLevel();
            Clause conflict = this.setLiteral(lit);
            this.mBaseLevel = this.mCurrentDecideLevel;
            if (conflict == null) continue;
            this.mLogger.debug("Conflict when setting literal");
            this.startBacktrack();
            this.mUnsatClause = this.explainConflict(conflict);
            this.checkValidUnsatClause();
            this.finalizeBacktrack();
            return false;
        }
        this.mLogger.debug("Setting base level to %d", this.mCurrentDecideLevel);
        return true;
    }

    private boolean checkValidUnsatClause() {
        if (this.mUnsatClause != null) {
            for (Literal lit : this.mUnsatClause.mLiterals) {
                assert (this.mAssumptionLiterals.contains(lit.negate())) : "Not an assumption in unsat clause";
            }
        }
        return true;
    }

    public void messWithActivityOfAtoms(Random rnd) {
        this.mAtoms.clear();
        for (DPLLAtom atom : this.mAtomList) {
            atom.mActivity += rnd.nextDouble() * this.mAtomScale;
            if (atom.mDecideStatus != null) continue;
            this.mAtoms.add(atom);
        }
    }

    public class AllSatIterator
    implements Iterator<Term[]> {
        private final Literal[] mPreds;
        private final Term[] mTerms;
        private Literal[] mBlocker;
        private int mBlockerSize;

        public AllSatIterator(Literal[] preds, Term[] terms) {
            this.mPreds = preds;
            this.mTerms = terms;
            assert (this.mPreds.length == this.mTerms.length);
            for (Literal l : preds) {
                if (l.getAtom() instanceof DPLLAtom.TrueAtom) continue;
                ++this.mBlockerSize;
            }
        }

        @Override
        public boolean hasNext() {
            Clause conflict;
            if (this.mBlocker != null && DPLLEngine.this.explain(conflict = new Clause(this.mBlocker, DPLLEngine.this.mPushPopLevel))) {
                return false;
            }
            return DPLLEngine.this.solve() && DPLLEngine.this.hasModel();
        }

        @Override
        public Term[] next() {
            Term[] res = new Term[this.mPreds.length];
            this.mBlocker = new Literal[this.mBlockerSize];
            for (int i = 0; i < this.mPreds.length; ++i) {
                Literal l = this.mPreds[i];
                if (!(l.getAtom() instanceof DPLLAtom.TrueAtom)) {
                    this.mBlocker[i] = l.getAtom().mDecideStatus.negate();
                }
                res[i] = l.getAtom().mDecideStatus == l ? this.mTerms[i] : this.mTerms[i].getTheory().term("not", this.mTerms[i]);
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove model!");
        }
    }
}

