/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import java.util.Iterator;

public class SimpleList<E extends SimpleListable<E>>
extends SimpleListable<E>
implements Iterable<E> {
    public SimpleList() {
        this.mNext = this.mPrev = this;
    }

    public boolean isEmpty() {
        return this.mNext == this;
    }

    public E removeFirst() {
        SimpleListable entry = this.mNext;
        this.mNext = entry.mNext;
        this.mNext.mPrev = this;
        entry.mPrev = null;
        entry.mNext = null;
        return entry.getElem();
    }

    public E removeLast() {
        SimpleListable entry = this.mPrev;
        this.mPrev = entry.mPrev;
        this.mPrev.mNext = this;
        entry.mPrev = null;
        entry.mNext = null;
        return entry.getElem();
    }

    public void prepareRemove(E entry) {
        if (this.mNext == entry) {
            this.mNext = this.mPrev == entry ? (this.mPrev = this) : ((SimpleListable)entry).mNext;
        } else if (this.mPrev == entry) {
            this.mPrev = ((SimpleListable)entry).mPrev;
        }
    }

    public void append(E entry) {
        assert (this.mPrev.mNext == this);
        ((SimpleListable)entry).mPrev = this.mPrev;
        ((SimpleListable)entry).mNext = this;
        this.mPrev.mNext = entry;
        this.mPrev = this.mPrev.mNext;
    }

    public void prepend(E entry) {
        assert (this.mNext.mPrev == this);
        ((SimpleListable)entry).mNext = this.mNext;
        ((SimpleListable)entry).mPrev = this;
        this.mNext.mPrev = entry;
        this.mNext = entry;
    }

    public void prependIntoJoined(E entry, boolean isLast) {
        if (((SimpleListable)entry).mNext == null) {
            if (this != this.mNext || isLast) {
                ((SimpleListable)entry).mNext = this.mNext;
                ((SimpleListable)entry).mPrev = this.mNext.mPrev;
                if (this.mNext.mPrev != this) {
                    this.mNext.mPrev.mNext = entry;
                }
            }
            this.mNext.mPrev = entry;
            this.mNext = entry;
        } else if (this.mNext == ((SimpleListable)entry).mNext) {
            this.mNext = entry;
        }
    }

    public void undoPrependIntoJoined(E entry, boolean isLast) {
        if (this.mNext == entry && this.mPrev == entry) {
            this.mNext = this;
            this.mPrev = this;
        } else if (this.mNext == entry) {
            this.mNext = ((SimpleListable)entry).mNext;
        } else if (this.mPrev == entry) {
            this.mPrev = ((SimpleListable)entry).mPrev;
        }
        if (isLast) {
            ((SimpleListable)entry).removeFromList();
        }
    }

    public void moveAll(SimpleList<E> source) {
        if (source.mNext == source) {
            return;
        }
        source.mNext.mPrev = this.mPrev;
        source.mPrev.mNext = this;
        this.mPrev.mNext = source.mNext;
        this.mPrev = source.mPrev;
        source.mNext = source.mPrev = source;
    }

    public void joinList(SimpleList<E> source) {
        if (source.mNext == source) {
            return;
        }
        this.mPrev.mNext = source.mNext;
        source.mNext.mPrev = this.mPrev;
        this.mPrev = source.mPrev;
        this.mPrev.mNext = this;
    }

    public void unjoinList(SimpleList<E> source) {
        source.mPrev.mNext.mPrev = source.mNext.mPrev;
        source.mNext.mPrev.mNext = source.mPrev.mNext;
        source.mNext.mPrev = source;
        source.mPrev.mNext = source;
    }

    public boolean isSublistOf(SimpleList<E> bigList) {
        if (this.mNext == this && this.mPrev == this) {
            return true;
        }
        boolean foundHead = false;
        boolean foundTail = false;
        SimpleListable item = bigList.mNext;
        while (item != bigList) {
            if (item == this.mNext) {
                foundHead = true;
            }
            if (item == this.mPrev) {
                assert (foundHead);
                foundTail = true;
            }
            item = item.mNext;
        }
        return foundHead && foundTail;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            SimpleListable<E> mCur;
            SimpleListable<E> mPrev;
            {
                this.mCur = SimpleList.this;
                this.mPrev = null;
            }

            @Override
            public boolean hasNext() {
                return this.mCur != SimpleList.this.mPrev;
            }

            @Override
            public E next() {
                this.mPrev = this.mCur;
                this.mCur = this.mCur.mNext;
                return this.mCur.getElem();
            }

            @Override
            public void remove() {
                assert (this.mPrev != null);
                this.mPrev.mNext = this.mCur.mNext;
                this.mCur.mNext.mPrev = this.mPrev;
                this.mCur.mNext = null;
                this.mCur.mPrev = null;
                this.mCur = this.mPrev;
                this.mPrev = null;
            }
        };
    }

    public Iterable<E> reverse() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    SimpleListable<E> mCur;
                    {
                        this.mCur = SimpleList.this.mPrev;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mCur != SimpleList.this;
                    }

                    @Override
                    public E next() {
                        Object data = this.mCur.getElem();
                        this.mCur = this.mCur.mPrev;
                        return data;
                    }

                    @Override
                    public void remove() {
                        this.mCur.mNext = this.mCur.mNext.mNext;
                        this.mCur.mNext.mPrev = this.mCur;
                    }
                };
            }
        };
    }

    public void clear() {
        this.mNext = this.mPrev = this;
    }

    public boolean wellformed() {
        if (this.mNext.mPrev != this) {
            System.err.println("Not in this list!!!!");
            return false;
        }
        SimpleListable entry = this.mNext;
        while (!(entry instanceof SimpleList)) {
            if (entry.mNext.mPrev != entry) {
                System.err.println("Wrong links!!!!");
                return false;
            }
            entry = entry.mNext;
        }
        return entry == this;
    }

    public boolean wellformedPart() {
        SimpleListable entry = this.mNext;
        while (entry != this.mPrev) {
            if (entry instanceof SimpleList) {
                return false;
            }
            if (entry.mNext.mPrev != entry) {
                return false;
            }
            entry = entry.mNext;
        }
        return true;
    }

    public boolean contains(E elem) {
        SimpleListable entry = this.mNext;
        while (entry != this) {
            if (entry.getElem().equals(elem)) {
                return true;
            }
            entry = entry.mNext;
        }
        return false;
    }

    public String toString() {
        if (this.mNext == this) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        if (this.mNext.mPrev != this) {
            sb.append('~');
        }
        sb.append('[');
        SimpleListable entry = this.mNext;
        while (entry != this.mPrev) {
            sb.append(entry).append(",");
            entry = entry.mNext;
        }
        sb.append(entry);
        sb.append(']');
        return sb.toString();
    }

    public SimpleList<E> cloneJoinedList() {
        SimpleList<E> clonedList = new SimpleList<E>();
        clonedList.mNext = this.mNext;
        clonedList.mPrev = this.mPrev;
        if (this.mNext.mPrev == this) {
            this.mNext.mPrev = clonedList;
            this.mPrev.mNext = clonedList;
        }
        return clonedList;
    }
}

