/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.horn;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class HornSolver
extends NoopScript {
    HashMap<FunctionSymbol, ArrayList<HornClause>> mAllClauses = new HashMap();
    Script mBackend = new SMTInterpol();
    private int mClauseCtr = 0;
    private int mCtr = 0;

    public HornSolver() {
        this.mBackend.setOption(":produce-interpolants", Boolean.TRUE);
        this.mBackend.setOption(":verbosity", 2);
    }

    @Override
    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        if (!logic.equals("HORN")) {
            throw new SMTLIBException("No Horn logic");
        }
        super.setLogic(Logics.AUFLIRA);
        this.mBackend.setLogic(Logics.QF_LIA);
    }

    @Override
    public void setOption(String opt, Object value) {
        super.setOption(opt, value);
        this.mBackend.setOption(opt, value);
    }

    @Override
    public void setInfo(String info, Object value) {
        super.setInfo(info, value);
        if (info.equals(":status")) {
            if (value.equals("sat")) {
                this.mBackend.setInfo(info, "unsat");
            } else if (value.equals("unsat")) {
                this.mBackend.setInfo(info, "sat");
            }
        }
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        term = this.toPrenex(term);
        ArrayList<TermVariable> tvList = new ArrayList<TermVariable>();
        while (term instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)term;
            if (qf.getQuantifier() != 1) {
                throw new SMTLIBException("Illegal Horn Clause");
            }
            tvList.addAll(Arrays.asList(qf.getVariables()));
            term = qf.getSubformula();
        }
        term = this.isNegatedTerm(term) ? ((ApplicationTerm)term).getParameters()[0] : this.term("not", term);
        ArrayDeque<Term> todo = new ArrayDeque<Term>();
        ArrayList<Term> literals = new ArrayList<Term>();
        todo.addLast(term);
        while (!todo.isEmpty()) {
            term = (Term)todo.removeFirst();
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                if (appTerm.getFunction().isIntern() && appTerm.getFunction().getName().equals("and")) {
                    todo.addAll(Arrays.asList(appTerm.getParameters()));
                    continue;
                }
                literals.add(term);
                continue;
            }
            literals.add(term);
        }
        ArrayList<Term> phi = new ArrayList<Term>();
        ApplicationTerm head = null;
        ArrayList<ApplicationTerm> body = new ArrayList<ApplicationTerm>();
        for (Term lit : literals) {
            Term neglit;
            if (this.isNegatedTerm(lit) && (neglit = ((ApplicationTerm)lit).getParameters()[0]) instanceof ApplicationTerm && !((ApplicationTerm)neglit).getFunction().isIntern()) {
                if (head != null) {
                    throw new SMTLIBException("Illegal Horn Clause");
                }
                head = (ApplicationTerm)neglit;
                continue;
            }
            if (lit instanceof ApplicationTerm && !((ApplicationTerm)lit).getFunction().isIntern()) {
                body.add((ApplicationTerm)lit);
                continue;
            }
            phi.add(lit);
        }
        if (head == null) {
            head = (ApplicationTerm)this.term("false", new Term[0]);
        }
        this.addHornClause(tvList, head, body, phi);
        return Script.LBool.UNKNOWN;
    }

    private Term toPrenex(Term term) {
        class PrenexTransformer
        extends TermTransformer {
            LinkedHashSet<TermVariable> mTvs = new LinkedHashSet();

            PrenexTransformer() {
            }

            @Override
            public void convert(Term term) {
                while (term instanceof QuantifiedFormula) {
                    QuantifiedFormula qf = (QuantifiedFormula)term;
                    for (TermVariable tv : qf.getVariables()) {
                        if (this.mTvs.contains(tv)) {
                            throw new SMTLIBException("Variable " + tv + " occurs more than once");
                        }
                        this.mTvs.add(tv);
                    }
                    term = qf.getSubformula();
                }
                super.convert(term);
            }
        }
        PrenexTransformer trafo = new PrenexTransformer();
        term = trafo.transform(term);
        if (!trafo.mTvs.isEmpty()) {
            TermVariable[] vars = trafo.mTvs.toArray(new TermVariable[trafo.mTvs.size()]);
            term = this.quantifier(1, vars, term, new Term[0][]);
        }
        return term;
    }

    private void addHornClause(ArrayList<TermVariable> tvList, ApplicationTerm head, ArrayList<ApplicationTerm> body, ArrayList<Term> phi) {
        Term phiAsTerm = phi.size() <= 1 ? (phi.isEmpty() ? this.term("true", new Term[0]) : phi.get(0)) : this.term("and", phi.toArray(new Term[phi.size()]));
        tvList.trimToSize();
        body.trimToSize();
        ArrayList<HornClause> clauses = this.mAllClauses.get(head.getFunction());
        if (clauses == null) {
            clauses = new ArrayList(1);
            this.mAllClauses.put(head.getFunction(), clauses);
        }
        clauses.add(new HornClause(tvList, head, body, phiAsTerm));
    }

    private Term translateToBackend(Term phi) {
        return new TermTransformer(){

            @Override
            public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
                this.setResult(HornSolver.this.mBackend.term(appTerm.getFunction().getName(), newArgs));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void convert(Term term) {
                if (term instanceof TermVariable) {
                    TermVariable tv = (TermVariable)term;
                    Sort sort = HornSolver.this.mBackend.sort(tv.getSort().getName(), new Sort[0]);
                    this.setResult(HornSolver.this.mBackend.variable(tv.getName(), sort));
                    return;
                } else if (term instanceof ConstantTerm) {
                    Object value = ((ConstantTerm)term).getValue();
                    if (value instanceof BigInteger) {
                        this.setResult(HornSolver.this.mBackend.numeral((BigInteger)value));
                        return;
                    } else {
                        if (!(value instanceof BigDecimal)) throw new AssertionError((Object)("Unknown constant: " + value));
                        this.setResult(HornSolver.this.mBackend.decimal((BigDecimal)value));
                    }
                    return;
                } else {
                    super.convert(term);
                }
            }
        }.transform(phi);
    }

    private boolean isNegatedTerm(Term lit) {
        if (!(lit instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm appTerm = (ApplicationTerm)lit;
        return appTerm.getFunction().isIntern() && appTerm.getFunction().getName().equals("not");
    }

    @Override
    public Script.LBool checkSat() {
        FormulaUnLet unletter = new FormulaUnLet();
        ArrayDeque<DerivationTreeNode> todo = new ArrayDeque<DerivationTreeNode>();
        DerivationTreeNode root = new DerivationTreeNode((ApplicationTerm)this.term("false", new Term[0]));
        todo.add(root);
        while (!todo.isEmpty()) {
            DerivationTreeNode n = (DerivationTreeNode)todo.removeFirst();
            ApplicationTerm head = n.mTerm;
            ArrayList<HornClause> hclist = this.mAllClauses.get(head.getFunction());
            if (hclist.size() > 1) {
                System.err.println("Cannot solve disjunctive Horn Clauses, yet");
                return Script.LBool.UNKNOWN;
            }
            HornClause hc = hclist.get(0);
            TermVariable[] tvs = hc.mTvs.toArray(new TermVariable[hc.mTvs.size()]);
            Term[] freshConstants = this.createConstants(tvs);
            Term[] headParam = head.getParameters();
            Term[] hcheadParam = hc.mHead.getParameters();
            Term[] eqs = new Term[headParam.length + 1];
            eqs[0] = hc.mPhi;
            for (int i = 0; i < head.getParameters().length; ++i) {
                eqs[i + 1] = this.term("=", new Term[]{headParam[i], hcheadParam[i]});
            }
            Term term = eqs.length > 1 ? this.term("and", eqs) : eqs[0];
            term = this.let(tvs, freshConstants, term);
            term = unletter.transform(term);
            term = this.translateToBackend(term);
            String name = "X" + this.mClauseCtr++;
            term = this.mBackend.annotate(term, new Annotation(":named", name));
            this.mBackend.assertTerm(term);
            n.setName(this.mBackend.term(name, new Term[0]));
            n.initChildren(hc.mBody.size());
            int i = 0;
            for (ApplicationTerm appTerm : hc.mBody) {
                term = unletter.transform(this.let(tvs, freshConstants, appTerm));
                todo.add(n.addChild(i++, (ApplicationTerm)term));
            }
        }
        long nanotime = System.nanoTime();
        Script.LBool result = this.mBackend.checkSat();
        System.err.println("SAT Check Time: " + (System.nanoTime() - nanotime));
        if (result == Script.LBool.UNSAT) {
            ArrayList<Term> partition = new ArrayList<Term>();
            ArrayList<Integer> startOfSubtree = new ArrayList<Integer>();
            root.postOrderTraverse(partition, startOfSubtree);
            int[] sos = new int[startOfSubtree.size()];
            int pos = 0;
            for (Integer i : startOfSubtree) {
                sos[pos++] = i;
            }
            try {
                nanotime = System.nanoTime();
                Term[] solution = this.mBackend.getInterpolants(partition.toArray(new Term[partition.size()]), sos);
                System.err.println("Interpolation Time: " + (System.nanoTime() - nanotime));
                root.printSolution(solution);
            }
            catch (SMTLIBException ese) {
                System.err.println(ese);
                System.exit(1);
            }
        }
        return result == Script.LBool.SAT ? Script.LBool.UNSAT : Script.LBool.SAT;
    }

    private Term[] createConstants(TermVariable[] tvs) {
        Term[] values = new Term[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            String name = "x" + this.mCtr++;
            Sort sort = tvs[i].getSort();
            this.declareFun(name, new Sort[0], sort);
            Sort bsort = this.mBackend.sort(sort.getName(), new Sort[0]);
            this.mBackend.declareFun(name, new Sort[0], bsort);
            values[i] = this.term(name, new Term[0]);
        }
        return values;
    }

    @Override
    public void reset() {
        super.reset();
        this.mBackend.reset();
        this.mAllClauses.clear();
        this.mCtr = 0;
        this.mClauseCtr = 0;
    }

    class DerivationTreeNode {
        ApplicationTerm mTerm;
        Term mName;
        DerivationTreeNode[] mChildren;

        public DerivationTreeNode(ApplicationTerm term) {
            this.mTerm = term;
        }

        public void setName(Term name) {
            this.mName = name;
        }

        public void initChildren(int size) {
            this.mChildren = new DerivationTreeNode[size];
        }

        public DerivationTreeNode addChild(int pos, ApplicationTerm term) {
            assert (this.mChildren[pos] == null);
            this.mChildren[pos] = new DerivationTreeNode(term);
            return this.mChildren[pos];
        }

        public int postOrderTraverse(ArrayList<Term> partition, ArrayList<Integer> startOfSubtree) {
            int pos = partition.size();
            if (this.mChildren.length > 0) {
                pos = this.mChildren[0].postOrderTraverse(partition, startOfSubtree);
                for (int i = 1; i < this.mChildren.length; ++i) {
                    this.mChildren[i].postOrderTraverse(partition, startOfSubtree);
                }
            }
            partition.add(this.mName);
            startOfSubtree.add(pos);
            return pos;
        }

        public void printSolution(Term[] solution) {
            this.printSolutionRec(solution, 0);
        }

        private int printSolutionRec(Term[] solution, int offset) {
            for (DerivationTreeNode n : this.mChildren) {
                offset += n.printSolutionRec(solution, offset);
            }
            System.err.print(this.mTerm);
            System.err.print(" = ");
            System.err.println(offset >= solution.length ? "false" : solution[offset]);
            SMTInterpol backend = (SMTInterpol)HornSolver.this.mBackend;
            SimplifyDDA simp = new SimplifyDDA(new SMTInterpol(backend, Collections.singletonMap(":check-type", "quick"), OptionMap.CopyMode.CURRENT_VALUE));
            if (offset < solution.length) {
                System.err.println("size: " + new DAGSize().size(solution[offset]));
                Term simplified = simp.getSimplifiedTerm(solution[offset]);
                System.err.println("simplified: " + simplified);
                System.err.println("simpsize: " + new DAGSize().size(simplified));
            }
            return offset + 1;
        }
    }

    class HornClause {
        List<TermVariable> mTvs;
        ApplicationTerm mHead;
        List<ApplicationTerm> mBody;
        Term mPhi;

        public HornClause(List<TermVariable> tvs, ApplicationTerm head, List<ApplicationTerm> body, Term phi) {
            this.mTvs = tvs;
            this.mHead = head;
            this.mBody = body;
            this.mPhi = phi;
        }
    }
}

