/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ArrayInterpolator {
    private final Interpolator mInterpolator;
    private final Theory mTheory;
    private final int mNumInterpolants;
    private Set<Term>[] mInterpolants;
    private InterpolatorClauseInfo mLemmaInfo;
    private Term mDiseq;
    private Interpolator.LitInfo mDiseqInfo;
    private Map<SymmetricPair<Term>, Term> mEqualities;
    private Map<SymmetricPair<Term>, Term> mDisequalities;
    private ProofPath mStorePath;
    private Interpolator.Occurrence mABSwitchOccur;
    private Term mIndexEquality;
    private Map<Term, ProofPath> mIndexPaths;
    private Map<Term, WeakPathInfo> mIndexPathInfos;
    private Map<Term, WeakPathInfo> mRecIndexPathInfos;
    private Term[] mRewriteSide;
    private TermVariable mRecursionVar;
    private TermVariable mDoubleDot;

    public ArrayInterpolator(Interpolator ipolator) {
        this.mInterpolator = ipolator;
        this.mTheory = ipolator.mTheory;
        this.mNumInterpolants = ipolator.mNumInterpolants;
        this.mInterpolants = new Set[this.mNumInterpolants];
        for (int i = 0; i < this.mNumInterpolants; ++i) {
            this.mInterpolants[i] = new HashSet<Term>();
        }
    }

    private ApplicationTerm getDiseq(InterpolatorClauseInfo clauseInfo) {
        Object[] annotations = (Object[])clauseInfo.getLemmaAnnotation();
        assert (annotations.length % 2 == 1);
        ApplicationTerm diseq = (ApplicationTerm)annotations[0];
        assert (diseq.getFunction().getName().equals("="));
        return diseq;
    }

    private ProofPath[] getPaths(InterpolatorClauseInfo clauseInfo) {
        Object[] annotations = (Object[])clauseInfo.getLemmaAnnotation();
        assert (annotations.length % 2 == 1);
        int length = (annotations.length - 1) / 2;
        ProofPath[] paths = new ProofPath[length];
        for (int i = 0; i < length; ++i) {
            int j = 2 * i + 1;
            String type = (String)annotations[j];
            Object path = annotations[j + 1];
            paths[i] = new ProofPath(type, path);
        }
        return paths;
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo lemmaInfo) {
        this.mLemmaInfo = lemmaInfo;
        this.mEqualities = new HashMap<SymmetricPair<Term>, Term>();
        this.mDisequalities = new HashMap<SymmetricPair<Term>, Term>();
        this.mABSwitchOccur = new Interpolator.Occurrence(this.mInterpolator);
        for (Term literal : this.mLemmaInfo.getLiterals()) {
            Term atom = this.mInterpolator.getAtom(literal);
            InterpolatorAtomInfo atomTermInfo = this.mInterpolator.getAtomTermInfo(atom);
            ApplicationTerm equality = atomTermInfo.getEquality();
            Map<SymmetricPair<Term>, Term> map = atom != literal ? this.mEqualities : this.mDisequalities;
            map.put(new SymmetricPair<Term>(equality.getParameters()[0], equality.getParameters()[1]), atom);
        }
        ApplicationTerm equality = this.getDiseq(this.mLemmaInfo);
        Term[] eqParams = equality.getParameters();
        this.mDiseq = this.mDisequalities.get(new SymmetricPair<Term>(eqParams[0], eqParams[1]));
        this.mDiseqInfo = this.mInterpolator.getAtomOccurenceInfo(this.mDiseq);
        Term[] interpolants = new Term[this.mNumInterpolants];
        if (this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq")) {
            interpolants = this.computeReadOverWeakeqInterpolants();
        } else if (this.mLemmaInfo.getLemmaType().equals(":weakeq-ext")) {
            interpolants = this.computeWeakeqExtInterpolants();
        } else if (this.mLemmaInfo.getLemmaType().equals(":const-weakeq")) {
            interpolants = this.computeConstWeakeqInterpolants();
        } else {
            assert (this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq")) : "Unknown array lemma!";
            interpolants = this.computeReadConstWeakeqInterpolants();
        }
        FormulaUnLet unletter = new FormulaUnLet();
        for (int i = 0; i < this.mNumInterpolants; ++i) {
            interpolants[i] = unletter.unlet(interpolants[i]);
        }
        return interpolants;
    }

    private Term[] computeReadOverWeakeqInterpolants() {
        Term rightIndex;
        ProofPath[] paths = this.getPaths(this.mLemmaInfo);
        assert (paths.length == 1);
        this.mStorePath = paths[0];
        assert (this.mDiseq != null);
        ApplicationTerm selectEq = (ApplicationTerm)this.mDiseq;
        assert (selectEq.getFunction().getName().equals("=") && selectEq.getParameters()[0] instanceof ApplicationTerm && selectEq.getParameters()[1] instanceof ApplicationTerm && ((ApplicationTerm)selectEq.getParameters()[0]).getFunction().getName().equals("select") && ((ApplicationTerm)selectEq.getParameters()[1]).getFunction().getName().equals("select"));
        Term leftIndex = ((ApplicationTerm)selectEq.getParameters()[0]).getParameters()[1];
        if (leftIndex != (rightIndex = ((ApplicationTerm)selectEq.getParameters()[1]).getParameters()[1])) {
            this.mIndexEquality = this.mEqualities.get(new SymmetricPair<Term>(leftIndex, rightIndex));
            assert (this.mIndexEquality != null);
        }
        WeakPathInfo arrayPath = new WeakPathInfo(this.mStorePath);
        this.determineInterpolationColor();
        arrayPath.mSharedIndex = this.findSharedTerms(this.mStorePath.getIndex());
        this.mInterpolants = arrayPath.interpolateWeakPathInfo(true);
        if (this.mIndexEquality != null) {
            this.addIndexEqualityReadOverWeakeq(arrayPath);
        }
        Term[] interpolants = new Term[this.mNumInterpolants];
        for (int color = 0; color < this.mNumInterpolants; ++color) {
            if (this.mABSwitchOccur.isALocal(color)) {
                assert (this.mDiseqInfo.isALocal(color));
                interpolants[color] = this.mTheory.or(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()]));
                continue;
            }
            interpolants[color] = this.mTheory.and(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()]));
        }
        return interpolants;
    }

    private Term[] computeWeakeqExtInterpolants() {
        ProofPath[] paths = this.getPaths(this.mLemmaInfo);
        this.mStorePath = paths[0];
        this.mIndexPaths = new HashMap<Term, ProofPath>();
        this.mIndexPathInfos = new HashMap<Term, WeakPathInfo>();
        for (int i = 1; i < paths.length; ++i) {
            if (paths[i].getIndex() == null) continue;
            this.mIndexPaths.put(paths[i].getIndex(), paths[i]);
        }
        this.mDoubleDot = this.mTheory.createFreshTermVariable("ddot", this.mIndexPaths.keySet().iterator().next().getSort());
        if (this.mDiseqInfo.getMixedVar() != null) {
            this.mRewriteSide = new Term[this.mNumInterpolants];
            this.mRecursionVar = this.mTheory.createFreshTermVariable("recursive", this.mStorePath.getPath()[0].getSort());
            this.mRecIndexPathInfos = new HashMap<Term, WeakPathInfo>();
        } else {
            this.determineInterpolationColor();
        }
        WeakPathInfo mainPath = new WeakPathInfo(this.mStorePath);
        mainPath.collectStorePaths();
        this.mInterpolants = mainPath.interpolateStorePathInfoExt();
        Term[] interpolants = new Term[this.mNumInterpolants];
        for (int color = 0; color < this.mNumInterpolants; ++color) {
            if (!this.mDiseqInfo.isMixed(color)) {
                if (this.mDiseqInfo.isALocal(color)) {
                    interpolants[color] = this.mTheory.or(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()]));
                    continue;
                }
                interpolants[color] = this.mTheory.and(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()]));
                continue;
            }
            assert (this.mInterpolants[color].size() == 1);
            interpolants[color] = this.mInterpolants[color].iterator().next();
        }
        return interpolants;
    }

    private Term[] computeConstWeakeqInterpolants() {
        ProofPath[] paths = this.getPaths(this.mLemmaInfo);
        assert (paths.length == 1);
        this.mStorePath = paths[0];
        if (this.mDiseqInfo.getMixedVar() != null) {
            this.mRewriteSide = new Term[this.mNumInterpolants];
        } else {
            this.determineInterpolationColor();
        }
        WeakPathInfo arrayPath = new WeakPathInfo(this.mStorePath);
        arrayPath.collectStorePaths();
        this.mInterpolants = arrayPath.interpolateStorePathInfoConst();
        Term[] interpolants = new Term[this.mNumInterpolants];
        for (int color = 0; color < this.mNumInterpolants; ++color) {
            interpolants[color] = this.mABSwitchOccur.isALocal(color) ? this.mTheory.or(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()])) : this.mTheory.and(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()]));
        }
        return interpolants;
    }

    private Term[] computeReadConstWeakeqInterpolants() {
        ProofPath[] paths = this.getPaths(this.mLemmaInfo);
        assert (paths.length == 1);
        this.mStorePath = paths[0];
        WeakPathInfo arrayPath = new WeakPathInfo(this.mStorePath);
        this.determineInterpolationColor();
        Term weakeqIndex = this.mStorePath.getIndex();
        for (int color = 0; color < this.mNumInterpolants; ++color) {
            Interpolator.Occurrence indexOccur = this.mInterpolator.getOccurrence(weakeqIndex);
            if (!indexOccur.isAB(color)) continue;
            arrayPath.mSharedIndex[color] = weakeqIndex;
        }
        this.mInterpolants = arrayPath.interpolateWeakPathInfo(true);
        Term[] interpolants = new Term[this.mNumInterpolants];
        for (int color = 0; color < this.mNumInterpolants; ++color) {
            interpolants[color] = this.mABSwitchOccur.isALocal(color) ? this.mTheory.or(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()])) : this.mTheory.and(this.mInterpolants[color].toArray(new Term[this.mInterpolants[color].size()]));
        }
        return interpolants;
    }

    private void determineInterpolationColor() {
        int color = this.mNumInterpolants;
        if (this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq") || this.mDiseqInfo.getMixedVar() == null) {
            int child;
            while ((child = this.getChild(color, this.mDiseqInfo)) >= 0) {
                assert (this.mDiseqInfo.isALocal(child));
                color = child;
            }
        } else if (this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq")) {
            int child;
            Term select;
            InterpolatorAtomInfo diseqInfo = this.mInterpolator.getAtomTermInfo(this.mDiseq);
            ApplicationTerm mainDiseqApp = diseqInfo.getEquality();
            Term left = mainDiseqApp.getParameters()[0];
            Term right = mainDiseqApp.getParameters()[1];
            if (left instanceof ApplicationTerm && ((ApplicationTerm)left).getFunction().getName().equals("select")) {
                select = left;
            } else {
                assert (right instanceof ApplicationTerm && ((ApplicationTerm)right).getFunction().getName().equals("select"));
                select = right;
            }
            Interpolator.Occurrence selectInfo = this.mInterpolator.getOccurrence(select);
            while ((child = this.getChild(color, selectInfo)) >= 0) {
                assert (selectInfo.isALocal(child));
                color = child;
            }
        } else {
            color = 0;
            while (!this.mDiseqInfo.isALocal(color)) {
                if (this.mDiseqInfo.isMixed(color)) {
                    assert (this.mRewriteSide[color] != null);
                    Interpolator.Occurrence rewriteInfo = this.mInterpolator.getOccurrence(this.mRewriteSide[color]);
                    if (rewriteInfo.isALocal(color)) {
                        ++color;
                        continue;
                    }
                    break;
                }
                ++color;
            }
        }
        this.mABSwitchOccur.occursIn(color);
    }

    private Term[] findSharedTerms(Term term) {
        Term[] sharedTerms = new Term[this.mNumInterpolants];
        Interpolator.Occurrence termOccur = this.mInterpolator.getOccurrence(term);
        int sharedTermCounter = 0;
        for (int color = 0; color < this.mNumInterpolants; ++color) {
            if (!termOccur.isAB(color)) continue;
            sharedTerms[color] = term;
            ++sharedTermCounter;
        }
        if (sharedTermCounter == this.mNumInterpolants) {
            return sharedTerms;
        }
        for (SymmetricPair<Term> eq : this.mEqualities.keySet()) {
            if (sharedTermCounter == this.mNumInterpolants) {
                return sharedTerms;
            }
            if (!eq.getFirst().equals(term) && !eq.getSecond().equals(term)) continue;
            Interpolator.LitInfo eqInfo = this.mInterpolator.getAtomOccurenceInfo(this.mEqualities.get(eq));
            for (int color = 0; color < this.mNumInterpolants; ++color) {
                Term otherTerm;
                Interpolator.Occurrence otherOccur;
                if (eqInfo.isMixed(color)) {
                    sharedTerms[color] = eqInfo.getMixedVar();
                    continue;
                }
                if (sharedTerms[color] != null || !(otherOccur = this.mInterpolator.getOccurrence(otherTerm = eq.getFirst().equals(term) ? eq.getSecond() : eq.getFirst())).isAB(color)) continue;
                sharedTerms[color] = otherTerm;
            }
        }
        return sharedTerms;
    }

    private void addIndexEqualityReadOverWeakeq(WeakPathInfo mainPath) {
        Interpolator.LitInfo indexEqInfo = this.mInterpolator.getAtomOccurenceInfo(this.mIndexEquality);
        InterpolatorAtomInfo diseqInfo = this.mInterpolator.getAtomTermInfo(this.mDiseq);
        ApplicationTerm mainDiseqApp = diseqInfo.getEquality();
        Term otherIndex = ArrayInterpolator.getIndexFromSelect(mainDiseqApp.getParameters()[0]).equals(this.mStorePath.getIndex()) ? ArrayInterpolator.getIndexFromSelect(mainDiseqApp.getParameters()[1]) : ArrayInterpolator.getIndexFromSelect(mainDiseqApp.getParameters()[0]);
        Interpolator.Occurrence otherIndexOccur = this.mInterpolator.getOccurrence(otherIndex);
        for (int color = 0; color < this.mNumInterpolants; ++color) {
            if (mainPath.mSharedIndex[color] == null || mainPath.mSharedIndex[color] != this.mStorePath.getIndex()) continue;
            if (this.mDiseqInfo.isALocal(color) && indexEqInfo.isBLocal(color)) {
                this.mInterpolants[color].add(this.mTheory.not(this.mIndexEquality));
                continue;
            }
            if (this.mDiseqInfo.isALocal(color) || !indexEqInfo.isALocal(color) || !otherIndexOccur.isAB(color)) continue;
            this.mInterpolants[color].add(this.mIndexEquality);
        }
    }

    private int getParent(int color) {
        int parent = color + 1;
        while (this.mInterpolator.mStartOfSubtrees[parent] > color) {
            ++parent;
        }
        return parent;
    }

    private int getChild(int color, Interpolator.Occurrence occur) {
        int child = color - 1;
        while (child >= this.mInterpolator.mStartOfSubtrees[color]) {
            if (occur.isALocal(child)) {
                return child;
            }
            child = this.mInterpolator.mStartOfSubtrees[child] - 1;
        }
        return -1;
    }

    private static boolean isSelectTerm(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("select");
        }
        return false;
    }

    private static boolean isStoreTerm(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("store");
        }
        return false;
    }

    private static boolean isConstArray(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("const");
        }
        return false;
    }

    private static Term getArrayFromSelect(Term select) {
        assert (ArrayInterpolator.isSelectTerm(select));
        return ((ApplicationTerm)select).getParameters()[0];
    }

    private static Term getIndexFromSelect(Term select) {
        assert (ArrayInterpolator.isSelectTerm(select));
        return ((ApplicationTerm)select).getParameters()[1];
    }

    private static Term getArrayFromStore(Term store) {
        assert (ArrayInterpolator.isStoreTerm(store));
        return ((ApplicationTerm)store).getParameters()[0];
    }

    private static Term getIndexFromStore(Term store) {
        assert (ArrayInterpolator.isStoreTerm(store));
        return ((ApplicationTerm)store).getParameters()[1];
    }

    private static Term getValueFromConst(Term constArr) {
        assert (ArrayInterpolator.isConstArray(constArr));
        return ((ApplicationTerm)constArr).getParameters()[0];
    }

    private Term buildConst(Term value, Sort arraySort) {
        FunctionSymbol fsym = this.mTheory.getFunctionWithResult("const", null, arraySort, value.getSort());
        return this.mTheory.term(fsym, value);
    }

    private Term buildSelectEq(Term left, Term right, Term index) {
        if (left.equals(this.mDiseq)) {
            return this.mTheory.term("@EQ", this.mDiseqInfo.getMixedVar(), this.buildSelect(right, index));
        }
        if (right.equals(this.mDiseq)) {
            return this.mTheory.term("@EQ", this.mDiseqInfo.getMixedVar(), this.buildSelect(left, index));
        }
        Term leftSelect = this.buildSelect(left, index);
        Term rightSelect = this.buildSelect(right, index);
        return this.mTheory.equals(leftSelect, rightSelect);
    }

    private Term buildSelect(Term term, Term index) {
        Term select;
        if (this.mEqualities.containsValue(term)) {
            Interpolator.LitInfo selectInfo = this.mInterpolator.getAtomOccurenceInfo(term);
            select = selectInfo.getMixedVar();
        } else {
            select = ArrayInterpolator.isConstArray(term) ? ArrayInterpolator.getValueFromConst(term) : this.mTheory.term("select", term, index);
        }
        return select;
    }

    private Term buildWeqTerm(Term left, Term right, int order, Term formula, TermVariable auxVar) {
        Term rewrite = left;
        Term weqTerm = this.mTheory.mTrue;
        for (int m = 0; m < order; ++m) {
            Term arrayEquality = this.mTheory.equals(rewrite, right);
            Term diffTerm = this.mTheory.term("@diff", rewrite, right);
            Term fTerm = this.mTheory.let(auxVar, diffTerm, formula);
            weqTerm = this.mTheory.and(weqTerm, this.mTheory.or(arrayEquality, fTerm));
            rewrite = this.mTheory.term("store", rewrite, diffTerm, this.buildSelect(right, diffTerm));
        }
        weqTerm = this.mTheory.and(weqTerm, this.mTheory.equals(rewrite, right));
        return weqTerm;
    }

    private Term buildNweqTerm(Term left, Term right, int order, Term formula, TermVariable auxVar) {
        Term rewrite = left;
        Term nweqTerm = this.mTheory.mFalse;
        for (int m = 0; m < order; ++m) {
            Term arrayDisequality = this.mTheory.not(this.mTheory.equals(rewrite, right));
            Term diffTerm = this.mTheory.term("@diff", rewrite, right);
            Term fTerm = this.mTheory.let(auxVar, diffTerm, formula);
            nweqTerm = this.mTheory.or(nweqTerm, this.mTheory.and(arrayDisequality, fTerm));
            rewrite = this.mTheory.term("store", rewrite, diffTerm, this.buildSelect(right, diffTerm));
        }
        nweqTerm = this.mTheory.or(nweqTerm, this.mTheory.not(this.mTheory.equals(rewrite, right)));
        return nweqTerm;
    }

    private Term buildConstPathInterpolant(boolean isAPath, Term sharedArr, Set<Term> sharedIndices, TermVariable auxVar, int order, Term fPi) {
        TermVariable vTilde = this.mTheory.createFreshTermVariable("vTilde", this.mDiseqInfo.getMixedVar().getSort());
        Term eqTerm = this.mTheory.term("@EQ", this.mDiseqInfo.getMixedVar(), vTilde);
        Term itpClause = isAPath ? this.buildWeqTerm(this.buildConst(vTilde, sharedArr.getSort()), sharedArr, order, fPi, auxVar) : this.buildNweqTerm(this.buildConst(vTilde, sharedArr.getSort()), sharedArr, order, fPi, auxVar);
        Term itpVTilde = isAPath ? this.mTheory.and(eqTerm, itpClause) : this.mTheory.or(eqTerm, itpClause);
        Term searchIdx = this.mTheory.term("@diff", sharedArr, sharedArr);
        Term searchVal = this.buildSelect(sharedArr, searchIdx);
        Term searchArr = this.buildConst(searchVal, sharedArr.getSort());
        for (Term idx : sharedIndices) {
            searchArr = this.mTheory.term("store", searchArr, idx, this.buildSelect(sharedArr, idx));
        }
        Term constPathItp = this.mTheory.let(vTilde, searchVal, itpVTilde);
        for (int i = 0; i < order; ++i) {
            searchIdx = this.mTheory.term("@diff", searchArr, sharedArr);
            searchVal = this.buildSelect(sharedArr, searchIdx);
            constPathItp = isAPath ? this.mTheory.or(constPathItp, this.mTheory.let(vTilde, searchVal, itpVTilde)) : this.mTheory.and(constPathItp, this.mTheory.let(vTilde, searchVal, itpVTilde));
            searchArr = this.mTheory.term("store", searchArr, searchIdx, this.buildSelect(sharedArr, searchIdx));
        }
        return constPathItp;
    }

    private class StorePath {
        final Term mLeft;
        final Term mRight;
        final Set<Term> mStores;
        final boolean mIsAPath;

        public StorePath(Term left, Term right, Set<Term> stores, boolean isAPath) {
            this.mLeft = left;
            this.mRight = right;
            this.mStores = stores;
            this.mIsAPath = isAPath;
        }
    }

    class WeakPathInfo {
        Term mPathIndex;
        Term[] mSharedIndex;
        Term[] mPath;
        BitSet mHasABPath;
        int mMaxColor;
        WeakPathEnd mHead;
        WeakPathEnd mTail;
        private final Set<Term>[] mPathInterpolants;
        private Vector<Term> mStores;
        private Vector<StorePath>[] mStorePaths;

        public WeakPathInfo(ProofPath path) {
            this.mPathIndex = path.getIndex();
            this.mSharedIndex = new Term[ArrayInterpolator.this.mNumInterpolants];
            this.mPath = path.getPath();
            this.mHasABPath = new BitSet(ArrayInterpolator.this.mNumInterpolants);
            this.mHasABPath.set(0, ArrayInterpolator.this.mNumInterpolants);
            this.mMaxColor = ArrayInterpolator.this.mNumInterpolants;
            this.mPathInterpolants = new Set[ArrayInterpolator.this.mNumInterpolants];
            for (int i = 0; i < ArrayInterpolator.this.mNumInterpolants; ++i) {
                this.mPathInterpolants[i] = new HashSet<Term>();
            }
        }

        public Set<Term>[] interpolateWeakPathInfo(boolean close) {
            Term tailTerm;
            Term headTerm;
            this.mHead = new WeakPathEnd();
            this.mTail = new WeakPathEnd();
            String lemmaType = ArrayInterpolator.this.mLemmaInfo.getLemmaType();
            if (lemmaType.equals(":read-over-weakeq") || lemmaType.equals(":read-const-weakeq")) {
                InterpolatorAtomInfo diseqInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(ArrayInterpolator.this.mDiseq);
                Term[] diseqTerms = diseqInfo.getEquality().getParameters();
                if (ArrayInterpolator.isSelectTerm(diseqTerms[0]) && ArrayInterpolator.getArrayFromSelect(diseqTerms[0]).equals(this.mPath[0]) || ArrayInterpolator.isConstArray(this.mPath[0]) && ArrayInterpolator.getValueFromConst(this.mPath[0]).equals(diseqTerms[0])) {
                    headTerm = diseqTerms[0];
                    tailTerm = diseqTerms[1];
                } else {
                    headTerm = diseqTerms[1];
                    tailTerm = diseqTerms[0];
                }
            } else {
                assert (lemmaType.equals(":weakeq-ext"));
                headTerm = this.mPath[0];
                tailTerm = this.mPath[this.mPath.length - 1];
            }
            Interpolator.Occurrence headOccur = ArrayInterpolator.this.mInterpolator.getOccurrence(headTerm);
            Interpolator.Occurrence tailOccur = ArrayInterpolator.this.mInterpolator.getOccurrence(tailTerm);
            this.mTail.closeAPath(this.mHead, null, headOccur);
            this.mTail.openAPath(this.mHead, null, headOccur);
            for (int i = 0; i < this.mPath.length - 1; ++i) {
                Term left = this.mPath[i];
                Term right = this.mPath[i + 1];
                Term lit = (Term)ArrayInterpolator.this.mEqualities.get(new SymmetricPair<Term>(left, right));
                Term boundaryTerm = left;
                if (lit == null) {
                    if (ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":weakeq-ext") && this.checkAndAddSelectEdgeStep(left, right)) continue;
                    this.addStoreEdgeStep(left, right);
                    continue;
                }
                Interpolator.LitInfo stepInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(lit);
                this.mTail.closeAPath(this.mHead, boundaryTerm, stepInfo);
                this.mTail.openAPath(this.mHead, boundaryTerm, stepInfo);
                if (stepInfo.getMixedVar() == null) continue;
                Interpolator.Occurrence occ = ArrayInterpolator.this.mInterpolator.getOccurrence(right);
                boundaryTerm = stepInfo.getMixedVar();
                this.mTail.closeAPath(this.mHead, boundaryTerm, occ);
                this.mTail.openAPath(this.mHead, boundaryTerm, occ);
            }
            this.mTail.closeAPath(this.mHead, this.mPath[this.mPath.length - 1], tailOccur);
            this.mTail.openAPath(this.mHead, this.mPath[this.mPath.length - 1], tailOccur);
            if (close) {
                this.addDiseq(headOccur, tailOccur);
                this.closeWeakPath();
            } else {
                this.closeWeakPath();
            }
            return this.mPathInterpolants;
        }

        private void addStoreEdgeStep(Term left, Term right) {
            Term arrayTerm;
            Term storeTerm;
            if (ArrayInterpolator.isStoreTerm(left) && ArrayInterpolator.getArrayFromStore(left).equals(right)) {
                storeTerm = left;
                arrayTerm = right;
            } else {
                storeTerm = right;
                arrayTerm = left;
            }
            assert (ArrayInterpolator.getArrayFromStore(storeTerm).equals(arrayTerm));
            Term boundaryTerm = left;
            Interpolator.Occurrence stepOcc = ArrayInterpolator.this.mInterpolator.getOccurrence(storeTerm);
            Term storeIndex = ArrayInterpolator.getIndexFromStore(storeTerm);
            Term indexDiseq = (Term)ArrayInterpolator.this.mDisequalities.get(new SymmetricPair<Term>(storeIndex, this.mPathIndex));
            if (indexDiseq != null) {
                Interpolator.LitInfo indexDiseqOcc = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(indexDiseq);
                Interpolator.Occurrence intersectOcc = stepOcc.intersect(indexDiseqOcc);
                this.mTail.closeAPath(this.mHead, boundaryTerm, stepOcc);
                this.mTail.closeAPath(this.mHead, boundaryTerm, intersectOcc);
                this.mTail.openAPath(this.mHead, boundaryTerm, intersectOcc);
                this.mTail.openAPath(this.mHead, boundaryTerm, stepOcc);
                this.mTail.addIndexDisequality(this.mHead, indexDiseq);
            } else {
                this.mTail.closeAPath(this.mHead, boundaryTerm, stepOcc);
                this.mTail.openAPath(this.mHead, boundaryTerm, stepOcc);
            }
        }

        private boolean checkAndAddSelectEdgeStep(Term left, Term right) {
            MatchingSelectEquality match = this.findSelectEquality(left, right);
            if (match == null) {
                return false;
            }
            Term selectEq = match.mEqualityLit;
            InterpolatorAtomInfo termInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(selectEq);
            Interpolator.LitInfo stepInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(selectEq);
            ApplicationTerm selectEqApp = termInfo.getEquality();
            Term leftSelectOrValue = selectEqApp.getParameters()[match.mIsSwapped ? 1 : 0];
            Term rightSelectOrValue = selectEqApp.getParameters()[match.mIsSwapped ? 0 : 1];
            Term boundaryTerm = left;
            this.mTail.closeAPath(this.mHead, boundaryTerm, stepInfo);
            this.mTail.openAPath(this.mHead, boundaryTerm, stepInfo);
            TermVariable mixedVar = stepInfo.getMixedVar();
            if (mixedVar != null) {
                Interpolator.Occurrence leftOcc = ArrayInterpolator.this.mInterpolator.getOccurrence(leftSelectOrValue);
                this.mTail.closeAPath(this.mHead, boundaryTerm, leftOcc);
                this.mTail.openAPath(this.mHead, boundaryTerm, leftOcc);
            }
            if (!match.mIsConstLeft) {
                this.mTail.addSelectIndexEquality(this.mHead, leftSelectOrValue);
            }
            if (mixedVar != null) {
                Interpolator.Occurrence rightOcc = ArrayInterpolator.this.mInterpolator.getOccurrence(rightSelectOrValue);
                boundaryTerm = match.mIsConstLeft || match.mIsConstRight ? ArrayInterpolator.this.buildConst(mixedVar, left.getSort()) : selectEq;
                this.mTail.closeAPath(this.mHead, boundaryTerm, rightOcc);
                this.mTail.openAPath(this.mHead, boundaryTerm, rightOcc);
            }
            if (!match.mIsConstRight) {
                this.mTail.addSelectIndexEquality(this.mHead, rightSelectOrValue);
            }
            return true;
        }

        public void collectStorePaths() {
            Object right;
            Object left;
            this.mStores = new Vector();
            this.mStorePaths = new Vector[ArrayInterpolator.this.mNumInterpolants];
            for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                this.mStorePaths[color] = new Vector();
            }
            this.mHead = new WeakPathEnd();
            this.mTail = new WeakPathEnd();
            Term headArray = this.mPath[0];
            Term tailArray = this.mPath[this.mPath.length - 1];
            Interpolator.Occurrence headOccur = ArrayInterpolator.this.mInterpolator.getOccurrence(headArray);
            Interpolator.Occurrence tailOccur = ArrayInterpolator.this.mInterpolator.getOccurrence(tailArray);
            this.mTail.closeAPath(this.mHead, null, headOccur);
            this.mTail.openAPath(this.mHead, null, headOccur);
            for (int i = 0; i < this.mPath.length - 1; ++i) {
                left = this.mPath[i];
                right = this.mPath[i + 1];
                Term lit = (Term)ArrayInterpolator.this.mEqualities.get(new SymmetricPair<Term>((Term)left, (Term)right));
                Term boundaryTerm = left;
                if (lit == null) {
                    Term arrayTerm;
                    Term storeTerm;
                    if (ArrayInterpolator.isStoreTerm((Term)left) && ArrayInterpolator.getArrayFromStore((Term)left).equals(right)) {
                        storeTerm = left;
                        arrayTerm = right;
                    } else {
                        storeTerm = right;
                        arrayTerm = left;
                    }
                    assert (ArrayInterpolator.getArrayFromStore(storeTerm).equals(arrayTerm));
                    Term storeIndex = ArrayInterpolator.getIndexFromStore(storeTerm);
                    Interpolator.Occurrence stepOcc = ArrayInterpolator.this.mInterpolator.getOccurrence(storeTerm);
                    this.mTail.closeAPath(this.mHead, boundaryTerm, stepOcc);
                    this.mTail.openAPath(this.mHead, boundaryTerm, stepOcc);
                    this.mTail.addMainStoreIndex(this.mHead, storeIndex);
                    this.mStores.add(storeIndex);
                    continue;
                }
                Interpolator.LitInfo stepInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(lit);
                this.mTail.closeAPath(this.mHead, boundaryTerm, stepInfo);
                this.mTail.openAPath(this.mHead, boundaryTerm, stepInfo);
                if (stepInfo.getMixedVar() == null) continue;
                Interpolator.Occurrence occ = ArrayInterpolator.this.mInterpolator.getOccurrence((Term)right);
                boundaryTerm = stepInfo.getMixedVar();
                this.mTail.closeAPath(this.mHead, boundaryTerm, occ);
                this.mTail.openAPath(this.mHead, boundaryTerm, occ);
            }
            this.mTail.closeAPath(this.mHead, this.mPath[this.mPath.length - 1], tailOccur);
            this.mTail.openAPath(this.mHead, this.mPath[this.mPath.length - 1], tailOccur);
            this.addDiseq(headOccur, tailOccur);
            this.closeWeakeqExt(headOccur, tailOccur);
            if (ArrayInterpolator.this.mDiseqInfo.getMixedVar() != null) {
                for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                    if (!ArrayInterpolator.this.mDiseqInfo.isMixed(color)) continue;
                    left = this.mStorePaths[color].get(0);
                    right = this.mStorePaths[color].get(this.mStorePaths[color].size() - 1);
                    int leftSteps = ((StorePath)left).mStores != null ? ((StorePath)left).mStores.size() : 0;
                    int rightSteps = ((StorePath)right).mStores != null ? ((StorePath)right).mStores.size() : 0;
                    ((ArrayInterpolator)ArrayInterpolator.this).mRewriteSide[color] = leftSteps <= rightSteps ? this.mPath[0] : this.mPath[this.mPath.length - 1];
                }
                ArrayInterpolator.this.determineInterpolationColor();
            }
        }

        public Set<Term>[] interpolateStorePathInfoExt() {
            assert (this.mStorePaths != null);
            for (int i = 0; i < this.mStores.size(); ++i) {
                Term index = this.mStores.get(i);
                Interpolator.Occurrence indexInfo = ArrayInterpolator.this.mInterpolator.getOccurrence(index);
                if (ArrayInterpolator.this.mIndexPathInfos.containsKey(index)) continue;
                WeakPathInfo indexPath = new WeakPathInfo((ProofPath)ArrayInterpolator.this.mIndexPaths.get(index));
                Term[] sharedIndex = ArrayInterpolator.this.findSharedTerms(index);
                indexPath.mSharedIndex = sharedIndex;
                for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                    if (sharedIndex[color] != null || (!indexInfo.isALocal(color) || !ArrayInterpolator.this.mABSwitchOccur.isBLocal(color)) && (!indexInfo.isBLocal(color) || !ArrayInterpolator.this.mABSwitchOccur.isALocal(color))) continue;
                    indexPath.mSharedIndex[color] = ArrayInterpolator.this.mDoubleDot;
                }
                indexPath.interpolateWeakPathInfo(true);
                ArrayInterpolator.this.mIndexPathInfos.put(index, indexPath);
            }
            for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                StorePath recursionPath = null;
                for (StorePath storePath : this.mStorePaths[color]) {
                    if (ArrayInterpolator.this.mDiseqInfo.isMixed(color) && ArrayInterpolator.this.mRewriteSide[color] == this.mPath[0] && storePath.mLeft == null || ArrayInterpolator.this.mDiseqInfo.isMixed(color) && ArrayInterpolator.this.mRewriteSide[color] == this.mPath[this.mPath.length - 1] && storePath.mRight == null) {
                        recursionPath = storePath;
                        continue;
                    }
                    this.mTail.addInterpolantClauseExt(color, storePath);
                }
                if (!ArrayInterpolator.this.mDiseqInfo.isMixed(color)) continue;
                WeakPathEnd recSide = ArrayInterpolator.this.mRewriteSide[color] == this.mPath[0] ? this.mHead : this.mTail;
                WeakPathEnd other = recSide == this.mHead ? this.mTail : this.mHead;
                recSide.buildRecursiveInterpolant(color, other, recursionPath);
            }
            return this.mPathInterpolants;
        }

        public Set<Term>[] interpolateStorePathInfoConst() {
            assert (this.mStorePaths != null);
            for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                boolean collectA = !ArrayInterpolator.this.mABSwitchOccur.isALocal(color);
                for (StorePath storePath : this.mStorePaths[color]) {
                    Term sharedArr;
                    Term itpClause;
                    TermVariable cdot;
                    HashSet<Term> sharedIndices = new HashSet<Term>();
                    int order = 0;
                    if (storePath.mStores != null) {
                        order = storePath.mStores.size();
                        for (Term idx : storePath.mStores) {
                            Interpolator.Occurrence occur = ArrayInterpolator.this.mInterpolator.getOccurrence(idx);
                            if (!occur.isAB(color)) continue;
                            sharedIndices.add(idx);
                            --order;
                        }
                    }
                    TermVariable termVariable = cdot = order == 0 ? null : ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", storePath.mStores.iterator().next().getSort());
                    if (storePath.mLeft != null && storePath.mRight != null) {
                        Term rewriteLeftAtShared = storePath.mLeft;
                        for (Term idx : sharedIndices) {
                            rewriteLeftAtShared = ArrayInterpolator.this.mTheory.term("store", rewriteLeftAtShared, idx, ArrayInterpolator.this.buildSelect(storePath.mRight, idx));
                        }
                        if (storePath.mIsAPath && collectA) {
                            itpClause = ArrayInterpolator.this.buildWeqTerm(rewriteLeftAtShared, storePath.mRight, order, ((ArrayInterpolator)ArrayInterpolator.this).mTheory.mTrue, cdot);
                            this.mPathInterpolants[color].add(itpClause);
                            continue;
                        }
                        if (storePath.mIsAPath || collectA) continue;
                        itpClause = ArrayInterpolator.this.buildNweqTerm(rewriteLeftAtShared, storePath.mRight, order, ((ArrayInterpolator)ArrayInterpolator.this).mTheory.mFalse, cdot);
                        this.mPathInterpolants[color].add(itpClause);
                        continue;
                    }
                    if ((!storePath.mIsAPath || !collectA) && (storePath.mIsAPath || collectA)) continue;
                    Term term = sharedArr = storePath.mLeft != null ? storePath.mLeft : storePath.mRight;
                    assert (sharedArr != null);
                    ApplicationTerm fPi = storePath.mIsAPath ? ((ArrayInterpolator)ArrayInterpolator.this).mTheory.mTrue : ((ArrayInterpolator)ArrayInterpolator.this).mTheory.mFalse;
                    itpClause = ArrayInterpolator.this.buildConstPathInterpolant(storePath.mIsAPath, sharedArr, sharedIndices, cdot, order, fPi);
                    this.mPathInterpolants[color].add(itpClause);
                }
            }
            return this.mPathInterpolants;
        }

        private MatchingSelectEquality findSelectEquality(Term leftArray, Term rightArray) {
            for (SymmetricPair testEq : ArrayInterpolator.this.mEqualities.keySet()) {
                Term value;
                Term eqLeft = (Term)testEq.getFirst();
                Term eqRight = (Term)testEq.getSecond();
                boolean isLeftSelect = ArrayInterpolator.isSelectTerm(eqLeft);
                boolean isRightSelect = ArrayInterpolator.isSelectTerm(eqRight);
                if (isLeftSelect && isRightSelect) {
                    if (this.isGoodSelect(eqLeft, leftArray) && this.isGoodSelect(eqRight, rightArray)) {
                        return new MatchingSelectEquality((Term)ArrayInterpolator.this.mEqualities.get(testEq), false, false, false);
                    }
                    if (this.isGoodSelect(eqRight, leftArray) && this.isGoodSelect(eqLeft, rightArray)) {
                        return new MatchingSelectEquality((Term)ArrayInterpolator.this.mEqualities.get(testEq), true, false, false);
                    }
                }
                if (ArrayInterpolator.isConstArray(leftArray)) {
                    value = ArrayInterpolator.getValueFromConst(leftArray);
                    if (eqLeft == value && isRightSelect && this.isGoodSelect(eqRight, rightArray)) {
                        return new MatchingSelectEquality((Term)ArrayInterpolator.this.mEqualities.get(testEq), false, true, false);
                    }
                    if (eqRight == value && isLeftSelect && this.isGoodSelect(eqLeft, rightArray)) {
                        return new MatchingSelectEquality((Term)ArrayInterpolator.this.mEqualities.get(testEq), true, true, false);
                    }
                }
                if (!ArrayInterpolator.isConstArray(rightArray)) continue;
                value = ArrayInterpolator.getValueFromConst(rightArray);
                if (eqLeft == value && isRightSelect && this.isGoodSelect(eqRight, leftArray)) {
                    return new MatchingSelectEquality((Term)ArrayInterpolator.this.mEqualities.get(testEq), true, false, true);
                }
                if (eqRight != value || !isLeftSelect || !this.isGoodSelect(eqLeft, leftArray)) continue;
                return new MatchingSelectEquality((Term)ArrayInterpolator.this.mEqualities.get(testEq), false, false, true);
            }
            return null;
        }

        private boolean isGoodSelect(Term selectTerm, Term arrayTerm) {
            if (ArrayInterpolator.getArrayFromSelect(selectTerm) == arrayTerm) {
                Term selectIndex = ArrayInterpolator.getIndexFromSelect(selectTerm);
                return selectIndex == this.mPathIndex || ArrayInterpolator.this.mEqualities.containsKey(new SymmetricPair<Term>(selectIndex, this.mPathIndex));
            }
            return false;
        }

        public void addDiseq(Interpolator.Occurrence headOcc, Interpolator.Occurrence tailOcc) {
            Term boundaryHeadTerm = this.mPath[0];
            Term boundaryTailTerm = this.mPath[this.mPath.length - 1];
            if (ArrayInterpolator.this.mDiseqInfo.getMixedVar() == null) {
                this.mTail.closeAPath(this.mHead, boundaryTailTerm, ArrayInterpolator.this.mABSwitchOccur);
                this.mTail.openAPath(this.mHead, boundaryTailTerm, ArrayInterpolator.this.mABSwitchOccur);
                this.mHead.closeAPath(this.mTail, boundaryHeadTerm, ArrayInterpolator.this.mABSwitchOccur);
                this.mHead.openAPath(this.mTail, boundaryHeadTerm, ArrayInterpolator.this.mABSwitchOccur);
            } else {
                this.mTail.closeAPath(this.mHead, boundaryTailTerm, tailOcc);
                this.mTail.openAPath(this.mHead, boundaryTailTerm, tailOcc);
                this.mTail.closeAPath(this.mHead, boundaryTailTerm, ArrayInterpolator.this.mDiseqInfo);
                this.mTail.openAPath(this.mHead, boundaryTailTerm, ArrayInterpolator.this.mDiseqInfo);
                this.mHead.closeAPath(this.mTail, boundaryHeadTerm, headOcc);
                this.mHead.openAPath(this.mTail, boundaryHeadTerm, headOcc);
                this.mHead.closeAPath(this.mTail, boundaryHeadTerm, ArrayInterpolator.this.mDiseqInfo);
                this.mHead.openAPath(this.mTail, boundaryHeadTerm, ArrayInterpolator.this.mDiseqInfo);
                if (ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq")) {
                    if (ArrayInterpolator.this.mIndexEquality != null) {
                        Interpolator.LitInfo indexEqInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(ArrayInterpolator.this.mIndexEquality);
                        this.mTail.addSelectIndexEqAllColors(this.mHead, indexEqInfo, ArrayInterpolator.this.mIndexEquality);
                    }
                    this.mTail.closeAPath(this.mHead, ArrayInterpolator.this.mDiseq, headOcc);
                    this.mHead.closeAPath(this.mTail, ArrayInterpolator.this.mDiseq, tailOcc);
                } else if (ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq") || ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":const-weakeq")) {
                    this.mTail.closeAPath(this.mHead, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                    this.mTail.openAPath(this.mHead, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.closeAPath(this.mTail, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.openAPath(this.mTail, ArrayInterpolator.this.mDiseq, ArrayInterpolator.this.mABSwitchOccur);
                } else if (this.mPathIndex != null) {
                    this.mTail.closeAPath(this.mHead, ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                    this.mTail.openAPath(this.mHead, ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.closeAPath(this.mTail, ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                    this.mHead.openAPath(this.mTail, ArrayInterpolator.this.mRecursionVar, ArrayInterpolator.this.mABSwitchOccur);
                }
            }
        }

        private void closeWeakPath() {
            for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                if (ArrayInterpolator.this.mABSwitchOccur.isALocal(color)) {
                    assert (ArrayInterpolator.this.mDiseqInfo.isALocal(color) || !ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq"));
                    if (this.mHead.mTerm[color] != null) {
                        this.mHead.addInterpolantClausePathSeg(true, color, null);
                    }
                    if (this.mTail.mTerm[color] != null) {
                        this.mTail.addInterpolantClausePathSeg(true, color, null);
                    }
                    if (this.mHead.mLastChange[color] != null || this.mTail.mLastChange[color] != null) continue;
                    this.mHead.addInterpolantClausePathSeg(true, color, null);
                    continue;
                }
                if (this.mHead.mLastChange[color] != this.mHead.mTerm[color]) {
                    this.mHead.addInterpolantClausePathSeg(false, color, null);
                }
                if (this.mTail.mLastChange[color] != this.mTail.mTerm[color]) {
                    this.mTail.addInterpolantClausePathSeg(false, color, null);
                }
                if (this.mHead.mLastChange[color] != null || this.mTail.mLastChange[color] != null) continue;
                this.mHead.addInterpolantClausePathSeg(false, color, null);
            }
        }

        private void closeWeakeqExt(Interpolator.Occurrence headOcc, Interpolator.Occurrence tailOcc) {
            while (this.mHead.mColor < this.mMaxColor || this.mTail.mColor < this.mMaxColor) {
                if (this.mHead.mColor < this.mTail.mColor) {
                    if (ArrayInterpolator.this.mDiseqInfo.isMixed(this.mHead.mColor)) {
                        this.mHead.mColor = ArrayInterpolator.this.getParent(this.mHead.mColor);
                        continue;
                    }
                    this.mHead.closeSingleAPath(this.mTail, this.mPath[0]);
                    continue;
                }
                if (this.mHead.mColor == this.mTail.mColor) {
                    if (!ArrayInterpolator.this.mDiseqInfo.isALocal(this.mHead.mColor)) {
                        assert (ArrayInterpolator.this.mDiseqInfo.isAB(this.mHead.mColor));
                        this.mHead.closeSingleAPath(this.mTail, this.mPath[0]);
                        this.mTail.closeSingleAPath(this.mHead, this.mPath[this.mPath.length - 1]);
                        continue;
                    }
                    this.mHead.mColor = this.mTail.mColor = ArrayInterpolator.this.getParent(this.mHead.mColor);
                    continue;
                }
                if (ArrayInterpolator.this.mDiseqInfo.isMixed(this.mTail.mColor)) {
                    this.mTail.mColor = ArrayInterpolator.this.getParent(this.mTail.mColor);
                    continue;
                }
                this.mTail.closeSingleAPath(this.mHead, this.mPath[this.mPath.length - 1]);
            }
            for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                if (ArrayInterpolator.this.mDiseqInfo.isALocal(color)) {
                    if (this.mHead.mTerm[color] != this.mPath[0]) {
                        this.mHead.addStorePathExt(true, color, null);
                    }
                    if (this.mTail.mTerm[color] == this.mPath[this.mPath.length - 1]) continue;
                    this.mTail.addStorePathExt(true, color, null);
                    continue;
                }
                if (ArrayInterpolator.this.mDiseqInfo.isBorShared(color)) {
                    if (this.mHead.mLastChange[color] != this.mPath[0]) {
                        this.mHead.addStorePathExt(false, color, null);
                    }
                    if (this.mTail.mLastChange[color] == this.mPath[this.mPath.length - 1]) continue;
                    this.mTail.addStorePathExt(false, color, null);
                    continue;
                }
                if (headOcc.isALocal(color)) {
                    if (this.mHead.mTerm[color] != this.mPath[0]) {
                        this.mHead.addStorePathExt(true, color, null);
                    }
                    if (this.mTail.mTerm[color] == this.mPath[this.mPath.length - 1]) continue;
                    this.mTail.addStorePathExt(false, color, null);
                    continue;
                }
                if (this.mHead.mLastChange[color] != this.mPath[0]) {
                    this.mHead.addStorePathExt(false, color, null);
                }
                if (this.mTail.mLastChange[color] == this.mPath[this.mPath.length - 1]) continue;
                this.mTail.addStorePathExt(true, color, null);
            }
        }

        private Term buildFPiTerm(boolean isAPath, int color, Term sharedIndex, ArrayList<Term> indexDiseqs, ArrayList<Term> indexEqs) {
            Term index;
            Term projection;
            Interpolator.LitInfo info;
            InterpolatorAtomInfo termInfo;
            if (indexDiseqs == null && indexEqs == null) {
                return isAPath ? ((ArrayInterpolator)ArrayInterpolator.this).mTheory.mFalse : ((ArrayInterpolator)ArrayInterpolator.this).mTheory.mTrue;
            }
            HashSet<Term> indexTerms = new HashSet<Term>();
            if (indexDiseqs != null) {
                for (Term diseq : indexDiseqs) {
                    termInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(diseq);
                    info = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(diseq);
                    ApplicationTerm diseqApp = termInfo.getEquality();
                    if (info.isMixed(color)) {
                        TermVariable var = info.getMixedVar();
                        projection = ArrayInterpolator.this.mTheory.term("@EQ", var, sharedIndex);
                        indexTerms.add(projection);
                        continue;
                    }
                    index = diseqApp.getParameters()[0].equals(this.mPathIndex) ? diseqApp.getParameters()[1] : diseqApp.getParameters()[0];
                    projection = ArrayInterpolator.this.mTheory.equals(index, sharedIndex);
                    if (!isAPath && info.isALocal(color)) {
                        projection = ArrayInterpolator.this.mTheory.not(projection);
                    }
                    indexTerms.add(projection);
                }
            }
            if (indexEqs != null) {
                for (Term eq : indexEqs) {
                    termInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(eq);
                    info = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(eq);
                    ApplicationTerm eqApp = termInfo.getEquality();
                    index = info.isMixed(color) ? info.getMixedVar() : (eqApp.getParameters()[0].equals(this.mPathIndex) ? eqApp.getParameters()[1] : eqApp.getParameters()[0]);
                    projection = ArrayInterpolator.this.mTheory.equals(index, sharedIndex);
                    if (isAPath) {
                        projection = ArrayInterpolator.this.mTheory.not(projection);
                    }
                    indexTerms.add(projection);
                }
            }
            Term fPiTerm = isAPath ? ArrayInterpolator.this.mTheory.or(indexTerms.toArray(new Term[indexTerms.size()])) : ArrayInterpolator.this.mTheory.and(indexTerms.toArray(new Term[indexTerms.size()]));
            return fPiTerm;
        }

        class WeakPathEnd {
            int mColor;
            Term[] mTerm;
            Term[] mLastChange;
            ArrayList<Term>[] mIndexDiseqs;
            ArrayList<Term>[] mIndexEqs;
            Set<Term>[] mMainStores;

            public WeakPathEnd() {
                this.mColor = ArrayInterpolator.this.mNumInterpolants;
                this.mTerm = new Term[ArrayInterpolator.this.mNumInterpolants];
                this.mLastChange = new Term[ArrayInterpolator.this.mNumInterpolants];
                if (WeakPathInfo.this.mPathIndex != null) {
                    this.mIndexDiseqs = new ArrayList[ArrayInterpolator.this.mNumInterpolants];
                    this.mIndexEqs = new ArrayList[ArrayInterpolator.this.mNumInterpolants];
                } else {
                    this.mMainStores = new Set[ArrayInterpolator.this.mNumInterpolants];
                }
            }

            public void closeAPath(WeakPathEnd other, Term boundary, Interpolator.Occurrence occur) {
                assert (other.mColor <= WeakPathInfo.this.mMaxColor);
                WeakPathInfo.this.mHasABPath.and(occur.mInA);
                while (this.mColor < ArrayInterpolator.this.mNumInterpolants && occur.isBLocal(this.mColor)) {
                    this.closeSingleAPath(other, boundary);
                }
            }

            public void openAPath(WeakPathEnd other, Term boundary, Interpolator.Occurrence occur) {
                int child;
                while ((child = ArrayInterpolator.this.getChild(this.mColor, occur)) >= 0) {
                    assert (occur.isALocal(child));
                    this.openSingleAPath(other, boundary, child);
                }
            }

            private void closeSingleAPath(WeakPathEnd other, Term boundary) {
                assert (WeakPathInfo.this.mHasABPath.isEmpty());
                int color = this.mColor;
                this.mColor = ArrayInterpolator.this.getParent(color);
                if (color < WeakPathInfo.this.mMaxColor) {
                    if (WeakPathInfo.this.mPathIndex != null) {
                        this.addInterpolantClausePathSeg(true, color, boundary);
                    } else {
                        this.addStorePathExt(true, color, boundary);
                    }
                    this.mTerm[color] = null;
                } else {
                    assert (WeakPathInfo.this.mMaxColor == color);
                    other.mTerm[color] = boundary;
                    WeakPathInfo.this.mMaxColor = ArrayInterpolator.this.getParent(color);
                }
                this.mLastChange[color] = boundary;
                if (other.mLastChange[color] == null) {
                    other.mLastChange[color] = boundary;
                }
            }

            private void openSingleAPath(WeakPathEnd other, Term boundary, int child) {
                if (WeakPathInfo.this.mHasABPath.get(child)) {
                    other.mColor = this.mColor = child;
                    WeakPathInfo.this.mMaxColor = this.mColor;
                    BitSet subtree = new BitSet();
                    subtree.set(((ArrayInterpolator)ArrayInterpolator.this).mInterpolator.mStartOfSubtrees[child], child);
                    WeakPathInfo.this.mHasABPath.and(subtree);
                } else {
                    this.mTerm[child] = boundary;
                    this.mColor = child;
                    if (this.mLastChange[child] != null) {
                        if (WeakPathInfo.this.mPathIndex != null) {
                            this.addInterpolantClausePathSeg(false, child, boundary);
                        } else {
                            this.addStorePathExt(false, child, boundary);
                        }
                    }
                    this.mLastChange[child] = boundary;
                    if (other.mLastChange[child] == null) {
                        other.mLastChange[child] = boundary;
                    }
                    WeakPathInfo.this.mHasABPath.clear();
                }
            }

            private void addIndexDisequality(WeakPathEnd other, Term diseq) {
                Interpolator.LitInfo diseqInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(diseq);
                this.addIndexDiseqAllColors(other, diseqInfo, diseq);
                if (diseqInfo.getMixedVar() != null) {
                    Interpolator.Occurrence occur = ArrayInterpolator.this.mInterpolator.getOccurrence(WeakPathInfo.this.mPathIndex);
                    this.addIndexDiseqAllColors(other, occur, diseq);
                }
            }

            private void addIndexDiseqAllColors(WeakPathEnd other, Interpolator.Occurrence occur, Term diseq) {
                int child;
                int currentColor = this.mColor;
                WeakPathInfo.this.mHasABPath.and(occur.mInA);
                while (currentColor < ArrayInterpolator.this.mNumInterpolants && occur.isBLocal(currentColor)) {
                    assert (WeakPathInfo.this.mHasABPath.isEmpty());
                    int color = currentColor;
                    currentColor = ArrayInterpolator.this.getParent(color);
                    this.addIndexDiseqOneColor(other, diseq, color);
                }
                while ((child = ArrayInterpolator.this.getChild(currentColor, occur)) >= 0) {
                    assert (occur.isALocal(child));
                    if (WeakPathInfo.this.mHasABPath.get(child)) {
                        BitSet subtree = new BitSet();
                        subtree.set(((ArrayInterpolator)ArrayInterpolator.this).mInterpolator.mStartOfSubtrees[child], child);
                        WeakPathInfo.this.mHasABPath.and(subtree);
                        continue;
                    }
                    this.addIndexDiseqOneColor(other, diseq, child);
                    currentColor = child;
                }
            }

            private void addIndexDiseqOneColor(WeakPathEnd other, Term diseq, int color) {
                if (other.mLastChange[color] == null) {
                    if (other.mIndexDiseqs[color] == null) {
                        other.mIndexDiseqs[color] = new ArrayList();
                    }
                    other.mIndexDiseqs[color].add(diseq);
                } else {
                    if (this.mIndexDiseqs[color] == null) {
                        this.mIndexDiseqs[color] = new ArrayList();
                    }
                    this.mIndexDiseqs[color].add(diseq);
                }
            }

            private void addSelectIndexEquality(WeakPathEnd other, Term selectTerm) {
                assert (ArrayInterpolator.isSelectTerm(selectTerm));
                if (ArrayInterpolator.getIndexFromSelect(selectTerm) != WeakPathInfo.this.mPathIndex) {
                    Term selectIndex = ArrayInterpolator.getIndexFromSelect(selectTerm);
                    Term indexEq = (Term)ArrayInterpolator.this.mEqualities.get(new SymmetricPair<Term>(selectIndex, WeakPathInfo.this.mPathIndex));
                    Interpolator.LitInfo eqInfo = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(indexEq);
                    this.addSelectIndexEqAllColors(other, eqInfo, indexEq);
                    if (eqInfo.getMixedVar() != null) {
                        Interpolator.Occurrence occur = ArrayInterpolator.this.mInterpolator.getOccurrence(WeakPathInfo.this.mPathIndex);
                        this.addSelectIndexEqAllColors(other, occur, indexEq);
                    }
                }
            }

            private void addSelectIndexEqAllColors(WeakPathEnd other, Interpolator.Occurrence occur, Term eq) {
                int child;
                int currentColor = this.mColor;
                WeakPathInfo.this.mHasABPath.and(occur.mInA);
                while (currentColor < ArrayInterpolator.this.mNumInterpolants && occur.isBLocal(currentColor)) {
                    assert (WeakPathInfo.this.mHasABPath.isEmpty());
                    int color = currentColor;
                    currentColor = ArrayInterpolator.this.getParent(color);
                    this.addSelectIndexEqOneColor(other, eq, color);
                }
                while ((child = ArrayInterpolator.this.getChild(currentColor, occur)) >= 0) {
                    assert (occur.isALocal(child));
                    if (WeakPathInfo.this.mHasABPath.get(child)) {
                        BitSet subtree = new BitSet();
                        subtree.set(((ArrayInterpolator)ArrayInterpolator.this).mInterpolator.mStartOfSubtrees[child], child);
                        WeakPathInfo.this.mHasABPath.and(subtree);
                        continue;
                    }
                    this.addSelectIndexEqOneColor(other, eq, child);
                    currentColor = child;
                }
            }

            private void addSelectIndexEqOneColor(WeakPathEnd other, Term eq, int color) {
                if (other.mLastChange[color] == null) {
                    if (other.mIndexEqs[color] == null) {
                        other.mIndexEqs[color] = new ArrayList();
                    }
                    other.mIndexEqs[color].add(eq);
                } else {
                    if (this.mIndexEqs[color] == null) {
                        this.mIndexEqs[color] = new ArrayList();
                    }
                    this.mIndexEqs[color].add(eq);
                }
            }

            private void addMainStoreIndex(WeakPathEnd other, Term storeIndex) {
                for (int color = 0; color < ArrayInterpolator.this.mNumInterpolants; ++color) {
                    if (other.mLastChange[color] == null) {
                        if (other.mMainStores[color] == null) {
                            other.mMainStores[color] = new HashSet<Term>();
                        }
                        other.mMainStores[color].add(storeIndex);
                        continue;
                    }
                    if (this.mMainStores[color] == null) {
                        this.mMainStores[color] = new HashSet<Term>();
                    }
                    this.mMainStores[color].add(storeIndex);
                }
            }

            private void addInterpolantClausePathSeg(boolean isAPath, int color, Term boundary) {
                boolean collectA = !ArrayInterpolator.this.mABSwitchOccur.isALocal(color);
                Term left = this.mLastChange[color];
                Term right = boundary;
                if (WeakPathInfo.this.mSharedIndex[color] != null) {
                    Term index = WeakPathInfo.this.mSharedIndex[color];
                    Term fPi = WeakPathInfo.this.buildFPiTerm(isAPath, color, index, this.mIndexDiseqs[color], this.mIndexEqs[color]);
                    this.mIndexDiseqs[color] = null;
                    this.mIndexEqs[color] = null;
                    if (collectA && isAPath || !collectA && !isAPath) {
                        Term selectEq = ArrayInterpolator.this.buildSelectEq(left, right, index);
                        Term itpClause = collectA ? ArrayInterpolator.this.mTheory.or(selectEq, fPi) : ArrayInterpolator.this.mTheory.and(ArrayInterpolator.this.mTheory.not(selectEq), fPi);
                        WeakPathInfo.this.mPathInterpolants[color].add(itpClause);
                    } else {
                        if (isAPath && !fPi.equals(((ArrayInterpolator)ArrayInterpolator.this).mTheory.mFalse)) assert (WeakPathInfo.this.mSharedIndex[color] == WeakPathInfo.this.mPathIndex || ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":weakeq-ext"));
                        WeakPathInfo.this.mPathInterpolants[color].add(fPi);
                    }
                } else if (collectA && isAPath || !collectA && !isAPath) {
                    Term itpClause;
                    int order;
                    HashSet<Term> sharedIndices = new HashSet<Term>();
                    if (this.mIndexDiseqs[color] != null) {
                        Iterator<Term> it = this.mIndexDiseqs[color].iterator();
                        while (it.hasNext()) {
                            Term storeIndex;
                            Term diseq = it.next();
                            InterpolatorAtomInfo termInfo = ArrayInterpolator.this.mInterpolator.getAtomTermInfo(diseq);
                            Interpolator.LitInfo info = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(diseq);
                            if (info.isMixed(color)) continue;
                            ApplicationTerm diseqApp = termInfo.getEquality();
                            Term term = storeIndex = diseqApp.getParameters()[0].equals(WeakPathInfo.this.mPathIndex) ? diseqApp.getParameters()[1] : diseqApp.getParameters()[0];
                            Interpolator.Occurrence storeOcc = ArrayInterpolator.this.mInterpolator.getOccurrence(storeIndex);
                            if (!storeOcc.isAB(color)) continue;
                            sharedIndices.add(storeIndex);
                            it.remove();
                        }
                    }
                    int n = order = this.mIndexDiseqs[color] == null ? 0 : this.mIndexDiseqs[color].size();
                    if (ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-const-weakeq") && boundary.equals(ArrayInterpolator.this.mDiseq)) {
                        TermVariable cdot = ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", WeakPathInfo.this.mPathIndex.getSort());
                        Term fPi = WeakPathInfo.this.buildFPiTerm(isAPath, color, cdot, this.mIndexDiseqs[color], this.mIndexEqs[color]);
                        this.mIndexDiseqs[color] = null;
                        this.mIndexEqs[color] = null;
                        itpClause = ArrayInterpolator.this.buildConstPathInterpolant(isAPath, left, sharedIndices, cdot, order, fPi);
                    } else {
                        Term rewriteLeftAtShared = left;
                        for (Term idx : sharedIndices) {
                            rewriteLeftAtShared = ArrayInterpolator.this.mTheory.term("store", rewriteLeftAtShared, idx, ArrayInterpolator.this.buildSelect(right, idx));
                        }
                        TermVariable cdot = ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", WeakPathInfo.this.mPathIndex.getSort());
                        Term fPi = WeakPathInfo.this.buildFPiTerm(isAPath, color, cdot, this.mIndexDiseqs[color], this.mIndexEqs[color]);
                        this.mIndexDiseqs[color] = null;
                        this.mIndexEqs[color] = null;
                        itpClause = isAPath ? ArrayInterpolator.this.buildWeqTerm(rewriteLeftAtShared, right, order, fPi, cdot) : ArrayInterpolator.this.buildNweqTerm(rewriteLeftAtShared, right, order, fPi, cdot);
                    }
                    WeakPathInfo.this.mPathInterpolants[color].add(itpClause);
                } else if (ArrayInterpolator.this.mLemmaInfo.getLemmaType().equals(":read-over-weakeq") ? !$assertionsDisabled && this.mIndexDiseqs[color] != null : !$assertionsDisabled && this.mIndexDiseqs[color] != null && ArrayInterpolator.this.mDiseqInfo.isMixed(color)) {
                    throw new AssertionError();
                }
            }

            private void addStorePathExt(boolean isAPath, int color, Term boundary) {
                Term right;
                Term left;
                if (this.equals(WeakPathInfo.this.mTail)) {
                    left = this.mLastChange[color];
                    right = boundary;
                } else {
                    left = boundary;
                    right = this.mLastChange[color];
                }
                Set<Term> stores = this.mMainStores[color];
                StorePath storePath = new StorePath(left, right, stores, isAPath);
                if (this.equals(WeakPathInfo.this.mTail)) {
                    WeakPathInfo.this.mStorePaths[color].add(storePath);
                } else {
                    WeakPathInfo.this.mStorePaths[color].add(0, storePath);
                }
                if (left != null && right != null) {
                    this.mMainStores[color] = null;
                }
            }

            private void addInterpolantClauseExt(int color, StorePath storePath) {
                boolean collectA;
                boolean isAPath = storePath.mIsAPath;
                boolean bl = collectA = !ArrayInterpolator.this.mABSwitchOccur.isALocal(color);
                if (collectA && isAPath || !collectA && !isAPath) {
                    Term left = storePath.mLeft;
                    Term right = storePath.mRight;
                    assert (left != null && right != null);
                    if (storePath.mStores != null) {
                        Term interpolantClause;
                        Term formula;
                        HashSet<Term> subInterpolants = new HashSet<Term>();
                        HashSet<Term> sharedIndices = new HashSet<Term>();
                        for (Term index : storePath.mStores) {
                            WeakPathInfo indexPath = (WeakPathInfo)ArrayInterpolator.this.mIndexPathInfos.get(index);
                            Term subInterpolant = isAPath ? ArrayInterpolator.this.mTheory.and(indexPath.mPathInterpolants[color].toArray(new Term[indexPath.mPathInterpolants[color].size()])) : ArrayInterpolator.this.mTheory.or(indexPath.mPathInterpolants[color].toArray(new Term[indexPath.mPathInterpolants[color].size()]));
                            if (indexPath.mSharedIndex[color] != null && indexPath.mSharedIndex[color] != ArrayInterpolator.this.mDoubleDot) {
                                sharedIndices.add(indexPath.mSharedIndex[color]);
                                WeakPathInfo.this.mPathInterpolants[color].add(subInterpolant);
                                continue;
                            }
                            subInterpolants.add(subInterpolant);
                        }
                        int order = storePath.mStores == null ? 0 : storePath.mStores.size() - sharedIndices.size();
                        Term rewriteLeftAtShared = left;
                        for (Term idx : sharedIndices) {
                            rewriteLeftAtShared = ArrayInterpolator.this.mTheory.term("store", rewriteLeftAtShared, idx, ArrayInterpolator.this.buildSelect(right, idx));
                        }
                        if (isAPath) {
                            formula = ArrayInterpolator.this.mTheory.or(subInterpolants.toArray(new Term[subInterpolants.size()]));
                            interpolantClause = ArrayInterpolator.this.buildWeqTerm(rewriteLeftAtShared, right, order, formula, ArrayInterpolator.this.mDoubleDot);
                        } else {
                            formula = ArrayInterpolator.this.mTheory.and(subInterpolants.toArray(new Term[subInterpolants.size()]));
                            interpolantClause = ArrayInterpolator.this.buildNweqTerm(rewriteLeftAtShared, right, order, formula, ArrayInterpolator.this.mDoubleDot);
                        }
                        WeakPathInfo.this.mPathInterpolants[color].add(interpolantClause);
                    } else {
                        Term interpolantClause = ArrayInterpolator.this.mTheory.equals(left, right);
                        if (!isAPath) {
                            interpolantClause = ArrayInterpolator.this.mTheory.not(interpolantClause);
                        }
                        WeakPathInfo.this.mPathInterpolants[color].add(interpolantClause);
                    }
                } else if (storePath.mStores != null) {
                    for (Term index : storePath.mStores) {
                        WeakPathInfo indexPath = (WeakPathInfo)ArrayInterpolator.this.mIndexPathInfos.get(index);
                        Term subInterpolant = isAPath ? ArrayInterpolator.this.mTheory.or(indexPath.mPathInterpolants[color].toArray(new Term[indexPath.mPathInterpolants[color].size()])) : ArrayInterpolator.this.mTheory.and(indexPath.mPathInterpolants[color].toArray(new Term[indexPath.mPathInterpolants[color].size()]));
                        WeakPathInfo.this.mPathInterpolants[color].add(subInterpolant);
                    }
                }
            }

            private void buildRecursiveInterpolant(int color, WeakPathEnd other, StorePath recursionPath) {
                boolean isAPath = recursionPath.mIsAPath;
                Term eqTerm = ArrayInterpolator.this.mTheory.term("@EQ", ArrayInterpolator.this.mDiseqInfo.getMixedVar(), ArrayInterpolator.this.mRecursionVar);
                Term innerInterpolant = isAPath ? ArrayInterpolator.this.mTheory.and(WeakPathInfo.this.mPathInterpolants[color].toArray(new Term[WeakPathInfo.this.mPathInterpolants[color].size()])) : ArrayInterpolator.this.mTheory.or(WeakPathInfo.this.mPathInterpolants[color].toArray(new Term[WeakPathInfo.this.mPathInterpolants[color].size()]));
                WeakPathInfo.this.mPathInterpolants[color].clear();
                Term recursiveInterpolant = isAPath ? ArrayInterpolator.this.mTheory.and(eqTerm, innerInterpolant) : ArrayInterpolator.this.mTheory.or(eqTerm, innerInterpolant);
                TermVariable lastRecVar = ArrayInterpolator.this.mRecursionVar;
                if (recursionPath.mStores != null) {
                    for (Term index : recursionPath.mStores) {
                        Term fPi;
                        int fPiOrderForRecursion;
                        ArrayList<Term> indexDiseqs;
                        Term rewriteWithElement;
                        Term rewriteToArray;
                        Term pathInterpolant;
                        Term rewriteAtIndex;
                        Set recPathInterpolantTerms;
                        WeakPathInfo indexPath;
                        TermVariable currentRecVar = ArrayInterpolator.this.mTheory.createFreshTermVariable("recursive", ArrayInterpolator.this.mRecursionVar.getSort());
                        if (ArrayInterpolator.this.mRecIndexPathInfos.containsKey(index)) {
                            indexPath = (WeakPathInfo)ArrayInterpolator.this.mRecIndexPathInfos.get(index);
                            recPathInterpolantTerms = indexPath.mPathInterpolants[color];
                        } else {
                            indexPath = new WeakPathInfo((ProofPath)ArrayInterpolator.this.mIndexPaths.get(index));
                            indexPath.mSharedIndex = ArrayInterpolator.this.findSharedTerms(index);
                            BitSet oldInA = ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInA;
                            ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInA = ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInB;
                            ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInB = oldInA;
                            indexPath.interpolateWeakPathInfo(false);
                            oldInA = ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInB;
                            ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInB = ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInA;
                            ((ArrayInterpolator)ArrayInterpolator.this).mABSwitchOccur.mInA = oldInA;
                            recPathInterpolantTerms = indexPath.mPathInterpolants[color];
                        }
                        if (indexPath.mSharedIndex[color] != null) {
                            Term lastSharedOnIndexPath;
                            rewriteAtIndex = indexPath.mSharedIndex[color];
                            pathInterpolant = isAPath ? ArrayInterpolator.this.mTheory.or(recPathInterpolantTerms.toArray(new Term[recPathInterpolantTerms.size()])) : ArrayInterpolator.this.mTheory.and(recPathInterpolantTerms.toArray(new Term[recPathInterpolantTerms.size()]));
                            Term term = lastSharedOnIndexPath = this.equals(WeakPathInfo.this.mHead) ? indexPath.mTail.mLastChange[color] : indexPath.mHead.mLastChange[color];
                            if (ArrayInterpolator.this.mEqualities.containsValue(lastSharedOnIndexPath)) {
                                rewriteToArray = null;
                                Interpolator.LitInfo selectEq = ArrayInterpolator.this.mInterpolator.getAtomOccurenceInfo(lastSharedOnIndexPath);
                                rewriteWithElement = selectEq.getMixedVar();
                            } else {
                                rewriteToArray = lastSharedOnIndexPath;
                                rewriteWithElement = ArrayInterpolator.this.buildSelect(rewriteToArray, rewriteAtIndex);
                            }
                        } else {
                            Term lastSharedOnIndexPath;
                            TermVariable cdot = ArrayInterpolator.this.mTheory.createFreshTermVariable("cdot", index.getSort());
                            rewriteAtIndex = cdot;
                            pathInterpolant = isAPath ? ArrayInterpolator.this.mTheory.or(recPathInterpolantTerms.toArray(new Term[recPathInterpolantTerms.size()])) : ArrayInterpolator.this.mTheory.and(recPathInterpolantTerms.toArray(new Term[recPathInterpolantTerms.size()]));
                            Term term = lastSharedOnIndexPath = this.equals(WeakPathInfo.this.mHead) ? indexPath.mTail.mLastChange[color] : indexPath.mHead.mLastChange[color];
                            assert (!ArrayInterpolator.this.mEqualities.containsValue(lastSharedOnIndexPath));
                            rewriteToArray = lastSharedOnIndexPath;
                            rewriteWithElement = ArrayInterpolator.this.buildSelect(rewriteToArray, rewriteAtIndex);
                        }
                        if (this.equals(WeakPathInfo.this.mHead)) {
                            indexDiseqs = indexPath.mTail.mIndexDiseqs[color];
                            fPiOrderForRecursion = indexDiseqs == null ? 0 : indexDiseqs.size();
                            fPi = indexPath.buildFPiTerm(!isAPath, color, rewriteAtIndex, indexDiseqs, indexPath.mTail.mIndexEqs[color]);
                        } else {
                            indexDiseqs = indexPath.mHead.mIndexDiseqs[color];
                            fPiOrderForRecursion = indexDiseqs == null ? 0 : indexDiseqs.size();
                            fPi = indexPath.buildFPiTerm(!isAPath, color, rewriteAtIndex, indexDiseqs, indexPath.mHead.mIndexEqs[color]);
                        }
                        Term rewriteRecVar = ArrayInterpolator.this.mTheory.term("store", currentRecVar, rewriteAtIndex, rewriteWithElement);
                        Term rewriteRecInterpolant = isAPath ? ArrayInterpolator.this.mTheory.and(ArrayInterpolator.this.mTheory.let(lastRecVar, rewriteRecVar, recursiveInterpolant), fPi) : ArrayInterpolator.this.mTheory.or(ArrayInterpolator.this.mTheory.let(lastRecVar, rewriteRecVar, recursiveInterpolant), fPi);
                        if (indexPath.mSharedIndex[color] != null) {
                            recursiveInterpolant = isAPath ? ArrayInterpolator.this.mTheory.or(pathInterpolant, rewriteRecInterpolant) : ArrayInterpolator.this.mTheory.and(pathInterpolant, rewriteRecInterpolant);
                        } else {
                            assert (rewriteAtIndex instanceof TermVariable);
                            assert (rewriteToArray != null);
                            TermVariable rewriteDot = (TermVariable)rewriteAtIndex;
                            HashSet<Term> rewriteIndexFinders = new HashSet<Term>();
                            for (StorePath path : WeakPathInfo.this.mStorePaths[color]) {
                                Term left = path.mLeft;
                                Term right = path.mRight;
                                if (left == null || right == null) continue;
                                int order = path.mStores != null ? path.mStores.size() : 0;
                                Term rewriteIndexSearcher = isAPath ? ArrayInterpolator.this.buildNweqTerm(left, right, order, rewriteRecInterpolant, rewriteDot) : ArrayInterpolator.this.buildWeqTerm(left, right, order, rewriteRecInterpolant, rewriteDot);
                                rewriteIndexFinders.add(rewriteIndexSearcher);
                            }
                            Term concatLeft = other.mLastChange[color];
                            Term concatRight = rewriteToArray;
                            Set<Term> otherMainStores = other.mMainStores[color];
                            int concatStores = fPiOrderForRecursion + (otherMainStores == null ? 0 : otherMainStores.size());
                            Term concatTerm = isAPath ? ArrayInterpolator.this.buildNweqTerm(concatLeft, concatRight, concatStores, rewriteRecInterpolant, rewriteDot) : ArrayInterpolator.this.buildWeqTerm(concatLeft, concatRight, concatStores, rewriteRecInterpolant, rewriteDot);
                            rewriteIndexFinders.add(concatTerm);
                            Term recursionStepTerm = isAPath ? ArrayInterpolator.this.mTheory.or(rewriteIndexFinders.toArray(new Term[rewriteIndexFinders.size()])) : ArrayInterpolator.this.mTheory.and(rewriteIndexFinders.toArray(new Term[rewriteIndexFinders.size()]));
                            recursiveInterpolant = ArrayInterpolator.this.mTheory.let(lastRecVar, currentRecVar, recursiveInterpolant);
                            recursiveInterpolant = isAPath ? ArrayInterpolator.this.mTheory.or(recursiveInterpolant, pathInterpolant, recursionStepTerm) : ArrayInterpolator.this.mTheory.and(recursiveInterpolant, pathInterpolant, recursionStepTerm);
                        }
                        lastRecVar = currentRecVar;
                    }
                }
                recursiveInterpolant = ArrayInterpolator.this.mTheory.let(lastRecVar, this.mLastChange[color], recursiveInterpolant);
                WeakPathInfo.this.mPathInterpolants[color].add(recursiveInterpolant);
            }
        }

        class MatchingSelectEquality {
            Term mEqualityLit;
            boolean mIsSwapped;
            boolean mIsConstLeft;
            boolean mIsConstRight;

            public MatchingSelectEquality(Term equalityLit, boolean isSwapped, boolean isConstLeft, boolean isConstRight) {
                this.mEqualityLit = equalityLit;
                this.mIsSwapped = isSwapped;
                this.mIsConstLeft = isConstLeft;
                this.mIsConstRight = isConstRight;
            }
        }
    }

    class ProofPath {
        private final Term mPathIndex;
        private final Term[] mPath;

        private ProofPath(String type, Object path) {
            if (type.equals(":subpath")) {
                this.mPathIndex = null;
                this.mPath = (Term[])path;
            } else {
                assert (type.equals(":weakpath"));
                Object[] indexAndPath = (Object[])path;
                this.mPathIndex = (Term)indexAndPath[0];
                this.mPath = (Term[])indexAndPath[1];
            }
        }

        public Term getIndex() {
            return this.mPathIndex;
        }

        public Term[] getPath() {
            return this.mPath;
        }
    }
}

