/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LAInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;

public class CCInterpolator {
    Interpolator mInterpolator;
    Interpolator.LitInfo mDiseqOccurrences;
    HashMap<SymmetricPair<Term>, Interpolator.LitInfo> mEqualityOccurrences;
    Theory mTheory;
    int mNumInterpolants;
    Collection<Term>[] mInterpolants;
    Term[] mPath;
    BitSet mAllInA;
    int mMaxColor;
    PathEnd mHead;
    PathEnd mTail;

    public CCInterpolator(Interpolator ipolator) {
        this.mInterpolator = ipolator;
        this.mNumInterpolants = ipolator.mNumInterpolants;
        this.mTheory = ipolator.mTheory;
    }

    private int getParent(int color) {
        int parent = color + 1;
        while (this.mInterpolator.mStartOfSubtrees[parent] > color) {
            ++parent;
        }
        return parent;
    }

    private int getChild(int color, Interpolator.Occurrence occur) {
        int child = color - 1;
        while (child >= this.mInterpolator.mStartOfSubtrees[color]) {
            if (occur.isALocal(child)) {
                return child;
            }
            child = this.mInterpolator.mStartOfSubtrees[child] - 1;
        }
        return -1;
    }

    private Term[] interpolateCongruence(ApplicationTerm left, ApplicationTerm right) {
        Term[] interpolants = new Term[this.mNumInterpolants];
        Term[] leftParams = left.getParameters();
        Term[] rightParams = right.getParameters();
        Interpolator.LitInfo[] paramInfos = new Interpolator.LitInfo[leftParams.length];
        assert (left.getFunction() == right.getFunction() && leftParams.length == rightParams.length);
        for (int i = 0; i < leftParams.length; ++i) {
            paramInfos[i] = leftParams[i] == rightParams[i] ? null : this.mEqualityOccurrences.get(new SymmetricPair<Term>(leftParams[i], rightParams[i]));
        }
        for (int part = 0; part < this.mNumInterpolants; ++part) {
            TermVariable mixedVar;
            int paramNr;
            ArrayDeque<Term> terms;
            if (this.mDiseqOccurrences.isBorShared(part)) {
                terms = new ArrayDeque<Term>(leftParams.length);
                for (paramNr = 0; paramNr < leftParams.length; ++paramNr) {
                    if (paramInfos[paramNr] != null && paramInfos[paramNr].isALocal(part)) {
                        terms.add(this.mTheory.term("=", leftParams[paramNr], rightParams[paramNr]));
                        continue;
                    }
                    if (paramInfos[paramNr] == null || !paramInfos[paramNr].isMixed(part)) continue;
                    mixedVar = paramInfos[paramNr].getMixedVar();
                    Term sideA = paramInfos[paramNr].getLhsOccur().isALocal(part) ? leftParams[paramNr] : rightParams[paramNr];
                    terms.add(this.mTheory.term("=", mixedVar, sideA));
                }
                interpolants[part] = this.mTheory.and(terms.toArray(new Term[terms.size()]));
                continue;
            }
            if (this.mDiseqOccurrences.isALocal(part)) {
                terms = new ArrayDeque(leftParams.length);
                for (paramNr = 0; paramNr < leftParams.length; ++paramNr) {
                    if (paramInfos[paramNr] != null && paramInfos[paramNr].isBLocal(part)) {
                        terms.add(this.mTheory.not(this.mTheory.term("=", leftParams[paramNr], rightParams[paramNr])));
                        continue;
                    }
                    if (paramInfos[paramNr] == null || !paramInfos[paramNr].isMixed(part)) continue;
                    mixedVar = paramInfos[paramNr].getMixedVar();
                    Term sideB = paramInfos[paramNr].getLhsOccur().isBLocal(part) ? leftParams[paramNr] : rightParams[paramNr];
                    terms.add(this.mTheory.not(this.mTheory.term("=", mixedVar, sideB)));
                }
                interpolants[part] = this.mTheory.or(terms.toArray(new Term[terms.size()]));
                continue;
            }
            Term[] boundaryTerms = new Term[leftParams.length];
            boolean isLeftAlocal = this.mInterpolator.getOccurrence(left).isALocal(part);
            for (int paramNr2 = 0; paramNr2 < leftParams.length; ++paramNr2) {
                if (paramInfos[paramNr2] == null) {
                    boundaryTerms[paramNr2] = leftParams[paramNr2];
                    continue;
                }
                if (paramInfos[paramNr2].isMixed(part)) {
                    boundaryTerms[paramNr2] = paramInfos[paramNr2].getMixedVar();
                    continue;
                }
                if (paramInfos[paramNr2].isAorShared(part)) {
                    Term term = boundaryTerms[paramNr2] = isLeftAlocal ? rightParams[paramNr2] : leftParams[paramNr2];
                    assert (this.mInterpolator.getOccurrence(boundaryTerms[paramNr2]).isAB(part));
                    continue;
                }
                Term term = boundaryTerms[paramNr2] = isLeftAlocal ? leftParams[paramNr2] : rightParams[paramNr2];
                assert (this.mInterpolator.getOccurrence(boundaryTerms[paramNr2]).isAB(part));
            }
            Term sharedTerm = this.mTheory.term(left.getFunction(), boundaryTerms);
            interpolants[part] = this.mTheory.term("@EQ", this.mDiseqOccurrences.getMixedVar(), sharedTerm);
        }
        return interpolants;
    }

    public Term[] interpolateTransitivity() {
        this.mInterpolants = new Collection[this.mNumInterpolants];
        for (int part = 0; part < this.mNumInterpolants; ++part) {
            this.mInterpolants[part] = new ArrayList<Term>();
        }
        Term headTerm = this.mPath[0];
        Term tailTerm = this.mPath[this.mPath.length - 1];
        Interpolator.Occurrence headOccur = this.mInterpolator.getOccurrence(headTerm);
        Interpolator.Occurrence tailOccur = this.mInterpolator.getOccurrence(tailTerm);
        this.mHead = new PathEnd();
        this.mTail = new PathEnd();
        this.mMaxColor = this.mNumInterpolants;
        this.mAllInA = new BitSet(this.mNumInterpolants);
        this.mAllInA.set(0, this.mNumInterpolants);
        this.mTail.closeAPath(this.mHead, null, headOccur);
        this.mTail.openAPath(this.mHead, null, headOccur);
        for (int i = 0; i < this.mPath.length - 1; ++i) {
            Term left = this.mPath[i];
            Term right = this.mPath[i + 1];
            Interpolator.LitInfo info = this.mEqualityOccurrences.get(new SymmetricPair<Term>(left, right));
            this.mTail.closeAPath(this.mHead, left, info);
            this.mTail.openAPath(this.mHead, left, info);
            if (info.getMixedVar() == null) continue;
            Interpolator.Occurrence occ = this.mInterpolator.getOccurrence(right);
            this.mTail.closeAPath(this.mHead, info.getMixedVar(), occ);
            this.mTail.openAPath(this.mHead, info.getMixedVar(), occ);
        }
        if (this.mDiseqOccurrences != null) {
            this.mTail.closeAPath(this.mHead, tailTerm, this.mDiseqOccurrences);
            this.mTail.openAPath(this.mHead, tailTerm, this.mDiseqOccurrences);
            this.mHead.closeAPath(this.mTail, headTerm, this.mDiseqOccurrences);
            this.mHead.openAPath(this.mTail, headTerm, this.mDiseqOccurrences);
            if (this.mDiseqOccurrences.getMixedVar() != null) {
                this.mTail.closeAPathMixed(this.mDiseqOccurrences.getMixedVar(), headOccur);
                this.mHead.closeAPathMixed(this.mDiseqOccurrences.getMixedVar(), tailOccur);
            }
        }
        while (this.mHead.mColor != this.mTail.mColor) {
            while (this.mHead.mColor < this.mTail.mColor) {
                this.mInterpolants[this.mHead.mColor].add(this.mTheory.term("=", headTerm, this.mHead.mTerm[this.mHead.mColor]));
                this.mHead.mColor = this.getParent(this.mHead.mColor);
            }
            while (this.mTail.mColor < this.mHead.mColor) {
                this.mInterpolants[this.mTail.mColor].add(this.mTheory.term("=", this.mTail.mTerm[this.mTail.mColor], tailTerm));
                this.mTail.mColor = this.getParent(this.mTail.mColor);
            }
        }
        assert (this.mHead.mColor == this.mTail.mColor);
        int color = this.mHead.mColor;
        while (color < this.mMaxColor) {
            int color1 = color;
            this.mInterpolants[color1].add(this.mTheory.not(this.mTheory.term("=", this.mHead.mTerm[color], this.mTail.mTerm[color])));
            color = this.getParent(color);
        }
        while (color < this.mNumInterpolants) {
            int color1 = color;
            this.mInterpolants[color1].add(this.mTheory.mFalse);
            color = this.getParent(color);
        }
        Term[] interpolants = new Term[this.mNumInterpolants];
        for (int part = 0; part < this.mNumInterpolants; ++part) {
            interpolants[part] = this.mTheory.and(this.mInterpolants[part].toArray(new Term[this.mInterpolants[part].size()]));
        }
        return interpolants;
    }

    public Term[] interpolateInstantiation(InterpolatorClauseInfo proofTermInfo) {
        assert (proofTermInfo.getLemmaType().equals(":inst"));
        Term[] interpolants = new Term[this.mNumInterpolants];
        Term[] lits = proofTermInfo.getLiterals();
        Term quantLit = this.mInterpolator.getAtom(lits[0]);
        Interpolator.LitInfo quantLitInfo = this.mInterpolator.getAtomOccurenceInfo(quantLit);
        for (int part = 0; part < this.mNumInterpolants; ++part) {
            InterpolatorAffineTerm aPart;
            InterpolatorAtomInfo atomInfo;
            TermVariable mixedVar;
            Interpolator.LitInfo litInfo;
            Term atom;
            int i;
            ArrayDeque<Term> terms = new ArrayDeque<Term>(lits.length);
            if (quantLitInfo.isALocal(part)) {
                for (i = 0; i < lits.length; ++i) {
                    atom = this.mInterpolator.getAtom(lits[i]);
                    litInfo = this.mInterpolator.getAtomOccurenceInfo(atom);
                    if (litInfo.isBLocal(part)) {
                        terms.add(lits[i]);
                        continue;
                    }
                    if (!litInfo.isMixed(part)) continue;
                    mixedVar = litInfo.getMixedVar();
                    atomInfo = this.mInterpolator.getAtomTermInfo(atom);
                    if (atomInfo.isCCEquality()) {
                        Term sideB;
                        Term term = sideB = litInfo.getLhsOccur().isBLocal(part) ? ((ApplicationTerm)atom).getParameters()[0] : ((ApplicationTerm)atom).getParameters()[1];
                        if (this.mInterpolator.isNegatedTerm(lits[i])) {
                            terms.add(this.mTheory.not(this.mTheory.term("=", mixedVar, sideB)));
                            continue;
                        }
                        terms.add(this.mTheory.term("@EQ", mixedVar, sideB));
                        continue;
                    }
                    if (atomInfo.isLAEquality() || atomInfo.isBoundConstraint()) {
                        InfinitesimalNumber epsilon;
                        aPart = litInfo.getAPart(part);
                        InterpolatorAffineTerm bPart = new InterpolatorAffineTerm();
                        bPart.add(Rational.ONE, atomInfo.getAffineTerm());
                        bPart.add(Rational.MONE, aPart);
                        if (atomInfo.isLAEquality()) {
                            Term sideB = bPart.toSMTLib(this.mTheory, atomInfo.isInt());
                            if (this.mInterpolator.isNegatedTerm(lits[i])) {
                                terms.add(this.mTheory.not(this.mTheory.term("=", mixedVar, sideB)));
                                continue;
                            }
                            terms.add(this.mTheory.term("@EQ", mixedVar, sideB));
                            continue;
                        }
                        bPart.add(Rational.ONE, mixedVar);
                        InfinitesimalNumber infinitesimalNumber = epsilon = atomInfo.isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
                        if (this.mInterpolator.isNegatedTerm(lits[i])) {
                            bPart.mul(Rational.MONE);
                            bPart.add(epsilon);
                        }
                        terms.add(LAInterpolator.createLATerm(bPart, epsilon.negate(), bPart.toLeq0(this.mInterpolator.mTheory)));
                        continue;
                    }
                    throw new AssertionError();
                }
                if (terms.isEmpty()) {
                    interpolants[part] = this.mTheory.mFalse;
                    continue;
                }
                interpolants[part] = this.mTheory.or(terms.toArray(new Term[terms.size()]));
                continue;
            }
            for (i = 0; i < lits.length; ++i) {
                atom = this.mInterpolator.getAtom(lits[i]);
                litInfo = this.mInterpolator.getAtomOccurenceInfo(atom);
                if (litInfo.isALocal(part)) {
                    terms.add(this.mTheory.not(lits[i]));
                    continue;
                }
                if (!litInfo.isMixed(part)) continue;
                mixedVar = litInfo.getMixedVar();
                atomInfo = this.mInterpolator.getAtomTermInfo(atom);
                if (atomInfo.isCCEquality()) {
                    Term sideA;
                    Term term = sideA = litInfo.getLhsOccur().isALocal(part) ? ((ApplicationTerm)atom).getParameters()[0] : ((ApplicationTerm)atom).getParameters()[1];
                    if (this.mInterpolator.isNegatedTerm(lits[i])) {
                        terms.add(this.mTheory.term("=", mixedVar, sideA));
                        continue;
                    }
                    terms.add(this.mTheory.term("@EQ", mixedVar, sideA));
                    continue;
                }
                if (atomInfo.isLAEquality() || atomInfo.isBoundConstraint()) {
                    InfinitesimalNumber epsilon;
                    aPart = new InterpolatorAffineTerm(litInfo.getAPart(part));
                    if (atomInfo.isLAEquality()) {
                        Term sideA = aPart.toSMTLib(this.mTheory, atomInfo.isInt());
                        if (this.mInterpolator.isNegatedTerm(lits[i])) {
                            terms.add(this.mTheory.term("=", mixedVar, sideA));
                            continue;
                        }
                        terms.add(this.mTheory.term("@EQ", mixedVar, sideA));
                        continue;
                    }
                    aPart.add(Rational.MONE, mixedVar);
                    InfinitesimalNumber infinitesimalNumber = epsilon = atomInfo.isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
                    if (!this.mInterpolator.isNegatedTerm(lits[i])) {
                        aPart.mul(Rational.MONE);
                    }
                    terms.add(LAInterpolator.createLATerm(aPart, epsilon.negate(), aPart.toLeq0(this.mInterpolator.mTheory)));
                    continue;
                }
                throw new AssertionError();
            }
            interpolants[part] = terms.isEmpty() ? this.mTheory.mTrue : this.mTheory.and(terms.toArray(new Term[terms.size()]));
        }
        return interpolants;
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo proofTermInfo) {
        this.mEqualityOccurrences = new HashMap();
        for (Term literal : proofTermInfo.getLiterals()) {
            Term atom = this.mInterpolator.getAtom(literal);
            if (atom != literal) {
                InterpolatorAtomInfo atomTermInfo = this.mInterpolator.getAtomTermInfo(atom);
                Interpolator.LitInfo occInfo = this.mInterpolator.getAtomOccurenceInfo(atom);
                assert (atomTermInfo.isCCEquality());
                ApplicationTerm eq = atomTermInfo.getEquality();
                this.mEqualityOccurrences.put(new SymmetricPair<Term>(eq.getParameters()[0], eq.getParameters()[1]), occInfo);
                continue;
            }
            assert (this.mDiseqOccurrences == null);
            this.mDiseqOccurrences = this.mInterpolator.getAtomOccurenceInfo(atom);
        }
        this.mPath = (Term[])proofTermInfo.getLemmaAnnotation();
        if (proofTermInfo.getLemmaType() == ":cong") {
            return this.interpolateCongruence((ApplicationTerm)this.mPath[0], (ApplicationTerm)this.mPath[1]);
        }
        return this.interpolateTransitivity();
    }

    public String toString() {
        return "PathInfo[" + Arrays.toString(this.mPath) + "," + this.mHead + ',' + this.mTail + "," + this.mMaxColor + "]";
    }

    class PathEnd {
        int mColor;
        Term[] mTerm;

        public PathEnd() {
            this.mColor = CCInterpolator.this.mNumInterpolants;
            this.mTerm = new Term[CCInterpolator.this.mNumInterpolants];
        }

        public void closeAPath(PathEnd other, Term boundaryTerm, Interpolator.Occurrence occur) {
            assert (other.mColor <= CCInterpolator.this.mMaxColor);
            CCInterpolator.this.mAllInA.and(occur.mInA);
            while (this.mColor < CCInterpolator.this.mNumInterpolants && occur.isBLocal(this.mColor)) {
                CCInterpolator.this.mAllInA.clear();
                int color = this.mColor;
                this.mColor = CCInterpolator.this.getParent(color);
                if (color < CCInterpolator.this.mMaxColor) {
                    CCInterpolator.this.mInterpolants[color].add(CCInterpolator.this.mTheory.term("=", this.mTerm[color], boundaryTerm));
                    this.mTerm[color] = null;
                    continue;
                }
                assert (CCInterpolator.this.mMaxColor == color);
                other.mTerm[color] = boundaryTerm;
                CCInterpolator.this.mMaxColor = this.mColor;
            }
        }

        public void openAPath(PathEnd other, Term boundaryTerm, Interpolator.Occurrence occur) {
            int child;
            while ((child = CCInterpolator.this.getChild(this.mColor, occur)) >= 0) {
                assert (occur.isALocal(child));
                if (CCInterpolator.this.mAllInA.get(child)) {
                    assert (CCInterpolator.this.mMaxColor == this.mColor && CCInterpolator.this.mMaxColor == other.mColor);
                    CCInterpolator.this.mMaxColor = other.mColor = child;
                } else {
                    this.mTerm[child] = boundaryTerm;
                }
                this.mColor = child;
            }
        }

        public void closeAPathMixed(TermVariable mixedVar, Interpolator.Occurrence occur) {
            while (occur.isBLocal(this.mColor)) {
                int color = this.mColor;
                this.mColor = CCInterpolator.this.getParent(color);
                assert (color < CCInterpolator.this.mMaxColor);
                CCInterpolator.this.mInterpolants[color].add(CCInterpolator.this.mTheory.term("@EQ", mixedVar, this.mTerm[color]));
                this.mTerm[color] = null;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String comma = "";
            sb.append(this.mColor).append(":[");
            for (int i = this.mColor; i < CCInterpolator.this.mMaxColor; ++i) {
                sb.append(comma);
                sb.append(this.mTerm[i]);
                comma = ",";
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

