/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.util.Map;

public class EQInterpolator {
    Interpolator mInterpolator;

    public EQInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    static InterpolatorAffineTerm termToAffine(Term term) {
        if (term instanceof AnnotatedTerm) {
            term = ((AnnotatedTerm)term).getSubterm();
        }
        SMTAffineTerm affine = new SMTAffineTerm(term);
        return new InterpolatorAffineTerm(affine);
    }

    private Rational getLAFactor(InterpolatorAtomInfo ccEq, InterpolatorAtomInfo laEq) {
        SMTAffineTerm ccAffine = new SMTAffineTerm(ccEq.getEquality().getParameters()[0]);
        ccAffine.add(Rational.MONE, ccEq.getEquality().getParameters()[1]);
        assert (!ccAffine.isConstant());
        Map.Entry<Term, Rational> firstEntry = ccAffine.getSummands().entrySet().iterator().next();
        Rational ccCoeff = firstEntry.getValue();
        Rational laCoeff = laEq.getAffineTerm().getSummands().get(firstEntry.getKey());
        assert (laCoeff != null && laCoeff != Rational.ZERO);
        return laCoeff.div(ccCoeff);
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo lemmaTermInfo) {
        boolean ccIsNeg;
        Interpolator.LitInfo ccOccInfo;
        Interpolator.LitInfo laOccInfo;
        InterpolatorAtomInfo ccTermInfo;
        InterpolatorAtomInfo laTermInfo;
        Term[] interpolants = null;
        Term[] eqParams = lemmaTermInfo.getLiterals();
        Term atom0 = this.mInterpolator.getAtom(eqParams[0]);
        Term atom1 = this.mInterpolator.getAtom(eqParams[1]);
        InterpolatorAtomInfo termInfo0 = this.mInterpolator.getAtomTermInfo(atom0);
        InterpolatorAtomInfo termInfo1 = this.mInterpolator.getAtomTermInfo(atom1);
        assert (this.mInterpolator.isNegatedTerm(eqParams[0]) != this.mInterpolator.isNegatedTerm(eqParams[1]));
        if (termInfo0.isLAEquality()) {
            laTermInfo = termInfo0;
            ccTermInfo = termInfo1;
            laOccInfo = this.mInterpolator.getAtomOccurenceInfo(atom0);
            ccOccInfo = this.mInterpolator.getAtomOccurenceInfo(atom1);
            ccIsNeg = atom1 != eqParams[1];
        } else {
            laTermInfo = termInfo1;
            ccTermInfo = termInfo0;
            laOccInfo = this.mInterpolator.getAtomOccurenceInfo(atom1);
            ccOccInfo = this.mInterpolator.getAtomOccurenceInfo(atom0);
            boolean bl = ccIsNeg = atom0 != eqParams[0];
        }
        assert (laTermInfo.isLAEquality() && ccTermInfo.isCCEquality());
        Rational laFactor = this.getLAFactor(ccTermInfo, laTermInfo);
        interpolants = new Term[this.mInterpolator.mNumInterpolants];
        for (int p = 0; p < this.mInterpolator.mNumInterpolants; ++p) {
            Term interpolant;
            if (ccOccInfo.isAorShared(p) && laOccInfo.isAorShared(p)) {
                interpolant = this.mInterpolator.mTheory.mFalse;
            } else if (ccOccInfo.isBorShared(p) && laOccInfo.isBorShared(p)) {
                interpolant = this.mInterpolator.mTheory.mTrue;
            } else {
                InterpolatorAffineTerm iat = new InterpolatorAffineTerm();
                TermVariable mixed = null;
                boolean aPartNegated = false;
                ApplicationTerm ccEqApp = ccTermInfo.getEquality();
                if (ccOccInfo.isALocal(p)) {
                    iat.add(laFactor, EQInterpolator.termToAffine(ccEqApp.getParameters()[0]));
                    iat.add(laFactor.negate(), EQInterpolator.termToAffine(ccEqApp.getParameters()[1]));
                    if (!ccIsNeg) {
                        aPartNegated = true;
                    }
                } else if (ccOccInfo.isMixed(p)) {
                    if (!ccIsNeg) {
                        mixed = ccOccInfo.getMixedVar();
                    }
                    if (ccOccInfo.mLhsOccur.isALocal(p)) {
                        iat.add(laFactor, EQInterpolator.termToAffine(ccEqApp.getParameters()[0]));
                        iat.add(laFactor.negate(), ccOccInfo.getMixedVar());
                    } else {
                        iat.add(laFactor, ccOccInfo.getMixedVar());
                        iat.add(laFactor.negate(), EQInterpolator.termToAffine(ccEqApp.getParameters()[1]));
                    }
                }
                if (laOccInfo.isALocal(p)) {
                    iat.add(Rational.MONE, laTermInfo.getAffineTerm());
                    if (ccIsNeg) {
                        aPartNegated = true;
                    }
                } else if (laOccInfo.isMixed(p)) {
                    if (ccIsNeg) {
                        mixed = laOccInfo.getMixedVar();
                    }
                    iat.add(Rational.MONE, laOccInfo.getAPart(p));
                    iat.add(Rational.ONE, laOccInfo.getMixedVar());
                }
                iat.mul(iat.getGcd().inverse());
                if (mixed != null) {
                    Term sharedTerm;
                    Rational mixedFactor = iat.getSummands().remove(mixed);
                    assert (mixedFactor.isIntegral());
                    boolean isInt = mixed.getSort().getName().equals("Int");
                    if (isInt && mixedFactor.abs() != Rational.ONE) {
                        if (mixedFactor.signum() > 0) {
                            iat.negate();
                        }
                        sharedTerm = iat.toSMTLib(this.mInterpolator.mTheory, isInt);
                        Term divisor = mixedFactor.abs().toTerm(mixed.getSort());
                        interpolant = this.mInterpolator.mTheory.and(this.mInterpolator.mTheory.term("@EQ", mixed, this.mInterpolator.mTheory.term("div", sharedTerm, divisor)), this.mInterpolator.mTheory.term("=", this.mInterpolator.mTheory.term("mod", sharedTerm, divisor), Rational.ZERO.toTerm(mixed.getSort())));
                    } else {
                        iat.mul(mixedFactor.negate().inverse());
                        sharedTerm = iat.toSMTLib(this.mInterpolator.mTheory, isInt);
                        interpolant = this.mInterpolator.mTheory.term("@EQ", mixed, sharedTerm);
                    }
                } else if (iat.isConstant()) {
                    if (iat.getConstant() != InfinitesimalNumber.ZERO) {
                        aPartNegated ^= true;
                    }
                    interpolant = aPartNegated ? this.mInterpolator.mTheory.mFalse : this.mInterpolator.mTheory.mTrue;
                } else {
                    boolean isInt = iat.isInt();
                    Sort sort = this.mInterpolator.mTheory.getSort(isInt ? "Int" : "Real", new Sort[0]);
                    Term term = iat.toSMTLib(this.mInterpolator.mTheory, isInt);
                    Term zero = Rational.ZERO.toTerm(sort);
                    interpolant = aPartNegated ? this.mInterpolator.mTheory.not(this.mInterpolator.mTheory.equals(term, zero)) : this.mInterpolator.mTheory.equals(term, zero);
                }
            }
            interpolants[p] = interpolant;
        }
        return interpolants;
    }
}

