/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.ArrayInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.CCInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.EQInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolantChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolantPurifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LAInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Interpolator
extends NonRecursive {
    public static final String EQ = "@EQ";
    private final TerminationRequest mCancel;
    InterpolantChecker mChecker;
    final Collection<Term> mAllAssertions;
    LogProxy mLogger;
    Theory mTheory;
    int mNumInterpolants;
    Occurrence mFullOccurrence;
    int[] mStartOfSubtrees;
    HashMap<Term, Occurrence> mSymbolPartition;
    HashMap<String, Integer> mPartitions;
    HashMap<Term, LitInfo> mAtomOccurenceInfos;
    HashMap<Term, Term[]> mInterpolants;
    HashMap<Term, InterpolatorClauseInfo> mClauseTermInfos;
    HashMap<Term, InterpolatorAtomInfo> mLiteralTermInfos;
    HashMap<FunctionSymbol, Occurrence> mFunctionSymbolOccurrenceInfos;
    HashMap<Term, TermVariable> mMixedTermAuxEq;
    HashMap<TermVariable, Term> mPurifyDefinitions;
    private final HashMap<Term, Term[]> mProvedClauses = new HashMap();
    private final ArrayDeque<Term[]> mProvedClauseStack = new ArrayDeque();
    private final ArrayDeque<Term[]> mInterpolated = new ArrayDeque();

    public Interpolator(LogProxy logger, Script checkingSolver, Collection<Term> allAssertions, Theory theory, Set<String>[] partitions, int[] startOfSubTrees, TerminationRequest cancel) {
        assert (partitions.length == startOfSubTrees.length);
        this.mPartitions = new HashMap();
        for (int i = 0; i < partitions.length; ++i) {
            Integer part = i;
            for (String name : partitions[i]) {
                this.mPartitions.put(name, part);
            }
        }
        this.mLogger = logger;
        this.mCancel = cancel;
        if (checkingSolver != null) {
            this.mChecker = new InterpolantChecker(this, checkingSolver);
            this.mChecker.assertUnpartitionedFormulas(allAssertions, this.mPartitions.keySet());
        }
        this.mAllAssertions = allAssertions;
        this.mTheory = theory;
        this.mNumInterpolants = partitions.length - 1;
        this.mFullOccurrence = new Occurrence();
        this.mFullOccurrence.occursIn(-1);
        this.mStartOfSubtrees = startOfSubTrees;
        this.mSymbolPartition = new HashMap();
        this.mAtomOccurenceInfos = new HashMap();
        this.mInterpolants = new HashMap();
        this.mClauseTermInfos = new HashMap();
        this.mLiteralTermInfos = new HashMap();
        this.mFunctionSymbolOccurrenceInfos = new HashMap();
        this.mMixedTermAuxEq = new HashMap();
        this.mPurifyDefinitions = new HashMap();
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public Term[] getInterpolants(Term proofTree) {
        this.colorTermsInAssertions();
        this.colorLiterals(proofTree);
        Term[] interpolants = this.interpolate(proofTree);
        for (int i = 0; i < interpolants.length; ++i) {
            interpolants[i] = this.unfoldLAs(interpolants[i]);
        }
        if (this.mChecker != null && !this.mChecker.checkFinalInterpolants(this.mPartitions, interpolants)) {
            throw new SMTLIBException("generated interpolants did not pass sanity check");
        }
        return interpolants;
    }

    public Term[] interpolate(Term proofTerm) {
        if (this.mInterpolants.containsKey(proofTerm)) {
            this.mLogger.debug("Proof term %s has been interpolated before.", proofTerm.hashCode());
            return this.mInterpolants.get(proofTerm);
        }
        if (this.mCancel.isTerminationRequested()) {
            throw new SMTLIBException("Timeout exceeded");
        }
        Term[] interpolants = null;
        this.run(new ProofTreeWalker(proofTerm));
        interpolants = this.collectInterpolated();
        return interpolants;
    }

    private void walkResolutionNode(Term proofTerm) {
        if (this.mCancel.isTerminationRequested()) {
            throw new SMTLIBException("Timeout exceeded");
        }
        Term resolutionTerm = proofTerm instanceof AnnotatedTerm ? ((AnnotatedTerm)proofTerm).getSubterm() : proofTerm;
        Term[] resArgs = ((ApplicationTerm)resolutionTerm).getParameters();
        Term pivot = resArgs[0];
        Term prim = resArgs[1];
        Term antecedent = resArgs[2];
        if (proofTerm instanceof AnnotatedTerm) {
            this.enqueueWalker(new SummarizeResolution(proofTerm));
        }
        this.enqueueWalker(new CombineInterpolants(pivot));
        this.enqueueWalker(new ProofTreeWalker(antecedent));
        this.enqueueWalker(new ProofTreeWalker(prim));
    }

    private void walkLeafNode(Term leaf) {
        Term[] interpolants;
        Term[] clause;
        InterpolatorClauseInfo leafTermInfo;
        block28: {
            block29: {
                block27: {
                    if (this.mCancel.isTerminationRequested()) {
                        throw new SMTLIBException("Timeout exceeded");
                    }
                    leafTermInfo = this.getClauseTermInfo(leaf);
                    clause = leafTermInfo.getLiterals();
                    if (leafTermInfo.getLeafKind() != InterpolatorClauseInfo.ClauseKind.INPUT) break block27;
                    if (this.isSkolemizedFormula(leaf)) {
                        throw new UnsupportedOperationException("Interpolation not supported for quantified formulae.");
                    }
                    String source = leafTermInfo.getSource();
                    int partition = this.mPartitions.containsKey(source) ? this.mPartitions.get(source) : 0;
                    interpolants = new Term[this.mNumInterpolants];
                    for (int i = 0; i < this.mNumInterpolants; ++i) {
                        interpolants[i] = this.mStartOfSubtrees[i] <= partition && partition <= i ? this.mTheory.mFalse : this.mTheory.mTrue;
                    }
                    break block28;
                }
                if (leafTermInfo.getLeafKind() != InterpolatorClauseInfo.ClauseKind.LEMMA) break block29;
                switch (leafTermInfo.getLemmaType()) {
                    case ":EQ": {
                        interpolants = new EQInterpolator(this).computeInterpolants(leafTermInfo);
                        break;
                    }
                    case ":cong": 
                    case ":trans": {
                        int i;
                        Object ipolator = new CCInterpolator(this);
                        interpolants = ((CCInterpolator)ipolator).computeInterpolants(leafTermInfo);
                        InterpolantPurifier purifier = new InterpolantPurifier(this);
                        for (i = 0; i < interpolants.length; ++i) {
                            interpolants[i] = purifier.purify(interpolants[i], i);
                        }
                        break block28;
                    }
                    case ":LA": {
                        Object ipolator = new LAInterpolator(this);
                        interpolants = ((LAInterpolator)ipolator).computeInterpolants(leafTermInfo);
                        break;
                    }
                    case ":trichotomy": {
                        Object ipolator = new LAInterpolator(this);
                        interpolants = ((LAInterpolator)ipolator).computeTrichotomyInterpolants(leafTermInfo);
                        break;
                    }
                    case ":read-over-weakeq": 
                    case ":weakeq-ext": 
                    case ":const-weakeq": 
                    case ":read-const-weakeq": {
                        Object ipolator = new ArrayInterpolator(this);
                        interpolants = ((ArrayInterpolator)ipolator).computeInterpolants(leafTermInfo);
                        break;
                    }
                    case ":inst": {
                        int i;
                        Object ipolator = new CCInterpolator(this);
                        interpolants = ((CCInterpolator)ipolator).interpolateInstantiation(leafTermInfo);
                        InterpolantPurifier purifier = new InterpolantPurifier(this);
                        for (i = 0; i < interpolants.length; ++i) {
                            interpolants[i] = purifier.purify(interpolants[i], i);
                            interpolants[i] = this.addQuantifier(interpolants[i], i, clause);
                        }
                        break block28;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown lemma type!");
                    }
                }
                break block28;
            }
            throw new UnsupportedOperationException("Cannot interpolate " + leaf);
        }
        this.mInterpolated.add(interpolants);
        this.mProvedClauseStack.add(clause);
        this.mInterpolants.put(leaf, interpolants);
        this.mProvedClauses.put(leaf, clause);
        this.mLogger.debug("Interpolating leaf %s %s yields ...", leaf.hashCode(), leaf);
        for (int i = 0; i <= this.mNumInterpolants - 1; ++i) {
            this.mLogger.debug(interpolants[i]);
        }
        if (this.mChecker != null) {
            this.mChecker.checkInductivity(leafTermInfo.getLiterals(), interpolants);
        }
    }

    private Term[] computeResolution(Term[] primary, Term[] antecedent, Term pivot) {
        LinkedHashSet<Term> newClause = new LinkedHashSet<Term>(antecedent.length + primary.length);
        for (Term lit : primary) {
            if (lit == pivot) continue;
            newClause.add(lit);
        }
        Term negPivot = pivot.getTheory().not(pivot);
        for (Term lit : antecedent) {
            if (lit == negPivot) continue;
            newClause.add(lit);
        }
        return newClause.toArray(new Term[newClause.size()]);
    }

    private void combine(Term pivotAtom) {
        LitInfo pivInfo = this.mAtomOccurenceInfos.get(pivotAtom);
        Term[] antecedentInterp = this.collectInterpolated();
        Term[] primInterp = this.collectInterpolated();
        Term[] interp = new Term[this.mNumInterpolants];
        Term[] antecedentClause = this.mProvedClauseStack.removeLast();
        Term[] primClause = this.mProvedClauseStack.removeLast();
        Term[] provedClause = this.computeResolution(primClause, antecedentClause, pivotAtom);
        InterpolantPurifier purifier = new InterpolantPurifier(this);
        for (int i = 0; i < this.mNumInterpolants; ++i) {
            this.mLogger.debug("Pivot %3$s%4$s on interpolants %1$s and %2$s gives...", primInterp[i], antecedentInterp[i], pivotAtom, pivInfo);
            if (pivInfo.isALocal(i)) {
                interp[i] = this.mTheory.or(primInterp[i], antecedentInterp[i]);
            } else if (pivInfo.isBLocal(i)) {
                interp[i] = this.mTheory.and(primInterp[i], antecedentInterp[i]);
            } else if (pivInfo.isAB(i)) {
                interp[i] = this.mTheory.ifthenelse(pivotAtom, antecedentInterp[i], primInterp[i]);
            } else {
                InterpolatorAtomInfo pivotTermInfo = this.getAtomTermInfo(pivotAtom);
                if (pivotTermInfo.isCCEquality() || pivotTermInfo.isLAEquality()) {
                    Term eqIpol = primInterp[i];
                    Term neqIpol = antecedentInterp[i];
                    interp[i] = this.mixedEqInterpolate(eqIpol, neqIpol, pivInfo.mMixedVar);
                } else if (pivotTermInfo.isBoundConstraint()) {
                    interp[i] = this.mixedPivotLA(antecedentInterp[i], primInterp[i], pivInfo.mMixedVar);
                } else {
                    throw new UnsupportedOperationException("Cannot handle mixed literal " + pivotAtom);
                }
            }
            interp[i] = purifier.purify(interp[i], i);
            interp[i] = this.addQuantifier(interp[i], i, provedClause);
            this.mLogger.debug(interp[i]);
        }
        this.mProvedClauseStack.add(provedClause);
        this.mInterpolated.add(interp);
    }

    private void summarize(Term proofTerm) {
        Term[] interpolants = null;
        interpolants = this.mInterpolated.getLast();
        this.mInterpolants.put(proofTerm, interpolants);
        this.mProvedClauses.put(proofTerm, this.mProvedClauseStack.getLast());
        this.mLogger.debug("...which is the resulting interpolant for Term %s ", proofTerm.hashCode());
    }

    protected final Term[] collectInterpolated() {
        return this.mInterpolated.removeLast();
    }

    public boolean checkCacheForInterpolants(Term proofTerm) {
        Term[] interpolants = this.mInterpolants.get(proofTerm);
        if (interpolants != null) {
            this.mInterpolated.add(interpolants);
            this.mProvedClauseStack.add(this.mProvedClauses.get(proofTerm));
            return true;
        }
        return false;
    }

    Term unfoldLAs(Term interpolant) {
        TermTransformer substitutor = new TermTransformer(){

            @Override
            public void convert(Term term) {
                if (LAInterpolator.isLATerm(term)) {
                    term = ((AnnotatedTerm)term).getSubterm();
                }
                super.convert(term);
            }
        };
        return substitutor.transform(interpolant);
    }

    private void colorTermsInAssertions() {
        for (Term a : this.mAllAssertions) {
            int part = -1;
            Term subTerm = a;
            if (a instanceof AnnotatedTerm) {
                AnnotatedTerm annTerm = (AnnotatedTerm)a;
                for (Annotation an : annTerm.getAnnotations()) {
                    if (!":named".equals(an.getKey()) || !this.mPartitions.containsKey(an.getValue())) continue;
                    part = this.mPartitions.get(an.getValue());
                }
                subTerm = annTerm.getSubterm();
            }
            new ColorAssertion().color(subTerm, part);
        }
    }

    private void colorLiterals(Term proofTree) {
        HashSet<Term> seen = new HashSet<Term>();
        ArrayDeque<Term> todoStack = new ArrayDeque<Term>();
        seen.add(proofTree);
        todoStack.add(proofTree);
        while (!todoStack.isEmpty()) {
            Term proofTerm = (Term)todoStack.pop();
            InterpolatorClauseInfo proofTermInfo = this.getClauseTermInfo(proofTerm);
            if (proofTermInfo.isResolution()) {
                Term resolutionTerm = proofTerm instanceof AnnotatedTerm ? ((AnnotatedTerm)proofTerm).getSubterm() : proofTerm;
                Term[] resArgs = ((ApplicationTerm)resolutionTerm).getParameters();
                todoStack.add(resArgs[1]);
                todoStack.add(resArgs[2]);
                continue;
            }
            assert (proofTermInfo.isLeaf());
            if (proofTermInfo.getLeafKind() != InterpolatorClauseInfo.ClauseKind.INPUT) continue;
            String source = proofTermInfo.getSource();
            Term[] lits = proofTermInfo.getLiterals();
            int partition = this.mPartitions.containsKey(source) ? this.mPartitions.get(source) : -1;
            for (int i = 0; i < lits.length; ++i) {
                Term atom = this.getAtom(lits[i]);
                LitInfo info = this.mAtomOccurenceInfos.get(atom);
                if (info == null) {
                    info = new LitInfo();
                    this.mAtomOccurenceInfos.put(atom, info);
                }
                if (!info.contains(partition)) {
                    info.occursIn(partition);
                    this.addOccurrence(atom, partition);
                }
                this.colorSymbols(atom, partition);
            }
        }
    }

    Occurrence getOccurrence(FunctionSymbol func) {
        if (func.isIntern() && !func.getName().startsWith("@AUX") && !func.getName().startsWith("@skolem")) {
            return this.mFullOccurrence;
        }
        return this.mFunctionSymbolOccurrenceInfos.get(func);
    }

    Occurrence getOccurrence(Term term) {
        if (term instanceof ConstantTerm) {
            return this.mFullOccurrence;
        }
        Occurrence result = this.mSymbolPartition.get(term);
        if (result == null) {
            Occurrence fsymOccurrence;
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol func = appTerm.getFunction();
            result = fsymOccurrence = this.getOccurrence(func);
            for (Term param : appTerm.getParameters()) {
                result = result.intersect(this.getOccurrence(param));
            }
            BitSet veryMixed = new BitSet();
            veryMixed.set(0, this.mNumInterpolants + 1);
            veryMixed.andNot(result.mInA);
            veryMixed.andNot(result.mInB);
            if (veryMixed.nextSetBit(0) >= 0) {
                BitSet litInA = (BitSet)result.mInA.clone();
                BitSet litInB = (BitSet)result.mInB.clone();
                litInA.or(veryMixed);
                litInA.and(fsymOccurrence.mInA);
                litInB.or(veryMixed);
                litInB.and(fsymOccurrence.mInB);
                result = new Occurrence(litInA, litInB);
            }
            this.mSymbolPartition.put(term, result);
        }
        return result;
    }

    void addOccurrence(Term term, int part) {
        if (term instanceof ConstantTerm) {
            return;
        }
        Occurrence occ = this.mSymbolPartition.get(term);
        if (occ != null && occ.contains(part)) {
            return;
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)term;
            for (Term p : at.getParameters()) {
                this.addOccurrence(p, part);
            }
            FunctionSymbol fsym = at.getFunction();
            if (!fsym.isIntern() || fsym.getName().startsWith("@AUX") || fsym.getName().contains("skolem")) {
                this.addOccurrence(fsym, part);
            }
            return;
        }
        if (occ == null) {
            occ = new Occurrence();
            this.mSymbolPartition.put(term, occ);
        }
        occ.occursIn(part);
    }

    void addOccurrence(FunctionSymbol symbol, int part) {
        Occurrence occ = this.mFunctionSymbolOccurrenceInfos.get(symbol);
        if (occ == null) {
            occ = new Occurrence();
            this.mFunctionSymbolOccurrenceInfos.put(symbol, occ);
        } else if (occ.contains(part)) {
            return;
        }
        occ.occursIn(part);
    }

    HashSet<Term> getSubTerms(Term literal) {
        HashSet<Term> subTerms = new HashSet<Term>();
        ArrayDeque<Term> todo = new ArrayDeque<Term>();
        todo.addLast(literal);
        while (!todo.isEmpty()) {
            Term term = (Term)todo.removeLast();
            if (!subTerms.add(term) || !(term instanceof ApplicationTerm)) continue;
            ApplicationTerm appTerm = (ApplicationTerm)term;
            for (Term sub : appTerm.getParameters()) {
                todo.addLast(sub);
            }
        }
        return subTerms;
    }

    HashSet<Term> getAllSubTerms(Term literal) {
        HashSet<Term> subTerms = new HashSet<Term>();
        ArrayDeque<Term> todo = new ArrayDeque<Term>();
        todo.addLast(literal);
        while (!todo.isEmpty()) {
            Term term = (Term)todo.removeLast();
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                if (!appTerm.getFunction().equals(this.mTheory.mNot)) {
                    subTerms.add(appTerm);
                }
                for (Term sub : appTerm.getParameters()) {
                    todo.addLast(sub);
                }
            }
            if (!(term instanceof AnnotatedTerm)) continue;
            todo.add(((AnnotatedTerm)term).getSubterm());
        }
        return subTerms;
    }

    LitInfo getAtomOccurenceInfo(Term atom) {
        assert (!this.isNegatedTerm(atom));
        LitInfo result = this.mAtomOccurenceInfos.get(atom);
        if (result == null) {
            this.mLogger.info("colorLiteral: " + atom);
            result = this.colorMixedLiteral(atom);
        }
        return result;
    }

    public List<Term> getSubTermsForAtom(Term atom) {
        InterpolatorAtomInfo atomInfo = this.getAtomTermInfo(atom);
        if (atomInfo.isCCEquality()) {
            ApplicationTerm eq = atomInfo.getEquality();
            return Arrays.asList(eq.getParameters());
        }
        assert (atomInfo.isLAEquality() || atomInfo.isBoundConstraint());
        ArrayList<Term> subterms = new ArrayList<Term>();
        subterms.addAll(atomInfo.getAffineTerm().getSummands().keySet());
        return subterms;
    }

    public LitInfo colorMixedLiteral(Term atom) {
        assert (!this.isNegatedTerm(atom));
        assert (!this.mAtomOccurenceInfos.containsKey(atom));
        InterpolatorAtomInfo atomInfo = this.getAtomTermInfo(atom);
        List<Term> subterms = this.getSubTermsForAtom(atom);
        LitInfo info = this.computeMixedOccurrence(subterms);
        this.mAtomOccurenceInfos.put(atom, info);
        BitSet shared = new BitSet();
        shared.or(info.mInA);
        shared.or(info.mInB);
        if (shared.nextClearBit(0) >= this.mNumInterpolants) {
            return info;
        }
        info.mMixedVar = this.mTheory.createFreshTermVariable("litaux", subterms.get(0).getSort());
        if (atomInfo.isCCEquality()) {
            ApplicationTerm eq = atomInfo.getEquality();
            info.mLhsOccur = this.getOccurrence(eq.getParameters()[0]);
        } else if (atomInfo.isBoundConstraint() || atomInfo.isLAEquality()) {
            InterpolatorAffineTerm lv = atomInfo.getAffineTerm();
            assert (lv.getSummands().size() > 1) : "Mixed Literal with only one subterm: " + lv + " atom: " + atom;
            info.mAPart = new InterpolatorAffineTerm[this.mNumInterpolants];
            for (int part = 0; part < this.mNumInterpolants; ++part) {
                if (!info.isMixed(part)) continue;
                InterpolatorAffineTerm sumApart = new InterpolatorAffineTerm();
                for (Map.Entry<Term, Rational> en : lv.getSummands().entrySet()) {
                    Term var = en.getKey();
                    Occurrence occ = this.getOccurrence(var);
                    if (!occ.isALocal(part)) continue;
                    Rational coeff = en.getValue();
                    sumApart.add(coeff, var);
                }
                info.mAPart[part] = sumApart;
            }
        }
        return info;
    }

    private LitInfo computeMixedOccurrence(List<Term> subterms) {
        BitSet inA = new BitSet(this.mNumInterpolants + 1);
        inA.set(0, this.mNumInterpolants + 1);
        BitSet inB = new BitSet(this.mNumInterpolants + 1);
        inB.set(0, this.mNumInterpolants);
        for (Term st : subterms) {
            Occurrence occInfo = this.getOccurrence(st);
            inA.and(occInfo.mInA);
            inB.and(occInfo.mInB);
        }
        LitInfo info = new LitInfo(inA, inB);
        return info;
    }

    Term substitute(Term mainTerm, TermVariable termVar, Term replacement) {
        return new Substitutor(termVar, replacement).transform(mainTerm);
    }

    private Term mixedEqInterpolate(Term eqIpol, Term neqIpol, TermVariable mixedVar) {
        EQSubstitutor ipolator = new EQSubstitutor(neqIpol, mixedVar);
        return ipolator.transform(eqIpol);
    }

    public Term mixedPivotLA(Term leqItp, Term sgItp, TermVariable mixedVar) {
        MixedLAInterpolator ipolator = mixedVar.getSort().getName().equals("Real") ? new RealInterpolator(sgItp, mixedVar) : new IntegerInterpolator(sgItp, mixedVar);
        Term newI = ipolator.transform(leqItp);
        return newI;
    }

    InterpolatorClauseInfo getClauseTermInfo(Term term) {
        if (this.mClauseTermInfos.containsKey(term)) {
            return this.mClauseTermInfos.get(term);
        }
        InterpolatorClauseInfo info = new InterpolatorClauseInfo(term);
        this.mClauseTermInfos.put(term, info);
        return info;
    }

    InterpolatorAtomInfo getAtomTermInfo(Term term) {
        assert (!this.isNegatedTerm(term));
        if (this.mLiteralTermInfos.containsKey(term)) {
            return this.mLiteralTermInfos.get(term);
        }
        InterpolatorAtomInfo info = new InterpolatorAtomInfo(term);
        this.mLiteralTermInfos.put(term, info);
        return info;
    }

    public HashSet<FunctionSymbol> getSymbols(Term term) {
        assert (term != null);
        HashSet<FunctionSymbol> result = new HashSet<FunctionSymbol>();
        HashSet<Term> visited = new HashSet<Term>();
        ArrayDeque<Term> todoStack = new ArrayDeque<Term>();
        todoStack.add(term);
        while (!todoStack.isEmpty()) {
            Term t = (Term)todoStack.pop();
            while (t instanceof AnnotatedTerm || t instanceof QuantifiedFormula) {
                if (t instanceof QuantifiedFormula) {
                    t = ((QuantifiedFormula)t).getSubformula();
                }
                if (!(t instanceof AnnotatedTerm)) continue;
                t = ((AnnotatedTerm)t).getSubterm();
            }
            if (t instanceof TermVariable || t instanceof ConstantTerm || !visited.add(t)) continue;
            ApplicationTerm at = (ApplicationTerm)t;
            FunctionSymbol funSymbol = at.getFunction();
            if (!funSymbol.isIntern() || funSymbol.getName().startsWith("@AUX") || funSymbol.getName().contains("skolem")) {
                result.add(funSymbol);
            }
            todoStack.addAll(Arrays.asList(at.getParameters()));
        }
        return result;
    }

    int getNestingDepth(ApplicationTerm term, int n) {
        if (term.getParameters().length == 0) {
            return n;
        }
        int nMax = n;
        for (int i = 0; i < term.getParameters().length; ++i) {
            if (term.getParameters()[i] instanceof TermVariable) continue;
            int j = this.getNestingDepth((ApplicationTerm)term.getParameters()[i], n + 1);
            nMax = j > nMax ? j : nMax;
        }
        return nMax;
    }

    ArrayList<Term> orderTerms(HashSet<Term> terms) {
        ApplicationTerm at;
        ArrayList<Term> ordered = new ArrayList<Term>();
        HashMap<ApplicationTerm, Integer> info = new HashMap<ApplicationTerm, Integer>();
        for (Term t : terms) {
            at = (ApplicationTerm)t;
            if (info.get(at) != null) continue;
            info.put(at, this.getNestingDepth(at, 0));
        }
        for (Term t : terms) {
            at = (ApplicationTerm)t;
            int n = 0;
            for (int i = 0; i < ordered.size(); ++i) {
                if ((Integer)info.get(at) <= (Integer)info.get(ordered.get(i))) continue;
                n = i;
                break;
            }
            ordered.add(n, at);
        }
        return ordered;
    }

    public void colorSymbols(Term literal, int partition) {
        assert (literal != null);
        HashSet<FunctionSymbol> symbols = this.getSymbols(literal);
        for (FunctionSymbol symbol : symbols) {
            Occurrence funOcc = new Occurrence();
            if (this.mFunctionSymbolOccurrenceInfos.containsKey(symbol)) {
                funOcc = this.mFunctionSymbolOccurrenceInfos.get(symbol);
            }
            funOcc.occursIn(partition);
            this.mFunctionSymbolOccurrenceInfos.put(symbol, funOcc);
        }
    }

    public TermVariable getOrCreatePurificationVariable(Term term) {
        TermVariable auxVar = this.mMixedTermAuxEq.get(term);
        if (auxVar == null) {
            auxVar = this.mTheory.createFreshTermVariable("purAux", term.getSort());
            this.mMixedTermAuxEq.put(term, auxVar);
            this.mPurifyDefinitions.put(auxVar, term);
        }
        return auxVar;
    }

    private HashSet<TermVariable> getSupportedVariables(Term[] clause, int partition) {
        HashSet<ApplicationTerm> visitedSupported = new HashSet<ApplicationTerm>();
        for (Term lit : clause) {
            Term atom = this.getAtom(lit);
            LitInfo atomOccurrence = this.getAtomOccurenceInfo(atom);
            if (atomOccurrence.isMixed(partition)) {
                for (Term term : this.getSubTermsForAtom(atom)) {
                    this.addMixedSubTerms(term, this.getOccurrence(term), partition, visitedSupported);
                }
                continue;
            }
            this.addMixedSubTerms(atom, atomOccurrence, partition, visitedSupported);
        }
        HashSet<TermVariable> supportedVars = new HashSet<TermVariable>();
        ArrayList<ApplicationTerm> todo = new ArrayList<ApplicationTerm>();
        todo.addAll(visitedSupported);
        while (!todo.isEmpty()) {
            ApplicationTerm appTerm = (ApplicationTerm)todo.remove(todo.size() - 1);
            if (!supportedVars.add(this.mMixedTermAuxEq.get(appTerm))) continue;
            for (Term subTerm : Arrays.asList(appTerm.getParameters())) {
                if (!(subTerm instanceof ApplicationTerm)) continue;
                todo.add((ApplicationTerm)subTerm);
            }
        }
        return supportedVars;
    }

    private void addMixedSubTerms(Term atom, Occurrence atomOccurrence, int partition, HashSet<ApplicationTerm> visitedSupported) {
        HashSet<Term> visited = new HashSet<Term>();
        ArrayList<Term> todo = new ArrayList<Term>();
        todo.add(atom);
        while (!todo.isEmpty()) {
            Term term = (Term)todo.remove(todo.size() - 1);
            if (!(term instanceof ApplicationTerm) || !visited.add(term)) continue;
            ApplicationTerm appTerm = (ApplicationTerm)term;
            Occurrence fsymOccurrence = this.getOccurrence(appTerm.getFunction());
            if (fsymOccurrence.isALocal(partition) && atomOccurrence.isBorShared(partition) || fsymOccurrence.isBLocal(partition) && atomOccurrence.isAorShared(partition)) {
                visitedSupported.add(appTerm);
                continue;
            }
            todo.addAll(Arrays.asList(appTerm.getParameters()));
        }
    }

    private List<TermVariable> sortVariables(Map<TermVariable, Term> map) {
        HashMap dependencies = new HashMap();
        for (Map.Entry<TermVariable, Term> e1 : map.entrySet()) {
            Term t1 = e1.getValue();
            HashSet<TermVariable> deps = new HashSet<TermVariable>();
            for (Map.Entry<TermVariable, Term> e2 : map.entrySet()) {
                if (e1.equals(e2)) continue;
                Term t2 = e2.getValue();
                HashSet<Term> sub = this.getAllSubTerms(t1);
                if (!sub.contains(t2)) continue;
                deps.add(e2.getKey());
            }
            dependencies.put(e1.getKey(), deps);
        }
        ArrayDeque<TermVariable> todoStack = new ArrayDeque<TermVariable>(map.keySet());
        ArrayList<TermVariable> ordered = new ArrayList<TermVariable>();
        TermVariable seen = null;
        Boolean reset = true;
        while (!todoStack.isEmpty()) {
            TermVariable tv = (TermVariable)todoStack.pop();
            if (tv == seen) {
                throw new IllegalArgumentException("Variable dependencies must not contain cycles.");
            }
            if (((HashSet)dependencies.get(tv)).isEmpty() || ordered.containsAll((Collection)dependencies.get(tv))) {
                ordered.add(tv);
                reset = true;
                seen = tv;
                continue;
            }
            todoStack.add(tv);
            if (!reset.booleanValue()) continue;
            seen = tv;
            reset = false;
        }
        return ordered;
    }

    private Term addQuantifier(Term interpolant, int partition, Term[] clause) {
        HashSet<TermVariable> supported = this.getSupportedVariables(clause, partition);
        LinkedHashMap<TermVariable, Term> unsupportedFreeVars = new LinkedHashMap<TermVariable, Term>();
        for (TermVariable freeVar : interpolant.getFreeVars()) {
            Term definition = this.mPurifyDefinitions.get(freeVar);
            if (definition == null) continue;
            boolean foundDependent = false;
            HashSet<Term> visited = new HashSet<Term>();
            ArrayList<Term> todo = new ArrayList<Term>();
            todo.add(definition);
            while (!todo.isEmpty()) {
                Term term = (Term)todo.remove(todo.size() - 1);
                if (supported.contains(this.mMixedTermAuxEq.get(term))) {
                    foundDependent = true;
                    break;
                }
                if (!(term instanceof ApplicationTerm) || !visited.add(term)) continue;
                todo.addAll(Arrays.asList(((ApplicationTerm)term).getParameters()));
            }
            if (foundDependent) continue;
            unsupportedFreeVars.put(freeVar, definition);
        }
        List<TermVariable> ordered = this.sortVariables(unsupportedFreeVars);
        Collections.reverse(ordered);
        for (TermVariable var : ordered) {
            FunctionSymbol outermost = ((ApplicationTerm)this.mPurifyDefinitions.get(var)).getFunction();
            if (this.mFunctionSymbolOccurrenceInfos.get(outermost).isALocal(partition)) {
                interpolant = this.mTheory.exists(new TermVariable[]{var}, interpolant);
                continue;
            }
            interpolant = this.mTheory.forall(new TermVariable[]{var}, interpolant);
        }
        return interpolant;
    }

    public boolean isNegatedTerm(Term literal) {
        return literal instanceof ApplicationTerm && ((ApplicationTerm)literal).getFunction().getName().equals("not");
    }

    public Term getAtom(Term literal) {
        return this.isNegatedTerm(literal) ? ((ApplicationTerm)literal).getParameters()[0] : literal;
    }

    private boolean isSkolemizedFormula(Term leaf) {
        InterpolatorClauseInfo info = this.getClauseTermInfo(leaf);
        for (Term lit : info.getLiterals()) {
            if (!this.containsSkolemVar(lit)) continue;
            return true;
        }
        return false;
    }

    private boolean containsSkolemVar(Term t) {
        if (t instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)t;
            String f = appTerm.getFunction().getName();
            if (f.matches("@.*skolem.*")) {
                return true;
            }
            for (Term arg : appTerm.getParameters()) {
                if (!this.containsSkolemVar(arg)) continue;
                return true;
            }
        }
        return false;
    }

    class IntegerInterpolator
    extends MixedLAInterpolator {
        public IntegerInterpolator(Term i2, TermVariable mixedVar) {
            super(i2, mixedVar);
        }

        @Override
        public Term interpolate(AnnotatedTerm la1, AnnotatedTerm la2) {
            Rational kc;
            InterpolatorAffineTerm theS;
            Rational theC;
            Rational k2c2;
            InterpolatorAffineTerm s1 = LAInterpolator.getS(la1);
            Rational c1 = s1.getSummands().get(this.mMixedVar);
            InfinitesimalNumber k1 = LAInterpolator.getK(la1);
            InterpolatorAffineTerm s2 = LAInterpolator.getS(la2);
            Rational c2 = s2.getSummands().get(this.mMixedVar);
            InfinitesimalNumber k2 = LAInterpolator.getK(la2);
            assert (c1.isIntegral() && c2.isIntegral());
            assert (c1.signum() * c2.signum() == -1);
            Rational absc1 = c1.abs();
            Rational absc2 = c2.abs();
            InterpolatorAffineTerm c1s2c2s1 = new InterpolatorAffineTerm();
            c1s2c2s1.add(absc1, s2);
            c1s2c2s1.add(absc2, s1);
            assert (!c1s2c2s1.getSummands().containsKey(this.mMixedVar));
            Rational c1c2 = absc1.mul(absc2);
            InfinitesimalNumber newK = k1.mul(absc2).add(k2.mul(absc1)).add(new InfinitesimalNumber(c1c2, 0));
            assert (newK.isIntegral());
            Rational k1c1 = k1.mReal.add(Rational.ONE).div(absc1).ceil();
            if (k1c1.compareTo(k2c2 = k2.mReal.add(Rational.ONE).div(absc2).ceil()) < 0) {
                theC = c1;
                theS = s1;
                kc = k1c1;
            } else {
                theC = c2;
                theS = s2;
                kc = k2c2;
            }
            Term newF = Interpolator.this.mTheory.mFalse;
            InterpolatorAffineTerm sPlusOffset = new InterpolatorAffineTerm();
            sPlusOffset.add(theC.signum() > 0 ? Rational.MONE : Rational.ONE, theS);
            sPlusOffset.getSummands().remove(this.mMixedVar);
            Rational offset = Rational.ZERO;
            Rational theCabs = theC.abs();
            if (theC.signum() < 0) {
                sPlusOffset.add(theCabs.add(Rational.MONE));
            }
            while (offset.compareTo(kc) <= 0) {
                if (Interpolator.this.mCancel.isTerminationRequested()) {
                    throw new SMTLIBException("Timeout exceeded");
                }
                Term x = sPlusOffset.toSMTLib(Interpolator.this.mTheory, true);
                if (theCabs != Rational.ONE) {
                    x = Interpolator.this.mTheory.term("div", x, theCabs.toTerm(Interpolator.this.mTheory.getNumericSort()));
                }
                Term F1 = Interpolator.this.substitute(la1.getSubterm(), this.mMixedVar, x);
                Term F2 = Interpolator.this.substitute(la2.getSubterm(), this.mMixedVar, x);
                if (offset.compareTo(kc) == 0) {
                    if (theS == s1) {
                        F1 = Interpolator.this.mTheory.mTrue;
                    } else {
                        F2 = Interpolator.this.mTheory.mTrue;
                    }
                }
                newF = Interpolator.this.mTheory.or(newF, Interpolator.this.mTheory.and(F1, F2));
                sPlusOffset.add(theC.negate());
                offset = offset.add(Rational.ONE);
            }
            return LAInterpolator.createLATerm(c1s2c2s1, newK, newF);
        }
    }

    class RealInterpolator
    extends MixedLAInterpolator {
        public RealInterpolator(Term i2, TermVariable mixedVar) {
            super(i2, mixedVar);
        }

        @Override
        public Term interpolate(AnnotatedTerm la1, AnnotatedTerm la2) {
            Term newF;
            InterpolatorAffineTerm s1 = LAInterpolator.getS(la1);
            Rational c1 = s1.getSummands().get(this.mMixedVar);
            InfinitesimalNumber k1 = LAInterpolator.getK(la1);
            InterpolatorAffineTerm s2 = LAInterpolator.getS(la2);
            Rational c2 = s2.getSummands().get(this.mMixedVar);
            InfinitesimalNumber k2 = LAInterpolator.getK(la2);
            assert (c1.signum() * c2.signum() == -1);
            InfinitesimalNumber newK = k1.mul(c2.abs()).add(k2.mul(c1.abs()));
            InterpolatorAffineTerm c1s2c2s1 = new InterpolatorAffineTerm();
            c1s2c2s1.add(c1.abs(), s2);
            c1s2c2s1.add(c2.abs(), s1);
            assert (!c1s2c2s1.getSummands().containsKey(this.mMixedVar));
            if (s1.getConstant().mEps > 0 || s2.getConstant().mEps > 0) {
                newF = c1s2c2s1.toLeq0(Interpolator.this.mTheory);
                newK = InfinitesimalNumber.EPSILON.negate();
            } else if (k1.less(InfinitesimalNumber.ZERO)) {
                InterpolatorAffineTerm s1divc1 = new InterpolatorAffineTerm(s1);
                s1divc1.getSummands().remove(this.mMixedVar);
                s1divc1.mul(c1.inverse().negate());
                Term s1DivByc1 = s1divc1.toSMTLib(Interpolator.this.mTheory, false);
                newF = Interpolator.this.substitute(la2.getSubterm(), this.mMixedVar, s1DivByc1);
                newK = k2;
            } else if (k2.less(InfinitesimalNumber.ZERO)) {
                InterpolatorAffineTerm s2divc2 = new InterpolatorAffineTerm(s2);
                s2divc2.getSummands().remove(this.mMixedVar);
                s2divc2.mul(c2.inverse().negate());
                Term s2DivByc2 = s2divc2.toSMTLib(Interpolator.this.mTheory, false);
                newF = Interpolator.this.substitute(la1.getSubterm(), this.mMixedVar, s2DivByc2);
                newK = k1;
            } else {
                InterpolatorAffineTerm s1divc1 = new InterpolatorAffineTerm(s1);
                s1divc1.getSummands().remove(this.mMixedVar);
                s1divc1.mul(c1.inverse().negate());
                Term s1DivByc1 = s1divc1.toSMTLib(Interpolator.this.mTheory, false);
                Term f1 = Interpolator.this.substitute(la1.getSubterm(), this.mMixedVar, s1DivByc1);
                Term f2 = Interpolator.this.substitute(la2.getSubterm(), this.mMixedVar, s1DivByc1);
                newF = Interpolator.this.mTheory.and(f1, f2);
                if (c1s2c2s1.isConstant()) {
                    if (c1s2c2s1.getConstant().less(InfinitesimalNumber.ZERO)) {
                        newF = Interpolator.this.mTheory.mTrue;
                    }
                } else {
                    InterpolatorAffineTerm s3 = new InterpolatorAffineTerm(c1s2c2s1);
                    s3.add(InfinitesimalNumber.EPSILON);
                    newF = Interpolator.this.mTheory.or(s3.toLeq0(Interpolator.this.mTheory), newF);
                }
                newK = InfinitesimalNumber.ZERO;
            }
            return LAInterpolator.createLATerm(c1s2c2s1, newK, newF);
        }
    }

    static abstract class MixedLAInterpolator
    extends TermTransformer {
        TermVariable mMixedVar;
        Term mI2;
        AnnotatedTerm mLA1;

        public MixedLAInterpolator(Term i2, TermVariable mixed) {
            this.mMixedVar = mixed;
            this.mLA1 = null;
            this.mI2 = i2;
        }

        abstract Term interpolate(AnnotatedTerm var1, AnnotatedTerm var2);

        @Override
        public void convert(Term term) {
            assert (term != this.mMixedVar);
            if (LAInterpolator.isLATerm(term)) {
                AnnotatedTerm laTerm = (AnnotatedTerm)term;
                InterpolatorAffineTerm s2 = LAInterpolator.getS(term);
                if (s2.getSummands().get(this.mMixedVar) != null) {
                    if (this.mLA1 == null) {
                        this.beginScope(new TermVariable[]{this.mMixedVar});
                        this.mLA1 = laTerm;
                        this.enqueueWalker(new NonRecursive.Walker(){

                            @Override
                            public void walk(NonRecursive engine) {
                                ((MixedLAInterpolator)engine).mLA1 = null;
                                ((MixedLAInterpolator)engine).endScope();
                            }
                        });
                        this.pushTerm(this.mI2);
                        return;
                    }
                    this.setResult(this.interpolate(this.mLA1, laTerm));
                    return;
                }
            }
            super.convert(term);
        }
    }

    class TermSubstitutor
    extends TermTransformer {
        Term mTerm;
        Term mReplacement;

        TermSubstitutor(Term term, Term replacement) {
            this.mTerm = term;
            this.mReplacement = replacement;
        }

        @Override
        public void convert(final Term oldTerm) {
            if (oldTerm == this.mTerm) {
                this.setResult(this.mReplacement);
            } else {
                if (oldTerm instanceof ApplicationTerm) {
                    final Term[] oldParams = ((ApplicationTerm)oldTerm).getParameters();
                    this.enqueueWalker(new NonRecursive.Walker(){

                        @Override
                        public void walk(NonRecursive engine) {
                            TermSubstitutor ts = (TermSubstitutor)engine;
                            String funName = ((ApplicationTerm)oldTerm).getFunction().getName();
                            Term[] newParams = ts.getConverted(oldParams);
                            if (newParams == oldParams) {
                                ts.setResult(oldTerm);
                                return;
                            }
                            Term newTerm = Interpolator.this.mTheory.term(funName, newParams);
                            ts.setResult(newTerm);
                        }
                    });
                    this.pushTerms(oldParams);
                    return;
                }
                super.convert(oldTerm);
            }
        }
    }

    class EQSubstitutor
    extends TermTransformer {
        Term mI2;
        TermVariable mAuxVar;

        EQSubstitutor(Term i2, TermVariable auxVar) {
            this.mI2 = i2;
            this.mAuxVar = auxVar;
        }

        @Override
        public void convert(Term term) {
            assert (term != this.mAuxVar);
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                FunctionSymbol func = appTerm.getFunction();
                Term[] params = appTerm.getParameters();
                if (func.isIntern() && func.getName().equals(Interpolator.EQ) && params[0] == this.mAuxVar) {
                    assert (params.length == 2);
                    this.setResult(Interpolator.this.substitute(this.mI2, this.mAuxVar, params[1]));
                    return;
                }
            }
            super.convert(term);
        }
    }

    public static class Substitutor
    extends TermTransformer {
        TermVariable mTermVar;
        Term mReplacement;

        public Substitutor(TermVariable termVar, Term replacement) {
            this.mTermVar = termVar;
            this.mReplacement = replacement;
        }

        private static boolean isSMTAffineTerm(Term term) {
            if (!term.getSort().isNumericSort()) {
                return false;
            }
            if (term instanceof ApplicationTerm) {
                FunctionSymbol fsym = ((ApplicationTerm)term).getFunction();
                return fsym.isIntern() && (fsym.getName() == "+" || fsym.getName() == "-" || fsym.getName() == "*" || fsym.getName() == "to_real");
            }
            return term instanceof ConstantTerm;
        }

        @Override
        public void convert(final Term oldTerm) {
            if (Substitutor.isSMTAffineTerm(oldTerm)) {
                final SMTAffineTerm oldAffine = new SMTAffineTerm(oldTerm);
                final Term[] oldSummands = oldAffine.getSummands().keySet().toArray(new Term[oldAffine.getSummands().size()]);
                this.enqueueWalker(new NonRecursive.Walker(){

                    @Override
                    public void walk(NonRecursive engine) {
                        Substitutor me = (Substitutor)engine;
                        Term[] newSummands = me.getConverted(oldSummands);
                        if (newSummands == oldSummands) {
                            me.setResult(oldTerm);
                            return;
                        }
                        SMTAffineTerm newAffine = new SMTAffineTerm();
                        for (int i = 0; i < oldSummands.length; ++i) {
                            newAffine.add(oldAffine.getSummands().get(oldSummands[i]), newSummands[i]);
                        }
                        newAffine.add(oldAffine.getConstant());
                        me.setResult(newAffine.toTerm(oldTerm.getSort()));
                    }
                });
                this.pushTerms(oldSummands);
                return;
            }
            if (LAInterpolator.isLATerm(oldTerm)) {
                final InterpolatorAffineTerm oldS = LAInterpolator.getS(oldTerm);
                final InfinitesimalNumber oldK = LAInterpolator.getK(oldTerm);
                final Term oldF = LAInterpolator.getF(oldTerm);
                final Term[] oldSummands = oldS.getSummands().keySet().toArray(new Term[oldS.getSummands().size()]);
                this.enqueueWalker(new NonRecursive.Walker(){

                    @Override
                    public void walk(NonRecursive engine) {
                        Substitutor me = (Substitutor)engine;
                        Term newF = me.getConverted();
                        Term[] newSummands = me.getConverted(oldSummands);
                        if (newF == oldF && newSummands == oldSummands) {
                            me.setResult(oldTerm);
                            return;
                        }
                        InterpolatorAffineTerm newS = new InterpolatorAffineTerm();
                        for (int i = 0; i < oldSummands.length; ++i) {
                            newS.add(oldS.getSummands().get(oldSummands[i]), newSummands[i]);
                        }
                        newS.add(oldS.getConstant());
                        me.setResult(LAInterpolator.createLATerm(newS, oldK, newF));
                    }
                });
                this.pushTerm(oldF);
                this.pushTerms(oldSummands);
                return;
            }
            if (oldTerm.equals(this.mTermVar)) {
                this.setResult(this.mReplacement);
            } else {
                super.convert(oldTerm);
            }
        }
    }

    private class ColorAssertion
    extends NonRecursive {
        private HashSet<Term> mSeen;

        private ColorAssertion() {
        }

        void color(Term term, int part) {
            this.mSeen = new HashSet();
            this.run(new ColorTerm(term, part));
        }

        private class ColorTerm
        extends NonRecursive.TermWalker {
            final int mPart;

            public ColorTerm(Term term, int part) {
                super(term);
                this.mPart = part;
            }

            @Override
            public void walk(NonRecursive walker) {
                if (ColorAssertion.this.mSeen.add(this.mTerm)) {
                    super.walk(walker);
                }
            }

            @Override
            public void walk(NonRecursive walker, ConstantTerm term) {
            }

            @Override
            public void walk(NonRecursive walker, AnnotatedTerm term) {
                walker.enqueueWalker(new ColorTerm(term.getSubterm(), this.mPart));
            }

            @Override
            public void walk(NonRecursive walker, ApplicationTerm term) {
                FunctionSymbol fsym = term.getFunction();
                Term def = fsym.getDefinition();
                if (def != null) {
                    Term[] params = term.getParameters();
                    HashMap<TermVariable, Term> subs = new HashMap<TermVariable, Term>();
                    for (int i = 0; i < params.length; ++i) {
                        subs.put(term.getFunction().getDefinitionVars()[i], params[i]);
                    }
                    FormulaUnLet unletter = new FormulaUnLet();
                    unletter.addSubstitutions(subs);
                    Term expanded = unletter.unlet(def);
                    walker.enqueueWalker(new ColorTerm(expanded, this.mPart));
                } else {
                    if (!term.getFunction().isIntern()) {
                        if (term.getFreeVars().length == 0) {
                            Interpolator.this.addOccurrence(term, this.mPart);
                        }
                        Interpolator.this.addOccurrence(fsym, this.mPart);
                    }
                    for (Term param : ((ApplicationTerm)this.mTerm).getParameters()) {
                        walker.enqueueWalker(new ColorTerm(param, this.mPart));
                    }
                }
            }

            @Override
            public void walk(NonRecursive walker, LetTerm term) {
                walker.enqueueWalker(new ColorTerm(new FormulaUnLet().unlet(term), this.mPart));
            }

            @Override
            public void walk(NonRecursive walker, LambdaTerm term) {
                walker.enqueueWalker(new ColorTerm(term.getSubterm(), this.mPart));
            }

            @Override
            public void walk(NonRecursive walker, QuantifiedFormula term) {
                walker.enqueueWalker(new ColorTerm(term.getSubformula(), this.mPart));
            }

            @Override
            public void walk(NonRecursive walker, TermVariable term) {
            }

            @Override
            public void walk(NonRecursive walker, MatchTerm term) {
                walker.enqueueWalker(new ColorTerm(term.getDataTerm(), this.mPart));
                for (Term t : term.getCases()) {
                    walker.enqueueWalker(new ColorTerm(t, this.mPart));
                }
            }
        }
    }

    class LitInfo
    extends Occurrence {
        TermVariable mMixedVar;
        Occurrence mLhsOccur;
        InterpolatorAffineTerm[] mAPart;

        public LitInfo() {
        }

        public LitInfo(BitSet inA, BitSet inB) {
            super(inA, inB);
        }

        public TermVariable getMixedVar() {
            return this.mMixedVar;
        }

        public Occurrence getLhsOccur() {
            return this.mLhsOccur;
        }

        public InterpolatorAffineTerm getAPart(int p) {
            return this.mAPart[p];
        }
    }

    class Occurrence {
        BitSet mInA;
        BitSet mInB;

        public Occurrence() {
            this.mInA = new BitSet(Interpolator.this.mNumInterpolants + 1);
            this.mInA.set(Interpolator.this.mNumInterpolants);
            this.mInB = new BitSet(Interpolator.this.mNumInterpolants + 1);
        }

        public Occurrence(BitSet inA, BitSet inB) {
            this.mInA = inA;
            this.mInB = inB;
        }

        public void occursIn(int partition) {
            for (int i = 0; i <= Interpolator.this.mNumInterpolants; ++i) {
                if (partition == -1) {
                    this.mInA.set(i);
                    if (i == Interpolator.this.mNumInterpolants) continue;
                    this.mInB.set(i);
                    continue;
                }
                if (i < partition || Interpolator.this.mStartOfSubtrees[i] > partition) {
                    this.mInB.set(i);
                    continue;
                }
                this.mInA.set(i);
            }
        }

        public boolean isALocalInSomeChild(int partition) {
            int i = partition - 1;
            while (i >= Interpolator.this.mStartOfSubtrees[partition]) {
                if (this.mInA.get(i)) {
                    return true;
                }
                i = Interpolator.this.mStartOfSubtrees[i] - 1;
            }
            return false;
        }

        public boolean contains(int partition) {
            if (partition == -1) {
                for (int i = 0; i <= Interpolator.this.mNumInterpolants; ++i) {
                    if (this.mInA.get(i) && this.mInB.get(i)) continue;
                    return false;
                }
                return true;
            }
            if (!this.mInA.get(partition)) {
                return false;
            }
            if (this.mInB.get(partition)) {
                return true;
            }
            int i = partition - 1;
            while (i >= Interpolator.this.mStartOfSubtrees[partition]) {
                if (!this.mInB.get(i)) {
                    return false;
                }
                i = Interpolator.this.mStartOfSubtrees[i] - 1;
            }
            return true;
        }

        public Occurrence intersect(Occurrence other) {
            BitSet inA = (BitSet)this.mInA.clone();
            BitSet inB = (BitSet)this.mInB.clone();
            inA.and(other.mInA);
            inB.and(other.mInB);
            return new Occurrence(inA, inB);
        }

        public boolean isAorShared(int partition) {
            return this.mInA.get(partition);
        }

        public boolean isBorShared(int partition) {
            return this.mInB.get(partition);
        }

        public boolean isALocal(int partition) {
            return this.mInA.get(partition) && !this.mInB.get(partition);
        }

        public boolean isBLocal(int partition) {
            return this.mInB.get(partition) && !this.mInA.get(partition);
        }

        public boolean isAB(int partition) {
            return this.mInA.get(partition) && this.mInB.get(partition);
        }

        public boolean isMixed(int partition) {
            return !this.mInA.get(partition) && !this.mInB.get(partition);
        }

        public String toString() {
            return "[" + this.mInA + "|" + this.mInB + "]";
        }

        public int getALocalColor() {
            int color = this.mInA.nextSetBit(0);
            if (this.mInB.get(color)) {
                color = this.mInB.nextClearBit(color);
            }
            return color;
        }
    }

    public static class SummarizeResolution
    implements NonRecursive.Walker {
        private final Term mProofTerm;

        public SummarizeResolution(Term proofTerm) {
            this.mProofTerm = proofTerm;
        }

        @Override
        public void walk(NonRecursive engine) {
            ((Interpolator)engine).summarize(this.mProofTerm);
        }
    }

    public static class CombineInterpolants
    implements NonRecursive.Walker {
        private final Term mPivot;

        public CombineInterpolants(Term pivot) {
            this.mPivot = pivot;
        }

        @Override
        public void walk(NonRecursive engine) {
            ((Interpolator)engine).combine(this.mPivot);
        }
    }

    public static class ProofTreeWalker
    implements NonRecursive.Walker {
        private final Term mProofTerm;

        public ProofTreeWalker(Term proofTerm) {
            this.mProofTerm = proofTerm;
        }

        @Override
        public void walk(NonRecursive engine) {
            Interpolator proofTreeWalker = (Interpolator)engine;
            if (proofTreeWalker.checkCacheForInterpolants(this.mProofTerm)) {
                return;
            }
            InterpolatorClauseInfo proofTermInfo = ((Interpolator)engine).getClauseTermInfo(this.mProofTerm);
            if (proofTermInfo.isResolution()) {
                ((Interpolator)engine).walkResolutionNode(this.mProofTerm);
            } else {
                ((Interpolator)engine).walkLeafNode(this.mProofTerm);
            }
        }
    }
}

