/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.util.Map;

public class InterpolatorAffineTerm {
    final SMTAffineTerm mAffine = new SMTAffineTerm();
    int mEpsilon;

    public InterpolatorAffineTerm() {
        this.mEpsilon = 0;
    }

    public InterpolatorAffineTerm(InterpolatorAffineTerm iat) {
        this.mAffine.add(iat.mAffine);
        this.mEpsilon = iat.mEpsilon;
    }

    public InterpolatorAffineTerm(SMTAffineTerm affine) {
        this.mAffine.add(affine);
        this.mEpsilon = 0;
    }

    public void add(Rational c) {
        this.mAffine.add(c);
    }

    public void add(InfinitesimalNumber c) {
        this.mAffine.add(c.mReal);
        this.mEpsilon += c.mEps;
    }

    public void add(Rational c, Term term) {
        this.mAffine.add(c, term);
    }

    public void add(Rational c, InterpolatorAffineTerm a) {
        this.mAffine.add(c, a.mAffine);
        this.mEpsilon += c.signum() * a.mEpsilon;
    }

    public void mul(Rational c) {
        this.mAffine.mul(c);
        this.mEpsilon *= c.signum();
    }

    public void negate() {
        this.mAffine.negate();
        this.mEpsilon = -this.mEpsilon;
    }

    public boolean isConstant() {
        return this.mAffine.isConstant();
    }

    public InfinitesimalNumber getConstant() {
        return new InfinitesimalNumber(this.mAffine.getConstant(), this.mEpsilon);
    }

    public Map<Term, Rational> getSummands() {
        return this.mAffine.getSummands();
    }

    public Rational getGcd() {
        return this.mAffine.getGcd();
    }

    public String toString() {
        return this.mAffine.toString() + (this.mEpsilon == 0 ? "" : (this.mEpsilon < 0 ? " - eps" : " + eps"));
    }

    public Term toSMTLib(Theory t, boolean isInt) {
        assert (this.mEpsilon == 0);
        Sort numSort = isInt ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
        return this.mAffine.toTerm(numSort);
    }

    public boolean isInt() {
        for (Term v : this.getSummands().keySet()) {
            if (v.getSort().getName().equals("Int")) continue;
            return false;
        }
        return true;
    }

    public Term toLeq0(Theory t) {
        assert (this.mEpsilon >= 0);
        if (this.isConstant()) {
            return this.getConstant().compareTo(InfinitesimalNumber.ZERO) <= 0 ? t.mTrue : t.mFalse;
        }
        SMTAffineTerm left = new SMTAffineTerm();
        SMTAffineTerm right = new SMTAffineTerm();
        Sort numSort = this.isInt() ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
        for (Map.Entry<Term, Rational> entry : this.getSummands().entrySet()) {
            Rational coeff = entry.getValue();
            if (coeff.signum() < 0) {
                right.add(coeff.negate(), entry.getKey());
                continue;
            }
            left.add(coeff, entry.getKey());
        }
        right.add(this.mAffine.getConstant().negate());
        return t.term(this.mEpsilon == 0 ? "<=" : "<", left.toTerm(numSort), right.toTerm(numSort));
    }

    public int hashCode() {
        return this.mAffine.hashCode() + 1021 * this.mEpsilon;
    }
}

