/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;

public class InterpolatorAtomInfo {
    private boolean mIsCCEquality = false;
    private boolean mIsLAEquality = false;
    private boolean mIsBoundConstraint = false;
    private ApplicationTerm mCCEquality;
    private InterpolatorAffineTerm mAffineTerm = null;
    private boolean mIsInt = false;

    public InterpolatorAtomInfo(Term atom) {
        this.computeAtomInfo(atom);
    }

    public void computeAtomInfo(Term term) {
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().isIntern()) {
            boolean isEquals;
            ApplicationTerm atom = (ApplicationTerm)term;
            assert (!atom.getFunction().getName().equals("not"));
            String funcName = atom.getFunction().getName();
            boolean bl = isEquals = funcName == "=";
            if (isEquals && !InterpolatorAtomInfo.isZero(atom.getParameters()[1])) {
                this.mIsCCEquality = true;
                this.mCCEquality = atom;
            } else if (isEquals || funcName == "<=" || funcName == "<") {
                this.computeLAInformation(atom);
            }
        }
    }

    private static boolean isZero(Term term) {
        return term instanceof ConstantTerm && ((ConstantTerm)term).getValue() == Rational.ZERO;
    }

    private void computeLAInformation(ApplicationTerm laAtom) {
        boolean isStrict = false;
        switch (laAtom.getFunction().getName()) {
            case "<=": {
                this.mIsBoundConstraint = true;
                break;
            }
            case "<": {
                this.mIsBoundConstraint = true;
                isStrict = true;
                break;
            }
            case "=": {
                this.mIsLAEquality = true;
                break;
            }
            default: {
                throw new AssertionError((Object)"Malformed LA term.");
            }
        }
        Term[] params = laAtom.getParameters();
        assert (params[1] == Rational.ZERO.toTerm(params[1].getSort()));
        this.mIsInt = params[1].getSort().getName().equals("Int");
        this.mAffineTerm = new InterpolatorAffineTerm(new SMTAffineTerm(params[0]));
        assert (this.mAffineTerm.getConstant().mEps == 0);
        if (isStrict) {
            this.mAffineTerm.add(this.getEpsilon());
        }
    }

    public boolean isCCEquality() {
        return this.mIsCCEquality;
    }

    public boolean isLAEquality() {
        return this.mIsLAEquality;
    }

    public boolean isBoundConstraint() {
        return this.mIsBoundConstraint;
    }

    public ApplicationTerm getEquality() {
        return this.mCCEquality;
    }

    public InterpolatorAffineTerm getAffineTerm() {
        return this.mAffineTerm;
    }

    public InfinitesimalNumber getEpsilon() {
        return this.isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
    }

    public boolean isInt() {
        return this.mIsInt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AtomInfo(");
        if (this.isCCEquality()) {
            sb.append("CC:").append(this.getEquality());
        } else if (this.isLAEquality()) {
            sb.append("LA:").append(this.getAffineTerm()).append(" == 0");
            if (!this.isInt()) {
                sb.append(".0");
            }
        } else if (this.isBoundConstraint()) {
            sb.append("LA:").append(this.getAffineTerm()).append(" <= 0");
            if (!this.isInt()) {
                sb.append(".0");
            }
        } else {
            sb.append("NOINFO");
        }
        sb.append(")");
        return sb.toString();
    }
}

