/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import java.util.LinkedHashSet;

public class InterpolatorClauseInfo {
    private Term[] mLiterals;
    private final ClauseKind mNodeKind;
    private Term[] mResolutionArgs;
    private Annotation mLemmaAnnotation;

    public InterpolatorClauseInfo(Term term) {
        if (ProofRules.isProofRule("res", term)) {
            this.mNodeKind = ClauseKind.RESOLUTION;
        } else {
            AnnotatedTerm annotTerm = (AnnotatedTerm)term;
            this.mLemmaAnnotation = annotTerm.getAnnotations()[1];
            this.mNodeKind = this.mLemmaAnnotation.getKey() == ":rup" ? ClauseKind.RESOLUTION : (this.mLemmaAnnotation.getKey() == ":input" ? ClauseKind.INPUT : ClauseKind.LEMMA);
            this.mLiterals = InterpolatorClauseInfo.computeLiterals((Object[])annotTerm.getAnnotations()[0].getValue());
        }
    }

    public void computeResolutionLiterals(Interpolator interpolator) {
        assert (this.isResolution());
        LinkedHashSet<Term> literals = new LinkedHashSet<Term>();
        InterpolatorClauseInfo primInfo = interpolator.mClauseTermInfos.get(this.mResolutionArgs[1]);
        Term pivot = this.mResolutionArgs[0];
        for (Term primLit : primInfo.getLiterals()) {
            if (primLit == pivot) continue;
            literals.add(primLit);
        }
        InterpolatorClauseInfo antecedentInfo = interpolator.mClauseTermInfos.get(this.mResolutionArgs[2]);
        Term negPivot = pivot.getTheory().term("not", pivot);
        for (Term antLit : antecedentInfo.getLiterals()) {
            if (antLit == negPivot) continue;
            literals.add(antLit);
        }
        this.mLiterals = literals.toArray(new Term[literals.size()]);
    }

    private static Term[] computeLiterals(Object[] rawLits) {
        assert (rawLits.length % 2 == 0);
        Term[] literals = new Term[rawLits.length / 2];
        for (int i = 0; i < literals.length; ++i) {
            Term atom = (Term)rawLits[2 * i + 1];
            literals[i] = rawLits[2 * i] == "+" ? atom : atom.getTheory().term("not", atom);
        }
        return literals;
    }

    public boolean isResolution() {
        return this.mNodeKind == ClauseKind.RESOLUTION;
    }

    public boolean isLeaf() {
        return this.mNodeKind != ClauseKind.RESOLUTION;
    }

    public ClauseKind getLeafKind() {
        return this.mNodeKind;
    }

    public String getLemmaType() {
        return this.mLemmaAnnotation.getKey();
    }

    public Object getLemmaAnnotation() {
        return this.mLemmaAnnotation.getValue();
    }

    public Term[] getLiterals() {
        return this.mLiterals;
    }

    public Term getPivotLiteral() {
        return this.mResolutionArgs[0];
    }

    public Term[] getResolutionArgs() {
        return this.mResolutionArgs;
    }

    public String getSource() {
        assert (this.mNodeKind == ClauseKind.INPUT);
        return (String)this.mLemmaAnnotation.getValue();
    }

    static enum ClauseKind {
        RESOLUTION,
        LEMMA,
        INPUT;

    }
}

