/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LAInterpolator {
    public static final String ANNOT_LA = ":LA";
    Interpolator mInterpolator;

    public LAInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public static Term createLATerm(InterpolatorAffineTerm s, InfinitesimalNumber k, Term formula) {
        Theory theory = formula.getTheory();
        return theory.annotatedTerm(new Annotation[]{new Annotation(ANNOT_LA, new Object[]{s, k})}, formula);
    }

    public static boolean isLATerm(Term term) {
        if (term instanceof AnnotatedTerm) {
            Annotation[] annot = ((AnnotatedTerm)term).getAnnotations();
            return annot.length == 1 && annot[0].getKey().equals(ANNOT_LA);
        }
        return false;
    }

    public static InterpolatorAffineTerm getS(Term term) {
        assert (LAInterpolator.isLATerm(term));
        return (InterpolatorAffineTerm)((Object[])((AnnotatedTerm)term).getAnnotations()[0].getValue())[0];
    }

    public static InfinitesimalNumber getK(Term term) {
        assert (LAInterpolator.isLATerm(term));
        return (InfinitesimalNumber)((Object[])((AnnotatedTerm)term).getAnnotations()[0].getValue())[1];
    }

    public static Term getF(Term term) {
        assert (LAInterpolator.isLATerm(term));
        return ((AnnotatedTerm)term).getSubterm();
    }

    private HashMap<Term, Rational> getFarkasCoeffs(InterpolatorClauseInfo clauseInfo) {
        HashMap<Term, Rational> coeffMap = new HashMap<Term, Rational>();
        Term[] lits = clauseInfo.getLiterals();
        Object[] coeffs = (Object[])clauseInfo.getLemmaAnnotation();
        for (int i = 0; i < coeffs.length; ++i) {
            Rational coeff = SMTAffineTerm.convertConstant((ConstantTerm)coeffs[i]);
            coeffMap.put(lits[i], coeff);
        }
        return coeffMap;
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo lemmaInfo) {
        InterpolatorAffineTerm[] ipl = new InterpolatorAffineTerm[this.mInterpolator.mNumInterpolants + 1];
        for (int part = 0; part < ipl.length; ++part) {
            ipl[part] = new InterpolatorAffineTerm();
        }
        ArrayList[] auxVars = new ArrayList[this.mInterpolator.mNumInterpolants];
        for (Map.Entry<Term, Rational> entry : this.getFarkasCoeffs(lemmaInfo).entrySet()) {
            Term atom = this.mInterpolator.getAtom(entry.getKey());
            InterpolatorAtomInfo atomTermInfo = this.mInterpolator.getAtomTermInfo(atom);
            boolean isNegated = atom == entry.getKey();
            Rational factor = entry.getValue();
            assert (atomTermInfo.isBoundConstraint() || !isNegated && atomTermInfo.isLAEquality());
            Interpolator.LitInfo occurrenceInfo = this.mInterpolator.getAtomOccurenceInfo(atom);
            InterpolatorAffineTerm lv = new InterpolatorAffineTerm(atomTermInfo.getAffineTerm());
            if (isNegated) {
                lv.add(atomTermInfo.getEpsilon().negate());
            }
            for (int part = 0; part < ipl.length; ++part) {
                if (occurrenceInfo.isMixed(part)) {
                    assert (occurrenceInfo.mMixedVar != null);
                    ipl[part].add(factor, occurrenceInfo.getAPart(part));
                    ipl[part].add(factor.negate(), occurrenceInfo.mMixedVar);
                    if (auxVars[part] == null) {
                        auxVars[part] = new ArrayList();
                    }
                    auxVars[part].add(occurrenceInfo.mMixedVar);
                    continue;
                }
                if (!occurrenceInfo.isALocal(part)) continue;
                ipl[part].add(factor, lv);
            }
        }
        assert (ipl[ipl.length - 1].isConstant() && ipl[ipl.length - 1].getConstant().signum() > 0);
        Term[] interpolants = new Term[this.mInterpolator.mNumInterpolants];
        for (int part = 0; part < auxVars.length; ++part) {
            Rational normFactor = ipl[part].isConstant() ? Rational.ONE : ipl[part].getGcd().inverse().abs();
            ipl[part].mul(normFactor);
            if (ipl[part].isInt()) {
                InfinitesimalNumber constant = ipl[part].getConstant();
                ipl[part].add(constant.ceil().sub(constant));
            }
            interpolants[part] = ipl[part].toLeq0(this.mInterpolator.mTheory);
            if (auxVars[part] == null) continue;
            InfinitesimalNumber epsilon = ipl[part].isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
            interpolants[part] = LAInterpolator.createLATerm(ipl[part], epsilon.negate(), interpolants[part]);
        }
        return interpolants;
    }

    public Term[] computeTrichotomyInterpolants(InterpolatorClauseInfo lemmaInfo) {
        Interpolator.Occurrence equalityOccurenceInfo = null;
        TermVariable ineqMix = null;
        TermVariable negIneqMix = null;
        int[] numALocal = new int[this.mInterpolator.mNumInterpolants];
        int[] numBLocal = new int[this.mInterpolator.mNumInterpolants];
        Term[] aLocalLit = new Term[this.mInterpolator.mNumInterpolants];
        Term[] bLocalLit = new Term[this.mInterpolator.mNumInterpolants];
        assert (lemmaInfo.getLiterals().length == 3);
        for (Term lit : lemmaInfo.getLiterals()) {
            Term atom = this.mInterpolator.getAtom(lit);
            InterpolatorAtomInfo atomTermInfo = this.mInterpolator.getAtomTermInfo(atom);
            Interpolator.LitInfo occurrenceInfo = this.mInterpolator.getAtomOccurenceInfo(atom);
            boolean isNegated = atom == lit;
            for (int part = 0; part < this.mInterpolator.mNumInterpolants; ++part) {
                if (occurrenceInfo.isALocal(part)) {
                    int n = part;
                    numALocal[n] = numALocal[n] + 1;
                    aLocalLit[part] = lit;
                    continue;
                }
                if (!occurrenceInfo.isBLocal(part)) continue;
                int n = part;
                numBLocal[n] = numBLocal[n] + 1;
                bLocalLit[part] = lit;
            }
            if (atomTermInfo.isBoundConstraint()) {
                if (isNegated) {
                    negIneqMix = occurrenceInfo.getMixedVar();
                    continue;
                }
                ineqMix = occurrenceInfo.getMixedVar();
                continue;
            }
            assert (isNegated && atomTermInfo.isLAEquality());
            equalityOccurenceInfo = occurrenceInfo;
        }
        Term[] interpolants = new Term[this.mInterpolator.mNumInterpolants];
        for (int part = 0; part < this.mInterpolator.mNumInterpolants; ++part) {
            if (equalityOccurenceInfo.isMixed(part)) {
                InterpolatorAffineTerm s = new InterpolatorAffineTerm();
                s.add(Rational.MONE, ineqMix);
                s.add(Rational.ONE, negIneqMix);
                Term leqTerm = this.mInterpolator.mTheory.term("<=", negIneqMix, ineqMix);
                Term lessTerm = this.mInterpolator.mTheory.term("<", negIneqMix, ineqMix);
                Term F = this.mInterpolator.mTheory.and(leqTerm, this.mInterpolator.mTheory.or(lessTerm, this.mInterpolator.mTheory.term("@EQ", ((Interpolator.LitInfo)equalityOccurenceInfo).getMixedVar(), ineqMix)));
                interpolants[part] = LAInterpolator.createLATerm(s, InfinitesimalNumber.ZERO, F);
                continue;
            }
            assert (numALocal[part] + numBLocal[part] <= 3);
            if (numALocal[part] == 0) {
                interpolants[part] = this.mInterpolator.mTheory.mTrue;
                continue;
            }
            if (numBLocal[part] == 0) {
                interpolants[part] = this.mInterpolator.mTheory.mFalse;
                continue;
            }
            if (numALocal[part] == 1) {
                interpolants[part] = this.mInterpolator.mTheory.not(aLocalLit[part]);
                continue;
            }
            assert (numBLocal[part] == 1);
            interpolants[part] = bLocalLit[part];
        }
        return interpolants;
    }
}

