/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolCollector;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SymbolChecker {
    private Map<FunctionSymbol, Integer> mSubtreeOccurrences;
    private final Map<FunctionSymbol, Integer> mAllOccurences;
    private HashSet<FunctionSymbol> mALocal;
    private HashSet<FunctionSymbol> mBLocal;
    private final Set<FunctionSymbol> mGlobals;
    private final SymbolCollector mCollector = new SymbolCollector();

    public SymbolChecker(Set<FunctionSymbol> globals, Map<FunctionSymbol, Integer> allOccurrences) {
        this.mGlobals = globals;
        this.mAllOccurences = allOccurrences;
    }

    public final boolean check(Term interpolant, Map<FunctionSymbol, Integer> subtreeOccurrences) {
        this.mSubtreeOccurrences = subtreeOccurrences;
        this.mALocal = new HashSet();
        this.mBLocal = new HashSet();
        this.mCollector.collect(interpolant);
        for (FunctionSymbol fsym : this.mCollector.getSymbols()) {
            if (this.mGlobals.contains(fsym)) continue;
            Integer inA = this.mSubtreeOccurrences.get(fsym);
            Integer inAll = this.mAllOccurences.get(fsym);
            if (inAll == null) {
                throw new InternalError("Detected new symbol in interpolant: " + fsym);
            }
            if (inA == null) {
                this.mBLocal.add(fsym);
                continue;
            }
            if (inAll - inA > 0) continue;
            this.mALocal.add(fsym);
        }
        this.mSubtreeOccurrences = null;
        return !this.mALocal.isEmpty() || !this.mBLocal.isEmpty();
    }

    public Set<FunctionSymbol> getALocals() {
        return this.mALocal;
    }

    public Set<FunctionSymbol> getBLocals() {
        return this.mBLocal;
    }
}

