/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.HashSet;
import java.util.Set;

public class SymbolCollector
extends NonRecursive {
    private HashSet<FunctionSymbol> mSymbols = new HashSet();
    private HashSet<Term> mVisited = new HashSet();

    public final void collect(Term input) {
        this.run(new CollectWalker(input));
    }

    public Set<FunctionSymbol> getSymbols() {
        HashSet<FunctionSymbol> result = this.mSymbols;
        this.mSymbols = new HashSet();
        this.mVisited = new HashSet();
        return result;
    }

    public static class CollectWalker
    implements NonRecursive.Walker {
        protected Term mTerm;

        public CollectWalker(Term term) {
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive walker) {
            SymbolCollector collector = (SymbolCollector)walker;
            if (!collector.mVisited.add(this.mTerm)) {
                return;
            }
            if (this.mTerm instanceof ApplicationTerm) {
                Term definition;
                ApplicationTerm appTerm = (ApplicationTerm)this.mTerm;
                FunctionSymbol fsym = appTerm.getFunction();
                if (!fsym.isIntern()) {
                    collector.mSymbols.add(appTerm.getFunction());
                }
                if ((definition = fsym.getDefinition()) != null) {
                    collector.enqueueWalker(new CollectWalker(definition));
                }
                Term[] params = appTerm.getParameters();
                for (int i = 0; i < params.length; ++i) {
                    collector.enqueueWalker(new CollectWalker(params[i]));
                }
            } else if (this.mTerm instanceof LetTerm) {
                LetTerm letTerm = (LetTerm)this.mTerm;
                Term[] values = letTerm.getValues();
                for (int i = 0; i < values.length; ++i) {
                    collector.enqueueWalker(new CollectWalker(values[i]));
                }
                collector.enqueueWalker(new CollectWalker(letTerm.getSubTerm()));
            } else if (this.mTerm instanceof AnnotatedTerm) {
                collector.enqueueWalker(new CollectWalker(((AnnotatedTerm)this.mTerm).getSubterm()));
            } else if (this.mTerm instanceof QuantifiedFormula) {
                collector.enqueueWalker(new CollectWalker(((QuantifiedFormula)this.mTerm).getSubformula()));
            }
        }
    }
}

