/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArraySortInterpretation
implements SortInterpretation {
    private final Model mModel;
    private final SortInterpretation mIndexSort;
    private final SortInterpretation mValueSort;
    private final HashMap<Map<Term, Term>, Map<Term, Term>> mUnifier;
    private final HashMap<Term, HashMap<Term, Term>> mDiffMap;

    public ArraySortInterpretation(Model model, SortInterpretation index, SortInterpretation value) {
        this.mModel = model;
        this.mIndexSort = index;
        this.mValueSort = value;
        this.mUnifier = new HashMap();
        Map empty = Collections.emptyMap();
        this.mUnifier.put(empty, empty);
        this.mDiffMap = new HashMap();
    }

    @Override
    public Term getModelValue(int idx, Sort arraySort) {
        Sort valueSort = arraySort.getArguments()[1];
        return this.createArray(Collections.emptyMap(), this.mValueSort.getModelValue(idx, valueSort), arraySort);
    }

    private Term createArray(Map<Term, Term> mapping, Term defaultValue, Sort arraySort) {
        Theory theory = defaultValue.getTheory();
        FunctionSymbol constFunc = theory.getFunctionWithResult("const", null, arraySort, defaultValue.getSort());
        Term result = theory.term(constFunc, defaultValue);
        ArrayDeque<Term> keys = new ArrayDeque<Term>(mapping.keySet());
        while (!keys.isEmpty()) {
            Term index = keys.removeLast();
            result = theory.term("store", result, index, mapping.get(index));
        }
        return result;
    }

    public Term normalizeStoreTerm(Term storeTerm) {
        LinkedHashMap<Term, Term> map = new LinkedHashMap<Term, Term>();
        ApplicationTerm arrayTerm = (ApplicationTerm)storeTerm;
        while (arrayTerm.getFunction().getName() == "store") {
            Term index = arrayTerm.getParameters()[1];
            if (!map.containsKey(index)) {
                map.put(index, arrayTerm.getParameters()[2]);
            }
            arrayTerm = (ApplicationTerm)arrayTerm.getParameters()[0];
        }
        assert (arrayTerm.getFunction().getName() == "const");
        Term defaultValue = arrayTerm.getParameters()[0];
        Iterator entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            if (entry.getValue() != defaultValue) continue;
            entryIterator.remove();
        }
        Map<Term, Term> unified = this.mUnifier.get(map);
        if (unified == null) {
            this.mUnifier.put(map, map);
            unified = map;
        }
        return this.createArray(unified, defaultValue, storeTerm.getSort());
    }

    @Override
    public Term extendFresh(Sort arraySort) {
        assert (arraySort.getSortSymbol().getName() == "Array");
        Sort indexSort = arraySort.getArguments()[0];
        Sort valueSort = arraySort.getArguments()[1];
        Term freshIndex = this.mIndexSort.extendFresh(indexSort);
        Term value = this.mModel.getSecondValue(valueSort);
        Map<Term, Term> map = Collections.singletonMap(freshIndex, value);
        Map<Term, Term> old = this.mUnifier.put(map, map);
        assert (old == null);
        return this.createArray(map, this.mModel.getSomeValue(valueSort), arraySort);
    }

    @Override
    public Term toSMTLIB(Theory t, Sort sort) {
        throw new InternalError("toSMTLIB called");
    }

    public void addDiff(Term fstArray, Term sndArray, Term index) {
        HashMap<Term, Term> subMap = this.mDiffMap.get(fstArray);
        if (subMap == null) {
            subMap = new HashMap();
            this.mDiffMap.put(fstArray, subMap);
        }
        Term old = subMap.put(sndArray, index);
        assert (old == null);
    }

    public Term computeDiff(Term fstArray, Term sndArray, Sort indexSort) {
        Term result;
        Map subMap = this.mDiffMap.get(fstArray);
        if (subMap != null && (result = (Term)subMap.get(sndArray)) != null) {
            return result;
        }
        if (fstArray == sndArray) {
            return this.mModel.getSomeValue(indexSort);
        }
        HashMap<Term, Term> secondValues = new HashMap<Term, Term>();
        ApplicationTerm arrayTerm = (ApplicationTerm)sndArray;
        while (arrayTerm.getFunction().getName() == "store") {
            Term index = arrayTerm.getParameters()[1];
            secondValues.put(index, arrayTerm.getParameters()[2]);
            arrayTerm = (ApplicationTerm)arrayTerm.getParameters()[0];
        }
        assert (arrayTerm.getFunction().getName() == "const");
        Term secondDefault = arrayTerm.getParameters()[0];
        arrayTerm = (ApplicationTerm)fstArray;
        while (arrayTerm.getFunction().getName() == "store") {
            Term index = arrayTerm.getParameters()[1];
            Term secondValue = (Term)secondValues.get(index);
            if (secondValue == null) {
                secondValue = secondDefault;
            }
            if (secondValue != arrayTerm.getParameters()[2]) {
                return index;
            }
            arrayTerm = (ApplicationTerm)arrayTerm.getParameters()[0];
        }
        assert (arrayTerm.getFunction().getName() == "const");
        assert (secondDefault != arrayTerm.getParameters()[0]);
        Term diffIndex = this.mIndexSort.extendFresh(indexSort);
        this.addDiff(fstArray, sndArray, diffIndex);
        return diffIndex;
    }

    public SortInterpretation getIndexInterpretation() {
        return this.mIndexSort;
    }

    public SortInterpretation getValueInterpretation() {
        return this.mValueSort;
    }

    @Override
    public void register(Term t) {
    }
}

