/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import java.util.NoSuchElementException;

public class BidiMap<E> {
    private Entry<E>[] mIntTable;
    private Entry<E>[] mValTable;
    private int mSize = 0;
    private int mThreshold;
    private float mLoadFactor;
    private Entry<E> mLastEntry;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_SIZE = 8;
    public static final int MAXIMUM_CAPACITY = 0x40000000;

    private static int roundUpToPowerOf2(int number) {
        int rounded;
        rounded = number >= 0x40000000 ? 0x40000000 : ((rounded = Integer.highestOneBit(number)) != 0 ? (Integer.bitCount(number) > 1 ? rounded << 1 : rounded) : 1);
        return rounded;
    }

    public BidiMap() {
        this(8, 0.75f);
    }

    public BidiMap(int size) {
        this(size, 0.75f);
    }

    public BidiMap(int size, float loadFactor) {
        this.mLoadFactor = loadFactor;
        this.init(BidiMap.roundUpToPowerOf2(size));
    }

    private void init(int size) {
        this.mIntTable = new Entry[size];
        this.mValTable = new Entry[size];
        this.mThreshold = (int)((float)size * this.mLoadFactor);
    }

    private final int hash(E val) {
        int h = 0;
        h ^= val.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private final int intBucketIdx(int idx) {
        return idx & this.mIntTable.length - 1;
    }

    private final int valBucketIdx(int hash) {
        return hash & this.mValTable.length - 1;
    }

    public boolean add(int idx, E val) {
        int hash = this.hash(val);
        Entry<E> newEntry = new Entry<E>(idx, val, hash);
        if (this.canInsert(newEntry)) {
            this.mLastEntry = null;
            if (++this.mSize >= this.mThreshold) {
                this.grow();
            }
            this.insertInt(newEntry);
            this.insertVal(newEntry);
            return true;
        }
        this.mLastEntry = null;
        return false;
    }

    private void grow() {
        Entry<E> reinsert;
        Entry<E> bucket;
        int i;
        int newCapacity = this.mIntTable.length << 1;
        if (newCapacity > 0x40000000) {
            newCapacity = 0x40000000;
        }
        this.mThreshold = (int)((float)newCapacity * this.mLoadFactor);
        Entry<E>[] oldIntTable = this.mIntTable;
        Entry<E>[] oldValTable = this.mValTable;
        this.mIntTable = new Entry[newCapacity];
        this.mValTable = new Entry[newCapacity];
        for (i = 0; i < oldIntTable.length; ++i) {
            bucket = oldIntTable[i];
            while (bucket != null) {
                reinsert = bucket;
                bucket = bucket.mNextIdx;
                this.insertInt(reinsert);
            }
        }
        for (i = 0; i < oldValTable.length; ++i) {
            bucket = oldValTable[i];
            while (bucket != null) {
                reinsert = bucket;
                bucket = bucket.mNextVal;
                this.insertVal(reinsert);
            }
        }
    }

    private Entry<E> getEntryByIdx(int idx) {
        int b = this.intBucketIdx(idx);
        Entry<E> bucket = this.mIntTable[b];
        while (bucket != null) {
            if (bucket.mIdx == idx) {
                this.mLastEntry = bucket;
                return this.mLastEntry;
            }
            bucket = bucket.mNextIdx;
        }
        return null;
    }

    private Entry<E> getEntryByVal(E val) {
        int hash = this.hash(val);
        int b = this.valBucketIdx(hash);
        Entry<E> bucket = this.mValTable[b];
        while (bucket != null) {
            if (bucket.mHash == hash && bucket.mVal.equals(val)) {
                this.mLastEntry = bucket;
                return this.mLastEntry;
            }
            bucket = bucket.mNextVal;
        }
        return null;
    }

    private boolean canInsert(Entry<E> newEntry) {
        return this.getEntryByIdx(newEntry.mIdx) == null && this.getEntryByVal(newEntry.mVal) == null;
    }

    private void insertInt(Entry<E> newEntry) {
        int idx = this.intBucketIdx(newEntry.mIdx);
        newEntry.mNextIdx = this.mIntTable[idx];
        this.mIntTable[idx] = newEntry;
    }

    private void insertVal(Entry<E> newEntry) {
        int idx = this.valBucketIdx(newEntry.mHash);
        newEntry.mNextVal = this.mValTable[idx];
        this.mValTable[idx] = newEntry;
    }

    public E get(int idx) {
        if (this.mLastEntry != null && this.mLastEntry.mIdx == idx) {
            return this.mLastEntry.getValue();
        }
        Entry<E> bucket = this.getEntryByIdx(idx);
        return bucket == null ? null : (E)bucket.getValue();
    }

    public int get(E val) {
        int hash;
        if (this.mLastEntry != null && this.mLastEntry.mHash == (hash = this.hash(val)) && this.mLastEntry.mVal.equals(val)) {
            return this.mLastEntry.getIdx();
        }
        Entry<E> bucket = this.getEntryByVal(val);
        if (bucket == null) {
            throw new NoSuchElementException();
        }
        return bucket.getIdx();
    }

    public boolean containsIdx(int idx) {
        return this.getEntryByIdx(idx) != null;
    }

    public boolean containsVal(E val) {
        return this.getEntryByVal(val) != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Entry<E>[] entryArray = this.mIntTable;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry<E> outer;
            Entry<E> bucket = outer = entryArray[i];
            while (bucket != null) {
                sb.append(bucket);
                bucket = bucket.mNextIdx;
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.mSize;
    }

    private static class Entry<E> {
        final int mIdx;
        final E mVal;
        final int mHash;
        Entry<E> mNextIdx;
        Entry<E> mNextVal;

        public Entry(int idx, E val, int hash) {
            this.mIdx = idx;
            this.mVal = val;
            this.mHash = hash;
            this.mNextIdx = null;
            this.mNextVal = null;
        }

        public int getIdx() {
            return this.mIdx;
        }

        public E getValue() {
            return this.mVal;
        }

        public String toString() {
            return "[" + this.mIdx + "," + this.mVal + "]";
        }
    }
}

