/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class DataTypeInterpretation
implements SortInterpretation {
    Model mModel;
    Sort mSort;
    Set<Term> mExistingTerms = new LinkedHashSet<Term>();
    private FunctionSymbol mInfiniteConstructor;
    private int mInfiniteConsArg;

    public DataTypeInterpretation(Model model, Sort sort) {
        this.mModel = model;
        this.mSort = sort;
    }

    @Override
    public Term toSMTLIB(Theory t, Sort sort) {
        throw new InternalError("Should never be called!");
    }

    @Override
    public Term extendFresh(Sort sort) {
        assert (this.mSort == sort);
        return this.extendFreshOrLast(new HashSet<Sort>());
    }

    private boolean isInfinite(Sort sort, Set<Sort> visited) {
        DataType dataType = (DataType)sort.getSortSymbol();
        for (DataType.Constructor constr : dataType.getConstructors()) {
            for (Sort argSort : constr.getArgumentSorts()) {
                Sort realArgSort = argSort.mapSort(sort.getArguments());
                if (!realArgSort.isNumericSort() && !realArgSort.isArraySort() && realArgSort.isInternal() && (!realArgSort.getSortSymbol().isDatatype() || !this.isInfinite(realArgSort, visited))) continue;
                return true;
            }
        }
        return false;
    }

    private void findInfiniteConstructor() {
        DataType dataType = (DataType)this.mSort.getSortSymbol();
        HashSet<Sort> visited = new HashSet<Sort>();
        visited.add(this.mSort);
        for (DataType.Constructor constr : dataType.getConstructors()) {
            int j;
            Sort[] argSorts;
            Sort[] realArgSorts = argSorts = constr.getArgumentSorts();
            if (this.mSort.getArguments().length > 0) {
                realArgSorts = new Sort[argSorts.length];
                for (j = 0; j < argSorts.length; ++j) {
                    realArgSorts[j] = argSorts[j].mapSort(this.mSort.getArguments());
                }
            }
            for (j = 0; j < argSorts.length; ++j) {
                if (!realArgSorts[j].isNumericSort() && !realArgSorts[j].isArraySort() && realArgSorts[j].isInternal() && (!realArgSorts[j].getSortSymbol().isDatatype() || !this.isInfinite(realArgSorts[j], visited))) continue;
                this.mInfiniteConsArg = j;
                Sort constrSort = constr.needsReturnOverload() ? this.mSort : null;
                this.mInfiniteConstructor = this.mModel.getTheory().getFunctionWithResult(constr.getName(), null, constrSort, realArgSorts);
            }
        }
    }

    private Term createSomeTerm(HashSet<Sort> visited) {
        if (!this.mExistingTerms.isEmpty()) {
            return this.mExistingTerms.iterator().next();
        }
        if (!visited.add(this.mSort)) {
            return null;
        }
        DataType dataType = (DataType)this.mSort.getSortSymbol();
        block0: for (DataType.Constructor constr : dataType.getConstructors()) {
            int j;
            Sort[] argSorts;
            Sort[] realArgSorts = argSorts = constr.getArgumentSorts();
            Term[] args = new Term[argSorts.length];
            if (this.mSort.getArguments().length > 0) {
                realArgSorts = new Sort[argSorts.length];
                for (j = 0; j < argSorts.length; ++j) {
                    realArgSorts[j] = argSorts[j].mapSort(this.mSort.getArguments());
                }
            }
            for (j = 0; j < argSorts.length; ++j) {
                if (realArgSorts[j].getSortSymbol().isDatatype()) {
                    DataTypeInterpretation childInterpretation = (DataTypeInterpretation)this.mModel.provideSortInterpretation(realArgSorts[j]);
                    args[j] = childInterpretation.createSomeTerm(visited);
                    if (args[j] != null) continue;
                    continue block0;
                }
                args[j] = this.mModel.getSomeValue(realArgSorts[j]);
            }
            Sort returnSort = constr.needsReturnOverload() ? this.mSort : null;
            Term newTerm = this.mModel.getTheory().term(constr.getName(), null, returnSort, args);
            this.register(newTerm);
            return newTerm;
        }
        throw new AssertionError((Object)"DataType is empty");
    }

    private Term getLastAddedTerm() {
        if (this.mExistingTerms.isEmpty()) {
            Term term = this.createSomeTerm(new HashSet<Sort>());
            assert (term != null) : "DataType is empty";
            return term;
        }
        Iterator<Term> it = this.mExistingTerms.iterator();
        Term last = it.next();
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    private Term extendFreshOrLast(Set<Sort> visited) {
        if (!visited.add(this.mSort)) {
            return this.getLastAddedTerm();
        }
        if (this.mInfiniteConstructor == null) {
            this.findInfiniteConstructor();
        }
        Sort[] argSorts = this.mInfiniteConstructor.getParameterSorts();
        Term[] args = new Term[argSorts.length];
        for (int i = 0; i < args.length; ++i) {
            if (i != this.mInfiniteConsArg) {
                args[i] = this.mModel.getSomeValue(argSorts[i]);
                continue;
            }
            if (argSorts[i].getSortSymbol().isDatatype()) {
                DataTypeInterpretation childInterpretation = (DataTypeInterpretation)this.mModel.provideSortInterpretation(argSorts[i]);
                args[i] = childInterpretation.extendFreshOrLast(visited);
                continue;
            }
            args[i] = this.mModel.extendFresh(argSorts[i]);
        }
        Term newTerm = this.mModel.getTheory().term(this.mInfiniteConstructor, args);
        this.register(newTerm);
        return newTerm;
    }

    @Override
    public void register(Term term) {
        assert (term.getSort() == this.mSort && ((ApplicationTerm)term).getFunction().isConstructor());
        this.mExistingTerms.add(term);
    }

    public String toString() {
        return "datatypeSort" + this.mExistingTerms;
    }

    public static Rational toRational(Term constTerm) {
        return (Rational)((ConstantTerm)constTerm).getValue();
    }

    @Override
    public Term getModelValue(int idx, Sort sort) {
        while (idx >= this.mExistingTerms.size()) {
            this.extendFresh(sort);
        }
        Iterator<Term> it = this.mExistingTerms.iterator();
        while (idx-- > 0) {
            it.next();
        }
        return it.next();
    }
}

