/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;

public class FiniteSortInterpretation
implements SortInterpretation {
    private int mSize = 0;

    @Override
    public Term toSMTLIB(Theory t, Sort sort) {
        TermVariable var = t.createTermVariable("@v", sort);
        Term[] disj = new Term[this.mSize];
        for (int i = 0; i < this.mSize; ++i) {
            disj[i] = t.equals(var, this.genModelTerm(i, t, sort));
        }
        return t.forall(new TermVariable[]{var}, t.or(disj));
    }

    private Term genModelTerm(int idx, Theory t, Sort s) {
        return t.term(t.getFunctionWithResult("@" + idx, null, s, new Sort[0]), new Term[0]);
    }

    @Override
    public void register(Term term) {
        assert (((ApplicationTerm)term).getFunction().isModelValue());
    }

    @Override
    public Term extendFresh(Sort sort) {
        Theory theory = sort.getTheory();
        int idx = this.mSize++;
        return theory.term(theory.getFunctionWithResult("@" + idx, null, sort, new Sort[0]), new Term[0]);
    }

    @Override
    public Term getModelValue(int idx, Sort sort) {
        assert (idx >= 0);
        Theory theory = sort.getTheory();
        this.mSize = Math.max(this.mSize, idx);
        return theory.term(theory.getFunctionWithResult("@" + idx, null, sort, new Sort[0]), new Term[0]);
    }
}

