/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FunctionValue {
    private Map<Index, Term> mValues;
    private Term mDefault;

    public FunctionValue() {
        this.mDefault = null;
    }

    public FunctionValue(Term defaultValue) {
        this.mDefault = defaultValue;
    }

    public void put(Term value, Term ... idx) {
        if (idx.length == 0) {
            assert (this.mDefault == null);
            this.mDefault = value;
        } else {
            if (this.mValues == null) {
                this.mValues = new HashMap<Index, Term>();
            }
            this.mValues.put(new Index(idx), value);
        }
    }

    public Term get(Term[] idx) {
        if (this.mValues == null) {
            return this.mDefault;
        }
        Term res = this.mValues.get(new Index(idx));
        return res == null ? this.mDefault : res;
    }

    public Term getDefault() {
        return this.mDefault;
    }

    public Map<Index, Term> values() {
        return this.mValues != null ? this.mValues : Collections.emptyMap();
    }

    public static class Index {
        private final Term[] mIdx;
        private final int mHash;

        public Index(Term[] idx) {
            this.mIdx = idx;
            this.mHash = Arrays.hashCode(this.mIdx);
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object o) {
            if (o instanceof Index) {
                return Arrays.equals(this.mIdx, ((Index)o).mIdx);
            }
            return false;
        }

        public Term[] toArray() {
            return this.mIdx;
        }

        public String toString() {
            return Arrays.toString(this.mIdx);
        }
    }
}

