/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.BooleanVarAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BoolSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.DataTypeInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FiniteSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelFormatter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Model
implements de.uni_freiburg.informatik.ultimate.logic.Model {
    private final HashMap<Sort, SortInterpretation> mSorts = new HashMap();
    private final HashMap<FunctionSymbol, FunctionValue> mFuncVals = new HashMap();
    private final Theory mTheory;
    private final ModelEvaluator mEval;

    public Model(Clausifier clausifier, Theory theory) {
        this.mTheory = theory;
        this.mSorts.put(theory.getBooleanSort(), new BoolSortInterpretation());
        if (theory.getLogic().hasIntegers() || theory.getLogic().hasReals()) {
            NumericSortInterpretation numericInterpretation = new NumericSortInterpretation();
            if (theory.getLogic().hasIntegers()) {
                this.mSorts.put(theory.getNumericSort(), numericInterpretation);
            }
            if (theory.getLogic().hasReals()) {
                this.mSorts.put(theory.getRealSort(), numericInterpretation);
            }
        }
        FunctionValue trueValue = new FunctionValue(theory.mTrue);
        FunctionValue falseValue = new FunctionValue(theory.mFalse);
        for (BooleanVarAtom atom : clausifier.getBooleanVars()) {
            ApplicationTerm at = (ApplicationTerm)atom.getSMTFormula(theory);
            FunctionValue value = atom.getDecideStatus() == null ? (atom.getPreferredStatus() == atom ? trueValue : falseValue) : (atom.getDecideStatus() == atom ? trueValue : falseValue);
            this.mFuncVals.put(at.getFunction(), value);
        }
        CClosure cc = null;
        LinArSolve la = null;
        ArrayTheory array = null;
        DataTypeTheory datatype = null;
        for (ITheory theorySolver : clausifier.getEngine().getAttachedTheories()) {
            if (theorySolver instanceof CClosure) {
                cc = (CClosure)theorySolver;
                continue;
            }
            if (theorySolver instanceof LinArSolve) {
                la = (LinArSolve)theorySolver;
                continue;
            }
            if (theorySolver instanceof ArrayTheory) {
                array = (ArrayTheory)theorySolver;
                continue;
            }
            if (theorySolver instanceof DataTypeTheory) {
                datatype = (DataTypeTheory)theorySolver;
                continue;
            }
            if (theorySolver instanceof QuantifierTheory) {
                if (((QuantifierTheory)theorySolver).getQuantClauses().isEmpty()) continue;
                throw new UnsupportedOperationException("Modelproduction for quantifier theory not implemented.");
            }
            if (theorySolver instanceof EprTheory) {
                throw new UnsupportedOperationException("Modelproduction for EPR theory not implemented.");
            }
            throw new InternalError("Unknown theory: " + theorySolver);
        }
        SharedTermEvaluator ste = new SharedTermEvaluator(clausifier);
        if (la != null) {
            la.fillInModel(this, theory, ste);
        }
        if (cc != null) {
            cc.fillInModel(this, theory, ste, array, datatype);
        }
        for (FunctionSymbol fs : theory.getDeclaredFunctions().values()) {
            if (fs.getDefinition() != null || fs.isIntern() || this.mFuncVals.containsKey(fs)) continue;
            this.map(fs, this.getSomeValue(fs.getReturnSort()));
        }
        this.mEval = new ModelEvaluator(this);
    }

    public boolean checkTypeValues(LogProxy logger) {
        boolean correct = true;
        for (Map.Entry<FunctionSymbol, FunctionValue> me : this.mFuncVals.entrySet()) {
            FunctionSymbol fs = me.getKey();
            FunctionValue functionMap = me.getValue();
            if (!fs.getReturnSort().getName().equals("Int")) continue;
            if (!NumericSortInterpretation.toRational(functionMap.getDefault()).isIntegral()) {
                if (fs.getParameterSorts().length == 0) {
                    logger.fatal("Non-integral value for integer variable " + fs);
                } else {
                    logger.fatal("Non-integral default value for function " + fs);
                }
                correct = false;
            }
            for (Map.Entry<FunctionValue.Index, Term> valEntry : functionMap.values().entrySet()) {
                if (NumericSortInterpretation.toRational(valEntry.getValue()).isIntegral()) continue;
                logger.fatal("Non-integral value for function " + fs + " at index " + valEntry.getKey());
                correct = false;
            }
        }
        return correct;
    }

    public Term getModelValue(int index, Sort sort) {
        return this.provideSortInterpretation(sort).getModelValue(index, sort);
    }

    public Term getSomeValue(Sort sort) {
        return this.getModelValue(0, sort);
    }

    public Term getSecondValue(Sort sort) {
        return this.getModelValue(1, sort);
    }

    public Term extendFresh(Sort sort) {
        return this.provideSortInterpretation(sort).extendFresh(sort);
    }

    @Override
    public Set<FunctionSymbol> getDefinedFunctions() {
        return Collections.unmodifiableSet(this.mFuncVals.keySet());
    }

    Term generateCondition(FunctionValue.Index index, TermVariable[] vars) {
        Term[] idx = index.toArray();
        assert (vars.length == idx.length);
        Term[] conj = new Term[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            conj[i] = this.mTheory.equals(vars[i], idx[i]);
        }
        return this.mTheory.and(conj);
    }

    private static boolean isDivision(FunctionSymbol fs) {
        String name = fs.getName();
        return fs.isIntern() && (name == "/" || name == "div" || name == "mod");
    }

    public Term getFunctionDefinition(FunctionSymbol fs, TermVariable[] vars) {
        Term defaultVal;
        FunctionValue value = this.mFuncVals.get(fs);
        if (value == null) {
            throw new IllegalArgumentException("No model for " + fs);
        }
        if (fs.getParameterSorts().length != vars.length) {
            throw new IllegalArgumentException("Wrong number of variables");
        }
        Term definition = defaultVal = value.getDefault();
        for (Map.Entry<FunctionValue.Index, Term> me : value.values().entrySet()) {
            if (me.getValue() == defaultVal) continue;
            Term cond = this.generateCondition(me.getKey(), vars);
            definition = this.mTheory.ifthenelse(cond, me.getValue(), definition);
        }
        if (fs.isSelector()) {
            assert (vars.length == 1);
            Sort sort = fs.getParameterSorts()[0];
            DataType datatype = (DataType)sort.getSortSymbol();
            DataType.Constructor constr = null;
            for (DataType.Constructor c : datatype.getConstructors()) {
                if (!Arrays.asList(c.getSelectors()).contains(fs.getName())) continue;
                constr = c;
            }
            Term tester = this.mTheory.term("is", new String[]{constr.getName()}, null, vars[0]);
            definition = this.mTheory.ifthenelse(tester, this.mTheory.term(fs, vars[0]), definition);
        }
        if (Model.isDivision(fs)) {
            Term isZero = this.mTheory.term("=", vars[1], Rational.ZERO.toTerm(vars[1].getSort()));
            definition = this.mTheory.ifthenelse(this.mTheory.term("not", isZero), this.mTheory.term(fs, vars[0], vars[1]), definition);
        }
        return definition;
    }

    @Override
    public Term getFunctionDefinition(String func, TermVariable[] args) {
        Sort[] argTypes = new Sort[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getSort();
        }
        FunctionSymbol fs = this.mTheory.getFunction(func, argTypes);
        if (fs == null) {
            throw new IllegalArgumentException("Function " + func + " not defined.");
        }
        return this.getFunctionDefinition(fs, args);
    }

    public FunctionValue map(FunctionSymbol fs, Term value) {
        FunctionValue res = this.mFuncVals.get(fs);
        if (res == null) {
            res = new FunctionValue(value);
            this.mFuncVals.put(fs, res);
        }
        assert (res.getDefault() == value);
        return res;
    }

    public FunctionValue map(FunctionSymbol fs, Term[] args, Term value) {
        assert (fs.getParameterSorts().length == args.length);
        FunctionValue val = this.mFuncVals.get(fs);
        if (val == null) {
            val = new FunctionValue(value);
            this.mFuncVals.put(fs, val);
        }
        val.put(value, args);
        return val;
    }

    Term getUndefined(Sort s) {
        FunctionSymbol fsym = this.mTheory.getFunctionWithResult("@undefined", null, s, new Sort[0]);
        return this.mTheory.term(fsym, new Term[0]);
    }

    @Override
    public Term evaluate(Term input) {
        return this.mEval.evaluate(input);
    }

    @Override
    public Map<Term, Term> evaluate(Term[] input) {
        LinkedHashMap<Term, Term> values = new LinkedHashMap<Term, Term>();
        for (Term t : input) {
            values.put(t, this.evaluate(t));
        }
        return values;
    }

    public String toString() {
        ModelFormatter mf = new ModelFormatter(this.mTheory);
        for (Map.Entry<FunctionSymbol, FunctionValue> me : this.mFuncVals.entrySet()) {
            FunctionSymbol fs = me.getKey();
            if (fs.isIntern() && fs.getDefinition() != null) continue;
            Sort[] paramSorts = fs.getParameterSorts();
            TermVariable[] vars = new TermVariable[paramSorts.length];
            for (int i = 0; i < vars.length; ++i) {
                vars[i] = this.mTheory.createTermVariable("@p" + i, paramSorts[i]);
            }
            mf.appendValue(fs, vars, this.getFunctionDefinition(fs, vars));
        }
        return mf.finish();
    }

    Theory getTheory() {
        return this.mTheory;
    }

    public SortInterpretation provideSortInterpretation(Sort sort) {
        SortInterpretation interpretation = this.mSorts.get(sort);
        if (interpretation == null) {
            interpretation = sort.isArraySort() ? new ArraySortInterpretation(this, this.provideSortInterpretation(sort.getArguments()[0]), this.provideSortInterpretation(sort.getArguments()[1])) : (sort.getSortSymbol().isDatatype() ? new DataTypeInterpretation(this, sort) : new FiniteSortInterpretation());
            this.mSorts.put(sort, interpretation);
        }
        return interpretation;
    }

    public FunctionValue getFunctionValue(FunctionSymbol fs) {
        return this.mFuncVals.get(fs);
    }
}

