/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.math.BigInteger;
import java.util.HashSet;

public class ModelEvaluator
extends TermTransformer {
    private final Model mModel;
    private final ScopedHashMap<TermVariable, Term> mLetMap = new ScopedHashMap(false);

    private static boolean isBooleanValue(Term term) {
        Theory theory = term.getTheory();
        return term == theory.mTrue || term == theory.mFalse;
    }

    @Override
    public void convert(Term term) {
        while (term instanceof AnnotatedTerm) {
            term = ((AnnotatedTerm)term).getSubterm();
        }
        if (term instanceof ConstantTerm) {
            if (!term.getSort().isNumericSort()) {
                throw new InternalError("Don't know how to evaluate this: " + term);
            }
            Term result = SMTAffineTerm.convertConstant((ConstantTerm)term).toTerm(term.getSort());
            this.setResult(result);
            return;
        }
        if (term instanceof TermVariable) {
            if (this.mLetMap.containsKey(term)) {
                this.setResult(this.mLetMap.get(term));
                return;
            }
            throw new SMTLIBException("Terms to evaluate must be closed");
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if (appTerm.getFunction().isIntern() && appTerm.getFunction().getName() == "ite") {
                this.enqueueWalker(new ITESelector(appTerm));
                this.pushTerm(appTerm.getParameters()[0]);
                return;
            }
        } else {
            if (term instanceof QuantifiedFormula) {
                throw new SMTLIBException("Quantifiers not supported in model evaluation");
            }
            if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                this.enqueueWalker(new MatchSelector(matchTerm));
                this.pushTerm(matchTerm.getDataTerm());
                return;
            }
        }
        super.convert(term);
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        FunctionSymbol fs = appTerm.getFunction();
        if (fs.isIntern() || fs.isModelValue()) {
            this.setResult(this.interpret(fs, newArgs));
        } else if (fs.getDefinition() != null) {
            this.pushTerm(appTerm.getTheory().let(fs.getDefinitionVars(), newArgs, fs.getDefinition()));
        } else {
            this.setResult(this.lookupFunction(fs, newArgs));
        }
    }

    @Override
    public void preConvertLet(LetTerm oldLet, Term[] newValues) {
        this.mLetMap.beginScope();
        TermVariable[] vars = oldLet.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            this.mLetMap.put(vars[i], newValues[i]);
        }
        super.preConvertLet(oldLet, newValues);
    }

    @Override
    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        this.setResult(newBody);
        this.mLetMap.endScope();
    }

    public ModelEvaluator(Model model) {
        this.mModel = model;
    }

    public Term evaluate(Term input) {
        return this.transform(input);
    }

    private Term lookupFunction(FunctionSymbol fs, Term[] args) {
        FunctionValue val = this.mModel.getFunctionValue(fs);
        if (val == null) {
            Sort sort = fs.getReturnSort();
            return this.mModel.getSomeValue(sort);
        }
        Term value = val.values().get(new FunctionValue.Index(args));
        return value == null ? val.getDefault() : value;
    }

    private Term interpret(FunctionSymbol fs, Term[] args) {
        if (fs.isModelValue()) {
            int idx = Integer.parseInt(fs.getName().substring(1));
            return this.mModel.getModelValue(idx, fs.getReturnSort());
        }
        Theory theory = this.mModel.getTheory();
        switch (fs.getName()) {
            case "true": {
                return theory.mTrue;
            }
            case "false": {
                return theory.mFalse;
            }
            case "and": {
                for (Term arg : args) {
                    if (arg == theory.mFalse) {
                        return arg;
                    }
                    assert (arg == theory.mTrue);
                }
                return theory.mTrue;
            }
            case "or": {
                for (Term arg : args) {
                    assert (ModelEvaluator.isBooleanValue(arg));
                    if (arg == theory.mTrue) {
                        return arg;
                    }
                    assert (arg == theory.mFalse);
                }
                return theory.mFalse;
            }
            case "=>": {
                for (int i = 0; i < args.length - 1; ++i) {
                    Term argi = args[i];
                    assert (ModelEvaluator.isBooleanValue(argi));
                    if (argi == theory.mFalse) {
                        return theory.mTrue;
                    }
                    assert (argi == theory.mTrue);
                }
                return args[args.length - 1];
            }
            case "not": {
                assert (ModelEvaluator.isBooleanValue(args[0]));
                return args[0] == theory.mTrue ? theory.mFalse : theory.mTrue;
            }
            case "xor": {
                boolean result = false;
                for (Term arg : args) {
                    assert (ModelEvaluator.isBooleanValue(arg));
                    result ^= arg == theory.mTrue;
                }
                return result ? theory.mTrue : theory.mFalse;
            }
            case "=": {
                for (int i = 1; i < args.length; ++i) {
                    if (args[i] == args[0]) continue;
                    return theory.mFalse;
                }
                return theory.mTrue;
            }
            case "distinct": {
                HashSet<Term> vals = new HashSet<Term>();
                for (Term arg : args) {
                    if (vals.add(arg)) continue;
                    return theory.mFalse;
                }
                return theory.mTrue;
            }
            case "ite": {
                return args[0] == theory.mTrue ? args[1] : args[2];
            }
            case "+": {
                Rational val = this.rationalValue(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    val = val.add(this.rationalValue(args[i]));
                }
                return val.toTerm(fs.getReturnSort());
            }
            case "-": {
                Rational val = this.rationalValue(args[0]);
                if (args.length == 1) {
                    val = val.negate();
                } else {
                    for (int i = 1; i < args.length; ++i) {
                        val = val.sub(this.rationalValue(args[i]));
                    }
                }
                return val.toTerm(fs.getReturnSort());
            }
            case "*": {
                Rational val = this.rationalValue(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    val = val.mul(this.rationalValue(args[i]));
                }
                return val.toTerm(fs.getReturnSort());
            }
            case "/": {
                Rational val = this.rationalValue(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    Rational divisor = this.rationalValue(args[i]);
                    val = divisor.equals(Rational.ZERO) ? this.rationalValue(this.lookupFunction(fs, new Term[]{val.toTerm(args[0].getSort()), args[i]})) : val.div(divisor);
                }
                return val.toTerm(fs.getReturnSort());
            }
            case "<=": {
                for (int i = 1; i < args.length; ++i) {
                    Rational arg2;
                    Rational arg1 = this.rationalValue(args[i - 1]);
                    if (arg1.compareTo(arg2 = this.rationalValue(args[i])) <= 0) continue;
                    return theory.mFalse;
                }
                return theory.mTrue;
            }
            case "<": {
                for (int i = 1; i < args.length; ++i) {
                    Rational arg2;
                    Rational arg1 = this.rationalValue(args[i - 1]);
                    if (arg1.compareTo(arg2 = this.rationalValue(args[i])) < 0) continue;
                    return theory.mFalse;
                }
                return theory.mTrue;
            }
            case ">=": {
                for (int i = 1; i < args.length; ++i) {
                    Rational arg2;
                    Rational arg1 = this.rationalValue(args[i - 1]);
                    if (arg1.compareTo(arg2 = this.rationalValue(args[i])) >= 0) continue;
                    return theory.mFalse;
                }
                return theory.mTrue;
            }
            case ">": {
                for (int i = 1; i < args.length; ++i) {
                    Rational arg2;
                    Rational arg1 = this.rationalValue(args[i - 1]);
                    if (arg1.compareTo(arg2 = this.rationalValue(args[i])) > 0) continue;
                    return theory.mFalse;
                }
                return theory.mTrue;
            }
            case "div": {
                Rational val = this.rationalValue(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    Rational n = this.rationalValue(args[i]);
                    if (n.equals(Rational.ZERO)) {
                        val = this.rationalValue(this.lookupFunction(fs, new Term[]{val.toTerm(args[0].getSort()), args[i]}));
                        continue;
                    }
                    Rational div = val.div(n);
                    val = n.isNegative() ? div.ceil() : div.floor();
                }
                return val.toTerm(fs.getReturnSort());
            }
            case "mod": {
                assert (args.length == 2);
                Rational n = this.rationalValue(args[1]);
                if (n.equals(Rational.ZERO)) {
                    return this.lookupFunction(fs, args);
                }
                Rational m = this.rationalValue(args[0]);
                Rational div = m.div(n);
                div = n.isNegative() ? div.ceil() : div.floor();
                return m.sub(div.mul(n)).toTerm(fs.getReturnSort());
            }
            case "abs": {
                assert (args.length == 1);
                Rational arg = this.rationalValue(args[0]);
                return arg.abs().toTerm(fs.getReturnSort());
            }
            case "divisible": {
                BigInteger divisor;
                assert (args.length == 1);
                Rational arg = this.rationalValue(args[0]);
                String[] indices = fs.getIndices();
                assert (indices.length == 1);
                try {
                    divisor = new BigInteger(indices[0]);
                }
                catch (NumberFormatException e) {
                    throw new SMTLIBException("index of divisible must be numeral", e);
                }
                Rational rdivisor = Rational.valueOf(divisor, BigInteger.ONE);
                return arg.div(rdivisor).isIntegral() ? theory.mTrue : theory.mFalse;
            }
            case "to_int": {
                assert (args.length == 1);
                Rational arg = this.rationalValue(args[0]);
                return arg.floor().toTerm(fs.getReturnSort());
            }
            case "to_real": {
                assert (args.length == 1);
                Rational arg = this.rationalValue(args[0]);
                return arg.toTerm(fs.getReturnSort());
            }
            case "is_int": {
                assert (args.length == 1);
                Rational arg = this.rationalValue(args[0]);
                return arg.isIntegral() ? theory.mTrue : theory.mFalse;
            }
            case "store": {
                ArraySortInterpretation array = (ArraySortInterpretation)this.mModel.provideSortInterpretation(fs.getParameterSorts()[0]);
                return array.normalizeStoreTerm(theory.term(fs, args));
            }
            case "const": {
                return theory.term(fs, args[0]);
            }
            case "select": {
                ApplicationTerm array = (ApplicationTerm)args[0];
                Term index = args[1];
                FunctionSymbol head = array.getFunction();
                while (head.getName() == "store") {
                    if (array.getParameters()[1] == index) {
                        return array.getParameters()[2];
                    }
                    array = (ApplicationTerm)array.getParameters()[0];
                    head = array.getFunction();
                }
                assert (head.getName() == "const");
                return array.getParameters()[0];
            }
            case "@diff": {
                ArraySortInterpretation array = (ArraySortInterpretation)this.mModel.provideSortInterpretation(fs.getParameterSorts()[0]);
                return array.computeDiff(args[0], args[1], fs.getReturnSort());
            }
            case "@EQ": {
                return this.lookupFunction(fs, args);
            }
        }
        if (fs.isConstructor()) {
            return theory.term(fs, args);
        }
        if (fs.isSelector()) {
            ApplicationTerm arg = (ApplicationTerm)args[0];
            DataType dataType = (DataType)arg.getSort().getSortSymbol();
            assert (arg.getFunction().isConstructor());
            DataType.Constructor constr = dataType.getConstructor(arg.getFunction().getName());
            String[] selectors = constr.getSelectors();
            for (int i = 0; i < selectors.length; ++i) {
                if (!selectors[i].equals(fs.getName())) continue;
                return arg.getParameters()[i];
            }
            return this.lookupFunction(fs, args);
        }
        if (fs.getName().equals("is")) {
            ApplicationTerm arg = (ApplicationTerm)args[0];
            assert (arg.getFunction().isConstructor());
            return arg.getFunction().getName().equals(fs.getIndices()[0]) ? theory.mTrue : theory.mFalse;
        }
        throw new AssertionError((Object)("Unknown internal function " + fs.getName()));
    }

    private Rational rationalValue(Term term) {
        return (Rational)((ConstantTerm)term).getValue();
    }

    private static class MatchSelector
    implements NonRecursive.Walker {
        private final MatchTerm mMatch;

        public MatchSelector(MatchTerm match) {
            this.mMatch = match;
        }

        @Override
        public void walk(NonRecursive engine) {
            Theory theory = this.mMatch.getTheory();
            ModelEvaluator eval = (ModelEvaluator)engine;
            ApplicationTerm dataTerm = (ApplicationTerm)eval.getConverted();
            for (int i = 0; i < this.mMatch.getConstructors().length; ++i) {
                DataType.Constructor cons = this.mMatch.getConstructors()[i];
                if (cons == null) {
                    eval.pushTerm(theory.let(this.mMatch.getVariables()[i][0], dataTerm, this.mMatch.getCases()[i]));
                    return;
                }
                if (dataTerm.getFunction().getName() != cons.getName()) continue;
                eval.pushTerm(theory.let(this.mMatch.getVariables()[i], dataTerm.getParameters(), this.mMatch.getCases()[i]));
                return;
            }
            throw new InternalError("Match term not total or data term not evaluated");
        }
    }

    private static class ITESelector
    implements NonRecursive.Walker {
        private final ApplicationTerm mIte;

        public ITESelector(ApplicationTerm ite) {
            this.mIte = ite;
        }

        @Override
        public void walk(NonRecursive engine) {
            ModelEvaluator eval = (ModelEvaluator)engine;
            ApplicationTerm condition = (ApplicationTerm)eval.getConverted();
            assert (ModelEvaluator.isBooleanValue(condition)) : "condition must be 'true' or 'false'";
            eval.pushTerm(this.mIte.getParameters()[condition.getFunction().getName() == "true" ? 1 : 2]);
        }
    }
}

