/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;

public class ModelFormatter {
    private final String mLineSep = System.getProperty("line.separator");
    private final StringBuilder mString = new StringBuilder("(");
    private int mIndent = 0;
    private final Theory mTheory;

    private void newline() {
        this.mString.append(this.mLineSep);
        for (int i = 0; i < this.mIndent; ++i) {
            this.mString.append(' ');
        }
    }

    public ModelFormatter(Theory t) {
        this.mTheory = t;
    }

    public void appendComment(String comment) {
        this.mIndent += 2;
        this.newline();
        this.mString.append(";; ").append(comment);
        this.mIndent -= 2;
    }

    public void appendSortInterpretation(SortInterpretation si, Sort sort) {
        Term t = si.toSMTLIB(this.mTheory, sort);
        if (t != null) {
            this.mIndent += 2;
            this.newline();
            this.mString.append(t);
            this.mIndent -= 2;
        }
    }

    public void appendValue(FunctionSymbol f, TermVariable[] vars, Term definition) {
        this.mIndent += 2;
        this.newline();
        Sort[] paramSorts = f.getParameterSorts();
        this.mString.append("(define-fun ").append(PrintTerm.quoteIdentifier(f.getName())).append(" (");
        for (int i = 0; i < vars.length; ++i) {
            this.mString.append('(').append(vars[i]).append(' ').append(paramSorts[i]).append(')');
        }
        this.mString.append(") ").append(f.getReturnSort());
        this.mIndent += 2;
        this.appendFunctionValue(definition);
        this.mString.append(')');
        this.mIndent -= 2;
        this.mIndent -= 2;
    }

    private void appendFunctionValue(Term definition) {
        int closing = 0;
        while (definition instanceof ApplicationTerm && ((ApplicationTerm)definition).getFunction().getName().equals("ite")) {
            Term[] iteArgs = ((ApplicationTerm)definition).getParameters();
            this.newline();
            this.mString.append("(ite ").append(iteArgs[0].toStringDirect()).append(' ').append(iteArgs[1].toStringDirect());
            definition = iteArgs[2];
            ++closing;
        }
        if (closing > 0) {
            this.mIndent += 2;
            this.newline();
            this.mString.append(definition.toStringDirect());
            for (int i = 0; i < closing; ++i) {
                this.mString.append(')');
            }
            this.mIndent -= 2;
        } else {
            this.newline();
            this.mString.append(definition.toStringDirect());
        }
    }

    public String finish() {
        return this.mString.append(')').toString();
    }
}

