/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.util.Map;

public class SharedTermEvaluator {
    private final Clausifier mClausifier;

    public SharedTermEvaluator(Clausifier clausifier) {
        this.mClausifier = clausifier;
    }

    public Rational evaluate(Term term, Theory t) {
        SMTAffineTerm affine = SMTAffineTerm.create(term);
        Rational value = affine.getConstant();
        for (Map.Entry<Term, Rational> entry : affine.getSummands().entrySet()) {
            LinVar var = this.mClausifier.getLinVar(entry.getKey());
            value = value.addmul(this.mClausifier.getLASolver().realValue(var), entry.getValue());
        }
        return value;
    }
}

