/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Translator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.util.BitSet;

public class ConstraintAdministrationSolver {
    final Script mScript;
    boolean mUnknownConstraintsAreSet;
    boolean mLastOpWasReset;
    int mLevels;
    Translator mTranslator;

    public ConstraintAdministrationSolver(Script script, Translator translator) {
        this.mScript = script;
        this.mUnknownConstraintsAreSet = false;
        this.mLastOpWasReset = false;
        this.mLevels = 0;
        this.mTranslator = translator;
        this.push(1);
    }

    public void pushRecLevel() {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("You may not push a new recursion level, when unknown constraints are set.");
        }
        this.push(1);
    }

    public void popRecLevel() {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        this.clearUnknownConstraints();
        this.pop(1);
    }

    private void push(int levels) {
        ++this.mLevels;
        this.mScript.push(levels);
    }

    private void pop(int levels) {
        this.mLevels -= levels;
        assert (this.mLevels >= 1) : "This class should not be able to modify lower levels of the script than the level at which it was created";
        this.mScript.pop(levels);
    }

    public void clearUnknownConstraints() {
        if (this.mUnknownConstraintsAreSet) {
            this.pop(1);
            this.mUnknownConstraintsAreSet = false;
        }
    }

    public void assertCriticalConstraint(int constraintNumber) throws SMTLIBException {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("Modifying crits without clearing unknowns is prohibited.");
        }
        this.mScript.assertTerm(this.mTranslator.translate2Constraint(constraintNumber));
    }

    public void assertCriticalConstraints(BitSet constraints) throws SMTLIBException {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("Modifying crits without clearing unknowns is prohibited.");
        }
        int i = constraints.nextSetBit(0);
        while (i >= 0) {
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(i));
            i = constraints.nextSetBit(i + 1);
        }
    }

    public void assertUnknownConstraint(int constraintNumber) {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (!this.mUnknownConstraintsAreSet) {
            this.push(1);
            this.mUnknownConstraintsAreSet = true;
        }
        this.mScript.assertTerm(this.mTranslator.translate2Constraint(constraintNumber));
    }

    public void assertUnknownConstraints(BitSet constraints) {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (!this.mUnknownConstraintsAreSet) {
            this.push(1);
            this.mUnknownConstraintsAreSet = true;
        }
        int i = constraints.nextSetBit(0);
        while (i >= 0) {
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(i));
            i = constraints.nextSetBit(i + 1);
        }
    }

    public Script.LBool checkSat() throws SMTLIBException {
        return this.mScript.checkSat();
    }

    public BitSet getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        Term[] core = this.mScript.getUnsatCore();
        return this.mTranslator.translateToBitSet(core);
    }

    public BitSet getSatExtension(TerminationRequest request) throws SMTLIBException, UnsupportedOperationException {
        Script.LBool sat = this.mScript.checkSat();
        if (Script.LBool.SAT != sat) {
            if (Script.LBool.UNKNOWN == sat && request != null && request.isTerminationRequested()) {
                return null;
            }
            throw new SMTLIBException("The current assertions are not satisfiable.");
        }
        Model model = this.mScript.getModel();
        Term[] assertions = this.mScript.getAssertions();
        BitSet assertedAsBits = this.mTranslator.translateToBitSet(assertions);
        BitSet notAsserted = (BitSet)assertedAsBits.clone();
        notAsserted.flip(0, this.mTranslator.getNumberOfConstraints());
        int i = notAsserted.nextSetBit(0);
        while (i >= 0) {
            Term evaluatedTerm = model.evaluate(this.mTranslator.translate2Constraint(i));
            if (evaluatedTerm == evaluatedTerm.getTheory().mTrue) {
                assertedAsBits.set(i);
            } else if (evaluatedTerm != evaluatedTerm.getTheory().mFalse) {
                throw new SMTLIBException("Term evaluated by model is neither True nor False.");
            }
            i = notAsserted.nextSetBit(i + 1);
        }
        return assertedAsBits;
    }

    public BitSet getSatExtensionMoreDemanding() throws SMTLIBException {
        if (Script.LBool.SAT != this.mScript.checkSat()) {
            throw new SMTLIBException("The current assertions are not satisfiable.");
        }
        this.push(1);
        Term[] assertions = this.mScript.getAssertions();
        BitSet assertedAsBits = this.mTranslator.translateToBitSet(assertions);
        BitSet notAsserted = (BitSet)assertedAsBits.clone();
        notAsserted.flip(0, this.mTranslator.getNumberOfConstraints());
        int i = notAsserted.nextSetBit(0);
        while (i >= 0) {
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(i));
            assertedAsBits.set(i);
            switch (this.mScript.checkSat()) {
                case UNSAT: {
                    assertedAsBits.clear(i);
                    this.pop(1);
                    return assertedAsBits;
                }
                case SAT: {
                    break;
                }
                case UNKNOWN: {
                    throw new SMTLIBException("Solver returns UNKNOWN in Extension process.");
                }
                default: {
                    throw new SMTLIBException("Unknown LBool value in Extension process.");
                }
            }
            i = notAsserted.nextSetBit(i + 1);
        }
        this.pop(1);
        throw new SMTLIBException("This means, that the set of all constraints is satisfiable. Something is not right!");
    }

    public BitSet getSatExtensionMaximalDemanding() {
        if (Script.LBool.SAT != this.mScript.checkSat()) {
            throw new SMTLIBException("The current assertions are not satisfiable.");
        }
        this.push(1);
        int pushCounter = 1;
        Term[] assertions = this.mScript.getAssertions();
        BitSet assertedAsBits = this.mTranslator.translateToBitSet(assertions);
        BitSet notAsserted = (BitSet)assertedAsBits.clone();
        notAsserted.flip(0, this.mTranslator.getNumberOfConstraints());
        int i = notAsserted.nextSetBit(0);
        while (i >= 0) {
            this.push(1);
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(i));
            ++pushCounter;
            assertedAsBits.set(i);
            switch (this.mScript.checkSat()) {
                case UNSAT: {
                    assertedAsBits.clear(i);
                    this.pop(1);
                    --pushCounter;
                    break;
                }
                case SAT: {
                    break;
                }
                case UNKNOWN: {
                    throw new SMTLIBException("Solver returns LBool.UNKNOWN in extension process.");
                }
                default: {
                    throw new SMTLIBException("Unknown LBool value in extension process.");
                }
            }
            i = notAsserted.nextSetBit(i + 1);
        }
        this.pop(pushCounter);
        return assertedAsBits;
    }

    public BitSet getCrits() throws SMTLIBException {
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("Reading crits without clearing unknowns is prohibited.");
        }
        Term[] crits = this.mScript.getAssertions();
        return this.mTranslator.translateToBitSet(crits);
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        return this.mScript.getProof();
    }

    public int getNumberOfConstraints() {
        return this.mTranslator.getNumberOfConstraints();
    }

    public void reset() {
        this.mUnknownConstraintsAreSet = false;
        this.mLastOpWasReset = true;
        this.mScript.pop(this.mLevels);
    }

    public Object getInfo(String info) {
        return this.mScript.getInfo(info);
    }
}

