/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import java.util.function.BiFunction;

public class Heuristics {
    public static MusContainer chooseRandomMus(ArrayList<MusContainer> muses, Random rnd) {
        if (muses.isEmpty()) {
            return null;
        }
        return muses.get(rnd.nextInt(muses.size()));
    }

    public static MusContainer chooseSmallestMus(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusIsSmaller, request), rnd);
    }

    public static MusContainer chooseBiggestMus(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusIsBigger, request), rnd);
    }

    public static MusContainer chooseMusWithLowestLexicographicalOrder(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusHasLowerLexicographicalOrder, request), rnd);
    }

    public static MusContainer chooseMusWithHighestLexicographicalOrder(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusHasHigherLexicographicalOrder, request), rnd);
    }

    public static MusContainer chooseShallowestMus(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusIsShallowerMus, request), rnd);
    }

    public static MusContainer chooseDeepestMus(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusIsDeeperMus, request), rnd);
    }

    public static MusContainer chooseNarrowestMus(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusIsNarrowerMus, request), rnd);
    }

    public static MusContainer chooseWidestMus(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(muses, Heuristics::compareWhichMusIsWiderMus, request), rnd);
    }

    public static MusContainer chooseSmallestAmongWideMuses(ArrayList<MusContainer> muses, double tolerance, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        ArrayList<MusContainer> widestMuses = new ArrayList<MusContainer>();
        MusContainer widestMus = Heuristics.chooseWidestMus(muses, rnd, request);
        int maximalOccurringWidth = Heuristics.width(widestMus);
        if (request.isTerminationRequested()) {
            return widestMus;
        }
        for (int i = 0; i < muses.size() && !request.isTerminationRequested(); ++i) {
            MusContainer container = muses.get(i);
            int currentWidth = Heuristics.width(container);
            if (!((double)currentWidth >= (1.0 - tolerance) * (double)maximalOccurringWidth)) continue;
            widestMuses.add(container);
        }
        return Heuristics.chooseSmallestMus(widestMuses, rnd, request);
    }

    public static MusContainer chooseWidestAmongSmallMuses(ArrayList<MusContainer> muses, double tolerance, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return null;
        }
        ArrayList<MusContainer> smallestMuses = new ArrayList<MusContainer>();
        MusContainer smallestMus = Heuristics.chooseSmallestMus(muses, rnd, request);
        int minimalOccurringSize = Heuristics.size(smallestMus);
        if (request.isTerminationRequested()) {
            return smallestMus;
        }
        for (int i = 0; i < muses.size() && !request.isTerminationRequested(); ++i) {
            MusContainer container = muses.get(i);
            int currentSize = Heuristics.size(container);
            if (!((double)currentSize <= (1.0 + tolerance) * (double)minimalOccurringSize)) continue;
            smallestMuses.add(container);
        }
        return Heuristics.chooseWidestMus(smallestMuses, rnd, request);
    }

    public static ArrayList<MusContainer> chooseAllMuses(ArrayList<MusContainer> muses) {
        return muses;
    }

    public static ArrayList<MusContainer> chooseMostDifferentMusesWithRespectToOtherHeuristics(ArrayList<MusContainer> muses, Random rnd, TerminationRequest request) {
        if (muses.isEmpty()) {
            return new ArrayList<MusContainer>();
        }
        ArrayList<MusContainer> mostExtremeMuses = new ArrayList<MusContainer>();
        mostExtremeMuses.add(Heuristics.chooseSmallestMus(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseBiggestMus(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseMusWithLowestLexicographicalOrder(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseMusWithHighestLexicographicalOrder(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseShallowestMus(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseDeepestMus(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseNarrowestMus(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseWidestMus(muses, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseSmallestAmongWideMuses(muses, 0.9, rnd, request));
        mostExtremeMuses.add(Heuristics.chooseWidestAmongSmallMuses(muses, 0.9, rnd, request));
        return mostExtremeMuses;
    }

    public static ArrayList<MusContainer> chooseDifferentMusesWithRespectToStatements(ArrayList<MusContainer> muses, int size, Random rnd, TerminationRequest request) {
        if (muses.isEmpty() || size == 0) {
            return new ArrayList<MusContainer>();
        }
        ArrayList<MusContainer> differentMuses = new ArrayList<MusContainer>();
        ArrayList<MusContainer> maxMinDifferenceMuses = new ArrayList<MusContainer>();
        differentMuses.add(muses.get(rnd.nextInt(muses.size())));
        for (int i = 1; i < size && !request.isTerminationRequested(); ++i) {
            int maxMinDifference = Integer.MIN_VALUE;
            for (MusContainer contender : muses) {
                int currentMinDifference = Heuristics.findMinimumNumberOfDifferentStatements(contender, differentMuses);
                if (currentMinDifference > maxMinDifference) {
                    maxMinDifference = currentMinDifference;
                    maxMinDifferenceMuses.clear();
                    maxMinDifferenceMuses.add(contender);
                    continue;
                }
                if (currentMinDifference != maxMinDifference) continue;
                maxMinDifferenceMuses.add(contender);
            }
            if (maxMinDifference == 0) break;
            differentMuses.add(Heuristics.chooseRandomMus(maxMinDifferenceMuses, rnd));
        }
        return differentMuses;
    }

    private static int findMinimumNumberOfDifferentStatements(MusContainer mus1, ArrayList<MusContainer> muses) {
        int minimumDifference = Integer.MAX_VALUE;
        for (MusContainer mus2 : muses) {
            int currentDifference = Heuristics.numberOfDifferentStatements(mus1, mus2);
            if (currentDifference >= minimumDifference) continue;
            minimumDifference = currentDifference;
        }
        return minimumDifference;
    }

    public static int numberOfDifferentStatements(MusContainer mus1, MusContainer mus2) {
        int i;
        BitSet realMus1 = mus1.getMus();
        BitSet realMus2 = mus2.getMus();
        int difference = 0;
        for (i = 0; i < realMus1.length(); ++i) {
            if ((!realMus1.get(i) || realMus2.get(i)) && (!realMus2.get(i) || realMus1.get(i))) continue;
            ++difference;
        }
        if (realMus2.length() > realMus1.length()) {
            i = realMus2.nextSetBit(realMus1.length());
            while (i >= 0) {
                ++difference;
                i = realMus2.nextSetBit(i + 1);
            }
        }
        return difference;
    }

    private static ResultOfComparison compareWhichMusIsSmaller(MusContainer mus1, MusContainer mus2) {
        int length2;
        int length1 = Heuristics.size(mus1);
        if (length1 < (length2 = Heuristics.size(mus2))) {
            return ResultOfComparison.MUS1;
        }
        if (length1 > length2) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.EQUAL;
    }

    private static ResultOfComparison compareWhichMusIsBigger(MusContainer mus1, MusContainer mus2) {
        return Heuristics.compareWhichMusIsSmaller(mus2, mus1);
    }

    private static ResultOfComparison compareWhichMusHasLowerLexicographicalOrder(MusContainer mus1, MusContainer mus2) {
        BitSet realMus1 = mus1.getMus();
        BitSet realMus2 = mus2.getMus();
        for (int i = 0; i < realMus1.length(); ++i) {
            if (realMus1.get(i)) {
                if (realMus2.get(i)) continue;
                return ResultOfComparison.MUS1;
            }
            if (!realMus2.get(i)) continue;
            return ResultOfComparison.MUS2;
        }
        if (realMus2.length() > realMus1.length()) {
            return ResultOfComparison.MUS1;
        }
        throw new SMTLIBException("Both muses must be the same. This should not be.");
    }

    private static ResultOfComparison compareWhichMusHasHigherLexicographicalOrder(MusContainer mus1, MusContainer mus2) {
        if (Heuristics.compareWhichMusHasLowerLexicographicalOrder(mus1, mus2) == ResultOfComparison.MUS1) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.MUS1;
    }

    private static ResultOfComparison compareWhichMusIsShallowerMus(MusContainer mus1, MusContainer mus2) {
        int depth2;
        int depth1 = Heuristics.depth(mus1);
        if (depth1 < (depth2 = Heuristics.depth(mus2))) {
            return ResultOfComparison.MUS1;
        }
        if (depth1 > depth2) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.EQUAL;
    }

    private static ResultOfComparison compareWhichMusIsDeeperMus(MusContainer mus1, MusContainer mus2) {
        return Heuristics.compareWhichMusIsShallowerMus(mus2, mus1);
    }

    private static ResultOfComparison compareWhichMusIsNarrowerMus(MusContainer mus1, MusContainer mus2) {
        int width2;
        int width1 = Heuristics.width(mus1);
        if (width1 < (width2 = Heuristics.width(mus2))) {
            return ResultOfComparison.MUS1;
        }
        if (width1 > width2) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.EQUAL;
    }

    private static ResultOfComparison compareWhichMusIsWiderMus(MusContainer mus1, MusContainer mus2) {
        return Heuristics.compareWhichMusIsNarrowerMus(mus2, mus1);
    }

    private static ArrayList<MusContainer> findBestMusesAccordingToGivenCriterion(ArrayList<MusContainer> muses, BiFunction<MusContainer, MusContainer, ResultOfComparison> criterion, TerminationRequest request) {
        ArrayList<MusContainer> bestMuses = new ArrayList<MusContainer>();
        MusContainer oneOfTheBestMuses = muses.get(0);
        bestMuses.add(oneOfTheBestMuses);
        for (int i = 1; i < muses.size() && !request.isTerminationRequested(); ++i) {
            MusContainer contender = muses.get(i);
            ResultOfComparison result = criterion.apply(oneOfTheBestMuses, contender);
            if (result == ResultOfComparison.MUS2) {
                bestMuses.clear();
                bestMuses.add(contender);
                oneOfTheBestMuses = contender;
                continue;
            }
            if (result != ResultOfComparison.EQUAL) continue;
            bestMuses.add(contender);
        }
        return bestMuses;
    }

    public static int size(MusContainer mus) {
        return mus.getMus().cardinality();
    }

    public static int depth(MusContainer mus) {
        return mus.getMus().nextSetBit(0);
    }

    public static int width(MusContainer mus) {
        return mus.getMus().length() - mus.getMus().nextSetBit(0);
    }

    private static enum ResultOfComparison {
        MUS1{}
        ,
        MUS2{}
        ,
        EQUAL{};

    }
}

