/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ConstraintAdministrationSolver;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Heuristics;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ReMus;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Shrinking;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Translator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.UnexploredMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.BooleanOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.DoubleOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.EnumOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.LongOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.TimeoutHandler;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class MusEnumerationScript
extends WrapperScript {
    TimeoutHandler mHandler;
    ScopedArrayList<Term> mRememberedAssertions;
    int mCustomNameId;
    boolean mAssertedTermsAreUnsat;
    EnumOption<HeuristicsType> mInterpolationHeuristic;
    DoubleOption mTolerance;
    LongOption mEnumerationTimeout;
    LongOption mHeuristicTimeout;
    BooleanOption mLogAdditionalInformation;
    BooleanOption mUnknownAllowed;
    LogProxy mLogger;
    Random mRandom;

    public MusEnumerationScript() {
        this(new SMTInterpol());
    }

    public MusEnumerationScript(SMTInterpol wrappedScript) {
        this(wrappedScript, null);
    }

    public MusEnumerationScript(SMTInterpol wrappedScript, LogProxy logger) {
        super(wrappedScript);
        assert (wrappedScript instanceof SMTInterpol) : "Currently, only SMTInterpol is supported.";
        SMTInterpol wrappedSMTInterpol = (SMTInterpol)this.mScript;
        this.mCustomNameId = 0;
        this.mAssertedTermsAreUnsat = false;
        this.mHandler = new TimeoutHandler(wrappedSMTInterpol.getTerminationRequest());
        this.mLogger = logger == null ? wrappedScript.getLogger() : logger;
        this.mRandom = new Random(this.getRandomSeed());
        this.mRememberedAssertions = new ScopedArrayList();
        this.mInterpolationHeuristic = new EnumOption<HeuristicsType>(HeuristicsType.RANDOM, true, HeuristicsType.class, "The Heuristic that is used to choose a minimal unsatisfiable subset/core for interpolant generation");
        this.mTolerance = new DoubleOption(0.1, true, "The tolerance value that is used by the SMALLESTAMONGWIDE and the WIDESTAMONGSMALL Heuristic.");
        this.mEnumerationTimeout = new LongOption(0L, true, "The time that is invested into enumerating Muses");
        this.mHeuristicTimeout = new LongOption(0L, true, "The time that is invested into finding the best Mus according to the set Heuristic");
        this.mLogAdditionalInformation = new BooleanOption(false, true, "Whether additional information (e.g. of the enumeration) should be logged.");
        this.mUnknownAllowed = new BooleanOption(false, true, "Whether LBool.UNKNOWN is allowed to occur in the enumeration process.");
    }

    private long getRandomSeed() {
        return ((BigInteger)this.getOption(":random-seed")).longValue();
    }

    private long getEnumerationTimeout() {
        return ((BigInteger)this.getOption(":enumeration-timeout")).longValue();
    }

    private long getHeuristicTimeout() {
        return ((BigInteger)this.getOption(":heuristic-timeout")).longValue();
    }

    @Override
    public FunctionSymbol getFunctionSymbol(String constructor) {
        return this.mScript.getFunctionSymbol(constructor);
    }

    @Override
    public Term[] getInterpolants(Term[] partition) {
        int[] startOfSubtrees = new int[partition.length];
        return this.getInterpolants(partition, startOfSubtrees);
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree, Term proofTree) {
        return this.mScript.getInterpolants(partition, startOfSubtree, proofTree);
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) {
        if (!this.mAssertedTermsAreUnsat) {
            throw new SMTLIBException("Asserted terms must be determined to be unsatisfiable before an interpolant can be generated. Call checkSat to determine satisfiability.");
        }
        if (!((Boolean)this.getOption(":produce-proofs")).booleanValue()) {
            throw new SMTLIBException("Proof production must be enabled (you can do this via setOption).");
        }
        if (!((Boolean)this.getOption(":produce-unsat-cores")).booleanValue() && this.mInterpolationHeuristic.getValue() == HeuristicsType.FIRST) {
            throw new SMTLIBException("For the FIRST Heuristic, unsat core production must be enabled.");
        }
        Translator translator = new Translator();
        long enumerationTimeout = this.getEnumerationTimeout();
        long heuristicTimeout = this.getHeuristicTimeout();
        if (enumerationTimeout > 0L) {
            this.mHandler.setTimeout(enumerationTimeout);
        }
        long elapsedTime = System.nanoTime();
        ArrayList<MusContainer> muses = this.mInterpolationHeuristic.getValue() == HeuristicsType.FIRST ? this.shrinkVanillaUnsatCore(translator) : this.executeReMus(translator);
        elapsedTime = (System.nanoTime() - elapsedTime) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            String value = enumerationTimeout <= 0L ? "Unlimited (no timeout set)" : Long.toString(enumerationTimeout);
            this.mLogger.fatal("Timeout: " + value);
            this.mLogger.fatal("Cardinality of Constraint set: " + translator.getNumberOfConstraints());
            this.mLogger.fatal("Number of enumerated Muses: " + muses.size());
            this.mLogger.fatal("Time needed for enumeration: " + elapsedTime);
        }
        this.mHandler.clearTimeout();
        if (muses.isEmpty()) {
            if (this.mLogAdditionalInformation.getValue()) {
                this.mLogger.fatal("Timeout for enumeration exceeded before any muses could be found.");
                this.mLogger.fatal("Heuristic: None (UC is from Vanilla-SMTInterpol)");
                if (((Boolean)this.getOption(":produce-unsat-cores")).booleanValue()) {
                    MusContainer container = new MusContainer(translator.translateToBitSet(this.mScript.getUnsatCore()), null);
                    this.mLogger.fatal("Vanilla-UC has size: " + Heuristics.size(container));
                    this.mLogger.fatal("Vanilla-UC has depth: " + Heuristics.depth(container));
                    this.mLogger.fatal("Vanilla-UC has width: " + Heuristics.width(container));
                }
            }
            Term[] sequenceOfInterpolants = this.getInterpolants(partition, startOfSubtree, this.mScript.getProof());
            return sequenceOfInterpolants;
        }
        if (heuristicTimeout > 0L) {
            this.mHandler.setTimeout(heuristicTimeout);
        }
        elapsedTime = System.nanoTime();
        MusContainer chosenMus = this.chooseMusAccordingToHeuristic(muses, this.mHandler);
        elapsedTime = (System.nanoTime() - elapsedTime) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            this.mLogger.fatal("Time needed for Heuristics: " + elapsedTime);
        }
        this.mHandler.clearTimeout();
        Term[] sequenceOfInterpolants = this.getInterpolants(partition, startOfSubtree, chosenMus.getProof());
        return sequenceOfInterpolants;
    }

    @Override
    public Term[] getUnsatCore() {
        if (!this.mAssertedTermsAreUnsat) {
            throw new SMTLIBException("Asserted Terms must be determined Unsat to return an unsat core. Call checkSat to determine satisfiability.");
        }
        if (!((Boolean)this.getOption(":produce-unsat-cores")).booleanValue()) {
            throw new SMTLIBException("Unsat core production must be enabled (you can do this via setOption).");
        }
        Translator translator = new Translator();
        long timeoutForReMus = this.getEnumerationTimeout();
        long timeoutForHeuristic = this.getHeuristicTimeout();
        if (timeoutForReMus > 0L) {
            this.mHandler.setTimeout(timeoutForReMus);
        }
        long elapsedTime = System.nanoTime();
        ArrayList<MusContainer> muses = this.mInterpolationHeuristic.getValue() == HeuristicsType.FIRST ? this.shrinkVanillaUnsatCore(translator) : this.executeReMus(translator);
        elapsedTime = (System.nanoTime() - elapsedTime) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            String value = timeoutForReMus <= 0L ? "Unlimited (no timeout set)" : Long.toString(timeoutForReMus);
            this.mLogger.fatal("Timeout: " + value);
            this.mLogger.fatal("Cardinality of Constraint set: " + translator.getNumberOfConstraints());
            this.mLogger.fatal("Number of enumerated Muses: " + muses.size());
            this.mLogger.fatal("Time needed for enumeration: " + elapsedTime);
        }
        this.mHandler.clearTimeout();
        if (muses.isEmpty()) {
            Term[] alternativeUnsatCore = this.mScript.getUnsatCore();
            if (this.mLogAdditionalInformation.getValue()) {
                this.mLogger.fatal("Enumeration timeout exceeded. Returning Unsat Core of wrapped Script.");
                MusContainer container = new MusContainer(translator.translateToBitSet(alternativeUnsatCore), null);
                this.mLogger.fatal("Heuristic: None (UC is from Vanilla-SMTInterpol)");
                this.mLogger.fatal("Vanilla-UC has size: " + Heuristics.size(container));
                this.mLogger.fatal("Vanilla-UC has depth: " + Heuristics.depth(container));
                this.mLogger.fatal("Vanilla-UC has width: " + Heuristics.width(container));
            }
            return alternativeUnsatCore;
        }
        if (timeoutForHeuristic > 0L) {
            this.mHandler.setTimeout(timeoutForHeuristic);
        }
        elapsedTime = System.nanoTime();
        MusContainer chosenMus = this.chooseMusAccordingToHeuristic(muses, this.mHandler);
        elapsedTime = (System.nanoTime() - elapsedTime) / 1000000L;
        if (this.mLogAdditionalInformation.getValue()) {
            this.mLogger.fatal("Time needed for Heuristics: " + elapsedTime);
        }
        this.mHandler.clearTimeout();
        ArrayDeque<Term> unsatcore = new ArrayDeque<Term>();
        block0: for (Term t : translator.translateToTerms(chosenMus.getMus())) {
            if (!(t instanceof AnnotatedTerm)) continue;
            AnnotatedTerm at = (AnnotatedTerm)t;
            for (Annotation a : at.getAnnotations()) {
                if (!a.getKey().equals(":named")) continue;
                String name = ((String)a.getValue()).intern();
                unsatcore.add(t.getTheory().term(name, new Term[0]));
                continue block0;
            }
        }
        return unsatcore.toArray(new Term[unsatcore.size()]);
    }

    private ArrayList<MusContainer> executeReMus() {
        Translator translator = new Translator();
        return this.executeReMus(translator);
    }

    private ArrayList<MusContainer> executeReMus(Translator translator) {
        if (translator.getNumberOfConstraints() != 0) {
            throw new SMTLIBException("Translator must be new.");
        }
        TimeoutHandler handlerForReMus = new TimeoutHandler(this.mHandler);
        DPLLEngine engine = new DPLLEngine(this.mLogger, handlerForReMus);
        Script scriptForReMus = this.createScriptForMuses((SMTInterpol)this.mScript, handlerForReMus);
        this.registerTermsForEnumeration(this.mRememberedAssertions, translator, engine, scriptForReMus);
        this.resetCustomNameId();
        UnexploredMap unexploredMap = new UnexploredMap(engine, translator);
        ConstraintAdministrationSolver solver = new ConstraintAdministrationSolver(scriptForReMus, translator);
        int nrOfConstraints = solver.getNumberOfConstraints();
        BitSet workingSet = new BitSet(nrOfConstraints);
        workingSet.flip(0, nrOfConstraints);
        LogProxy logForReMus = this.mLogAdditionalInformation.getValue() ? this.mLogger : null;
        ReMus remus = new ReMus(solver, unexploredMap, workingSet, handlerForReMus, 0L, this.mRandom, this.mUnknownAllowed.getValue(), logForReMus);
        ArrayList<MusContainer> muses = remus.enumerate();
        this.letScriptForReMusRetire(scriptForReMus, remus);
        return muses;
    }

    private ArrayList<MusContainer> shrinkVanillaUnsatCore(Translator translator) {
        Term[] unsatCore = this.mScript.getUnsatCore();
        ArrayList<MusContainer> muses = new ArrayList<MusContainer>();
        TimeoutHandler requestForShrinker = this.mHandler;
        Script scriptForShrinker = this.createScriptForMuses((SMTInterpol)this.mScript, requestForShrinker);
        this.registerTermsForShrinking(this.mRememberedAssertions, translator, scriptForShrinker);
        this.resetCustomNameId();
        ConstraintAdministrationSolver solver = new ConstraintAdministrationSolver(scriptForShrinker, translator);
        BitSet workingSet = translator.translateToBitSet(unsatCore);
        MusContainer firstMus = Shrinking.shrink(solver, workingSet, requestForShrinker, this.mRandom, this.mUnknownAllowed.getValue());
        if (firstMus != null) {
            muses.add(firstMus);
            if (this.mLogAdditionalInformation.getValue()) {
                MusContainer containsVanillaUc = new MusContainer(workingSet, null);
                int sizeDiff = Heuristics.size(containsVanillaUc) - Heuristics.size(firstMus);
                int depthDiff = Heuristics.depth(containsVanillaUc) - Heuristics.depth(firstMus);
                int widthDiff = Heuristics.width(containsVanillaUc) - Heuristics.width(firstMus);
                this.mLogger.fatal("Difference in size: " + sizeDiff);
                this.mLogger.fatal("Difference in depth: " + depthDiff);
                this.mLogger.fatal("Difference in width: " + widthDiff);
            }
        }
        this.letScriptForShrinkerRetire(scriptForShrinker, solver);
        return muses;
    }

    private Script createScriptForMuses(SMTInterpol smtInterpol, TerminationRequest terminationRequest) {
        Map<String, Object> remusOptions = this.createSMTInterpolOptionsForReMus();
        SMTInterpol scriptForReMus = new SMTInterpol(smtInterpol, remusOptions, OptionMap.CopyMode.CURRENT_VALUE);
        scriptForReMus.setTerminationRequest(terminationRequest);
        scriptForReMus.push(1);
        return scriptForReMus;
    }

    private Map<String, Object> createSMTInterpolOptionsForReMus() {
        HashMap<String, Object> remusOptions = new HashMap<String, Object>();
        remusOptions.put(":produce-models", true);
        remusOptions.put(":produce-proofs", true);
        remusOptions.put(":interactive-mode", true);
        remusOptions.put(":produce-unsat-cores", true);
        return remusOptions;
    }

    private void letScriptForReMusRetire(Script scriptForReMus, ReMus remus) {
        remus.resetSolver();
        scriptForReMus.pop(1);
    }

    private void letScriptForShrinkerRetire(Script scriptForShrinker, ConstraintAdministrationSolver solver) {
        solver.reset();
        scriptForShrinker.pop(1);
    }

    private boolean hasName(Term term) {
        if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annoTerm = (AnnotatedTerm)term;
            Annotation[] annotations = annoTerm.getAnnotations();
            String name = this.findName(annotations);
            return name != null;
        }
        return false;
    }

    private String findName(Annotation[] annotations) {
        String name = null;
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].getKey().equals(":named")) continue;
            name = (String)annotations[i].getValue();
        }
        return name;
    }

    private AnnotatedTerm nameTerm(Term term, Script script) {
        Annotation name = new Annotation(":named", "constraint" + Integer.toString(this.mCustomNameId));
        ++this.mCustomNameId;
        return (AnnotatedTerm)script.annotate(term, name);
    }

    private void registerTermsForEnumeration(ArrayList<Term> terms, Translator translator, DPLLEngine engine, Script scriptForReMus) {
        for (Term term : terms) {
            if (!this.hasName(term)) {
                scriptForReMus.assertTerm(term);
                continue;
            }
            AnnotatedTerm annoTerm = (AnnotatedTerm)term;
            NamedAtom atom = new NamedAtom(annoTerm, 0);
            atom.setPreferredStatus(atom.getAtom());
            atom.lockPreferredStatus();
            if (engine != null) {
                engine.addAtom(atom);
            }
            translator.declareConstraint(atom);
        }
    }

    private void registerTermsForShrinking(ArrayList<Term> terms, Translator translator, Script scriptForReMus) {
        this.registerTermsForEnumeration(terms, translator, null, scriptForReMus);
    }

    private MusContainer chooseMusAccordingToHeuristic(ArrayList<MusContainer> muses, TerminationRequest request) {
        MusContainer chosenMus;
        switch (this.mInterpolationHeuristic.getValue()) {
            case FIRST: {
                assert (muses.size() == 1) : "In case of the FIRST heuristic, only one mus should have been enumerated.";
                MusContainer musContainer = muses.get(0);
            }
            case RANDOM: {
                chosenMus = Heuristics.chooseRandomMus(muses, this.mRandom);
                break;
            }
            case SMALLEST: {
                chosenMus = Heuristics.chooseSmallestMus(muses, this.mRandom, this.mHandler);
                break;
            }
            case BIGGEST: {
                chosenMus = Heuristics.chooseBiggestMus(muses, this.mRandom, this.mHandler);
                break;
            }
            case LOWLEXORDER: {
                chosenMus = Heuristics.chooseMusWithLowestLexicographicalOrder(muses, this.mRandom, this.mHandler);
                break;
            }
            case HIGHLEXORDER: {
                chosenMus = Heuristics.chooseMusWithHighestLexicographicalOrder(muses, this.mRandom, this.mHandler);
                break;
            }
            case SHALLOWEST: {
                chosenMus = Heuristics.chooseShallowestMus(muses, this.mRandom, this.mHandler);
                break;
            }
            case DEEPEST: {
                chosenMus = Heuristics.chooseDeepestMus(muses, this.mRandom, this.mHandler);
                break;
            }
            case NARROWEST: {
                chosenMus = Heuristics.chooseNarrowestMus(muses, this.mRandom, this.mHandler);
                break;
            }
            case WIDEST: {
                chosenMus = Heuristics.chooseWidestMus(muses, this.mRandom, this.mHandler);
                break;
            }
            case SMALLESTAMONGWIDE: {
                double tolerance = (Double)this.mTolerance.get();
                chosenMus = Heuristics.chooseSmallestAmongWideMuses(muses, tolerance, this.mRandom, this.mHandler);
                break;
            }
            case WIDESTAMONGSMALL: {
                double tolerance = (Double)this.mTolerance.get();
                chosenMus = Heuristics.chooseWidestAmongSmallMuses(muses, tolerance, this.mRandom, this.mHandler);
                break;
            }
            default: {
                throw new SMTLIBException("Unknown Enum for Interpolation heuristic");
            }
        }
        if (this.mLogAdditionalInformation.getValue()) {
            String heuristic = this.mInterpolationHeuristic.getValue().toString();
            this.mLogger.fatal("Heuristic: " + heuristic);
            HeuristicsType heurType = this.mInterpolationHeuristic.getValue();
            if (heurType == HeuristicsType.SMALLESTAMONGWIDE || heurType == HeuristicsType.WIDESTAMONGSMALL) {
                this.mLogger.fatal("Tolerance: " + (Double)this.mTolerance.get());
            }
            this.mLogger.fatal("Chosen Mus has size: " + Heuristics.size(chosenMus));
            this.mLogger.fatal("Chosen Mus has depth: " + Heuristics.depth(chosenMus));
            this.mLogger.fatal("Chosen Mus has width: " + Heuristics.width(chosenMus));
        }
        return chosenMus;
    }

    @Override
    public Script.LBool checkSat() {
        Script.LBool sat = this.mScript.checkSat();
        if (sat == Script.LBool.UNSAT) {
            this.mAssertedTermsAreUnsat = true;
        }
        return sat;
    }

    @Override
    public void push(int levels) throws SMTLIBException {
        super.push(levels);
        for (int i = 0; i < levels; ++i) {
            this.mRememberedAssertions.beginScope();
        }
    }

    @Override
    public void pop(int levels) throws SMTLIBException {
        super.pop(levels);
        for (int i = 0; i < levels; ++i) {
            this.mRememberedAssertions.endScope();
        }
        this.mAssertedTermsAreUnsat = false;
    }

    @Override
    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        if (opt.equals(":interpolation-heuristic")) {
            this.mInterpolationHeuristic.set(value);
        } else if (opt.equals(":tolerance")) {
            this.mTolerance.set(value);
        } else if (opt.equals(":random-seed")) {
            this.mScript.setOption(opt, value);
            this.mRandom = new Random(this.getRandomSeed());
        } else if (opt.equals(":enumeration-timeout")) {
            this.mEnumerationTimeout.set(value);
        } else if (opt.equals(":heuristic-timeout")) {
            this.mHeuristicTimeout.set(value);
        } else if (opt.equals(":log-additional-information")) {
            this.mLogAdditionalInformation.set(value);
        } else if (opt.equals(":unknown-allowed")) {
            this.mUnknownAllowed.set(value);
        } else {
            this.mScript.setOption(opt, value);
        }
    }

    @Override
    public Object getOption(String opt) throws UnsupportedOperationException {
        if (opt.equals(":interpolation-heuristic")) {
            return this.mInterpolationHeuristic.get();
        }
        if (opt.equals(":tolerance")) {
            return this.mTolerance.get();
        }
        if (opt.equals(":enumeration-timeout")) {
            return this.mEnumerationTimeout.get();
        }
        if (opt.equals(":heuristic-timeout")) {
            return this.mHeuristicTimeout.get();
        }
        if (opt.equals(":log-additional-information")) {
            return this.mLogAdditionalInformation.getValue();
        }
        if (opt.equals(":unknown-allowed")) {
            return this.mUnknownAllowed.getValue();
        }
        return this.mScript.getOption(opt);
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mRememberedAssertions.add(term);
        this.mAssertedTermsAreUnsat = false;
        return this.mScript.assertTerm(term);
    }

    @Override
    public void reset() {
        this.mScript.reset();
        this.mRememberedAssertions.clear();
        this.mCustomNameId = 0;
        this.mAssertedTermsAreUnsat = false;
        this.mInterpolationHeuristic.reset();
        this.mTolerance.reset();
        this.mEnumerationTimeout.reset();
        this.mHeuristicTimeout.reset();
        this.mLogAdditionalInformation.reset();
        this.mRandom = new Random(this.getRandomSeed());
    }

    @Override
    public void resetAssertions() {
        this.mScript.resetAssertions();
        this.mRememberedAssertions.clear();
        this.mAssertedTermsAreUnsat = false;
    }

    private void resetCustomNameId() {
        this.mCustomNameId = 0;
    }

    public static enum HeuristicsType {
        RANDOM,
        SMALLEST,
        BIGGEST,
        LOWLEXORDER,
        HIGHLEXORDER,
        SHALLOWEST,
        DEEPEST,
        NARROWEST,
        WIDEST,
        SMALLESTAMONGWIDE,
        WIDESTAMONGSMALL,
        FIRST;

    }
}

