/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ConstraintAdministrationSolver;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusUtils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Shrinking;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.UnexploredMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SExpression;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.TimeoutHandler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class ReMus
implements Iterator<MusContainer> {
    ConstraintAdministrationSolver mSolver;
    UnexploredMap mMap;
    TimeoutHandler mTimeoutHandler;
    long mTimeout;
    Random mRnd;
    boolean mUnknownAllowed;
    LogProxy mLogger;
    ArrayList<MusContainer> mMuses;
    MusContainer mNextMus;
    boolean mProvisionalSat;
    BitSet mMaxUnexplored;
    ArrayList<Integer> mMcs;
    BitSet mKnownCrits;
    BitSet mWorkingSet;
    ReMus mSubordinateRemus;
    boolean mMembersUpToDate;
    boolean mSatisfiableCaseLoopIsRunning;
    BitSet mSatisfiableCaseLoopNextWorkingSet;
    boolean mTimeoutOrTerminationRequestOccurred;

    public ReMus(ConstraintAdministrationSolver solver, UnexploredMap map, BitSet workingSet, TimeoutHandler handler, long timeout, Random rnd, boolean unknownAllowed, LogProxy logger) {
        this.mSolver = solver;
        this.mMap = map;
        this.mTimeoutHandler = handler;
        this.mTimeout = timeout;
        this.mTimeoutOrTerminationRequestOccurred = false;
        this.mRnd = rnd;
        this.mUnknownAllowed = unknownAllowed;
        this.mLogger = logger;
        if (workingSet.length() > this.mSolver.getNumberOfConstraints()) {
            throw new SMTLIBException("There are constraints set in the workingSet that are not registered in the translator of the solver and the map");
        }
        this.mWorkingSet = workingSet;
        this.initializeMembersAndAssertImpliedCrits();
    }

    private ReMus(ConstraintAdministrationSolver solver, UnexploredMap map, BitSet workingSet, TimeoutHandler handler, Random rnd, boolean unknownAllowed, LogProxy logger) {
        this(solver, map, workingSet, handler, 0L, rnd, unknownAllowed, logger);
    }

    private void initializeMembersAndAssertImpliedCrits() {
        this.mMuses = new ArrayList();
        this.mSolver.clearUnknownConstraints();
        this.mKnownCrits = this.mSolver.getCrits();
        this.mMap.messWithActivityOfAtoms(this.mRnd);
        this.mMaxUnexplored = this.mMap.findMaximalUnexploredSubsetOf(this.mWorkingSet);
        BitSet newImpliedCrits = this.mMap.findImpliedCritsOf(this.mWorkingSet);
        this.mSolver.assertCriticalConstraints(newImpliedCrits);
        this.mProvisionalSat = !MusUtils.contains(this.mMaxUnexplored, this.mKnownCrits);
        this.mKnownCrits.or(newImpliedCrits);
        this.mMembersUpToDate = true;
    }

    @Override
    public boolean hasNext() throws SMTLIBException {
        if (this.mNextMus != null) {
            return true;
        }
        if (this.mTimeoutOrTerminationRequestOccurred) {
            return false;
        }
        boolean thisMethodHasSetTheTimeout = false;
        if (this.mTimeout > 0L && !this.mTimeoutHandler.timeoutIsSet()) {
            this.mTimeoutHandler.setTimeout(this.mTimeout);
            thisMethodHasSetTheTimeout = true;
        }
        if (this.mSubordinateRemus != null && this.mSubordinateRemus.hasNext()) {
            this.mNextMus = this.mSubordinateRemus.next();
            return true;
        }
        this.removeSubordinateRemus();
        if (this.mSatisfiableCaseLoopIsRunning) {
            this.resumeSatisfiableCaseLoopUntilNextMus();
        }
        if (this.mNextMus != null) {
            return true;
        }
        this.searchForNextMusBeginningInThisRecursionLevel();
        if (this.mNextMus != null) {
            return true;
        }
        if (this.mTimeoutHandler.isTerminationRequested()) {
            this.mTimeoutOrTerminationRequestOccurred = true;
        }
        if (thisMethodHasSetTheTimeout) {
            this.mTimeoutHandler.clearTimeout();
        }
        return false;
    }

    private void resumeSatisfiableCaseLoopUntilNextMus() {
        if (this.mSubordinateRemus != null) {
            throw new SMTLIBException("Let the subordinate find it's muses first.");
        }
        while (!this.mMcs.isEmpty() && this.mNextMus == null && !this.mTimeoutHandler.isTerminationRequested()) {
            int critical = MusUtils.pop(this.mMcs);
            this.mSatisfiableCaseLoopNextWorkingSet.set(critical);
            this.createNewSubordinateRemusWithExtraCrit(this.mSatisfiableCaseLoopNextWorkingSet, critical);
            if (this.mSubordinateRemus.hasNext()) {
                this.mNextMus = this.mSubordinateRemus.next();
            } else {
                this.removeSubordinateRemus();
            }
            this.mSatisfiableCaseLoopNextWorkingSet.clear(critical);
        }
        this.mSatisfiableCaseLoopIsRunning = !this.mMcs.isEmpty() && !this.mTimeoutHandler.isTerminationRequested();
    }

    private void searchForNextMusBeginningInThisRecursionLevel() {
        assert (this.mSubordinateRemus == null) : "Let the subordinate find its muses first.";
        assert (!this.mSatisfiableCaseLoopIsRunning) : "Finish the Satisfiable case loop first.";
        if (!this.mMembersUpToDate) {
            this.updateMembersAndAssertImpliedCrits();
        }
        while (!this.mMaxUnexplored.isEmpty() && this.mNextMus == null && !this.mTimeoutHandler.isTerminationRequested()) {
            assert (this.mMembersUpToDate && this.mSubordinateRemus == null) : "Variables of ReMus are corrupted.";
            if (this.mProvisionalSat) {
                this.handleUnexploredIsSat();
            } else {
                BitSet unknowns = (BitSet)this.mMaxUnexplored.clone();
                unknowns.andNot(this.mKnownCrits);
                this.mSolver.assertUnknownConstraints(unknowns);
                Script.LBool sat = this.mSolver.checkSat();
                this.mSolver.clearUnknownConstraints();
                if (sat == Script.LBool.SAT) {
                    this.handleUnexploredIsSat();
                } else if (sat == Script.LBool.UNSAT) {
                    this.handleUnexploredIsUnsat();
                } else {
                    if (this.mTimeoutHandler.isTerminationRequested()) {
                        return;
                    }
                    if (!this.mUnknownAllowed) {
                        throw new SMTLIBException("LBool.UNKNOWN occured in enumeration process, despite of not being explicitly allowed. (To allow it, use allowCheckSatUnknown).");
                    }
                    this.mMap.BlockDown(this.mMaxUnexplored);
                }
            }
            if (this.mSubordinateRemus == null && !this.mTimeoutHandler.isTerminationRequested()) {
                this.updateMembersAndAssertImpliedCrits();
                continue;
            }
            this.mMembersUpToDate = false;
        }
    }

    private void updateMembersAndAssertImpliedCrits() {
        this.mMap.messWithActivityOfAtoms(this.mRnd);
        this.mMaxUnexplored = this.mMap.findMaximalUnexploredSubsetOf(this.mWorkingSet);
        BitSet newImpliedCrits = this.mMap.findImpliedCritsOf(this.mWorkingSet);
        newImpliedCrits.andNot(this.mKnownCrits);
        this.mSolver.assertCriticalConstraints(newImpliedCrits);
        this.mProvisionalSat = !MusUtils.contains(this.mMaxUnexplored, this.mKnownCrits);
        this.mKnownCrits.or(newImpliedCrits);
        this.mMembersUpToDate = true;
    }

    private void handleUnexploredIsSat() {
        this.mMap.BlockDown(this.mMaxUnexplored);
        BitSet bitSetMcs = (BitSet)this.mWorkingSet.clone();
        bitSetMcs.andNot(this.mMaxUnexplored);
        if (bitSetMcs.cardinality() == 1) {
            this.mSolver.assertCriticalConstraint(bitSetMcs.nextSetBit(0));
        } else {
            this.mMcs = MusUtils.randomPermutation(bitSetMcs, this.mRnd);
            BitSet nextWorkingSet = (BitSet)this.mMaxUnexplored.clone();
            while (!this.mMcs.isEmpty() && this.mNextMus == null && !this.mTimeoutHandler.isTerminationRequested()) {
                int critical = MusUtils.pop(this.mMcs);
                nextWorkingSet.set(critical);
                this.createNewSubordinateRemusWithExtraCrit(nextWorkingSet, critical);
                if (this.mSubordinateRemus.hasNext()) {
                    this.mNextMus = this.mSubordinateRemus.next();
                } else {
                    this.removeSubordinateRemus();
                }
                nextWorkingSet.clear(critical);
                this.mSatisfiableCaseLoopNextWorkingSet = nextWorkingSet;
            }
            this.mSatisfiableCaseLoopIsRunning = !this.mMcs.isEmpty() && !this.mTimeoutHandler.isTerminationRequested();
        }
    }

    private void handleUnexploredIsUnsat() {
        this.mSolver.pushRecLevel();
        if (this.mLogger != null) {
            this.mLogger.fatal("Now shrinking...");
        }
        this.mNextMus = Shrinking.shrink(this.mSolver, this.mMaxUnexplored, this.mMap, this.mTimeoutHandler, this.mRnd, this.mUnknownAllowed);
        this.mSolver.popRecLevel();
        if (this.mNextMus == null) {
            return;
        }
        BitSet nextWorkingSet = (BitSet)this.mNextMus.getMus().clone();
        if ((double)nextWorkingSet.cardinality() < 0.9 * (double)this.mMaxUnexplored.cardinality()) {
            ArrayList<Integer> randomlyPermutatedMaxUnexplored = MusUtils.randomPermutation(this.mMaxUnexplored, this.mRnd);
            while ((double)nextWorkingSet.cardinality() < 0.9 * (double)this.mMaxUnexplored.cardinality()) {
                int toAdd = MusUtils.pop(randomlyPermutatedMaxUnexplored);
                if (nextWorkingSet.get(toAdd)) continue;
                nextWorkingSet.set(toAdd);
            }
            this.createNewSubordinateRemus(nextWorkingSet);
        }
    }

    private void createNewSubordinateRemus(BitSet nextWorkingSet) {
        this.mSolver.pushRecLevel();
        this.mSubordinateRemus = new ReMus(this.mSolver, this.mMap, nextWorkingSet, this.mTimeoutHandler, this.mRnd, this.mUnknownAllowed, this.mLogger);
    }

    private void createNewSubordinateRemusWithExtraCrit(BitSet nextWorkingSet, int crit) {
        this.mSolver.pushRecLevel();
        this.mSolver.assertCriticalConstraint(crit);
        this.mSubordinateRemus = new ReMus(this.mSolver, this.mMap, nextWorkingSet, this.mTimeoutHandler, this.mRnd, this.mUnknownAllowed, this.mLogger);
    }

    private void removeSubordinateRemus() {
        if (this.mSubordinateRemus != null) {
            this.mSubordinateRemus = null;
            this.mSolver.popRecLevel();
        }
    }

    @Override
    public MusContainer next() throws SMTLIBException {
        if (this.hasNext()) {
            MusContainer nextMus = this.mNextMus;
            this.mNextMus = null;
            return nextMus;
        }
        throw new NoSuchElementException();
    }

    public ArrayList<MusContainer> enumerate() throws SMTLIBException {
        boolean thisMethodHasSetTheTimeout = false;
        if (this.mTimeout > 0L) {
            this.mTimeoutHandler.setTimeout(this.mTimeout);
            thisMethodHasSetTheTimeout = true;
        }
        ArrayList<MusContainer> restOfMuses = new ArrayList<MusContainer>();
        while (this.hasNext()) {
            restOfMuses.add(this.next());
        }
        if (thisMethodHasSetTheTimeout) {
            this.mTimeoutHandler.clearTimeout();
        }
        if (this.mLogger != null && restOfMuses.size() == 0) {
            Object info = this.mSolver.getInfo(":all-statistics");
            SExpression infoToString = new SExpression(info);
            this.mLogger.fatal(infoToString.toString());
        }
        return restOfMuses;
    }

    public void resetSolver() {
        this.mTimeoutOrTerminationRequestOccurred = true;
        this.mSolver.reset();
    }
}

