/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ConstraintAdministrationSolver;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusUtils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.UnexploredMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;

public class Shrinking {
    public static MusContainer shrink(ConstraintAdministrationSolver solver, BitSet workingConstraints, UnexploredMap map, TerminationRequest request, Random rnd, boolean unknownAllowed) throws SMTLIBException {
        solver.pushRecLevel();
        if (!MusUtils.contains(workingConstraints, solver.getCrits())) {
            throw new SMTLIBException("WorkingConstraints is corrupted! It should contain all crits.");
        }
        BitSet unknown = (BitSet)workingConstraints.clone();
        unknown.andNot(solver.getCrits());
        ArrayList<Integer> unknownPermutated = MusUtils.randomPermutation(unknown, rnd);
        Term substituteProof = null;
        while (!unknownPermutated.isEmpty()) {
            int unknownIndex = MusUtils.pop(unknownPermutated);
            if (!unknown.get(unknownIndex)) continue;
            int j = unknown.nextSetBit(0);
            while (j >= 0) {
                if (j != unknownIndex) {
                    solver.assertUnknownConstraint(j);
                }
                j = unknown.nextSetBit(j + 1);
            }
            unknown.clear(unknownIndex);
            switch (solver.checkSat()) {
                case UNSAT: {
                    BitSet core = solver.getUnsatCore();
                    if (unknownAllowed) {
                        substituteProof = solver.getProof();
                    }
                    unknown.and(core);
                    solver.clearUnknownConstraints();
                    break;
                }
                case SAT: {
                    BitSet satisfiableSet;
                    if (unknownAllowed) {
                        solver.clearUnknownConstraints();
                        satisfiableSet = solver.getCrits();
                        satisfiableSet.or(unknown);
                        map.BlockDown(satisfiableSet);
                    } else {
                        BitSet extension = solver.getSatExtension(request);
                        if (extension == null) {
                            return null;
                        }
                        map.BlockDown(extension);
                        solver.clearUnknownConstraints();
                    }
                    solver.assertCriticalConstraint(unknownIndex);
                    break;
                }
                case UNKNOWN: {
                    if (request != null && request.isTerminationRequested()) {
                        return null;
                    }
                    if (!unknownAllowed) {
                        throw new SMTLIBException("LBool.UNKNOWN occured in the shrinking process, despite not being explicitly allowed.");
                    }
                    solver.clearUnknownConstraints();
                    BitSet satisfiableSet = solver.getCrits();
                    satisfiableSet.or(unknown);
                    map.BlockDown(satisfiableSet);
                    solver.assertCriticalConstraint(unknownIndex);
                }
            }
        }
        switch (solver.checkSat()) {
            case UNSAT: {
                break;
            }
            case SAT: {
                throw new SMTLIBException("Something went wrong, the set of all crits should be unsatisfiable!");
            }
            case UNKNOWN: {
                if (request != null && request.isTerminationRequested()) {
                    return null;
                }
                if (unknownAllowed) {
                    BitSet mus = solver.getCrits();
                    map.BlockUp(mus);
                    map.BlockDown(mus);
                    solver.popRecLevel();
                    assert (substituteProof != null) : "The case described in the comment above did not occur, so this is an unexpected behaviour";
                    return new MusContainer(mus, substituteProof);
                }
                throw new SMTLIBException("Solver returns UNKNOWN for final set in shrink procedure.");
            }
        }
        Term proofOfMus = solver.getProof();
        BitSet mus = solver.getCrits();
        map.BlockUp(mus);
        map.BlockDown(mus);
        solver.popRecLevel();
        return new MusContainer(mus, proofOfMus);
    }

    public static MusContainer shrink(ConstraintAdministrationSolver solver, BitSet workingSet, UnexploredMap map, Random rnd, boolean unknownAllowed) {
        return Shrinking.shrink(solver, workingSet, map, null, rnd, unknownAllowed);
    }

    public static MusContainer shrink(ConstraintAdministrationSolver solver, BitSet workingConstraints, TerminationRequest request, Random rnd, boolean unknownAllowed) throws SMTLIBException {
        solver.pushRecLevel();
        if (!MusUtils.contains(workingConstraints, solver.getCrits())) {
            throw new SMTLIBException("WorkingConstraints is corrupted! It should contain all crits.");
        }
        BitSet unknown = (BitSet)workingConstraints.clone();
        unknown.andNot(solver.getCrits());
        ArrayList<Integer> unknownPermutated = MusUtils.randomPermutation(unknown, rnd);
        Term substituteProof = null;
        while (!unknownPermutated.isEmpty()) {
            int unknownIndex = unknownPermutated.get(unknownPermutated.size() - 1);
            unknownPermutated.remove(unknownPermutated.size() - 1);
            if (!unknown.get(unknownIndex)) continue;
            int j = unknown.nextSetBit(0);
            while (j >= 0) {
                if (j != unknownIndex) {
                    solver.assertUnknownConstraint(j);
                }
                j = unknown.nextSetBit(j + 1);
            }
            unknown.clear(unknownIndex);
            switch (solver.checkSat()) {
                case UNSAT: {
                    BitSet core = solver.getUnsatCore();
                    if (unknownAllowed) {
                        substituteProof = solver.getProof();
                    }
                    unknown.and(core);
                    solver.clearUnknownConstraints();
                    break;
                }
                case SAT: {
                    solver.clearUnknownConstraints();
                    solver.assertCriticalConstraint(unknownIndex);
                    break;
                }
                case UNKNOWN: {
                    if (request != null && request.isTerminationRequested()) {
                        return null;
                    }
                    if (!unknownAllowed) {
                        throw new SMTLIBException("LBool.UNKNOWN occured in the shrinking process, despite not being explicitly allowed.");
                    }
                    BitSet isAsserted = solver.getCrits();
                    isAsserted.or(unknown);
                    solver.clearUnknownConstraints();
                    solver.assertCriticalConstraint(unknownIndex);
                }
            }
        }
        switch (solver.checkSat()) {
            case UNSAT: {
                break;
            }
            case SAT: {
                throw new SMTLIBException("Something went wrong, the set of all crits should be unsatisfiable!");
            }
            case UNKNOWN: {
                if (request != null && request.isTerminationRequested()) {
                    return null;
                }
                if (unknownAllowed) {
                    BitSet mus = solver.getCrits();
                    solver.popRecLevel();
                    if (substituteProof == null) {
                        throw new SMTLIBException("The case described in the comment above did not occur, so this is an unexpected behaviour.");
                    }
                    return new MusContainer(mus, substituteProof);
                }
                throw new SMTLIBException("Solver returns UNKNOWN for final set in shrink procedure.");
            }
        }
        Term proofOfMus = solver.getProof();
        solver.clearUnknownConstraints();
        BitSet mus = solver.getCrits();
        solver.popRecLevel();
        return new MusContainer(mus, proofOfMus);
    }
}

